/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl.access;

import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.cyclos.entities.access.Agreement;
import org.cyclos.entities.access.AgreementContent;
import org.cyclos.entities.access.QAgreement;
import org.cyclos.entities.access.QAgreementContent;
import org.cyclos.entities.users.BasicGroup;
import org.cyclos.entities.users.Group;
import org.cyclos.impl.CRUDServiceImpl;
import org.cyclos.impl.access.AgreementServiceLocal;
import org.cyclos.impl.system.ConfigurationImageServiceLocal;
import org.cyclos.impl.utils.persistence.DBQuery;
import org.cyclos.impl.utils.persistence.NetworkPathRegistry;
import org.cyclos.impl.utils.validation.Validator;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.EntityNotFoundException;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.Property;
import org.cyclos.model.access.AccessKeys;
import org.cyclos.model.access.agreements.AgreementContentVO;
import org.cyclos.model.access.agreements.AgreementDTO;
import org.cyclos.model.access.agreements.AgreementData;
import org.cyclos.model.access.agreements.AgreementVO;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.utils.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgreementServiceImpl
extends CRUDServiceImpl<Agreement, QAgreement, AgreementDTO, AgreementData, Void>
implements AgreementServiceLocal {
    @Autowired
    private ConfigurationImageServiceLocal configurationImageService;

    public AgreementServiceImpl() {
        super(Agreement.class, QAgreement.agreement, AgreementDTO.class);
    }

    public AgreementContentVO getContent(AgreementVO agreementVO, Integer n, Long l) throws FrameworkException {
        Object object;
        QAgreementContent qAgreementContent;
        Agreement agreement = (Agreement)this.conversionHandler.convert(Agreement.class, (Object)agreementVO);
        AgreementContentVO agreementContentVO = new AgreementContentVO();
        agreementContentVO.setAgreement((AgreementVO)this.conversionHandler.convert(AgreementVO.class, (Object)agreement));
        agreementContentVO.setLastVersion(this.getCurrentVersion(agreement));
        if (n == null) {
            agreementContentVO.setContent(agreement.getContent());
            agreementContentVO.setContentVersion(agreementContentVO.getLastVersion());
        } else {
            qAgreementContent = QAgreementContent.agreementContent;
            object = (String)((DBQuery)this.from(new EntityPath[]{qAgreementContent}).where(new Predicate[]{qAgreementContent.agreement().eq((Object)agreement), qAgreementContent.agreementVersion.eq((Object)n)})).singleResult((Expression)qAgreementContent.content);
            if (object == null) {
                throw new EntityNotFoundException(AgreementContent.class, agreement.getName() + ", version " + n);
            }
            agreementContentVO.setContent((String)object);
            agreementContentVO.setContentVersion(n.intValue());
        }
        if (l != null) {
            object = this.find(Group.class, l);
            qAgreementContent = this.configurationHandler.getAccessor((BasicGroup)object);
        } else {
            qAgreementContent = this.getSessionData().getConfiguration();
        }
        agreementContentVO.setReportsLogo(this.configurationImageService.getImageVO(new ConfigurationVO(qAgreementContent.getConfiguration().getId()), ConfigurationImageType.REPORTS_LOGO));
        return agreementContentVO;
    }

    public int getCurrentVersion(Agreement agreement) {
        if (agreement == null || agreement.isTransient()) {
            return 0;
        }
        QAgreementContent qAgreementContent = QAgreementContent.agreementContent;
        Integer n = (Integer)((DBQuery)this.from(new EntityPath[]{qAgreementContent}).where((Predicate)qAgreementContent.agreement().eq((Object)agreement))).singleResult((Expression)qAgreementContent.agreementVersion.max());
        return (Integer)ObjectHelper.defaultValue((Object)n, (Object)0) + 1;
    }

    public List<AgreementVO> list() {
        return ((DBQuery)this.from().orderBy(new OrderSpecifier[]{((QAgreement)this.$).required.desc(), ((QAgreement)this.$).name.asc()})).list(AgreementVO.class, (Expression)this.$);
    }

    @Override
    public Agreement newEntity(Void void_) {
        return new Agreement();
    }

    @Override
    public AgreementDTO toDTO(Agreement agreement) {
        AgreementDTO agreementDTO = (AgreementDTO)super.toDTO(agreement);
        agreementDTO.setCurrentVersion(Integer.valueOf(this.getCurrentVersion(agreement)));
        return agreementDTO;
    }

    @Override
    protected AgreementData getData(Agreement agreement) {
        AgreementData agreementData = new AgreementData();
        agreementData.setDto((EntityDTO)this.toDTO(agreement));
        if (agreement.isPersistent()) {
            QAgreementContent qAgreementContent = QAgreementContent.agreementContent;
            List list = ((DBQuery)((DBQuery)this.from(new EntityPath[]{qAgreementContent}).where((Predicate)qAgreementContent.agreement().eq((Object)agreement))).orderBy(qAgreementContent.agreementVersion.desc())).list(AgreementContentVO.class, (Expression)qAgreementContent);
            agreementData.setContentHistory(list);
        }
        return agreementData;
    }

    @Override
    protected void registerNetworkMappings(NetworkPathRegistry networkPathRegistry) {
        networkPathRegistry.register(((QAgreement)this.$).network());
    }

    @Override
    protected Validator resolveValidator(AgreementDTO agreementDTO) {
        Validator validator = new Validator();
        validator.property((Property)AgreementDTO.CONTENT, AccessKeys.Agreements.CONTENT).required();
        return validator;
    }
}

