/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.impl;

import com.hazelcast.spi.exception.RetryableHazelcastException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.persistence.EntityNotFoundException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import org.cyclos.impl.ApplicationHandler;
import org.cyclos.impl.BaseGlobalHandlerImpl;
import org.cyclos.impl.CyclosThreadFactory;
import org.cyclos.impl.InvocationContext;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionData;
import org.cyclos.impl.contentmanagement.TranslationHandler;
import org.cyclos.impl.sql.NativeQueryHandler;
import org.cyclos.model.ConstraintViolatedOnRemoveException;
import org.cyclos.model.CyclosException;
import org.cyclos.model.LockAcquisitionException;
import org.cyclos.model.RetryException;
import org.cyclos.model.StaleEntityException;
import org.cyclos.model.UnexpectedDataAccessException;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.passwords.ChangePasswordDTO;
import org.cyclos.model.banking.BankingKeys;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.ExceptionHelper;
import org.cyclos.services.access.PasswordService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

@Component
public class InvokerHandlerImpl
extends BaseGlobalHandlerImpl
implements InvokerHandler {
    private static final int MAX_TRIES = 10;
    private static final Set<String> PASSWORD_EXPIRED_WHITELIST = new HashSet<String>();
    @Autowired
    @Lazy
    private ApplicationHandler applicationHandler;
    @Autowired
    @Lazy
    private TranslationHandler translationHandler;
    @Autowired
    @Lazy
    private NativeQueryHandler nativeQueryHandler;
    private ScheduledExecutorService executorService;

    private static String getQualifiedMethodName(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            clazz.getMethod(string, classArray);
            return clazz.getName() + "." + string;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(String.format("Error creating whitelist of methods allowed to run with an expired password: method %s not found in class %s", clazz.getName(), string));
        }
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    @PostConstruct
    public void initialize() {
        this.executorService = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), CyclosThreadFactory.CyclosThreadGroup.EXECUTOR.factory());
    }

    public <T> T runAs(SessionData sessionData, Callable<T> callable) {
        InvocationContext invocationContext;
        if (this.applicationHandler.isShuttingDown()) {
            return null;
        }
        InvocationContext invocationContext2 = InvocationContext.get();
        InvocationContext invocationContext3 = invocationContext = invocationContext2 == null ? InvocationContext.init((SessionData)sessionData, (ApplicationContext)this.getApplicationContext()) : InvocationContext.nested((SessionData)sessionData, (InvocationContext)invocationContext2);
        if (invocationContext2 != null) {
            invocationContext2.delegateAcquiredResources(invocationContext);
        }
        try {
            T t = callable.call();
            return t;
        }
        catch (InvocationTargetException invocationTargetException) {
            try {
                throw invocationTargetException.getTargetException();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
            catch (Throwable throwable) {
                throw new IllegalStateException(throwable);
            }
        }
        finally {
            if (invocationContext2 != null) {
                invocationContext.delegateAcquiredResources(invocationContext2);
            } else {
                invocationContext.releaseWithoutTransaction();
            }
            InvocationContext.set((InvocationContext)invocationContext2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runAsInCurrentOrNewTransaction(SessionData sessionData, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback) throws RetryException {
        TransactionLevel transactionLevel2;
        if (this.applicationHandler.isShuttingDown()) {
            return null;
        }
        InvocationContext invocationContext = InvocationContext.get();
        TransactionLevel transactionLevel3 = transactionLevel2 = invocationContext == null ? null : invocationContext.getTransactionLevel();
        if (transactionLevel2 == null) {
            try {
                T t = this.doRunAsInTransaction(sessionData, transactionLevel, transactionCallback, false);
                return t;
            }
            finally {
                if (invocationContext != null) {
                    InvocationContext.set((InvocationContext)invocationContext);
                }
            }
        }
        TransactionStatus transactionStatus = invocationContext.getTransactionStatus();
        if (transactionLevel2.compareTo((Enum)transactionLevel) >= 0) {
            return (T)this.runAs(sessionData, () -> transactionCallback.doInTransaction(transactionStatus));
        }
        throw new RetryException(transactionLevel);
    }

    public <T> Future<T> runAsInParallelTransaction(SessionData sessionData, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback) {
        if (this.applicationHandler.isShuttingDown()) {
            return new FutureTask<Object>(() -> null);
        }
        return this.executorService.submit(() -> this.runAsInTransaction(sessionData, transactionLevel, transactionCallback));
    }

    public <T> T runAsInTransaction(SessionData sessionData, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback) {
        return this.doRunAsInTransaction(sessionData, transactionLevel, transactionCallback, true);
    }

    @PreDestroy
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    public void submitAsInParallelTransaction(SessionData sessionData, TransactionLevel transactionLevel, Consumer<TransactionStatus> consumer) {
        if (this.applicationHandler.isShuttingDown()) {
            return;
        }
        this.executorService.execute(() -> this.runAsInTransaction(sessionData, transactionLevel, transactionStatus -> {
            consumer.accept(transactionStatus);
            return null;
        }));
    }

    public Throwable translateException(Throwable throwable) {
        String string;
        Exception exception = (Exception)ExceptionHelper.findCause((Throwable)throwable, CyclosException.class);
        if (exception != null) {
            return exception;
        }
        exception = (Exception)ExceptionHelper.findCause((Throwable)throwable, SQLException.class);
        if (exception instanceof SQLException) {
            try {
                this.nativeQueryHandler.retryIfConnectionError(exception);
            }
            catch (RetryException retryException) {
                return retryException;
            }
            string = exception.getMessage();
            if (string != null && string.contains("BEFORE_ARCHIVING")) {
                Date date = this.applicationHandler.getApplication().getArchivingDate();
                return new ValidationException(this.translationHandler.message(BankingKeys.Accounts.ERROR_BEFORE_ARCHIVING_DATE, new Object[]{this.getFormatter().formatAsDate(date)}));
            }
        }
        if ((exception = (Exception)ExceptionHelper.findCause((Throwable)throwable, DataAccessException.class)) instanceof DataIntegrityViolationException) {
            return new ConstraintViolatedOnRemoveException(throwable);
        }
        if (exception instanceof ConcurrencyFailureException) {
            string = new StaleEntityException();
            string.initCause(throwable);
            return string;
        }
        if (exception != null) {
            return new UnexpectedDataAccessException(throwable);
        }
        exception = (Exception)ExceptionHelper.findCause((Throwable)throwable, PersistenceException.class);
        if (exception instanceof EntityNotFoundException) {
            string = new org.cyclos.model.EntityNotFoundException();
            string.initCause(throwable);
            return string;
        }
        if (exception instanceof OptimisticLockException) {
            string = new StaleEntityException();
            string.initCause(throwable);
            return string;
        }
        if (exception != null) {
            return new UnexpectedDataAccessException(throwable);
        }
        exception = (Exception)ExceptionHelper.findCause((Throwable)throwable, RetryableHazelcastException.class);
        if (exception instanceof RetryableHazelcastException) {
            return new RetryException("Hazelcast retryable error");
        }
        return throwable;
    }

    protected <T> T doRunAsInTransaction(SessionData sessionData, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback, boolean bl) {
        Throwable throwable = null;
        for (int i = 0; i < 10; ++i) {
            InvocationContext invocationContext;
            if (bl && (invocationContext = InvocationContext.get()) != null && invocationContext.getTransactionLevel() != null) {
                throw new IllegalStateException("There is already a current transaction");
            }
            try {
                return this.performInTransaction(sessionData, transactionLevel, transactionCallback, i);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                Throwable throwable3 = this.translateException(throwable2);
                if (throwable3 instanceof LockAcquisitionException) {
                    this.getLogger().debug("Got a LockAcquisitionException: retrying transaction after sleeping " + i * 100 + " ms ");
                    try {
                        Thread.sleep(i * 100);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new UnexpectedDataAccessException(throwable3);
                    }
                }
                if (throwable3 instanceof RetryException) {
                    RetryException retryException = (RetryException)throwable3;
                    this.getLogger().debug("Got a RetryException: retrying transaction, attempt " + (i + 1) + " of 10", (Throwable)retryException);
                    if (retryException.getRequiredLevel() == null) continue;
                    transactionLevel = retryException.getRequiredLevel();
                    continue;
                }
                if (throwable3 instanceof RuntimeException) {
                    throw (RuntimeException)throwable3;
                }
                throw new UnexpectedDataAccessException(throwable3);
            }
        }
        UnexpectedDataAccessException unexpectedDataAccessException = new UnexpectedDataAccessException("Couldn't run transaction, maximum attempts reached");
        if (throwable != null) {
            unexpectedDataAccessException.initCause(throwable);
        }
        throw unexpectedDataAccessException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T performInTransaction(SessionData sessionData, TransactionLevel transactionLevel, TransactionCallback<T> transactionCallback, int n) {
        InvocationContext invocationContext = InvocationContext.init((SessionData)sessionData, (ApplicationContext)this.getApplicationContext());
        Boolean bl = transactionLevel.isReadOnly() ? null : Boolean.valueOf(false);
        try {
            Pair pair = this.transactionHandler.run(transactionLevel, transactionCallback, n);
            bl = (Boolean)pair.getSecond();
            Object object = pair.getFirst();
            return (T)object;
        }
        finally {
            InvocationContext.remove();
            invocationContext.releaseAfterTransaction(bl);
        }
    }

    static {
        CollectionHelper.addAll(PASSWORD_EXPIRED_WHITELIST, (Object[])new String[]{InvokerHandlerImpl.getQualifiedMethodName(PasswordService.class, "change", ChangePasswordDTO.class)});
    }
}

