/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_4;

import java.io.InputStream;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeDTO;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.contentmanagement.translations.DataTranslationType;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.server.utils.PropertiesHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class AccountNumberMigration
extends BaseMigration {
    @Override
    public int run() {
        Object object;
        HashMap<BuiltinLanguage, Properties> hashMap = new HashMap<BuiltinLanguage, Properties>();
        for (BuiltinLanguage object42 : BuiltinLanguage.values()) {
            Locale locale = LocaleHelper.mapLocale((BuiltinLanguage)object42);
            Object object2 = "/translations/translation-GENERAL";
            if (object42 != BuiltinLanguage.EN) {
                object2 = (String)object2 + "_" + String.valueOf(locale);
            }
            object2 = (String)object2 + ".properties";
            object = this.getClass().getResourceAsStream((String)object2);
            if (object == null) continue;
            hashMap.put(object42, PropertiesHelper.from((InputStream)object));
        }
        int n = 0;
        ExistingBuiltInPrincipalType existingBuiltInPrincipalType = ExistingBuiltInPrincipalType.ACCOUNT_NUMBER;
        Long l = (Long)this.jdbcTemplate.execute(connection -> connection.prepareStatement("insert into principal_types (version, subclass, internal_name, name) values (0, ?, ?, ?)", 1), preparedStatement -> {
            preparedStatement.setString(1, PrincipalTypeNature.BUILT_IN.name());
            preparedStatement.setString(2, existingBuiltInPrincipalType.getInternalName());
            preparedStatement.setString(3, existingBuiltInPrincipalType.getDisplayName());
            preparedStatement.execute();
            try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
                resultSet.next();
                Long l = resultSet.getLong(1);
                return l;
            }
        });
        List list = this.jdbcTemplate.query("select id, template from languages where parent_id is null", (RowMapper)new ColumnMapRowMapper());
        for (Object object2 : list) {
            String string;
            object = (Long)CoercionHelper.coerce(Long.class, object2.get("id"));
            BuiltinLanguage builtinLanguage = (BuiltinLanguage)CoercionHelper.coerce(BuiltinLanguage.class, object2.get("template"));
            Properties properties = (Properties)hashMap.get(builtinLanguage);
            if (properties == null || !StringHelper.isNotBlank((Object)(string = properties.getProperty("INITIAL_DATA.principalType." + existingBuiltInPrincipalType.name())))) continue;
            this.jdbcTemplate.update("insert into data_translations (version, type, language_id, property_name, entity_id, value) values (0, ?, ?, ?, ?, ?)", new Object[]{DataTranslationType.PRINCIPAL_TYPE.name(), object, PrincipalTypeDTO.NAME.getName(), l, string});
        }
        return ++n;
    }
}

