/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db.migrations.v4_13;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.cyclos.db.BaseMigration;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;

public class TransactionAccountsMigration
extends BaseMigration {
    private static final int BATCH_SIZE = 200;
    private static final String UPDATE = " update transactions set  from_id = (    select a.id    from accounts a    where ((? is null and a.user_id is null) or a.user_id = ?)    and a.account_type_id = ? ),  to_id = (    select a.id    from accounts a    where ((? is null and a.user_id is null) or a.user_id = ?)    and a.account_type_id = ?), by_id = ?, authorization_status = ?, authorization_type = ? where id = ?";
    private static final int[] TYPES = new int[]{-5, -5, -5, -5, -5, -5, -5, 12, 12, -5};
    private List<Object[]> batchArgs = new ArrayList<Object[]>(200);
    private int affected;

    @Override
    public int run() throws Exception {
        this.jdbcTemplate.query(" select t.id, t.subclass, t.from_user_id, tt.from_account_type_id, t.to_user_id, t.by_self, t.by_id, tt.to_account_type_id, t.authorization_status, t.authorization_type from transactions t inner join transfer_types tt on t.type_id = tt.id where t.from_id is null and t.to_id is null", this::processTransaction);
        if (!this.batchArgs.isEmpty()) {
            this.applyBatch();
        }
        return this.affected;
    }

    private void applyBatch() {
        this.jdbcTemplate.batchUpdate(UPDATE, this.batchArgs, TYPES);
        this.batchArgs.clear();
    }

    private void processTransaction(ResultSet resultSet) throws SQLException {
        Object object;
        Long l;
        Long l2;
        Long l3;
        Long l4;
        if (this.batchArgs.size() > 200) {
            this.applyBatch();
        }
        long l5 = resultSet.getLong("id");
        String string = resultSet.getString("subclass");
        Long l6 = resultSet.getLong("from_user_id");
        if (resultSet.wasNull()) {
            l6 = null;
        }
        Long l7 = resultSet.getLong("to_user_id");
        if (resultSet.wasNull()) {
            l7 = null;
        }
        long l8 = resultSet.getLong("from_account_type_id");
        long l9 = resultSet.getLong("to_account_type_id");
        String string2 = resultSet.getString("authorization_status");
        String string3 = resultSet.getString("authorization_type");
        if (string2 == null) {
            string2 = TransactionAuthorizationStatus.NA.name();
        }
        if (string3 == null) {
            string3 = TransactionAuthorizationType.NA.name();
        }
        switch (string) {
            case "CHARGEBACK": {
                l4 = l6;
                l3 = l7;
                l2 = l9;
                l = l8;
                break;
            }
            case "PAYMENT_REQUEST": 
            case "TICKET": {
                l4 = l7;
                l3 = l6;
                l2 = l8;
                l = l9;
                break;
            }
            default: {
                l4 = l6;
                l3 = l7;
                l2 = l8;
                l = l9;
            }
        }
        Boolean bl = resultSet.getBoolean("by_self");
        if (Boolean.TRUE.equals(bl)) {
            object = l6;
        } else {
            object = resultSet.getLong("by_id");
            if (resultSet.wasNull()) {
                object = null;
            }
        }
        this.batchArgs.add(new Object[]{l4, l4, l2, l3, l3, l, object, string2, string3, l5});
        ++this.affected;
    }
}

