/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.cyclos.CyclosVersion;
import org.cyclos.bootstrap.BootstrapConfiguration;
import org.cyclos.bootstrap.ServicesConfiguration;
import org.cyclos.entities.system.Network;
import org.cyclos.impl.InvokerHandler;
import org.cyclos.impl.access.SessionDataFactory;
import org.cyclos.impl.utils.transaction.TransactionHandler;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.users.UserNature;
import org.cyclos.model.utils.TransactionLevel;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DeleteNetworkData {
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private JdbcTemplate jdbc;
    @Autowired
    private TransactionHandler transactionHandler;

    public static void main(String[] stringArray) throws IOException {
        System.setProperty("cyclos.db.managed", "false");
        System.setProperty("cyclos.maxBackgroundTasks", "0");
        System.setProperty("cyclos.maxRecurringTasks", "0");
        System.setProperty("cyclos.clusterHandler", "none");
        System.setProperty("cyclos.searchHandler", "db");
        System.setProperty("cyclos.ignoreDatabaseLock", "true");
        try (AnnotationConfigApplicationContext annotationConfigApplicationContext = new AnnotationConfigApplicationContext(new Class[]{SpringConfiguration.class});){
            InvokerHandler invokerHandler = (InvokerHandler)annotationConfigApplicationContext.getBean(InvokerHandler.class);
            DeleteNetworkData deleteNetworkData = (DeleteNetworkData)annotationConfigApplicationContext.getBean(DeleteNetworkData.class);
            System.out.println();
            System.out.println("This program requires exclusive lock to all tables in order to work.");
            System.out.println("This means that it will likely fail if the Cyclos instance is currently active,");
            System.out.println("either by active users or background tasks.");
            System.out.println("As such it is recommended to first stop the Cyclos instance, or it may fail.");
            System.out.println("However, even on failure, everything is done in a single database transaction,");
            System.out.println("which means that a rollback will be performed, and no data will be left inconsistent.");
            System.out.println();
            invokerHandler.runAs(SessionDataFactory.system(), () -> {
                deleteNetworkData.run();
                return null;
            });
        }
    }

    private static String readInput() {
        try {
            return StringHelper.trim((Object)in.readLine());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public void deleteNetwork(Network network) {
        this.doDeleteNetwork(network.getId());
    }

    public int deleteUsersAndBanking(Network network) {
        return this.doDeleteUsersAndBanking(network.getId());
    }

    private void cancel() {
        System.out.println("Operation canceled");
        System.exit(0);
    }

    private <T> T deleteData(Supplier<T> supplier) {
        String string = "select tc.table_name, kcu.column_name, tc.constraint_name, ccu.table_name as foreign_table_name, ccu.column_name as foreign_column_name from information_schema.table_constraints as tc inner join information_schema.key_column_usage as kcu on tc.constraint_name = kcu.constraint_name inner join information_schema.constraint_column_usage as ccu on ccu.constraint_name = tc.constraint_name where constraint_type = 'FOREIGN KEY'   and tc.table_schema = 'public'";
        List list = this.jdbc.query(string, (RowMapper)new BeanPropertyRowMapper(Constraint.class));
        list.forEach(constraint -> constraint.recreate(this.jdbc, true));
        T t = supplier.get();
        list.forEach(constraint -> constraint.recreate(this.jdbc, false));
        return t;
    }

    private void deleteNetwork(Long l, String string) {
        System.out.println("This will delete the entire network '" + string + "'.");
        System.out.println("This operation cannot be undone.");
        System.out.println("It is highly recommended to perform a database backup before proceeding.");
        System.out.println("To confirm, type 'yes' (without quotes)");
        if (!DeleteNetworkData.readInput().equals("yes")) {
            this.cancel();
        }
        System.out.println("Deleting all data in the network...");
        this.doDeleteNetwork(l);
        System.out.println("This entire network '" + string + "' was deleted.");
        System.out.println("It is advised to do run a 'vacuum full' in the database if this network had a lot of data.");
    }

    private void deleteUsersAndBanking(Long l, String string) {
        System.out.println("This will delete all users and banking data in the network '" + string + "'.");
        System.out.println("The operation cannot be undone.");
        System.out.println("It is highly recommended to perform a database backup before proceeding.");
        System.out.println("To confirm, type 'yes' (without quotes)");
        if (!DeleteNetworkData.readInput().equals("yes")) {
            this.cancel();
        }
        System.out.println("Deleting users and banking data...");
        int n = this.doDeleteUsersAndBanking(l);
        System.out.println(n + " users, as well as banking data where deleted from network '" + string + "'.");
        System.out.println("It is advised to do run a 'vacuum full' in the database if this network had a lot of data.");
    }

    private void doDeleteNetwork(Long l) {
        this.deleteData(() -> {
            this.jdbc.update("delete from networks where id = ?", new Object[]{l});
            return null;
        });
    }

    private int doDeleteUsersAndBanking(Long l) {
        String string = "select a.id from accounts a inner join account_types at on a.account_type_id = at.id inner join currencies c on at.currency_id = c.id where c.network_id = " + l;
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("transfers", Arrays.asList("from_id", "to_id"));
        hashMap.put("transactions", Arrays.asList("from_id", "to_id"));
        hashMap.put("amount_reservations", Arrays.asList("account_id"));
        hashMap.put("closed_account_balances", Arrays.asList("account_id"));
        hashMap.put("account_balances", Arrays.asList("account_id"));
        hashMap.put("dirty_account_balances", Arrays.asList("account_id"));
        hashMap.put("account_rates", Arrays.asList("account_id"));
        return this.deleteData(() -> {
            this.jdbc.update("update accounts set account_rates_id = null where id in (" + string + ")");
            hashMap.forEach((string2, list) -> list.forEach(string3 -> this.jdbc.update("delete from " + string2 + " where " + string3 + " in (" + string + ")")));
            int n = this.jdbc.update("delete from users where network_id = ? and (subclass = ? or user_group_id in (   select id from groups where subclass in (?, ?) and network_id = ?))", new Object[]{l, UserNature.OPERATOR.name(), BasicGroupNature.MEMBER_GROUP.name(), BasicGroupNature.BROKER_GROUP.name(), l});
            this.jdbc.update("delete from bulk_actions where network_id = ?", new Object[]{l});
            this.jdbc.update("delete from account_fee_logs where account_fee_id in ( select af.id from account_fees af inner join account_types at on af.account_type_id = at.id inner join currencies c on at.currency_id = c.id where c.network_id = ?)", new Object[]{l});
            return n;
        });
    }

    private void run() {
        this.transactionHandler.run(TransactionLevel.READ_WRITE, transactionStatus -> {
            this.runInTransaction();
            return null;
        });
    }

    private void runInTransaction() {
        String string;
        Map map;
        Object object = this.cyclosProperties.getDataSourceProviderProperties().get("jdbcUrl");
        if (object != null) {
            System.out.printf("Database URL: %s%n", object);
        }
        String string2 = (String)this.jdbc.queryForObject("select application_name from configurations where parent_id is null", String.class);
        System.out.printf("Cyclos version: %s%n", CyclosVersion.get());
        System.out.printf("Instance name: %s%n", string2);
        System.out.print("Type in the internal name of the network to remove data: ");
        System.out.flush();
        String string3 = DeleteNetworkData.readInput();
        try {
            map = this.jdbc.queryForMap("select id, name from networks where internal_name = ?", new Object[]{string3});
        }
        catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
            System.out.printf("No network found for the given internal name: %s\n", string3);
            System.exit(2);
            return;
        }
        Long l = (Long)map.get("id");
        String string4 = (String)map.get("name");
        long l2 = (Long)this.jdbc.queryForObject("select count(id) from users where user_group_id in (select id from groups where network_id = ? and subclass in (?, ?))", Long.class, new Object[]{l, BasicGroupNature.MEMBER_GROUP.name(), BasicGroupNature.BROKER_GROUP.name()});
        long l3 = (Long)this.jdbc.queryForObject("select count(t.id) from transfers t inner join transfer_types tt on t.type_id = tt.id inner join account_types at on tt.from_account_type_id = at.id inner join currencies c on at.currency_id = c.id where c.network_id = ?", Long.class, new Object[]{l});
        System.out.printf("The network %s has %d users and %d transfers. Which data to remove?\n", string4, l2, l3);
        System.out.println("1: Remove all users and transfers");
        System.out.println("2: Remove the entire network");
        System.out.println("<any other key>: cancel");
        switch (string = DeleteNetworkData.readInput()) {
            case "1": {
                this.deleteUsersAndBanking(l, string4);
                break;
            }
            case "2": {
                this.deleteNetwork(l, string4);
                break;
            }
            default: {
                this.cancel();
            }
        }
    }

    @Configuration
    @Import(value={BootstrapConfiguration.class, ServicesConfiguration.class})
    public static class SpringConfiguration {
        @Bean
        public DeleteNetworkData deleteNetworkData() throws Exception {
            return new DeleteNetworkData();
        }
    }

    public static class Constraint {
        private String tableName;
        private String columnName;
        private String constraintName;
        private String foreignTableName;
        private String foreignColumnName;

        public String getColumnName() {
            return this.columnName;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public String getForeignColumnName() {
            return this.foreignColumnName;
        }

        public String getForeignTableName() {
            return this.foreignTableName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setColumnName(String string) {
            this.columnName = string;
        }

        public void setConstraintName(String string) {
            this.constraintName = string;
        }

        public void setForeignColumnName(String string) {
            this.foreignColumnName = string;
        }

        public void setForeignTableName(String string) {
            this.foreignTableName = string;
        }

        public void setTableName(String string) {
            this.tableName = string;
        }

        private void recreate(JdbcTemplate jdbcTemplate, boolean bl) {
            jdbcTemplate.execute(String.format("alter table %s drop constraint %s, add constraint %s foreign key (%s) references %s (%s) %s;", this.tableName, this.constraintName, this.constraintName, this.columnName, this.foreignTableName, this.foreignColumnName, bl ? "on delete cascade" : ""));
        }
    }
}

