/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.db;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.CyclosVersion;
import org.cyclos.db.DatabaseHistory;
import org.cyclos.db.DatabaseUpgradeException;
import org.cyclos.db.VersionScript;
import org.cyclos.impl.utils.jdbc.ScriptHelper;
import org.cyclos.model.access.Permission;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.Pair;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseUpgrade {
    private static final int NO_DATA_VERSION = -1;
    private static final int NO_SCHEMA_VERSION = -2;
    private static final Logger LOG = LogManager.getLogger(DatabaseUpgrade.class);
    private static final List<String> VERSIONS_WITHOUT_DB_LOG = Arrays.asList("4.6", "4.5", "4.4", "4.3", "4.2", "4.1", "4.0");
    private final TransactionTemplate transactionTemplate;
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseHistory databaseHistory;
    private final CyclosProperties cyclosProperties;
    private String currentApplicationVersion;
    private int currentDbVersion;

    public DatabaseUpgrade(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DatabaseHistory databaseHistory, CyclosProperties cyclosProperties) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.databaseHistory = databaseHistory;
        this.cyclosProperties = cyclosProperties;
        Pair<String, Integer> pair = this.readVersion();
        this.currentApplicationVersion = (String)pair.getFirst();
        this.currentDbVersion = (Integer)pair.getSecond();
    }

    public String getCurrentApplicationVersion() {
        return this.currentApplicationVersion;
    }

    public int getCurrentDbVersion() {
        return this.currentDbVersion;
    }

    public Status getStatus() {
        if (this.currentDbVersion == -2) {
            return Status.NO_SCHEMA;
        }
        if (this.currentDbVersion == -1) {
            return Status.NO_DATA;
        }
        String string = this.databaseHistory.normalizeVersion(CyclosVersion.get());
        if (!string.equals(this.currentApplicationVersion)) {
            if (this.databaseHistory.exists(this.currentApplicationVersion)) {
                return Status.NEEDS_UPGRADE;
            }
            return Status.INVALID;
        }
        int n = this.databaseHistory.getLastDbVersion(this.currentApplicationVersion);
        if (this.currentDbVersion == n) {
            return Status.UP_TO_DATE;
        }
        if (this.currentDbVersion > n) {
            return Status.INVALID;
        }
        return Status.NEEDS_UPGRADE;
    }

    public void removeStalePermissions() throws SQLException {
        Permission[] permissionArray = Permission.values();
        this.jdbcTemplate.execute(connection -> {
            Object[] objectArray = new String[permissionArray.length];
            Arrays.fill(objectArray, "?");
            return connection.prepareStatement("delete from products_permissions where permission not in (" + StringUtils.join((Object[])objectArray, (String)",") + ")");
        }, preparedStatement -> {
            for (int i = 0; i < permissionArray.length; ++i) {
                preparedStatement.setString(i + 1, permissionArray[i].name());
            }
            preparedStatement.execute();
            return null;
        });
    }

    public void upgrade() throws SQLException {
        List<String> list = this.databaseHistory.getApplicationVersionsToUpgrade(this.currentApplicationVersion);
        for (String string : list) {
            if (!string.equals(this.currentApplicationVersion)) {
                this.transactionTemplate.execute(transactionStatus -> {
                    this.jdbcTemplate.update("update application set app_version = ?, db_version=?", new Object[]{string, 0});
                    return null;
                });
                LOG.info("Upgrading to application version " + string);
                if (!VERSIONS_WITHOUT_DB_LOG.contains(this.currentApplicationVersion)) {
                    this.insertMissingDbLogs();
                }
                this.currentApplicationVersion = string;
                this.currentDbVersion = 0;
            }
            SortedMap<Integer, VersionScript> sortedMap = this.databaseHistory.getScripts(this.currentApplicationVersion);
            TreeMap<Integer, VersionScript> treeMap = new TreeMap<Integer, VersionScript>();
            treeMap.putAll(sortedMap.headMap(this.currentDbVersion));
            for (Map.Entry entry : treeMap.entrySet()) {
                int n = (Integer)entry.getKey();
                VersionScript versionScript = (VersionScript)entry.getValue();
                LOG.info("Upgrading to database version " + n);
                String string2 = null;
                try {
                    this.applyVersion(versionScript);
                }
                catch (DatabaseUpgradeException databaseUpgradeException) {
                    string2 = ExceptionUtils.getStackTrace((Throwable)databaseUpgradeException.getCause());
                }
                this.transactionTemplate.execute(transactionStatus -> {
                    this.jdbcTemplate.update("update application set db_version = ?", new Object[]{n});
                    return null;
                });
                if (string2 != null) {
                    LOG.warn("There were some errors while upgrading to version " + n + ". However, it is possible that the database is still consistent, depending on the statement (for example, a 'drop table' that failed because the table does not exist)");
                } else {
                    LOG.info("Successfully upgraded to database version " + n);
                }
                this.currentDbVersion = n;
                this.insertLog(string2);
            }
        }
    }

    private void applyVersion(VersionScript versionScript) {
        if (versionScript.isAlias()) {
            int n;
            String[] stringArray = versionScript.getAlias().split("_");
            String string = stringArray[0];
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Invalid alias version: " + String.valueOf(versionScript));
            }
            SortedMap<Integer, VersionScript> sortedMap = this.databaseHistory.getScripts(string);
            VersionScript versionScript2 = (VersionScript)sortedMap.get(n);
            if (versionScript2 == null) {
                throw new IllegalStateException("Invalid alias version: " + String.valueOf(versionScript));
            }
            String string2 = "select date from db_history_logs where app_version = ? and db_version = ?";
            try {
                Date date = (Date)this.transactionTemplate.execute(transactionStatus -> (Date)this.jdbcTemplate.queryForObject(string2, Date.class, new Object[]{string, n}));
                LOG.info("Skipping version " + versionScript.getVersion() + " because it is an alias to " + versionScript.getAlias() + " which was already executed on " + String.valueOf(date));
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                this.transactionTemplate.execute(transactionStatus -> {
                    ScriptHelper.run(this.jdbcTemplate, versionScript2.getScript(), this.currentApplicationVersion, versionScript2.getVersion(), true, this.cyclosProperties);
                    return null;
                });
            }
        } else {
            this.transactionTemplate.execute(transactionStatus -> {
                ScriptHelper.run(this.jdbcTemplate, versionScript.getScript(), this.currentApplicationVersion, versionScript.getVersion(), true, this.cyclosProperties);
                return null;
            });
        }
    }

    private void insertLog(String string) {
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                this.jdbcTemplate.update("delete from db_history_logs where app_version = ? and db_version = ?", new Object[]{this.currentApplicationVersion, this.currentDbVersion});
                this.jdbcTemplate.update("insert into db_history_logs (date, app_version, db_version, error, log_generated) values (?, ?, ?, ?, ?)", new Object[]{new Date(), this.currentApplicationVersion, this.currentDbVersion, string, false});
                return null;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void insertMissingDbLogs() {
        List<Integer> list = this.databaseHistory.getDbVersions(this.currentApplicationVersion);
        String string = "select date from db_history_logs where app_version = ? and db_version = ?";
        String string2 = "insert into db_history_logs (app_version, db_version, date) values (?, ?, now())";
        Collections.reverse(list);
        for (Integer n : list) {
            if (n <= 0) continue;
            try {
                boolean bl = false;
                try {
                    Date date = (Date)this.transactionTemplate.execute(transactionStatus -> (Date)this.jdbcTemplate.queryForObject(string, Date.class, new Object[]{this.currentApplicationVersion, n}));
                    bl = date == null;
                }
                catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                    bl = true;
                }
                if (!bl) continue;
                this.transactionTemplate.execute(transactionStatus -> this.jdbcTemplate.update(string2, new Object[]{this.currentApplicationVersion, n}));
            }
            catch (Exception exception) {
                LOG.warn("Error checking log for database version " + this.currentApplicationVersion + "_db" + n, (Throwable)exception);
            }
        }
    }

    private Pair<String, Integer> readVersion() {
        return (Pair)this.transactionTemplate.execute(transactionStatus -> {
            transactionStatus.setRollbackOnly();
            try {
                return (Pair)this.jdbcTemplate.query("select app_version, db_version from application", resultSet -> {
                    if (resultSet.next()) {
                        return Pair.create((Object)resultSet.getString("app_version"), (Object)resultSet.getInt("db_version"));
                    }
                    throw new EmptyResultDataAccessException(1);
                });
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                return Pair.create((Object)"", (Object)-1);
            }
            catch (Exception exception) {
                return Pair.create((Object)"", (Object)-2);
            }
        });
    }

    public static enum Status {
        UP_TO_DATE,
        NEEDS_UPGRADE,
        NO_SCHEMA,
        NO_DATA,
        INVALID;

    }
}

