/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Properties;
import javax.sql.DataSource;
import org.cyclos.bootstrap.BaseDataSourceProvider;
import org.cyclos.utils.StringHelper;

public class HikariDataSourceProvider
extends BaseDataSourceProvider {
    @Override
    public String getConnectionDetails(Properties properties) {
        if (StringHelper.isNotBlank((Object)properties.getProperty("dataSourceClassName"))) {
            String string = StringHelper.trimToNull((Object)properties.getProperty("dataSource.databaseName"));
            String string2 = StringHelper.trimToNull((Object)properties.getProperty("dataSource.serverName"));
            String string3 = StringHelper.trimToNull((Object)properties.getProperty("dataSource.portNumber"));
            return string + "@" + string2 + (String)(string3 == null ? "" : ":" + string3);
        }
        return properties.getProperty("jdbcUrl");
    }

    @Override
    protected void doDestroy(DataSource dataSource) throws Exception {
        ((HikariDataSource)dataSource).close();
    }

    @Override
    protected DataSource doInitialize(Properties properties) throws Exception {
        HikariConfig hikariConfig = new HikariConfig(properties);
        return new HikariDataSource(hikariConfig);
    }
}

