/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.lang.reflect.AnnotatedElement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.EntityManagerFactory;
import javax.persistence.JoinTable;
import javax.persistence.PersistenceException;
import javax.persistence.Table;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.bootstrap.CyclosEclipseLinkJpaDialect;
import org.cyclos.bootstrap.DatabaseManager;
import org.cyclos.impl.sql.DatabaseCachingMetadata;
import org.cyclos.impl.utils.cluster.ClusterHandler;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.utils.CollectionHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class EntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    private static final Logger LOG = LogManager.getLogger(EntityManagerFactoryBean.class);
    @Autowired(required=false)
    protected DatabaseManager databaseManager;
    @Autowired(required=false)
    private ClusterHandler clusterHandler;
    @Autowired
    private CyclosProperties cyclosProperties;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private DatabaseCachingMetadata metadata;

    @PostConstruct
    public void initialize() {
        this.setJpaDialect((JpaDialect)new CyclosEclipseLinkJpaDialect(this.dataSource));
    }

    public void setJpaProperties(Properties properties) {
        properties.setProperty("eclipselink.weaving", "static");
        properties.setProperty("eclipselink.ddl-generation.index-foreign-keys", "true");
        properties.setProperty("eclipselink.cache.shared.default", "false");
        super.setJpaProperties(properties);
    }

    protected EntityManagerFactory createNativeEntityManagerFactory() throws PersistenceException {
        this.setJpaProperties(this.cyclosProperties.getProperties());
        return super.createNativeEntityManagerFactory();
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory entityManagerFactory, PersistenceUnitInfo persistenceUnitInfo) {
        if (this.clusterHandler != null) {
            this.clusterHandler.getHostId();
        }
        this.databaseManager.doWithCyclosInstanceLock(() -> {
            if (this.clusterHandler != null) {
                this.clusterHandler.lockDatabase();
            }
            try {
                this.databaseManager.manageDatabase(entityManagerFactory);
            }
            catch (SQLException sQLException) {
                throw new PersistenceException("Error while performing the database checks", (Throwable)sQLException);
            }
        });
        for (EntityType entityType : entityManagerFactory.getMetamodel().getEntities()) {
            Class clazz = entityType.getJavaType();
            if (!this.isCacheable(clazz)) continue;
            String string2 = this.getTable(clazz);
            if (string2 != null) {
                this.metadata.addCacheableTable(string2);
            }
            for (Attribute attribute : entityType.getAttributes()) {
                this.collectAttribute(string2, attribute, null);
            }
        }
        if (LOG.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Cacheable tables:\n");
            CollectionHelper.sort((Collection)this.metadata.getCacheableTables()).forEach(string -> stringBuilder.append(" * ").append((String)string).append("\n"));
            stringBuilder.append("-----------------\n");
            stringBuilder.append("Many-to-many tables:\n");
            new TreeMap(CollectionHelper.orEmpty((Map)this.metadata.getManyToManyTables())).entrySet().forEach(entry -> stringBuilder.append(" * ").append((String)entry.getKey()).append(": ").append(entry.getValue()).append("\n"));
            stringBuilder.append("-----------------\n");
            LOG.debug(stringBuilder.toString());
        }
    }

    private void collectAttribute(String string, Attribute<?, ?> attribute2, AssociationOverrides associationOverrides) {
        AnnotatedElement annotatedElement = (AnnotatedElement)((Object)attribute2.getJavaMember());
        String string2 = attribute2.getName();
        AssociationOverride associationOverride2 = null;
        if (associationOverrides != null) {
            associationOverride2 = Stream.of(associationOverrides.value()).filter(associationOverride -> associationOverride.name().equals(string2)).findFirst().orElse(null);
        }
        switch (attribute2.getPersistentAttributeType()) {
            case BASIC: 
            case MANY_TO_ONE: 
            case ONE_TO_ONE: 
            case ONE_TO_MANY: {
                return;
            }
            case ELEMENT_COLLECTION: {
                CollectionTable collectionTable = annotatedElement.getAnnotation(CollectionTable.class);
                this.metadata.addCacheableTable(collectionTable == null ? null : collectionTable.name());
                break;
            }
            case EMBEDDED: {
                SingularAttribute singularAttribute = (SingularAttribute)attribute2;
                EmbeddableType embeddableType = (EmbeddableType)singularAttribute.getType();
                embeddableType.getAttributes().forEach(attribute -> this.collectAttribute(string, (Attribute<?, ?>)attribute, annotatedElement.getAnnotation(AssociationOverrides.class)));
                break;
            }
            case MANY_TO_MANY: {
                PluralAttribute pluralAttribute = (PluralAttribute)attribute2;
                Class clazz = pluralAttribute.getElementType().getJavaType();
                if (!this.isCacheable(clazz)) {
                    return;
                }
                Table table = (Table)AnnotationUtils.findAnnotation((Class)clazz, Table.class);
                JoinTable joinTable = null;
                Object[] objectArray = null;
                if (associationOverride2 != null) {
                    joinTable = associationOverride2.joinTable();
                    objectArray = associationOverride2.joinColumns();
                }
                if (joinTable == null) {
                    joinTable = annotatedElement.getAnnotation(JoinTable.class);
                }
                if (objectArray == null && joinTable != null) {
                    objectArray = joinTable.joinColumns();
                }
                if (joinTable == null || CollectionHelper.size((Object[])objectArray) != 1 || table == null) break;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string);
                arrayList.add(table.name());
                this.metadata.addManyToManyCacheableTable(joinTable.name(), arrayList);
            }
        }
    }

    private String getTable(Class<?> clazz) {
        Table table = (Table)AnnotationUtils.findAnnotation(clazz, Table.class);
        return table == null ? null : table.name();
    }

    private boolean isCacheable(Class<?> clazz) {
        Cacheable cacheable = (Cacheable)AnnotationUtils.findAnnotation(clazz, Cacheable.class);
        return cacheable != null && cacheable.value();
    }
}

