/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.bootstrap;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cyclos.bootstrap.DataSourceShutdownHandler;
import org.springframework.stereotype.Component;

@Component
public class DataSourceShutdownHandlerImpl
implements DataSourceShutdownHandler {
    private static final Logger LOG = LogManager.getLogger(DataSourceShutdownHandlerImpl.class);
    private List<Runnable> actions = new ArrayList<Runnable>();

    @Override
    public void execute() {
        this.actions.forEach(runnable -> {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LOG.warn("Error executing a datasource shutdown action", (Throwable)exception);
            }
        });
        this.actions.clear();
    }

    @Override
    public void register(Runnable runnable) {
        this.actions.add(runnable);
    }
}

