/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import org.opensearch.action.ActionListener;
import org.opensearch.action.search.ClearScrollController;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchTransportService;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class TransportClearScrollAction
extends HandledTransportAction<ClearScrollRequest, ClearScrollResponse> {
    private final ClusterService clusterService;
    private final SearchTransportService searchTransportService;
    private final NamedWriteableRegistry namedWriteableRegistry;

    @Inject
    public TransportClearScrollAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, SearchTransportService searchTransportService, NamedWriteableRegistry namedWriteableRegistry) {
        super("indices:data/read/scroll/clear", transportService, actionFilters, ClearScrollRequest::new);
        this.clusterService = clusterService;
        this.searchTransportService = searchTransportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    protected void doExecute(Task task, ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        ClearScrollController runnable = new ClearScrollController(request, listener, this.clusterService.state().nodes(), this.logger, this.searchTransportService);
        runnable.run();
    }
}

