/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.opensearch.action.admin.indices.rollover.Condition;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.ParseField;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;

public class RolloverInfo
extends AbstractDiffable<RolloverInfo>
implements Writeable,
ToXContentFragment {
    public static final ParseField CONDITION_FIELD = new ParseField("met_conditions", new String[0]);
    public static final ParseField TIME_FIELD = new ParseField("time", new String[0]);
    public static final ConstructingObjectParser<RolloverInfo, String> PARSER = new ConstructingObjectParser("rollover_info", false, (a, alias) -> new RolloverInfo((String)alias, (List)a[0], (Long)a[1]));
    private final String alias;
    private final List<Condition<?>> metConditions;
    private final long time;

    public RolloverInfo(String alias, List<Condition<?>> metConditions, long time) {
        this.alias = alias;
        this.metConditions = metConditions;
        this.time = time;
    }

    public RolloverInfo(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.time = in.readVLong();
        this.metConditions = in.readNamedWriteableList(Condition.class);
    }

    public static RolloverInfo parse(XContentParser parser, String alias) {
        return (RolloverInfo)PARSER.apply(parser, (Object)alias);
    }

    public String getAlias() {
        return this.alias;
    }

    public List<Condition<?>> getMetConditions() {
        return this.metConditions;
    }

    public long getTime() {
        return this.time;
    }

    public static Diff<RolloverInfo> readDiffFrom(StreamInput in) throws IOException {
        return RolloverInfo.readDiffFrom(RolloverInfo::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias);
        out.writeVLong(this.time);
        out.writeNamedWriteableList(this.metConditions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.alias);
        builder.startObject(CONDITION_FIELD.getPreferredName());
        for (Condition<?> condition : this.metConditions) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.field(TIME_FIELD.getPreferredName(), this.time);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.metConditions, this.time);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RolloverInfo other = (RolloverInfo)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.metConditions, other.metConditions) && Objects.equals(this.time, other.time);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> (Condition)p.namedObject(Condition.class, n, c), CONDITION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIME_FIELD);
    }
}

