/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.ObjectPool;
import org.apache.http.entity.ContentType;
import org.cyclos.server.utils.IOHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.utils.GzipResponseStream;

public class GzipResponse
extends HttpServletResponseWrapper {
    private static final Set<String> PROCESSABLE_CONTENT_TYPES = CollectionHelper.asSet((Object[])new String[]{ContentType.APPLICATION_JSON.getMimeType(), ContentType.APPLICATION_XML.getMimeType(), ContentType.TEXT_PLAIN.getMimeType(), ContentType.TEXT_XML.getMimeType(), ContentType.TEXT_HTML.getMimeType()});
    private ObjectPool<byte[]> pool;
    private byte[] buffer;
    private GzipResponseStream gzipStream;
    private ServletOutputStream outputStream;
    private PrintWriter printWriter;

    public GzipResponse(HttpServletResponse httpServletResponse, ObjectPool<byte[]> objectPool) throws IOException {
        super(httpServletResponse);
        this.pool = objectPool;
    }

    public void addHeader(String string, String string2) {
        if (this.isContentLength(string)) {
            return;
        }
        super.addHeader(string, string2);
    }

    public void addIntHeader(String string, int n) {
        if (this.isContentLength(string)) {
            return;
        }
        super.addIntHeader(string, n);
    }

    public void finish() throws IOException {
        if (this.gzipStream != null) {
            IOHelper.close((Closeable[])new Closeable[]{this.outputStream, this.printWriter});
        }
        if (this.buffer != null) {
            try {
                this.pool.returnObject((Object)this.buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void flushBuffer() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
        super.flushBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.printWriter != null) {
            throw new IllegalStateException("getWriter() already called!");
        }
        if (this.outputStream == null) {
            this.initGzipStream();
            this.outputStream = this.gzipStream == null ? super.getOutputStream() : this.gzipStream;
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStream != null) {
            throw new IllegalStateException("getOutputStream() already called!");
        }
        if (this.printWriter == null) {
            this.initGzipStream();
            this.printWriter = this.gzipStream == null ? super.getWriter() : new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.gzipStream), this.getResponse().getCharacterEncoding()));
        }
        return this.printWriter;
    }

    public void setContentLength(int n) {
    }

    public void setContentLengthLong(long l) {
    }

    public void setHeader(String string, String string2) {
        if (this.isContentLength(string)) {
            return;
        }
        super.setHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        if (this.isContentLength(string)) {
            return;
        }
        super.setIntHeader(string, n);
    }

    private void initGzipStream() throws IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)this.getResponse();
        if (StringHelper.isNotBlank((Object)httpServletResponse.getHeader("Content-Encoding"))) {
            return;
        }
        String string = httpServletResponse.getContentType();
        if (string != null) {
            string = StringUtils.substringBefore((String)string, (String)";").trim();
        }
        if (!PROCESSABLE_CONTENT_TYPES.contains(string)) {
            return;
        }
        try {
            this.buffer = (byte[])this.pool.borrowObject();
        }
        catch (Exception exception) {
            return;
        }
        this.gzipStream = new GzipResponseStream(httpServletResponse, this.buffer);
    }

    private boolean isContentLength(String string) {
        return string.equalsIgnoreCase("Content-Length");
    }
}

