/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rpc;

import com.google.common.base.Optional;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cyclos.services.Service;
import org.springframework.stereotype.Component;

@Component
public class WebRpcServiceRegistry {
    private Map<Class<?>, ConcurrentMap<String, Optional<Method>>> cache = new WeakHashMap();

    public Method get(Class<?> clazz, String string) {
        Optional optional;
        ConcurrentMap<String, Optional<Method>> concurrentMap = this.cache.get(clazz);
        if (concurrentMap == null) {
            concurrentMap = new ConcurrentHashMap<String, Optional<Method>>();
            this.cache.put(clazz, concurrentMap);
        }
        if ((optional = (Optional)concurrentMap.get(string)) == null) {
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(string) || !Service.class.isAssignableFrom(method.getDeclaringClass())) continue;
                optional = Optional.of((Object)method);
                break;
            }
            if (optional == null) {
                optional = Optional.absent();
            }
            concurrentMap.put(string, (Optional<Method>)optional);
        }
        return (Method)optional.orNull();
    }
}

