/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.channels.IdentificationMethod;
import org.cyclos.model.access.clients.AccessClientLocatorVO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.accounts.ITransSearchData;
import org.cyclos.model.banking.accounts.InternalAccountOwner;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.authorizationroles.AuthorizationRoleVO;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.authorizations.TransactionAuthorizationDTO;
import org.cyclos.model.banking.authorizations.TransactionAuthorizationVO;
import org.cyclos.model.banking.currencies.CurrencyVO;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.AbstractTransQuery;
import org.cyclos.model.banking.transactions.AbstractTransactionQuery;
import org.cyclos.model.banking.transactions.BaseInternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.BasePaymentData;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.BasePaymentTypeData;
import org.cyclos.model.banking.transactions.BasePaymentVO;
import org.cyclos.model.banking.transactions.BaseTransactionQuery;
import org.cyclos.model.banking.transactions.CreateTicketData;
import org.cyclos.model.banking.transactions.ExternalPaymentData;
import org.cyclos.model.banking.transactions.ExternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentResultVO;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.ITransactionSearchData;
import org.cyclos.model.banking.transactions.PaymentAuthorizationLevelData;
import org.cyclos.model.banking.transactions.PaymentCreationType;
import org.cyclos.model.banking.transactions.PaymentData;
import org.cyclos.model.banking.transactions.PaymentPreviewVO;
import org.cyclos.model.banking.transactions.PaymentRequestData;
import org.cyclos.model.banking.transactions.PaymentRequestResultVO;
import org.cyclos.model.banking.transactions.PaymentRequestVO;
import org.cyclos.model.banking.transactions.PerformInternalTransactionDTO;
import org.cyclos.model.banking.transactions.PerformPaymentData;
import org.cyclos.model.banking.transactions.PerformPaymentToOwnerData;
import org.cyclos.model.banking.transactions.PerformPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.ReceivePaymentData;
import org.cyclos.model.banking.transactions.ReceivePaymentFromUserData;
import org.cyclos.model.banking.transactions.RecurringPaymentData;
import org.cyclos.model.banking.transactions.RecurringPaymentPreviewVO;
import org.cyclos.model.banking.transactions.RecurringPaymentResultVO;
import org.cyclos.model.banking.transactions.RecurringPaymentVO;
import org.cyclos.model.banking.transactions.RequestPaymentData;
import org.cyclos.model.banking.transactions.RequestPaymentTypeData;
import org.cyclos.model.banking.transactions.ScheduledPaymentData;
import org.cyclos.model.banking.transactions.ScheduledPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentResultVO;
import org.cyclos.model.banking.transactions.ScheduledPaymentVO;
import org.cyclos.model.banking.transactions.TicketData;
import org.cyclos.model.banking.transactions.TicketPaymentTypeData;
import org.cyclos.model.banking.transactions.TicketResultVO;
import org.cyclos.model.banking.transactions.TicketVO;
import org.cyclos.model.banking.transactions.TransVO;
import org.cyclos.model.banking.transactions.TransactionAuthorizationStatus;
import org.cyclos.model.banking.transactions.TransactionAuthorizationType;
import org.cyclos.model.banking.transactions.TransactionData;
import org.cyclos.model.banking.transactions.TransactionDetailedVO;
import org.cyclos.model.banking.transactions.TransactionNature;
import org.cyclos.model.banking.transactions.TransactionOrderBy;
import org.cyclos.model.banking.transactions.TransactionOverviewQuery;
import org.cyclos.model.banking.transactions.TransactionOverviewSearchData;
import org.cyclos.model.banking.transactions.TransactionQuery;
import org.cyclos.model.banking.transactions.TransactionResultVO;
import org.cyclos.model.banking.transactions.TransactionSearchData;
import org.cyclos.model.banking.transactions.TransactionSubjects;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.banking.transactions.TransferFeesPreviewVO;
import org.cyclos.model.banking.transferfilters.TransferFilterVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.coercion.CoercionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ExternalPaymentsApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.OidcApiHelper;
import org.cyclos.web.rest.helpers.PaymentFeedbacksApiHelper;
import org.cyclos.web.rest.helpers.PaymentRequestsApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.RecurringPaymentsApiHelper;
import org.cyclos.web.rest.helpers.ScheduledPaymentsApiHelper;
import org.cyclos.web.rest.helpers.TicketsApiHelper;
import org.cyclos.web.rest.helpers.TransfersApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.model.AccountKind;
import org.cyclos.web.rest.model.AccountWithOwner;
import org.cyclos.web.rest.model.BaseTransDataForSearch;
import org.cyclos.web.rest.model.BaseTransQueryFilters;
import org.cyclos.web.rest.model.BaseTransactionDataForSearch;
import org.cyclos.web.rest.model.BaseTransactionOrInstallmentQueryFilters;
import org.cyclos.web.rest.model.BaseTransactionQueryFilters;
import org.cyclos.web.rest.model.BaseTransactionResult;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.IdentificationMethodEnum;
import org.cyclos.web.rest.model.InternalTransactionPreview;
import org.cyclos.web.rest.model.PaymentCreationTypeEnum;
import org.cyclos.web.rest.model.PaymentFeedbacksPermissions;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PaymentRequestPermissions;
import org.cyclos.web.rest.model.PendingPaymentActionParams;
import org.cyclos.web.rest.model.PerformInternalTransaction;
import org.cyclos.web.rest.model.PerformTransaction;
import org.cyclos.web.rest.model.RestModel;
import org.cyclos.web.rest.model.Trans;
import org.cyclos.web.rest.model.TransOrderByEnum;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.rest.model.TransactionAuthorization;
import org.cyclos.web.rest.model.TransactionAuthorizationActionEnum;
import org.cyclos.web.rest.model.TransactionAuthorizationLevelData;
import org.cyclos.web.rest.model.TransactionAuthorizationPermissions;
import org.cyclos.web.rest.model.TransactionAuthorizationStatusEnum;
import org.cyclos.web.rest.model.TransactionAuthorizationTypeEnum;
import org.cyclos.web.rest.model.TransactionDataForSearch;
import org.cyclos.web.rest.model.TransactionKind;
import org.cyclos.web.rest.model.TransactionOverviewDataForSearch;
import org.cyclos.web.rest.model.TransactionOverviewQueryFilters;
import org.cyclos.web.rest.model.TransactionOverviewResult;
import org.cyclos.web.rest.model.TransactionPreview;
import org.cyclos.web.rest.model.TransactionQueryFilters;
import org.cyclos.web.rest.model.TransactionResult;
import org.cyclos.web.rest.model.TransactionSubjectsEnum;
import org.cyclos.web.rest.model.TransactionTypeData;
import org.cyclos.web.rest.model.TransactionView;
import org.cyclos.web.rest.model.TransferFeesPreview;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class TransactionsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private TransfersApiHelper transfersApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private TicketsApiHelper ticketsApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;
    @Autowired
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    private PaymentFeedbacksApiHelper paymentFeedbacksApiHelper;
    @Autowired
    private ScheduledPaymentsApiHelper scheduledPaymentsApiHelper;
    @Autowired
    private RecurringPaymentsApiHelper recurringPaymentsApiHelper;
    @Autowired
    private ExternalPaymentsApiHelper externalPaymentsApiHelper;
    @Autowired
    private OidcApiHelper oidcApiHelper;
    @Autowired
    private PaymentRequestsApiHelper paymentRequestsApiHelper;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;

    public String getKey(TransactionVO transactionVO) {
        String string = transactionVO.getTransactionNumber();
        if (string == null) {
            string = ApiHelper.toId(transactionVO.getId());
        }
        return string;
    }

    public <Q extends AbstractTransactionQuery> Q newAbstractTransactionQuery(Class<Q> clazz, BaseTransactionOrInstallmentQueryFilters baseTransactionOrInstallmentQueryFilters) {
        AbstractTransactionQuery abstractTransactionQuery = (AbstractTransactionQuery)this.newAbstractTransQuery(clazz, baseTransactionOrInstallmentQueryFilters);
        abstractTransactionQuery.setNatures(CollectionHelper.orEmpty(baseTransactionOrInstallmentQueryFilters.getKinds()).stream().map(this::toTransactionNature).filter(Objects::nonNull).collect(Collectors.toSet()));
        abstractTransactionQuery.setCreationTypes(CollectionHelper.orEmpty(baseTransactionOrInstallmentQueryFilters.getCreationTypes()).stream().map(this::toPaymentCreationType).collect(Collectors.toSet()));
        abstractTransactionQuery.setAuthorized(baseTransactionOrInstallmentQueryFilters.getAuthorized());
        abstractTransactionQuery.setAuthorizationPerformedBy((BasicUserVO)ModelHelper.voFromString(BasicUserVO.class, (String)baseTransactionOrInstallmentQueryFilters.getAuthorizationPerformedBy()));
        abstractTransactionQuery.setAuthorizationStatuses(CollectionHelper.orEmpty(baseTransactionOrInstallmentQueryFilters.getAuthorizationStatuses()).stream().map(this::toTransactionAuthorizationStatus).collect(Collectors.toSet()));
        abstractTransactionQuery.setAuthorizationPerformedBy((BasicUserVO)ModelHelper.voFromString(UserVO.class, (String)baseTransactionOrInstallmentQueryFilters.getAuthorizationPerformedBy()));
        if (baseTransactionOrInstallmentQueryFilters.getKinds() != null && baseTransactionOrInstallmentQueryFilters.getKinds().contains(TransactionKind.ORDER)) {
            abstractTransactionQuery.getNatures().add(TransactionNature.PAYMENT);
            abstractTransactionQuery.getCreationTypes().add(PaymentCreationType.ORDER);
        }
        if (baseTransactionOrInstallmentQueryFilters.getKinds() != null && baseTransactionOrInstallmentQueryFilters.getKinds().contains(TransactionKind.IMPORT)) {
            abstractTransactionQuery.getNatures().add(TransactionNature.PAYMENT);
            abstractTransactionQuery.getCreationTypes().add(PaymentCreationType.IMPORT);
        }
        return (Q)abstractTransactionQuery;
    }

    public <Q extends AbstractTransQuery> Q newAbstractTransQuery(Class<Q> clazz, BaseTransQueryFilters baseTransQueryFilters) {
        AbstractTransQuery abstractTransQuery = (AbstractTransQuery)this.apiHelper.newQuery(clazz, baseTransQueryFilters);
        abstractTransQuery.setPeriod(this.apiHelper.toDatePeriodDTO(baseTransQueryFilters.getDatePeriod()));
        abstractTransQuery.setTransferFilters(ModelHelper.vosFromString(TransferFilterVO.class, baseTransQueryFilters.getTransferFilters()));
        abstractTransQuery.setTransferTypes(ModelHelper.vosFromString(TransferTypeVO.class, baseTransQueryFilters.getTransferTypes()));
        abstractTransQuery.setTransactionNumber(baseTransQueryFilters.getTransactionNumber());
        abstractTransQuery.setUser((UserVO)ModelHelper.voFromString(UserVO.class, (String)baseTransQueryFilters.getUser()));
        abstractTransQuery.setGroups(ModelHelper.vosFromString(BasicGroupVO.class, baseTransQueryFilters.getGroups()));
        abstractTransQuery.setBy((BasicUserVO)ModelHelper.voFromString(UserVO.class, (String)baseTransQueryFilters.getBy()));
        abstractTransQuery.setBrokers(CollectionHelper.orEmpty(baseTransQueryFilters.getBrokers()).stream().map(string -> (UserVO)ModelHelper.voFromString(UserVO.class, (String)string)).collect(Collectors.toSet()));
        abstractTransQuery.setChannels(ModelHelper.vosFromString(ChannelVO.class, baseTransQueryFilters.getChannels()));
        abstractTransQuery.setAccessClients(ModelHelper.vosFromString(AccessClientLocatorVO.class, baseTransQueryFilters.getAccessClients()));
        abstractTransQuery.setIncludeGeneratedByAccessClient(Boolean.TRUE.equals(baseTransQueryFilters.getIncludeGeneratedByAccessClient()));
        abstractTransQuery.setExcludedIds(CoercionHelper.coerceSet(Long.class, baseTransQueryFilters.getExcludedIds()));
        abstractTransQuery.setFromCurrentAccessClient(Boolean.TRUE.equals(baseTransQueryFilters.getFromCurrentAccessClient()));
        abstractTransQuery.setAmount(this.apiHelper.toDecimalRangeDTO(baseTransQueryFilters.getAmountRange()));
        abstractTransQuery.setOrderBy(this.toTransactionOrderBy(baseTransQueryFilters.getOrderBy()));
        abstractTransQuery.setCustomValues(this.apiHelper.toCustomFieldValuesForSearch(baseTransQueryFilters.getCustomFields()));
        return (Q)abstractTransQuery;
    }

    public <QF extends BaseTransactionOrInstallmentQueryFilters> QF newBaseTransactionOrInstallmentQueryFilters(Class<QF> clazz, AbstractTransactionQuery abstractTransactionQuery) {
        BaseTransactionOrInstallmentQueryFilters baseTransactionOrInstallmentQueryFilters = (BaseTransactionOrInstallmentQueryFilters)this.newBaseTransQueryFilters(clazz, (AbstractTransQuery)abstractTransactionQuery);
        CollectionHelper.orEmpty((Set)abstractTransactionQuery.getNatures()).stream().map(this::toTransactionKind).forEach(baseTransactionOrInstallmentQueryFilters.getKinds()::add);
        CollectionHelper.orEmpty((Set)abstractTransactionQuery.getCreationTypes()).stream().map(this::toPaymentCreationTypeEnum).forEach(baseTransactionOrInstallmentQueryFilters.getCreationTypes()::add);
        baseTransactionOrInstallmentQueryFilters.setAuthorizationPerformedBy(ModelHelper.stringOrIdFromVO((EntityVO)abstractTransactionQuery.getAuthorizationPerformedBy()));
        CollectionHelper.orEmpty((Set)abstractTransactionQuery.getAuthorizationStatuses()).stream().map(this::toTransactionAuthorizationStatusEnum).forEach(baseTransactionOrInstallmentQueryFilters.getAuthorizationStatuses()::add);
        baseTransactionOrInstallmentQueryFilters.setAuthorized(abstractTransactionQuery.getAuthorized());
        return (QF)baseTransactionOrInstallmentQueryFilters;
    }

    public <D extends BaseTransDataForSearch> D newBaseTransDataForSearch(Class<D> clazz, ITransSearchData iTransSearchData) {
        BaseTransDataForSearch baseTransDataForSearch = (BaseTransDataForSearch)ClassHelper.instantiate(clazz);
        baseTransDataForSearch.setArchivingDate(iTransSearchData.getArchivingDate());
        CollectionHelper.orEmpty((List)iTransSearchData.getTransferFilters()).stream().map(this.accountsApiHelper::toTransferFilter).forEach(baseTransDataForSearch.getTransferFilters()::add);
        CollectionHelper.orEmpty((List)iTransSearchData.getChannels()).stream().map(this.apiHelper::toReference).forEach(baseTransDataForSearch.getChannels()::add);
        CollectionHelper.orEmpty((List)iTransSearchData.getManagedGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(baseTransDataForSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)iTransSearchData.getPreselectedPeriods()).stream().map(this.apiHelper::toPreselectedPeriod).forEach(baseTransDataForSearch.getPreselectedPeriods()::add);
        CollectionHelper.orEmpty((List)iTransSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(baseTransDataForSearch.getExportFormats()::add);
        List list = CollectionHelper.orEmpty((List)iTransSearchData.getFieldsForSearch());
        List list2 = CollectionHelper.orEmpty((List)iTransSearchData.getFieldsForList());
        LinkedHashSet linkedHashSet = new LinkedHashSet(list);
        linkedHashSet.addAll(list2);
        linkedHashSet.stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseTransDataForSearch.getCustomFields()::add);
        list.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(baseTransDataForSearch.getFieldsInBasicSearch()::add);
        list2.stream().map(ModelHelper::unqualifiedInternalNameOrId).forEach(baseTransDataForSearch.getFieldsInList()::add);
        CollectionHelper.orEmpty((List)iTransSearchData.getFieldsForSearch()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseTransDataForSearch.getCustomFieldsInSearch()::add);
        CollectionHelper.orEmpty((List)iTransSearchData.getFieldsForList()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(baseTransDataForSearch.getCustomFieldsInList()::add);
        return (D)baseTransDataForSearch;
    }

    public <QF extends BaseTransQueryFilters> QF newBaseTransQueryFilters(Class<QF> clazz, AbstractTransQuery abstractTransQuery) {
        BaseTransQueryFilters baseTransQueryFilters = (BaseTransQueryFilters)this.apiHelper.newQueryFilters(clazz, (QueryParameters)abstractTransQuery);
        baseTransQueryFilters.setDatePeriod(this.apiHelper.toFilter(abstractTransQuery.getPeriod()));
        CollectionHelper.orEmpty((Set)abstractTransQuery.getTransferFilters()).stream().map(ModelHelper::internalNameOrId).forEach(baseTransQueryFilters.getTransferFilters()::add);
        CollectionHelper.orEmpty((Set)abstractTransQuery.getTransferTypes()).stream().map(ModelHelper::internalNameOrId).forEach(baseTransQueryFilters.getTransferTypes()::add);
        baseTransQueryFilters.setTransactionNumber(abstractTransQuery.getTransactionNumber());
        baseTransQueryFilters.setUser(ModelHelper.stringOrIdFromVO((EntityVO)abstractTransQuery.getUser()));
        CollectionHelper.orEmpty((Set)abstractTransQuery.getGroups()).stream().map(ModelHelper::internalNameOrId).forEach(baseTransQueryFilters.getGroups()::add);
        baseTransQueryFilters.setBy(ModelHelper.stringOrIdFromVO((EntityVO)abstractTransQuery.getBy()));
        baseTransQueryFilters.setBrokers(CollectionHelper.orEmpty((Set)abstractTransQuery.getBrokers()).stream().map(ModelHelper::stringOrIdFromVO).collect(Collectors.toList()));
        CollectionHelper.orEmpty((Set)abstractTransQuery.getChannels()).stream().map(ModelHelper::internalNameOrId).forEach(baseTransQueryFilters.getChannels()::add);
        CollectionHelper.orEmpty((Set)abstractTransQuery.getAccessClients()).stream().map(ModelHelper::stringOrIdFromVO).forEach(baseTransQueryFilters.getAccessClients()::add);
        baseTransQueryFilters.setIncludeGeneratedByAccessClient(abstractTransQuery.isIncludeGeneratedByAccessClient());
        CollectionHelper.orEmpty((Set)abstractTransQuery.getExcludedIds()).stream().map(ApiHelper::toId).forEach(baseTransQueryFilters.getExcludedIds()::add);
        baseTransQueryFilters.setFromCurrentAccessClient(abstractTransQuery.isFromCurrentAccessClient());
        baseTransQueryFilters.setAmountRange(this.apiHelper.toDecimalRangeList(abstractTransQuery.getAmount()));
        baseTransQueryFilters.setOrderBy(this.toTransOrderByEnum(abstractTransQuery.getOrderBy()));
        baseTransQueryFilters.setCustomFields(this.apiHelper.toFilters(abstractTransQuery.getCustomValues()));
        return (QF)baseTransQueryFilters;
    }

    public <T extends Trans> T newTrans(Class<T> clazz, TransVO transVO) {
        Trans trans = (Trans)this.apiHelper.newEntity(clazz, transVO);
        trans.setDisplay(transVO.getDisplay());
        trans.setTransactionNumber(transVO.getTransactionNumber());
        trans.setDate(transVO.getDate());
        trans.setAmount(this.apiHelper.getAmount(transVO.getCurrencyAmount()));
        trans.setType(this.apiHelper.toReference((EntityModel)transVO.getType()));
        trans.setCurrency(this.accountsApiHelper.toCurrency(transVO.getCurrencyAmount()));
        trans.setFrom(this.accountsApiHelper.toAccountWithOwner(transVO.getFrom()));
        trans.setTo(this.accountsApiHelper.toAccountWithOwner(transVO.getTo()));
        return (T)trans;
    }

    public <QF extends BaseTransactionQueryFilters> QF newTransactionQueryFilters(Class<QF> clazz, BaseTransactionQuery baseTransactionQuery) {
        BaseTransactionQueryFilters baseTransactionQueryFilters = (BaseTransactionQueryFilters)this.newBaseTransactionOrInstallmentQueryFilters(clazz, (AbstractTransactionQuery)baseTransactionQuery);
        CollectionHelper.orEmpty((Set)baseTransactionQuery.getAuthorizationRoles()).stream().map(ModelHelper::stringOrIdFromVO).forEach(baseTransactionQueryFilters.getAuthorizationRoles()::add);
        CollectionHelper.orEmpty((Set)baseTransactionQuery.getRecurringPaymentStatuses()).stream().map(this.recurringPaymentsApiHelper::toRecurringPaymentStatusEnum).forEach(baseTransactionQueryFilters.getRecurringPaymentStatuses()::add);
        baseTransactionQueryFilters.setPaymentRequestExpiration(this.apiHelper.toFilter(baseTransactionQuery.getPaymentRequestExpiration()));
        CollectionHelper.orEmpty((Set)baseTransactionQuery.getPaymentRequestStatuses()).stream().map(this.paymentRequestsApiHelper::toPaymentRequestStatusEnum).forEach(baseTransactionQueryFilters.getPaymentRequestStatuses()::add);
        CollectionHelper.orEmpty((Set)baseTransactionQuery.getScheduledPaymentStatuses()).stream().map(this.scheduledPaymentsApiHelper::toScheduledPaymentStatusEnum).forEach(baseTransactionQueryFilters.getScheduledPaymentStatuses()::add);
        baseTransactionQueryFilters.setExternalPaymentExpiration(this.apiHelper.toFilter(baseTransactionQuery.getExternalPaymentExpiration()));
        CollectionHelper.orEmpty((Set)baseTransactionQuery.getExternalPaymentStatuses()).stream().map(this.externalPaymentsApiHelper::toExternalPaymentStatusEnum).forEach(baseTransactionQueryFilters.getExternalPaymentStatuses()::add);
        baseTransactionQueryFilters.setTicketExpiration(this.apiHelper.toFilter(baseTransactionQuery.getTicketExpiration()));
        CollectionHelper.orEmpty((Set)baseTransactionQuery.getTicketStatuses()).stream().map(this.ticketsApiHelper::toTicketStatusEnum).forEach(baseTransactionQueryFilters.getTicketStatuses()::add);
        return (QF)baseTransactionQueryFilters;
    }

    public DataForTransaction toDataForTransaction(CreateTicketData createTicketData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        CollectionHelper.orEmpty((List)createTicketData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForTransaction.getPaymentTypes()::add);
        CollectionHelper.orEmpty((List)createTicketData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithStatus).forEach(dataForTransaction.getAccounts()::add);
        dataForTransaction.setPaymentTypeData(this.toTransactionTypeData((AbstractPaymentTypeData)createTicketData.getPaymentTypeData()));
        return dataForTransaction;
    }

    public DataForTransaction toDataForTransaction(PerformPaymentToOwnerData performPaymentToOwnerData) {
        PerformPaymentData performPaymentData;
        DataForTransaction dataForTransaction = new DataForTransaction();
        dataForTransaction.setToKind(this.accountsApiHelper.toAccountKind((AccountOwner)performPaymentToOwnerData.getTo()));
        dataForTransaction.setToUser(this.accountsApiHelper.toUser((AccountOwner)performPaymentToOwnerData.getTo()));
        CollectionHelper.orEmpty((List)performPaymentToOwnerData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForTransaction.getPaymentTypes()::add);
        dataForTransaction.setPaymentTypeData(this.toTransactionTypeData((AbstractPaymentTypeData)performPaymentToOwnerData.getPaymentTypeData()));
        PerformPaymentData performPaymentData2 = performPaymentData = performPaymentToOwnerData instanceof PerformPaymentData ? (PerformPaymentData)performPaymentToOwnerData : null;
        if (performPaymentData != null) {
            CollectionHelper.orEmpty((List)performPaymentData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithStatus).forEach(dataForTransaction.getAccounts()::add);
            dataForTransaction.setFromKind(this.accountsApiHelper.toAccountKind((AccountOwner)performPaymentData.getFrom()));
            dataForTransaction.setFromUser(this.accountsApiHelper.toUser((AccountOwner)performPaymentData.getFrom()));
            if (performPaymentData.getTo() == null) {
                dataForTransaction.setAllowAutocomplete(performPaymentData.isAllowAutocomplete());
                dataForTransaction.setAllowContacts(performPaymentData.isAllowContacts());
                CollectionHelper.orEmpty((List)performPaymentData.getAllowedUsers()).stream().map(this.usersApiHelper::toUser).forEach(dataForTransaction.getAllowedUsers()::add);
                dataForTransaction.setAllowScanQrCode(performPaymentData.isAllowScanQrCode());
            }
        }
        if (performPaymentToOwnerData.getTo() != null) {
            dataForTransaction.setPrincipalTypes(null);
        } else if (performPaymentData != null && performPaymentData.getPrincipalTypes() != null) {
            CollectionHelper.orEmpty((List)performPaymentData.getPrincipalTypes()).stream().map(this.authApiHelper::toPrincipalTypeInput).forEach(dataForTransaction.getPrincipalTypes()::add);
            dataForTransaction.setDefaultPrincipalType(ModelHelper.internalNameOrId((IEntity)performPaymentData.getDefaultPrincipalType()));
            dataForTransaction.setDefaultIdMethod(this.toIdentificationMethodEnum(performPaymentData.getDefaultIdMethod()));
        }
        if (CollectionHelper.isEmpty(dataForTransaction.getAllowedUsers())) {
            dataForTransaction.setAllowedUsers(null);
        }
        return dataForTransaction;
    }

    public DataForTransaction toDataForTransaction(ReceivePaymentData receivePaymentData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        CollectionHelper.orEmpty((List)receivePaymentData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForTransaction.getPaymentTypes()::add);
        CollectionHelper.orEmpty((List)receivePaymentData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithStatus).forEach(dataForTransaction.getAccounts()::add);
        dataForTransaction.setAllowAutocomplete(receivePaymentData.isAllowAutocomplete());
        dataForTransaction.setAllowContacts(receivePaymentData.isAllowContacts());
        CollectionHelper.orEmpty((List)receivePaymentData.getPrincipalTypes()).stream().map(this.authApiHelper::toPrincipalTypeInput).forEach(dataForTransaction.getPrincipalTypes()::add);
        dataForTransaction.setDefaultPrincipalType(ModelHelper.internalNameOrId((IEntity)receivePaymentData.getDefaultPrincipalType()));
        dataForTransaction.setDefaultIdMethod(this.toIdentificationMethodEnum(receivePaymentData.getDefaultIdMethod()));
        dataForTransaction.setAllowScanQrCode(receivePaymentData.isAllowScanQrCode());
        return dataForTransaction;
    }

    public DataForTransaction toDataForTransaction(ReceivePaymentFromUserData receivePaymentFromUserData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        dataForTransaction.setFromKind(AccountKind.USER);
        dataForTransaction.setFromUser(this.usersApiHelper.toUser(receivePaymentFromUserData.getFrom()));
        CollectionHelper.orEmpty((List)receivePaymentFromUserData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForTransaction.getPaymentTypes()::add);
        dataForTransaction.setPaymentTypeData(this.toTransactionTypeData((AbstractPaymentTypeData)receivePaymentFromUserData.getPaymentTypeData()));
        return dataForTransaction;
    }

    public DataForTransaction toDataForTransaction(RequestPaymentData requestPaymentData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        dataForTransaction.setFromKind(this.accountsApiHelper.toAccountKind((AccountOwner)requestPaymentData.getPayee()));
        dataForTransaction.setFromUser(this.accountsApiHelper.toUser((AccountOwner)requestPaymentData.getPayee()));
        dataForTransaction.setToKind(this.accountsApiHelper.toAccountKind((AccountOwner)requestPaymentData.getPayer()));
        dataForTransaction.setToUser(this.accountsApiHelper.toUser((AccountOwner)requestPaymentData.getPayer()));
        CollectionHelper.orEmpty((List)requestPaymentData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForTransaction.getPaymentTypes()::add);
        dataForTransaction.setPaymentTypeData(this.toTransactionTypeData((AbstractPaymentTypeData)requestPaymentData.getPaymentTypeData()));
        CollectionHelper.orEmpty((List)requestPaymentData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithStatus).forEach(dataForTransaction.getAccounts()::add);
        if (requestPaymentData.getPayer() == null) {
            dataForTransaction.setAllowAutocomplete(requestPaymentData.isAllowAutocomplete());
            dataForTransaction.setAllowContacts(requestPaymentData.isAllowContacts());
        }
        if (requestPaymentData.getPayer() != null) {
            dataForTransaction.setPrincipalTypes(null);
        } else if (requestPaymentData != null && requestPaymentData.getPrincipalTypes() != null) {
            CollectionHelper.orEmpty((List)requestPaymentData.getPrincipalTypes()).stream().map(this.authApiHelper::toPrincipalTypeInput).forEach(dataForTransaction.getPrincipalTypes()::add);
            dataForTransaction.setDefaultPrincipalType(ModelHelper.internalNameOrId((IEntity)requestPaymentData.getDefaultPrincipalType()));
            dataForTransaction.setDefaultIdMethod(this.toIdentificationMethodEnum(requestPaymentData.getDefaultIdMethod()));
        }
        dataForTransaction.setAllowedUsers(null);
        return dataForTransaction;
    }

    public DataForTransaction toDataForTransaction(TicketPaymentTypeData ticketPaymentTypeData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        dataForTransaction.setPaymentTypeData(this.toTransactionTypeData((AbstractPaymentTypeData)ticketPaymentTypeData));
        dataForTransaction.setAccounts(null);
        dataForTransaction.setPrincipalTypes(null);
        dataForTransaction.setPaymentTypes(null);
        dataForTransaction.setAllowedUsers(null);
        return dataForTransaction;
    }

    public IdentificationMethodEnum toIdentificationMethodEnum(IdentificationMethod identificationMethod) {
        if (identificationMethod != null) {
            switch (identificationMethod) {
                case AUTOCOMPLETE: {
                    return IdentificationMethodEnum.AUTOCOMPLETE;
                }
                case CONTACTS: {
                    return IdentificationMethodEnum.CONTACTS;
                }
                case PRINCIPAL_TYPE: {
                    return IdentificationMethodEnum.PRINCIPAL_TYPE;
                }
            }
        }
        return null;
    }

    public PaymentCreationType toPaymentCreationType(PaymentCreationTypeEnum paymentCreationTypeEnum) {
        if (paymentCreationTypeEnum != null) {
            switch (paymentCreationTypeEnum) {
                case DIRECT: {
                    return PaymentCreationType.DIRECT;
                }
                case EASY_INVOICE: {
                    return PaymentCreationType.EASY_INVOICE;
                }
                case EXTERNAL: {
                    return PaymentCreationType.EXTERNAL;
                }
                case IMPORT: {
                    return PaymentCreationType.IMPORT;
                }
                case ORDER: {
                    return PaymentCreationType.ORDER;
                }
                case POS: {
                    return PaymentCreationType.POS;
                }
                case REQUEST: {
                    return PaymentCreationType.REQUEST;
                }
                case TICKET: {
                    return PaymentCreationType.TICKET;
                }
                case VOUCHER_BUYING: {
                    return PaymentCreationType.VOUCHER_BUYING;
                }
                case VOUCHER_REDEEMING: {
                    return PaymentCreationType.VOUCHER_REDEEMING;
                }
                case VOUCHER_REFUNDING: {
                    return PaymentCreationType.VOUCHER_REFUNDING;
                }
                case VOUCHER_TOP_UP: {
                    return PaymentCreationType.VOUCHER_TOP_UP;
                }
            }
        }
        return null;
    }

    public PaymentCreationTypeEnum toPaymentCreationTypeEnum(PaymentCreationType paymentCreationType) {
        if (paymentCreationType != null) {
            switch (paymentCreationType) {
                case DIRECT: {
                    return PaymentCreationTypeEnum.DIRECT;
                }
                case EASY_INVOICE: {
                    return PaymentCreationTypeEnum.EASY_INVOICE;
                }
                case EXTERNAL: {
                    return PaymentCreationTypeEnum.EXTERNAL;
                }
                case IMPORT: {
                    return PaymentCreationTypeEnum.IMPORT;
                }
                case ORDER: {
                    return PaymentCreationTypeEnum.ORDER;
                }
                case POS: {
                    return PaymentCreationTypeEnum.POS;
                }
                case REQUEST: {
                    return PaymentCreationTypeEnum.REQUEST;
                }
                case TICKET: {
                    return PaymentCreationTypeEnum.TICKET;
                }
                case VOUCHER_BUYING: {
                    return PaymentCreationTypeEnum.VOUCHER_BUYING;
                }
                case VOUCHER_REDEEMING: {
                    return PaymentCreationTypeEnum.VOUCHER_REDEEMING;
                }
                case VOUCHER_REFUNDING: {
                    return PaymentCreationTypeEnum.VOUCHER_REFUNDING;
                }
                case VOUCHER_TOP_UP: {
                    return PaymentCreationTypeEnum.VOUCHER_TOP_UP;
                }
            }
        }
        return null;
    }

    public ResponseEntity<Transaction> toResponseTransaction(TransactionVO transactionVO) {
        return this.doToResponseTransaction(transactionVO, true);
    }

    public Transaction toTransaction(Long l, TransactionNature transactionNature, String string) {
        if (l == null || transactionNature == null) {
            return null;
        }
        Transaction transaction = new Transaction();
        transaction.setId(ApiHelper.toId(l));
        transaction.setKind(this.toTransactionKind(transactionNature));
        transaction.setTransactionNumber(string);
        return transaction;
    }

    public Transaction toTransaction(TransactionVO transactionVO) {
        if (transactionVO == null) {
            return null;
        }
        return this.newTransaction(Transaction.class, transactionVO);
    }

    public TransactionAuthorization toTransactionAuthorization(TransactionAuthorizationVO transactionAuthorizationVO) {
        if (transactionAuthorizationVO == null) {
            return null;
        }
        TransactionAuthorization transactionAuthorization = this.apiHelper.newEntity(TransactionAuthorization.class, transactionAuthorizationVO);
        transactionAuthorization.setAction(this.toTransactionAuthorizationActionEnum(transactionAuthorizationVO.getAction()));
        transactionAuthorization.setBy(this.usersApiHelper.toUser((BasicUserVO)transactionAuthorizationVO.getBy()));
        transactionAuthorization.setDate(transactionAuthorizationVO.getDate());
        transactionAuthorization.setLevel(transactionAuthorizationVO.getLevelNumber());
        transactionAuthorization.setComments(transactionAuthorizationVO.getComments());
        return transactionAuthorization;
    }

    public TransactionAuthorizationActionEnum toTransactionAuthorizationActionEnum(AuthorizationAction authorizationAction) {
        if (authorizationAction != null) {
            switch (authorizationAction) {
                case AUTHORIZED: {
                    return TransactionAuthorizationActionEnum.AUTHORIZED;
                }
                case DENIED: {
                    return TransactionAuthorizationActionEnum.DENIED;
                }
                case CANCELED: {
                    return TransactionAuthorizationActionEnum.CANCELED;
                }
                case EXPIRED: {
                    return TransactionAuthorizationActionEnum.EXPIRED;
                }
            }
        }
        return null;
    }

    public TransactionAuthorizationDTO toTransactionAuthorizationDTO(String string, PendingPaymentActionParams pendingPaymentActionParams, String string2) {
        TransactionAuthorizationDTO transactionAuthorizationDTO = new TransactionAuthorizationDTO();
        transactionAuthorizationDTO.setTransaction((TransactionVO)ModelHelper.voFromString(TransactionVO.class, (String)string));
        transactionAuthorizationDTO.setComments(pendingPaymentActionParams.getComments());
        transactionAuthorizationDTO.setConfirmationPassword(string2);
        return transactionAuthorizationDTO;
    }

    public TransactionAuthorizationLevelData toTransactionAuthorizationLevelData(PaymentAuthorizationLevelData paymentAuthorizationLevelData, List<UserVO> list) {
        if (paymentAuthorizationLevelData == null) {
            return null;
        }
        TransactionAuthorizationLevelData transactionAuthorizationLevelData = new TransactionAuthorizationLevelData();
        transactionAuthorizationLevelData.setAllowBroker(paymentAuthorizationLevelData.isAllowBroker());
        transactionAuthorizationLevelData.setAllowPayer(paymentAuthorizationLevelData.isAllowPayer());
        transactionAuthorizationLevelData.setAllowReceiver(paymentAuthorizationLevelData.isAllowReceiver());
        transactionAuthorizationLevelData.setAllowAdmin(paymentAuthorizationLevelData.isAllowAdmin());
        CollectionHelper.orEmpty(list).stream().map(this.usersApiHelper::toUser).forEach(transactionAuthorizationLevelData.getBrokers()::add);
        return transactionAuthorizationLevelData;
    }

    public TransactionAuthorizationStatus toTransactionAuthorizationStatus(TransactionAuthorizationStatusEnum transactionAuthorizationStatusEnum) {
        if (transactionAuthorizationStatusEnum != null) {
            switch (transactionAuthorizationStatusEnum) {
                case PENDING: {
                    return TransactionAuthorizationStatus.PENDING_AUTHORIZATION;
                }
                case AUTHORIZED: {
                    return TransactionAuthorizationStatus.AUTHORIZED;
                }
                case DENIED: {
                    return TransactionAuthorizationStatus.AUTHORIZATION_DENIED;
                }
                case CANCELED: {
                    return TransactionAuthorizationStatus.AUTHORIZATION_CANCELED;
                }
                case EXPIRED: {
                    return TransactionAuthorizationStatus.AUTHORIZATION_EXPIRED;
                }
            }
        }
        return null;
    }

    public TransactionAuthorizationStatusEnum toTransactionAuthorizationStatusEnum(TransactionAuthorizationStatus transactionAuthorizationStatus) {
        if (transactionAuthorizationStatus != null) {
            switch (transactionAuthorizationStatus) {
                case PENDING_AUTHORIZATION: {
                    return TransactionAuthorizationStatusEnum.PENDING;
                }
                case AUTHORIZED: {
                    return TransactionAuthorizationStatusEnum.AUTHORIZED;
                }
                case AUTHORIZATION_DENIED: {
                    return TransactionAuthorizationStatusEnum.DENIED;
                }
                case AUTHORIZATION_CANCELED: {
                    return TransactionAuthorizationStatusEnum.CANCELED;
                }
                case AUTHORIZATION_EXPIRED: {
                    return TransactionAuthorizationStatusEnum.EXPIRED;
                }
                case NA: {
                    return null;
                }
            }
        }
        return null;
    }

    public TransactionAuthorizationTypeEnum toTransactionAuthorizationTypeEnum(TransactionAuthorizationType transactionAuthorizationType) {
        if (transactionAuthorizationType != null) {
            switch (transactionAuthorizationType) {
                case OPERATOR: {
                    return TransactionAuthorizationTypeEnum.OPERATOR;
                }
                case LEVEL: {
                    return TransactionAuthorizationTypeEnum.LEVEL;
                }
                case NA: {
                    return null;
                }
            }
        }
        return null;
    }

    public TransactionDataForSearch toTransactionDataForSearch(TransactionSearchData transactionSearchData) {
        TransactionDataForSearch transactionDataForSearch = this.newTransactionDataForSearch(TransactionDataForSearch.class, (ITransactionSearchData)transactionSearchData);
        if (transactionSearchData.getAccountOwner() instanceof UserVO) {
            transactionDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)((UserVO)transactionSearchData.getAccountOwner())));
        }
        transactionDataForSearch.setUserPermissions(this.usersApiHelper.toUserTransactionPermissions(transactionSearchData.getUserPermissions()));
        CollectionHelper.orEmpty((List)transactionSearchData.getAccessClients()).stream().map(this.apiHelper::toReference).forEach(transactionDataForSearch.getAccessClients()::add);
        CollectionHelper.orEmpty((List)transactionSearchData.getOperators()).stream().map(this.usersApiHelper::toUser).forEach(transactionDataForSearch.getOperators()::add);
        transactionDataForSearch.setQuery(this.toTransactionQueryFilters((TransactionQuery)transactionSearchData.getQuery()));
        return transactionDataForSearch;
    }

    public TransactionKind toTransactionKind(TransactionNature transactionNature) {
        if (transactionNature != null) {
            switch (transactionNature) {
                case EXTERNAL_PAYMENT: {
                    return TransactionKind.EXTERNAL_PAYMENT;
                }
                case IMPORT: {
                    return TransactionKind.IMPORT;
                }
                case PAYMENT: {
                    return TransactionKind.PAYMENT;
                }
                case PAYMENT_REQUEST: {
                    return TransactionKind.PAYMENT_REQUEST;
                }
                case RECURRING_PAYMENT: {
                    return TransactionKind.RECURRING_PAYMENT;
                }
                case SCHEDULED_PAYMENT: {
                    return TransactionKind.SCHEDULED_PAYMENT;
                }
                case TICKET: {
                    return TransactionKind.TICKET;
                }
            }
        }
        return null;
    }

    public TransactionNature toTransactionNature(TransactionKind transactionKind) {
        if (transactionKind != null) {
            switch (transactionKind) {
                case EXTERNAL_PAYMENT: {
                    return TransactionNature.EXTERNAL_PAYMENT;
                }
                case IMPORT: {
                    return TransactionNature.IMPORT;
                }
                case PAYMENT: 
                case ORDER: {
                    return TransactionNature.PAYMENT;
                }
                case PAYMENT_REQUEST: {
                    return TransactionNature.PAYMENT_REQUEST;
                }
                case RECURRING_PAYMENT: {
                    return TransactionNature.RECURRING_PAYMENT;
                }
                case SCHEDULED_PAYMENT: {
                    return TransactionNature.SCHEDULED_PAYMENT;
                }
                case TICKET: {
                    return TransactionNature.TICKET;
                }
                case CHARGEBACK: {
                    return null;
                }
            }
        }
        return null;
    }

    public TransactionOrderBy toTransactionOrderBy(TransOrderByEnum transOrderByEnum) {
        if (transOrderByEnum != null) {
            switch (transOrderByEnum) {
                case AMOUNT_ASC: {
                    return TransactionOrderBy.AMOUNT_ASC;
                }
                case AMOUNT_DESC: {
                    return TransactionOrderBy.AMOUNT_DESC;
                }
                case DATE_ASC: {
                    return TransactionOrderBy.DATE_ASC;
                }
                case DATE_DESC: {
                    return TransactionOrderBy.DATE_DESC;
                }
            }
        }
        return null;
    }

    public TransactionOverviewDataForSearch toTransactionOverviewDataForSearch(TransactionOverviewSearchData transactionOverviewSearchData) {
        TransactionOverviewDataForSearch transactionOverviewDataForSearch = this.newTransactionDataForSearch(TransactionOverviewDataForSearch.class, (ITransactionSearchData)transactionOverviewSearchData);
        if (transactionOverviewSearchData.getAuthorizablePaymentTypes() == null) {
            transactionOverviewDataForSearch.setAuthorizablePaymentTypes(null);
        } else {
            transactionOverviewSearchData.getAuthorizablePaymentTypes().stream().map(this.accountsApiHelper::toTransferType).forEach(transactionOverviewDataForSearch.getAuthorizablePaymentTypes()::add);
        }
        transactionOverviewDataForSearch.setQuery(this.toTransactionOverviewQueryFilters((TransactionOverviewQuery)transactionOverviewSearchData.getQuery()));
        return transactionOverviewDataForSearch;
    }

    public TransactionOverviewQuery toTransactionOverviewQuery(TransactionOverviewQueryFilters transactionOverviewQueryFilters) {
        TransactionOverviewQuery transactionOverviewQuery = this.newTransactionQuery(TransactionOverviewQuery.class, transactionOverviewQueryFilters);
        transactionOverviewQuery.setCurrencies(CollectionHelper.orEmpty(transactionOverviewQueryFilters.getCurrencies()).stream().map(string -> (CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)string)).collect(Collectors.toSet()));
        transactionOverviewQuery.setFromAccounts(CollectionHelper.orEmpty(transactionOverviewQueryFilters.getFromAccountTypes()).stream().map(string -> (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string)).collect(Collectors.toSet()));
        transactionOverviewQuery.setToAccounts(CollectionHelper.orEmpty(transactionOverviewQueryFilters.getToAccountTypes()).stream().map(string -> (AccountTypeVO)ModelHelper.voFromString(AccountTypeVO.class, (String)string)).collect(Collectors.toSet()));
        transactionOverviewQuery.setPendingMyAuthorization(Boolean.TRUE.equals(transactionOverviewQueryFilters.getPendingMyAuthorization()));
        return transactionOverviewQuery;
    }

    public TransactionOverviewQueryFilters toTransactionOverviewQueryFilters(TransactionOverviewQuery transactionOverviewQuery) {
        TransactionOverviewQueryFilters transactionOverviewQueryFilters = this.newTransactionQueryFilters(TransactionOverviewQueryFilters.class, (BaseTransactionQuery)transactionOverviewQuery);
        CollectionHelper.orEmpty((Set)transactionOverviewQuery.getCurrencies()).stream().map(ModelHelper::stringOrIdFromVO).forEach(transactionOverviewQueryFilters.getCurrencies()::add);
        CollectionHelper.orEmpty((Set)transactionOverviewQuery.getFromAccounts()).stream().map(ModelHelper::stringOrIdFromVO).forEach(transactionOverviewQueryFilters.getFromAccountTypes()::add);
        CollectionHelper.orEmpty((Set)transactionOverviewQuery.getToAccounts()).stream().map(ModelHelper::stringOrIdFromVO).forEach(transactionOverviewQueryFilters.getToAccountTypes()::add);
        transactionOverviewQueryFilters.setPendingMyAuthorization(transactionOverviewQuery.isPendingMyAuthorization());
        return transactionOverviewQueryFilters;
    }

    public TransactionOverviewResult toTransactionOverviewResult(TransactionResultVO transactionResultVO, boolean bl) {
        if (transactionResultVO == null) {
            return null;
        }
        TransactionOverviewResult transactionOverviewResult = this.newBaseTransactionResult(TransactionOverviewResult.class, transactionResultVO);
        transactionOverviewResult.setFromName(transactionResultVO.getFromName());
        transactionOverviewResult.setToName(transactionResultVO.getToName());
        AccountWithOwner accountWithOwner = null;
        if (transactionResultVO.getFrom() != null) {
            accountWithOwner = this.accountsApiHelper.toAccountWithOwner(transactionResultVO.getFrom());
            transactionOverviewResult.setFrom(accountWithOwner);
        }
        AccountWithOwner accountWithOwner2 = null;
        if (transactionResultVO.getTo() != null) {
            accountWithOwner2 = this.accountsApiHelper.toAccountWithOwner(transactionResultVO.getTo());
            transactionOverviewResult.setTo(accountWithOwner2);
        }
        return transactionOverviewResult;
    }

    public TransactionQuery toTransactionQuery(String string, TransactionQueryFilters transactionQueryFilters) {
        TransactionQuery transactionQuery = this.newTransactionQuery(TransactionQuery.class, transactionQueryFilters);
        transactionQuery.setOwner(ModelHelper.accountOwner((String)string));
        transactionQuery.setDirection(this.transfersApiHelper.toTransferDirection(transactionQueryFilters.getDirection()));
        transactionQuery.setAccountTypes(ModelHelper.vosFromString(AccountTypeVO.class, transactionQueryFilters.getAccountTypes()));
        return transactionQuery;
    }

    public TransactionQueryFilters toTransactionQueryFilters(TransactionQuery transactionQuery) {
        TransactionQueryFilters transactionQueryFilters = this.newTransactionQueryFilters(TransactionQueryFilters.class, (BaseTransactionQuery)transactionQuery);
        transactionQueryFilters.setDirection(this.transfersApiHelper.toTransferDirectionEnum(transactionQuery.getDirection()));
        CollectionHelper.orEmpty((Set)transactionQuery.getAccountTypes()).stream().map(ModelHelper::internalNameOrId).forEach(transactionQueryFilters.getAccountTypes()::add);
        return transactionQueryFilters;
    }

    public TransactionResult toTransactionResult(TransactionResultVO transactionResultVO, boolean bl) {
        if (transactionResultVO == null) {
            return null;
        }
        TransactionResult transactionResult = this.newBaseTransactionResult(TransactionResult.class, transactionResultVO);
        AccountWithOwner accountWithOwner = this.accountsApiHelper.toAccountWithOwner(transactionResultVO.getRelated());
        transactionResult.setRelated(accountWithOwner);
        transactionResult.setRelatedName(transactionResultVO.getRelatedName());
        return transactionResult;
    }

    public TransactionSubjectsEnum toTransactionSubjectsEnum(TransactionSubjects transactionSubjects) {
        if (transactionSubjects != null) {
            switch (transactionSubjects) {
                case BOTH: {
                    return TransactionSubjectsEnum.BOTH;
                }
                case FROM: {
                    return TransactionSubjectsEnum.FROM;
                }
                case NONE: {
                    return TransactionSubjectsEnum.NONE;
                }
                case TO: {
                    return TransactionSubjectsEnum.TO;
                }
            }
        }
        return null;
    }

    public TransactionTypeData toTransactionTypeData(AbstractPaymentTypeData abstractPaymentTypeData) {
        if (abstractPaymentTypeData == null) {
            return null;
        }
        TransactionTypeData transactionTypeData = this.apiHelper.newEntity(TransactionTypeData.class, abstractPaymentTypeData);
        transactionTypeData.setCurrency(this.accountsApiHelper.toCurrency(abstractPaymentTypeData.getCurrency()));
        transactionTypeData.setFixedAmount(abstractPaymentTypeData.getFixedAmount());
        transactionTypeData.setDescriptionAvailability(this.apiHelper.toAvailabilityEnum(abstractPaymentTypeData.getDescriptionAvailability()));
        CollectionHelper.orEmpty((List)abstractPaymentTypeData.getCustomFields()).stream().map(this.apiHelper::toCustomFieldDetailed).forEach(transactionTypeData.getCustomFields()::add);
        if (abstractPaymentTypeData instanceof BasePaymentTypeData) {
            BasePaymentTypeData basePaymentTypeData = (BasePaymentTypeData)abstractPaymentTypeData;
            transactionTypeData.setMaxInstallments(basePaymentTypeData.getMaxInstallments());
            transactionTypeData.setAllowsRecurringPayments(basePaymentTypeData.isAllowsRecurringPayments());
            if (abstractPaymentTypeData instanceof PerformPaymentTypeData) {
                this.paymentsApiHelper.fillTransactionTypeData((PerformPaymentTypeData)abstractPaymentTypeData, transactionTypeData);
            } else if (abstractPaymentTypeData instanceof RequestPaymentTypeData) {
                this.paymentRequestsApiHelper.fillTransactionTypeData((RequestPaymentTypeData)abstractPaymentTypeData, transactionTypeData);
            }
        }
        return transactionTypeData;
    }

    public TransactionView toTransactionView(TransactionData transactionData) {
        RestModel restModel;
        BasePaymentData basePaymentData;
        if (transactionData == null || transactionData.getTransaction() == null) {
            return null;
        }
        TransactionDetailedVO transactionDetailedVO = transactionData.getTransaction();
        TransactionView transactionView = this.toTransactionView(transactionDetailedVO);
        if (transactionData instanceof BasePaymentData) {
            basePaymentData = (BasePaymentData)transactionData;
            if (transactionDetailedVO.getAuthorizationStatus() == TransactionAuthorizationStatus.PENDING_AUTHORIZATION) {
                restModel = new TransactionAuthorizationPermissions();
                ((TransactionAuthorizationPermissions)restModel).setAuthorize(basePaymentData.isCanAuthorize());
                ((TransactionAuthorizationPermissions)restModel).setDeny(basePaymentData.isCanDeny());
                ((TransactionAuthorizationPermissions)restModel).setCancel(basePaymentData.isCanCancelAuthorization());
                transactionView.setAuthorizationPermissions((TransactionAuthorizationPermissions)restModel);
            }
            transactionView.setAuthorizationLevelData(this.toTransactionAuthorizationLevelData(basePaymentData.getAuthorizationLevelData(), basePaymentData.getAuthorizingBrokers()));
            transactionView.setAuthorizationType(this.toTransactionAuthorizationTypeEnum(basePaymentData.getAuthorizationType()));
            transactionView.setFeedback(basePaymentData.isCanViewFeedback() ? this.paymentFeedbacksApiHelper.toPaymentFeedback(basePaymentData.getFeedback()) : null);
            restModel = new PaymentFeedbacksPermissions();
            ((PaymentFeedbacksPermissions)restModel).setGive(basePaymentData.isCanGiveFeedback());
            ((PaymentFeedbacksPermissions)restModel).setReceive(basePaymentData.isCanReplyFeedback());
            ((PaymentFeedbacksPermissions)restModel).setView(basePaymentData.isCanViewFeedback());
            transactionView.setFeedbackPermissions((PaymentFeedbacksPermissions)restModel);
            CollectionHelper.orEmpty((List)basePaymentData.getAuthorizations()).stream().map(this::toTransactionAuthorization).forEach(transactionView.getAuthorizations()::add);
        } else {
            transactionView.setAuthorizations(null);
        }
        if (transactionData instanceof PaymentData) {
            basePaymentData = (PaymentData)transactionData;
            CollectionHelper.orEmpty((List)basePaymentData.getBoughtVouchers()).stream().map(this.vouchersApiHelper::toVoucher).forEach(transactionView.getBoughtVouchers()::add);
            transactionView.setVoucherTransaction(this.vouchersApiHelper.toVoucherTransactionResult(basePaymentData.getVoucherTransaction()));
            if (basePaymentData.getTransferData() != null) {
                transactionView.setTransfer(this.transfersApiHelper.toTransferView(basePaymentData.getTransferData()));
            }
        } else {
            transactionView.setBoughtVouchers(null);
        }
        if (transactionData instanceof ScheduledPaymentData) {
            this.scheduledPaymentsApiHelper.fillTransactionView((ScheduledPaymentData)transactionData, transactionView);
        } else {
            transactionView.setInstallments(null);
        }
        if (transactionData instanceof RecurringPaymentData) {
            this.recurringPaymentsApiHelper.fillTransactionView((RecurringPaymentData)transactionData, transactionView);
        } else {
            transactionView.setOccurrences(null);
        }
        transactionView.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)transactionData.getConfirmationPasswordInput()));
        transactionView.setUsersWhichCanAddToContacts(this.toTransactionSubjectsEnum(transactionData.getUsersWhichCanAddToContacts()));
        transactionView.setUsersWhichCanViewProfile(this.toTransactionSubjectsEnum(transactionData.getUsersWhichCanViewProfile()));
        CollectionHelper.orEmpty((List)transactionData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(transactionView.getExportFormats()::add);
        if (transactionData instanceof PaymentData) {
            basePaymentData = (PaymentData)transactionData;
            transactionView.setFeesOnAuthorization(this.toTransferFeesPreview(basePaymentData.getFeesOnAuthorization()));
        } else if (transactionData instanceof PaymentRequestData) {
            basePaymentData = (PaymentRequestData)transactionData;
            restModel = new PaymentRequestPermissions();
            ((PaymentRequestPermissions)restModel).setAccept(basePaymentData.isCanAccept());
            ((PaymentRequestPermissions)restModel).setCancel(basePaymentData.isCanCancel());
            ((PaymentRequestPermissions)restModel).setReject(basePaymentData.isCanDeny());
            ((PaymentRequestPermissions)restModel).setReschedule(basePaymentData.isCanReschedule());
            ((PaymentRequestPermissions)restModel).setChangeExpiration(basePaymentData.isCanChangeExpirationDate());
            transactionView.setPaymentRequestPermissions((PaymentRequestPermissions)restModel);
        } else if (transactionData instanceof ExternalPaymentData) {
            this.externalPaymentsApiHelper.fillTransactionView((ExternalPaymentData)transactionData, transactionView);
        } else if (transactionData instanceof TicketData && (restModel = (basePaymentData = (TicketData)transactionData).getPaymentPreview()) != null) {
            PaymentPreview paymentPreview = this.paymentsApiHelper.toPaymentPreview((BaseInternalPaymentPreviewVO)restModel, null);
            paymentPreview.setCurrency(null);
            transactionView.setPreview(paymentPreview);
        }
        return transactionView;
    }

    public TransactionView toTransactionView(TransactionDetailedVO transactionDetailedVO) {
        if (transactionDetailedVO == null) {
            return null;
        }
        TransactionView transactionView = this.newTransaction(TransactionView.class, (TransactionVO)transactionDetailedVO);
        transactionView.setBy(this.usersApiHelper.toUser(transactionDetailedVO.getBy()));
        transactionView.setChannel(this.apiHelper.toReference((EntityModel)transactionDetailedVO.getChannel()));
        transactionView.setAccessClient(this.apiHelper.toReference((EntityModel)transactionDetailedVO.getAccessClient()));
        transactionView.setCustomValues(this.apiHelper.toCustomFieldValuesList(transactionDetailedVO.getCustomValues()));
        if (transactionDetailedVO instanceof BasePaymentVO) {
            BasePaymentVO basePaymentVO = (BasePaymentVO)transactionDetailedVO;
            transactionView.setReceivedBy(this.usersApiHelper.toUser((BasicUserVO)basePaymentVO.getReceivedBy()));
            transactionView.setReceived(basePaymentVO.isReceived());
            transactionView.setOidcClient(this.oidcApiHelper.toOidcClient(basePaymentVO.getOidcClient()));
        }
        if (transactionDetailedVO instanceof ScheduledPaymentVO) {
            this.scheduledPaymentsApiHelper.fillTransactionView((ScheduledPaymentVO)transactionDetailedVO, transactionView);
        } else if (transactionDetailedVO instanceof RecurringPaymentVO) {
            this.recurringPaymentsApiHelper.fillTransactionView((RecurringPaymentVO)transactionDetailedVO, transactionView);
        } else if (transactionDetailedVO instanceof PaymentRequestVO) {
            this.paymentRequestsApiHelper.fillTransactionView((PaymentRequestVO)transactionDetailedVO, transactionView);
        } else if (transactionDetailedVO instanceof ExternalPaymentVO) {
            this.externalPaymentsApiHelper.fillTransactionView((ExternalPaymentVO)transactionDetailedVO, transactionView);
        } else if (transactionDetailedVO instanceof TicketVO) {
            this.ticketsApiHelper.fillTransactionView((TicketVO)transactionDetailedVO, transactionView);
        }
        if (!(transactionDetailedVO instanceof ScheduledPaymentVO)) {
            transactionView.setInstallments(null);
        }
        return transactionView;
    }

    public TransOrderByEnum toTransOrderByEnum(TransactionOrderBy transactionOrderBy) {
        if (transactionOrderBy != null) {
            switch (transactionOrderBy) {
                case AMOUNT_ASC: {
                    return TransOrderByEnum.AMOUNT_ASC;
                }
                case AMOUNT_DESC: {
                    return TransOrderByEnum.AMOUNT_DESC;
                }
                case DATE_ASC: {
                    return TransOrderByEnum.DATE_ASC;
                }
                case DATE_DESC: {
                    return TransOrderByEnum.DATE_DESC;
                }
            }
        }
        return null;
    }

    private ResponseEntity<Transaction> doToResponseTransaction(TransactionVO transactionVO, boolean bl) {
        String string = this.getKey(transactionVO);
        Transaction transaction = this.toTransaction(transactionVO);
        ServletHelper.getRequestData().getFields().apply((Object)transaction);
        if (bl) {
            return ResponseEntity.created((URI)this.apiHelper.uriFromApi("transactions", string)).body((Object)transaction);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().location(this.apiHelper.uriFromApi("transactions", string))).body((Object)transaction);
    }

    private <R extends BaseTransactionResult> R newBaseTransactionResult(Class<R> clazz, TransactionResultVO transactionResultVO) {
        BaseTransactionResult baseTransactionResult = (BaseTransactionResult)this.apiHelper.newEntity(clazz, transactionResultVO);
        baseTransactionResult.setKind(this.toTransactionKind(transactionResultVO.getNature()));
        baseTransactionResult.setCreationType(this.toPaymentCreationTypeEnum(transactionResultVO.getCreationType()));
        baseTransactionResult.setDate(transactionResultVO.getDate());
        baseTransactionResult.setAmount(transactionResultVO.getAmount());
        baseTransactionResult.setType(this.apiHelper.toReference((EntityModel)transactionResultVO.getType()));
        baseTransactionResult.setDescription(transactionResultVO.getDescription());
        baseTransactionResult.setTransactionNumber(transactionResultVO.getTransactionNumber());
        baseTransactionResult.setCurrency(ModelHelper.internalNameOrId((IEntity)transactionResultVO.getType().getCurrency()));
        baseTransactionResult.setAuthorizationStatus(this.toTransactionAuthorizationStatusEnum(transactionResultVO.getAuthorizationStatus()));
        baseTransactionResult.setCustomValues(this.apiHelper.toCustomFieldValuesMap(transactionResultVO.getCustomValues()));
        if (transactionResultVO instanceof ScheduledPaymentResultVO) {
            this.scheduledPaymentsApiHelper.fillTransactionResult((ScheduledPaymentResultVO)transactionResultVO, baseTransactionResult);
        } else if (transactionResultVO instanceof RecurringPaymentResultVO) {
            this.recurringPaymentsApiHelper.fillTransactionResult((RecurringPaymentResultVO)transactionResultVO, baseTransactionResult);
        } else if (transactionResultVO instanceof PaymentRequestResultVO) {
            this.paymentRequestsApiHelper.fillTransactionResult((PaymentRequestResultVO)transactionResultVO, baseTransactionResult);
        } else if (transactionResultVO instanceof TicketResultVO) {
            this.ticketsApiHelper.fillTransactionResult((TicketResultVO)transactionResultVO, baseTransactionResult);
        } else if (transactionResultVO instanceof ExternalPaymentResultVO) {
            this.externalPaymentsApiHelper.fillTransactionResult((ExternalPaymentResultVO)transactionResultVO, baseTransactionResult);
        }
        return (R)baseTransactionResult;
    }

    private <T extends Transaction> T newTransaction(Class<T> clazz, TransactionVO transactionVO) {
        Transaction transaction = (Transaction)this.newTrans(clazz, (TransVO)transactionVO);
        transaction.setKind(this.toTransactionKind(transactionVO.getNature()));
        transaction.setCreationType(this.toPaymentCreationTypeEnum(transactionVO.getCreationType()));
        transaction.setFromName(transactionVO.getFromName());
        transaction.setToName(transactionVO.getToName());
        transaction.setAuthorizationStatus(this.toTransactionAuthorizationStatusEnum(transactionVO.getAuthorizationStatus()));
        if (transactionVO instanceof TicketVO) {
            transaction.setTicketNumber(((TicketVO)transactionVO).getTicketNumber());
        }
        if (transactionVO instanceof BasePaymentVO) {
            transaction.setAuthorizationStatus(this.toTransactionAuthorizationStatusEnum(((BasePaymentVO)transactionVO).getAuthorizationStatus()));
        }
        transaction.setDescription(transactionVO.getDescription());
        return (T)transaction;
    }

    private <D extends BaseTransactionDataForSearch> D newTransactionDataForSearch(Class<D> clazz, ITransactionSearchData iTransactionSearchData) {
        BaseTransactionDataForSearch baseTransactionDataForSearch = (BaseTransactionDataForSearch)this.newBaseTransDataForSearch(clazz, (ITransSearchData)iTransactionSearchData);
        CollectionHelper.orEmpty((List)iTransactionSearchData.getAuthorizationRoles()).stream().map(this.apiHelper::toReference).forEach(baseTransactionDataForSearch.getAuthorizationRoles()::add);
        CollectionHelper.orEmpty((List)iTransactionSearchData.getAccountTypes()).stream().map(this.accountsApiHelper::toAccountType).forEach(baseTransactionDataForSearch.getAccountTypes()::add);
        baseTransactionDataForSearch.setCanViewAuthorized(iTransactionSearchData.isCanViewAuthorized());
        CollectionHelper.orEmpty((Set)iTransactionSearchData.getVisibleNatures()).stream().map(this::toTransactionKind).forEach(baseTransactionDataForSearch.getVisibleKinds()::add);
        return (D)baseTransactionDataForSearch;
    }

    private <Q extends BaseTransactionQuery> Q newTransactionQuery(Class<Q> clazz, BaseTransactionQueryFilters baseTransactionQueryFilters) {
        BaseTransactionQuery baseTransactionQuery = (BaseTransactionQuery)this.newAbstractTransactionQuery(clazz, baseTransactionQueryFilters);
        baseTransactionQuery.setAuthorizationRoles(CollectionHelper.orEmpty(baseTransactionQueryFilters.getAuthorizationRoles()).stream().map(string -> (AuthorizationRoleVO)ModelHelper.voFromString(AuthorizationRoleVO.class, (String)string)).collect(Collectors.toSet()));
        baseTransactionQuery.setRecurringPaymentStatuses(CollectionHelper.orEmpty(baseTransactionQueryFilters.getRecurringPaymentStatuses()).stream().map(this.recurringPaymentsApiHelper::toRecurringPaymentStatus).collect(Collectors.toSet()));
        baseTransactionQuery.setPaymentRequestExpiration(this.apiHelper.toDatePeriodDTO(baseTransactionQueryFilters.getPaymentRequestExpiration()));
        baseTransactionQuery.setPaymentRequestStatuses(CollectionHelper.orEmpty(baseTransactionQueryFilters.getPaymentRequestStatuses()).stream().map(this.paymentRequestsApiHelper::toPaymentRequestStatus).collect(Collectors.toSet()));
        baseTransactionQuery.setExternalPaymentExpiration(this.apiHelper.toDatePeriodDTO(baseTransactionQueryFilters.getExternalPaymentExpiration()));
        baseTransactionQuery.setExternalPaymentStatuses(CollectionHelper.orEmpty(baseTransactionQueryFilters.getExternalPaymentStatuses()).stream().map(this.externalPaymentsApiHelper::toExternalPaymentStatus).collect(Collectors.toSet()));
        baseTransactionQuery.setScheduledPaymentStatuses(CollectionHelper.orEmpty(baseTransactionQueryFilters.getScheduledPaymentStatuses()).stream().map(this.scheduledPaymentsApiHelper::toScheduledPaymentStatus).collect(Collectors.toSet()));
        baseTransactionQuery.setTicketExpiration(this.apiHelper.toDatePeriodDTO(baseTransactionQueryFilters.getTicketExpiration()));
        baseTransactionQuery.setTicketStatuses(CollectionHelper.orEmpty(baseTransactionQueryFilters.getTicketStatuses()).stream().map(this.ticketsApiHelper::toTicketStatus).collect(Collectors.toSet()));
        return (Q)baseTransactionQuery;
    }

    private TransferFeesPreview toTransferFeesPreview(TransferFeesPreviewVO transferFeesPreviewVO) {
        if (transferFeesPreviewVO == null) {
            return null;
        }
        TransferFeesPreview transferFeesPreview = new TransferFeesPreview();
        transferFeesPreview.setMainAmount(transferFeesPreviewVO.getMainAmount().getAmount());
        transferFeesPreview.setTotalAmount(transferFeesPreviewVO.getTotalAmount().getAmount());
        CollectionHelper.orEmpty((List)transferFeesPreviewVO.getFees()).stream().map(this.paymentsApiHelper::toFeePreview).forEach(transferFeesPreview.getFees()::add);
        return transferFeesPreview;
    }

    <P extends PerformTransaction> P newPerformTransaction(Class<P> clazz, PerformTransactionDTO performTransactionDTO) {
        PerformTransaction performTransaction = (PerformTransaction)ClassHelper.instantiate(clazz);
        performTransaction.setAmount(performTransactionDTO.getAmount());
        performTransaction.setDescription(performTransactionDTO.getDescription());
        performTransaction.setCurrency(ModelHelper.internalNameOrId((IEntity)performTransactionDTO.getCurrency()));
        performTransaction.setType(ModelHelper.internalNameOrId((IEntity)performTransactionDTO.getType()));
        performTransaction.setCustomValues(this.apiHelper.toCustomFieldValuesMap(performTransactionDTO.getCustomValues()));
        if (performTransaction instanceof PerformInternalTransaction && performTransactionDTO instanceof PerformInternalTransactionDTO) {
            PerformInternalTransaction performInternalTransaction = (PerformInternalTransaction)performTransaction;
            PerformInternalTransactionDTO performInternalTransactionDTO = (PerformInternalTransactionDTO)performTransactionDTO;
            performInternalTransaction.setFromName(performInternalTransactionDTO.getFromName());
            InternalAccountOwner internalAccountOwner = performInternalTransactionDTO.getSubject();
            performInternalTransaction.setSubject(this.accountsApiHelper.identifier((AccountOwner)internalAccountOwner));
            performInternalTransaction.setToName(performInternalTransactionDTO.getToName());
        }
        return (P)performTransaction;
    }

    <DTO extends PerformTransactionDTO> DTO newPerformTransactionDTO(Class<DTO> clazz, String string, String string2, PerformTransaction performTransaction) {
        PerformTransactionDTO performTransactionDTO = (PerformTransactionDTO)ClassHelper.instantiate(clazz);
        performTransactionDTO.setOwner(ModelHelper.accountOwner((String)string));
        performTransactionDTO.setAmount(this.apiHelper.toBigDecimal(performTransaction.getAmount()));
        performTransactionDTO.setCurrency((CurrencyVO)ModelHelper.voFromString(CurrencyVO.class, (String)performTransaction.getCurrency()));
        performTransactionDTO.setType((TransferTypeVO)ModelHelper.voFromString(TransferTypeVO.class, (String)performTransaction.getType()));
        performTransactionDTO.setDescription(performTransaction.getDescription());
        performTransactionDTO.setConfirmationPassword(string2);
        performTransactionDTO.setCustomValues(this.apiHelper.toCustomFieldValuesDTO(performTransaction.getCustomValues()));
        if (performTransactionDTO instanceof PerformInternalTransactionDTO && performTransaction instanceof PerformInternalTransaction) {
            PerformInternalTransactionDTO performInternalTransactionDTO = (PerformInternalTransactionDTO)performTransactionDTO;
            PerformInternalTransaction performInternalTransaction = (PerformInternalTransaction)performTransaction;
            performInternalTransactionDTO.setFromName(performInternalTransaction.getFromName());
            performInternalTransactionDTO.setSubject(ModelHelper.accountOwner((String)performInternalTransaction.getSubject()));
            performInternalTransactionDTO.setToName(performInternalTransaction.getToName());
        }
        return (DTO)performTransactionDTO;
    }

    <P extends TransactionPreview> P newPreview(Class<P> clazz, BasePaymentPreviewVO basePaymentPreviewVO) {
        InternalTransactionPreview internalTransactionPreview;
        TransactionPreview transactionPreview = (TransactionPreview)ClassHelper.instantiate(clazz);
        transactionPreview.setConfirmationMessage(basePaymentPreviewVO.getConfirmationMessage());
        transactionPreview.setConfirmationPasswordInput(this.authApiHelper.toPasswordInput((ICredentialInputDTO)basePaymentPreviewVO.getConfirmationPasswordInput()));
        transactionPreview.setFromAccount(this.accountsApiHelper.toAccountWithOwner(basePaymentPreviewVO.getFromAccount()));
        transactionPreview.setTotalAmount(this.apiHelper.getAmount(basePaymentPreviewVO.getTotalAmount()));
        transactionPreview.setCurrency(this.accountsApiHelper.toCurrency(basePaymentPreviewVO.getTotalAmount().getCurrency()));
        if (transactionPreview instanceof InternalTransactionPreview && basePaymentPreviewVO instanceof BaseInternalPaymentPreviewVO) {
            internalTransactionPreview = (InternalTransactionPreview)transactionPreview;
            BaseInternalPaymentPreviewVO baseInternalPaymentPreviewVO = (BaseInternalPaymentPreviewVO)basePaymentPreviewVO;
            internalTransactionPreview.setToAccount(this.accountsApiHelper.toAccountWithOwner(baseInternalPaymentPreviewVO.getToAccount()));
            internalTransactionPreview.setPendingAuthorization(baseInternalPaymentPreviewVO.isPendingAuthorization());
            if (transactionPreview instanceof PaymentPreview) {
                ((PaymentPreview)transactionPreview).setSkipConfirmation(baseInternalPaymentPreviewVO.isSkipConfirmation());
            }
        }
        internalTransactionPreview = null;
        if (basePaymentPreviewVO instanceof PaymentPreviewVO) {
            internalTransactionPreview = ((PaymentPreviewVO)basePaymentPreviewVO).getPayment();
        } else if (basePaymentPreviewVO instanceof ScheduledPaymentPreviewVO) {
            internalTransactionPreview = ((ScheduledPaymentPreviewVO)basePaymentPreviewVO).getScheduledPayment();
        } else if (basePaymentPreviewVO instanceof RecurringPaymentPreviewVO) {
            internalTransactionPreview = ((RecurringPaymentPreviewVO)basePaymentPreviewVO).getRecurringPayment();
        } else if (basePaymentPreviewVO instanceof ExternalPaymentPreviewVO) {
            internalTransactionPreview = ((ExternalPaymentPreviewVO)basePaymentPreviewVO).getPayment();
        } else {
            throw new IllegalArgumentException("Can't get perform dto from preview. Unknown payment preview class: " + basePaymentPreviewVO.getClass().getName());
        }
        if (internalTransactionPreview != null) {
            transactionPreview.setPaymentType(this.accountsApiHelper.toTransferType(internalTransactionPreview.getType()));
            transactionPreview.setCustomValues(this.apiHelper.toCustomFieldValuesList(internalTransactionPreview.getCustomValues()));
        }
        return (P)transactionPreview;
    }
}

