/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.IEntity;
import org.cyclos.model.QueryParameters;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.TokenPermissionsVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.tokens.NFCTokenDTO;
import org.cyclos.model.access.tokens.TokenBarcodeParams;
import org.cyclos.model.access.tokens.TokenDTO;
import org.cyclos.model.access.tokens.TokenData;
import org.cyclos.model.access.tokens.TokenDataParams;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenSearchData;
import org.cyclos.model.access.tokens.TokenStatus;
import org.cyclos.model.access.tokens.TokenVO;
import org.cyclos.model.access.tokens.TokensListData;
import org.cyclos.model.users.groups.BasicGroupVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.TokensApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.GroupsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.PhysicalTokenTypeEnum;
import org.cyclos.web.rest.model.Token;
import org.cyclos.web.rest.model.TokenDataForNew;
import org.cyclos.web.rest.model.TokenDataForSearch;
import org.cyclos.web.rest.model.TokenDetailed;
import org.cyclos.web.rest.model.TokenNew;
import org.cyclos.web.rest.model.TokenPermissions;
import org.cyclos.web.rest.model.TokenQueryFilters;
import org.cyclos.web.rest.model.TokenResult;
import org.cyclos.web.rest.model.TokenStatusEnum;
import org.cyclos.web.rest.model.TokenType;
import org.cyclos.web.rest.model.TokenView;
import org.cyclos.web.rest.model.UserTokensListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TokensApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private GroupsApiHelper groupsApiHelper;

    public PhysicalTokenTypeEnum toPhysicalTokenTypeEnum(org.cyclos.model.access.principaltypes.TokenType tokenType) {
        if (tokenType != null) {
            switch (tokenType) {
                case NFC_TAG: {
                    return PhysicalTokenTypeEnum.NFC_TAG;
                }
                case BARCODE: {
                    return PhysicalTokenTypeEnum.BARCODE;
                }
                case SWIPE: {
                    return PhysicalTokenTypeEnum.SWIPE;
                }
                case QRCODE: {
                    return PhysicalTokenTypeEnum.QR_CODE;
                }
                case OTHER: {
                    return PhysicalTokenTypeEnum.OTHER;
                }
            }
        }
        return null;
    }

    public TokenBarcodeParams toTokenBarcodeParams(String string, ImageSizeEnum imageSizeEnum) {
        TokenBarcodeParams tokenBarcodeParams = new TokenBarcodeParams();
        tokenBarcodeParams.setToken((TokenVO)ModelHelper.voFromString(TokenVO.class, (String)string));
        tokenBarcodeParams.setSize(this.apiHelper.toImageSize(imageSizeEnum));
        return tokenBarcodeParams;
    }

    public TokenDataForNew toTokenDataForNew(TokenData tokenData) {
        TokenDataForNew tokenDataForNew = new TokenDataForNew();
        TokenDTO tokenDTO = (TokenDTO)tokenData.getDto();
        tokenDataForNew.setType(this.toTokenType(tokenDTO.getType()));
        tokenDataForNew.setUser(this.usersApiHelper.toUser(tokenDTO.getUser()));
        tokenDataForNew.setToken(this.toTokenNew(tokenDTO));
        tokenDataForNew.setCanActivate(tokenData.isCanActivate());
        return tokenDataForNew;
    }

    public TokenDataForSearch toTokenDataForSearch(TokenSearchData tokenSearchData) {
        TokenDataForSearch tokenDataForSearch = new TokenDataForSearch();
        tokenDataForSearch.setType(this.toTokenType(tokenSearchData.getType()));
        CollectionHelper.orEmpty((List)tokenSearchData.getGroups()).stream().map(this.groupsApiHelper::toGroup).forEach(tokenDataForSearch.getGroups()::add);
        CollectionHelper.orEmpty((List)tokenSearchData.getExportFormats()).stream().map(this.apiHelper::toExportFormat).forEach(tokenDataForSearch.getExportFormats()::add);
        tokenDataForSearch.setCreate(tokenSearchData.isCreate());
        tokenDataForSearch.setActivate(tokenSearchData.isActivate());
        tokenDataForSearch.setQuery(this.toTokenQueryFilters((TokenQuery)tokenSearchData.getQuery()));
        return tokenDataForSearch;
    }

    public TokenDataParams toTokenDataParams(String string, String string2) {
        TokenDataParams tokenDataParams = new TokenDataParams();
        tokenDataParams.setType((PrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string));
        tokenDataParams.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        return tokenDataParams;
    }

    public TokenDetailed toTokenDetailed(TokenVO tokenVO) {
        if (tokenVO == null) {
            return null;
        }
        TokenDetailed tokenDetailed = this.newTokenResult(TokenDetailed.class, tokenVO);
        tokenDetailed.setType(this.toTokenType(tokenVO.getType()));
        return tokenDetailed;
    }

    public TokenDTO toTokenDTO(String string, TokenNew tokenNew) {
        TokenDTO tokenDTO = new TokenDTO();
        tokenDTO.setType((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string));
        tokenDTO.setUser((BasicUserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)tokenNew.getUser()));
        tokenDTO.setValue(tokenNew.getValue());
        tokenDTO.setActivateNow(Boolean.TRUE.equals(tokenNew.getActivateNow()));
        return tokenDTO;
    }

    public TokenPermissions toTokenPermissions(TokenPermissionsVO tokenPermissionsVO) {
        TokenPermissions tokenPermissions = new TokenPermissions();
        tokenPermissions.setType(this.toTokenType(tokenPermissionsVO.getType()));
        tokenPermissions.setCreate(tokenPermissionsVO.isCreate());
        tokenPermissions.setActivate(tokenPermissionsVO.isActivate());
        return tokenPermissions;
    }

    public TokenQuery toTokenQuery(TokensApi.SearchGeneralTokensParams searchGeneralTokensParams) {
        TokenQuery tokenQuery = this.apiHelper.newQuery(TokenQuery.class, searchGeneralTokensParams.page, searchGeneralTokensParams.pageSize, searchGeneralTokensParams.skipTotalCount);
        tokenQuery.setType((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)searchGeneralTokensParams.type));
        tokenQuery.setUser((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)searchGeneralTokensParams.user));
        tokenQuery.setActivation(this.apiHelper.toDatePeriodDTO(searchGeneralTokensParams.activationPeriod));
        tokenQuery.setExpiry(this.apiHelper.toDatePeriodDTO(searchGeneralTokensParams.expiryPeriod));
        tokenQuery.setValue(searchGeneralTokensParams.value);
        tokenQuery.setBrokers(CollectionHelper.orEmpty(searchGeneralTokensParams.brokers).stream().map(string -> (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string)).collect(Collectors.toSet()));
        tokenQuery.setGroups(CollectionHelper.orEmpty(searchGeneralTokensParams.groups).stream().map(string -> (BasicGroupVO)ModelHelper.voFromString(BasicGroupVO.class, (String)string)).collect(Collectors.toSet()));
        tokenQuery.setStatuses(CollectionHelper.orEmpty(searchGeneralTokensParams.statuses).stream().map(this::toTokenStatus).collect(Collectors.toSet()));
        return tokenQuery;
    }

    public TokenResult toTokenResult(TokenVO tokenVO) {
        if (tokenVO == null) {
            return null;
        }
        TokenResult tokenResult = this.newToken(TokenResult.class, tokenVO);
        tokenResult.setUser(this.usersApiHelper.toUser(tokenVO.getUser()));
        return tokenResult;
    }

    public TokenStatus toTokenStatus(TokenStatusEnum tokenStatusEnum) {
        if (tokenStatusEnum != null) {
            switch (tokenStatusEnum) {
                case ACTIVATION_EXPIRED: {
                    return TokenStatus.ACTIVATION_EXPIRED;
                }
                case ACTIVE: {
                    return TokenStatus.ACTIVE;
                }
                case BLOCKED: {
                    return TokenStatus.BLOCKED;
                }
                case CANCELED: {
                    return TokenStatus.CANCELED;
                }
                case EXPIRED: {
                    return TokenStatus.EXPIRED;
                }
                case PENDING: {
                    return TokenStatus.PENDING_ACTIVATION;
                }
                case UNASSIGNED: {
                    return TokenStatus.UNASSIGNED;
                }
            }
        }
        return null;
    }

    public TokenStatusEnum toTokenStatusEnum(TokenStatus tokenStatus) {
        if (tokenStatus != null) {
            switch (tokenStatus) {
                case ACTIVATION_EXPIRED: {
                    return TokenStatusEnum.ACTIVATION_EXPIRED;
                }
                case ACTIVE: {
                    return TokenStatusEnum.ACTIVE;
                }
                case BLOCKED: {
                    return TokenStatusEnum.BLOCKED;
                }
                case CANCELED: {
                    return TokenStatusEnum.CANCELED;
                }
                case EXPIRED: {
                    return TokenStatusEnum.EXPIRED;
                }
                case PENDING_ACTIVATION: {
                    return TokenStatusEnum.PENDING;
                }
                case UNASSIGNED: {
                    return TokenStatusEnum.UNASSIGNED;
                }
            }
        }
        return null;
    }

    public TokenType toTokenType(TokenPrincipalTypeVO tokenPrincipalTypeVO) {
        TokenType tokenType = this.apiHelper.newEntity(TokenType.class, tokenPrincipalTypeVO);
        tokenType.setPluralName(tokenPrincipalTypeVO.getPluralName());
        tokenType.setPhysicalType(this.toPhysicalTokenTypeEnum(tokenPrincipalTypeVO.getTokenType()));
        tokenType.setMask(tokenPrincipalTypeVO.getTokenMask());
        return tokenType;
    }

    public TokenView toTokenView(TokenData tokenData) {
        TokenDTO tokenDTO = (TokenDTO)tokenData.getDto();
        TokenView tokenView = this.apiHelper.newEntity(TokenView.class, tokenDTO);
        tokenView.setType(this.toTokenType(tokenDTO.getType()));
        tokenView.setUser(this.usersApiHelper.toUser(tokenDTO.getUser()));
        tokenView.setValue(tokenDTO instanceof NFCTokenDTO ? ((NFCTokenDTO)tokenDTO).getLabel() : tokenDTO.getValue());
        tokenView.setCreationDate(tokenDTO.getCreationDate());
        tokenView.setActivationDate(tokenDTO.getActivationDate());
        tokenView.setActivationDeadline(tokenDTO.getActivationDeadline());
        tokenView.setExpiryDate(tokenDTO.getExpiryDate());
        tokenView.setStatus(this.toTokenStatusEnum(tokenDTO.getStatus()));
        tokenView.setActivate(tokenData.isCanActivate());
        tokenView.setAssign(tokenData.isCanAssign());
        tokenView.setBlock(tokenData.isCanBlock());
        tokenView.setUnblock(tokenData.isCanUnblock());
        tokenView.setCancel(tokenData.isCanCancel());
        tokenView.setSetActivationDeadline(tokenData.isCanChangeActivationDeadline());
        tokenView.setSetExpiryDate(tokenData.isCanChangeExpiryDate());
        return tokenView;
    }

    public UserTokensListData toUserTokensListData(TokensListData tokensListData) {
        UserTokensListData userTokensListData = new UserTokensListData();
        userTokensListData.setUser(this.usersApiHelper.toUser(tokensListData.getUser()));
        userTokensListData.setType(this.toTokenType(tokensListData.getType()));
        userTokensListData.setActivate(tokensListData.isCanActivateNew());
        userTokensListData.setCreate(tokensListData.isCanCreateNew());
        userTokensListData.setMaxPerUser(tokensListData.getMaxPerUser());
        CollectionHelper.orEmpty((List)tokensListData.getTokens()).stream().map(this::toTokenResult).forEach(userTokensListData.getTokens()::add);
        return userTokensListData;
    }

    private <T extends Token> T newToken(Class<T> clazz, TokenVO tokenVO) {
        Token token = (Token)this.apiHelper.newEntity(clazz, tokenVO);
        token.setValue(tokenVO.getValue());
        token.setCreationDate(tokenVO.getCreationDate());
        token.setActivationDate(tokenVO.getActivationDate());
        token.setExpiryDate(tokenVO.getExpiryDate());
        token.setStatus(this.toTokenStatusEnum(tokenVO.getStatus()));
        return (T)token;
    }

    private <T extends TokenResult> T newTokenResult(Class<T> clazz, TokenVO tokenVO) {
        TokenResult tokenResult = (TokenResult)this.newToken(clazz, tokenVO);
        tokenResult.setUser(this.usersApiHelper.toUser(tokenVO.getUser()));
        return (T)tokenResult;
    }

    private TokenNew toTokenNew(TokenDTO tokenDTO) {
        TokenNew tokenNew = new TokenNew();
        tokenNew.setUser(ModelHelper.internalNameOrId((IEntity)tokenDTO.getUser()));
        tokenNew.setValue(tokenDTO.getValue());
        tokenNew.setActivateNow(tokenDTO.isActivateNow());
        return tokenNew;
    }

    private TokenQueryFilters toTokenQueryFilters(TokenQuery tokenQuery) {
        TokenQueryFilters tokenQueryFilters = this.apiHelper.newQueryFilters(TokenQueryFilters.class, (QueryParameters)tokenQuery);
        CollectionHelper.orEmpty((Set)tokenQuery.getStatuses()).stream().map(this::toTokenStatusEnum).forEach(tokenQueryFilters.getStatuses()::add);
        tokenQueryFilters.setUser(ModelHelper.internalNameOrId((IEntity)tokenQuery.getUser()));
        CollectionHelper.orEmpty((Set)tokenQuery.getBrokers()).stream().map(ModelHelper::internalNameOrId).forEach(tokenQueryFilters.getBrokers()::add);
        CollectionHelper.orEmpty((Set)tokenQuery.getGroups()).stream().map(ModelHelper::internalNameOrId).forEach(tokenQueryFilters.getGroups()::add);
        tokenQueryFilters.setActivationPeriod(this.apiHelper.toFilter(tokenQuery.getActivation()));
        tokenQueryFilters.setExpiryPeriod(this.apiHelper.toFilter(tokenQuery.getExpiry()));
        tokenQueryFilters.setValue(tokenQuery.getValue());
        return tokenQueryFilters;
    }
}

