/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.users.references.ReferenceQuery;
import org.cyclos.model.users.references.ReferenceType;
import org.cyclos.model.users.references.TransactionFeedbackDTO;
import org.cyclos.model.users.references.TransactionFeedbackData;
import org.cyclos.model.users.references.TransactionFeedbackEntryVO;
import org.cyclos.model.users.references.TransactionFeedbackQuery;
import org.cyclos.model.users.references.TransactionFeedbackSearchData;
import org.cyclos.model.users.references.TransactionFeedbackUpdateDTO;
import org.cyclos.model.users.references.TransactionFeedbackVO;
import org.cyclos.model.users.references.TransactionsAwaitingFeedbackQuery;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.PaymentFeedbacksApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ReferencesApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.model.PaymentAwaitingFeedbackQueryFilters;
import org.cyclos.web.rest.model.PaymentFeedback;
import org.cyclos.web.rest.model.PaymentFeedbackDataForEdit;
import org.cyclos.web.rest.model.PaymentFeedbackDataForGive;
import org.cyclos.web.rest.model.PaymentFeedbackDataForReply;
import org.cyclos.web.rest.model.PaymentFeedbackDataForSearch;
import org.cyclos.web.rest.model.PaymentFeedbackEdit;
import org.cyclos.web.rest.model.PaymentFeedbackGive;
import org.cyclos.web.rest.model.PaymentFeedbackQueryFilters;
import org.cyclos.web.rest.model.PaymentFeedbackResult;
import org.cyclos.web.rest.model.PaymentFeedbackView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PaymentFeedbacksApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private ReferencesApiHelper referencesApiHelper;
    @Autowired
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;

    public PaymentFeedback toPaymentFeedback(TransactionFeedbackVO transactionFeedbackVO) {
        if (transactionFeedbackVO == null) {
            return null;
        }
        long l = transactionFeedbackVO.getTransaction().getId();
        PaymentFeedback paymentFeedback = this.referencesApiHelper.newReference(PaymentFeedback.class, l, transactionFeedbackVO.getDate(), transactionFeedbackVO.getLevel(), transactionFeedbackVO.getComments());
        paymentFeedback.setReplyComments(transactionFeedbackVO.getReplyComments());
        paymentFeedback.setReplyCommentsDate(transactionFeedbackVO.getReplyCommentsDate());
        return paymentFeedback;
    }

    public PaymentFeedbackDataForEdit toPaymentFeedbackDataForEdit(TransactionFeedbackData transactionFeedbackData) {
        PaymentFeedbackDataForEdit paymentFeedbackDataForEdit = new PaymentFeedbackDataForEdit();
        paymentFeedbackDataForEdit.setFeedback(this.toPaymentFeedbackEdit((TransactionFeedbackDTO)transactionFeedbackData.getDto()));
        paymentFeedbackDataForEdit.setTransaction(this.transactionsApiHelper.toTransaction(transactionFeedbackData.getTransaction()));
        return paymentFeedbackDataForEdit;
    }

    public PaymentFeedbackDataForGive toPaymentFeedbackDataForGive(TransactionFeedbackData transactionFeedbackData) {
        PaymentFeedbackDataForGive paymentFeedbackDataForGive = new PaymentFeedbackDataForGive();
        paymentFeedbackDataForGive.setFeedback(this.toPaymentFeedbackGive((TransactionFeedbackDTO)transactionFeedbackData.getDto()));
        paymentFeedbackDataForGive.setCanGive(transactionFeedbackData.isCanComment());
        paymentFeedbackDataForGive.setDeadline(transactionFeedbackData.getDateLimit());
        paymentFeedbackDataForGive.setRequired(transactionFeedbackData.isRequiresFeedback());
        paymentFeedbackDataForGive.setTransaction(this.transactionsApiHelper.toTransaction(transactionFeedbackData.getTransaction()));
        return paymentFeedbackDataForGive;
    }

    public PaymentFeedbackDataForReply toPaymentFeedbackDataForReply(TransactionFeedbackData transactionFeedbackData) {
        PaymentFeedbackDataForReply paymentFeedbackDataForReply = new PaymentFeedbackDataForReply();
        paymentFeedbackDataForReply.setCanReply(transactionFeedbackData.isCanReply());
        paymentFeedbackDataForReply.setDeadline(transactionFeedbackData.getDateLimit());
        paymentFeedbackDataForReply.setComments(((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getComments());
        paymentFeedbackDataForReply.setLevel(this.referencesApiHelper.toReferenceLevelEnum(((TransactionFeedbackDTO)transactionFeedbackData.getDto()).getLevel()));
        paymentFeedbackDataForReply.setTransaction(this.transactionsApiHelper.toTransaction(transactionFeedbackData.getTransaction()));
        return paymentFeedbackDataForReply;
    }

    public PaymentFeedbackDataForSearch toPaymentFeedbackDataForSearch(TransactionFeedbackSearchData transactionFeedbackSearchData) {
        PaymentFeedbackDataForSearch paymentFeedbackDataForSearch = new PaymentFeedbackDataForSearch();
        paymentFeedbackDataForSearch.setUser(this.usersApiHelper.toUser((BasicUserVO)transactionFeedbackSearchData.getOwner()));
        paymentFeedbackDataForSearch.setManage(transactionFeedbackSearchData.isEditable());
        paymentFeedbackDataForSearch.setQuery(this.toPaymentFeedbackQueryFilters((TransactionFeedbackQuery)transactionFeedbackSearchData.getQuery()));
        CollectionHelper.orEmpty((List)transactionFeedbackSearchData.getDirections()).stream().map(referenceType -> this.referencesApiHelper.toReferenceDirectionEnum((ReferenceType)referenceType)).forEach(paymentFeedbackDataForSearch.getDirections()::add);
        return paymentFeedbackDataForSearch;
    }

    public PaymentFeedbackResult toPaymentFeedbackResult(TransactionFeedbackEntryVO transactionFeedbackEntryVO) {
        long l = transactionFeedbackEntryVO.getTransactionId();
        PaymentFeedbackResult paymentFeedbackResult = this.referencesApiHelper.newReference(PaymentFeedbackResult.class, l, transactionFeedbackEntryVO.getDate(), transactionFeedbackEntryVO.getLevel(), transactionFeedbackEntryVO.getComments());
        paymentFeedbackResult.setRelatedUser(this.usersApiHelper.toUser((BasicUserVO)transactionFeedbackEntryVO.getRelatedUser()));
        paymentFeedbackResult.setDirection(this.referencesApiHelper.toReferenceDirectionEnum(transactionFeedbackEntryVO.getReferenceType()));
        paymentFeedbackResult.setReplyComments(transactionFeedbackEntryVO.getReplyComments());
        paymentFeedbackResult.setReplyCommentsDate(transactionFeedbackEntryVO.getReplyCommentsDate());
        return paymentFeedbackResult;
    }

    public PaymentFeedbackView toPaymentFeedbackView(TransactionFeedbackData transactionFeedbackData) {
        long l = transactionFeedbackData.getTransactionId();
        TransactionFeedbackDTO transactionFeedbackDTO = (TransactionFeedbackDTO)transactionFeedbackData.getDto();
        PaymentFeedbackView paymentFeedbackView = this.referencesApiHelper.newReference(PaymentFeedbackView.class, l, transactionFeedbackDTO.getDate(), transactionFeedbackDTO.getLevel(), transactionFeedbackDTO.getComments());
        paymentFeedbackView.setReplyComments(transactionFeedbackDTO.getReplyComments());
        paymentFeedbackView.setReplyCommentsDate(transactionFeedbackDTO.getReplyCommentsDate());
        paymentFeedbackView.setManagerComments(transactionFeedbackDTO.getAdminComments());
        paymentFeedbackView.setManagerCommentsDate(transactionFeedbackDTO.getAdminCommentsDate());
        paymentFeedbackView.setFrom(this.usersApiHelper.toUser((BasicUserVO)transactionFeedbackDTO.getFrom()));
        paymentFeedbackView.setTo(this.usersApiHelper.toUser((BasicUserVO)transactionFeedbackDTO.getTo()));
        paymentFeedbackView.setTransaction(this.transactionsApiHelper.toTransaction(transactionFeedbackData.getTransaction()));
        paymentFeedbackView.setCanEdit(transactionFeedbackData.isEditable());
        paymentFeedbackView.setCanGive(transactionFeedbackData.isCanComment());
        paymentFeedbackView.setCanReply(transactionFeedbackData.isCanReply());
        return paymentFeedbackView;
    }

    public TransactionFeedbackUpdateDTO toTranactionFeedbackUpdateDTO(PaymentFeedbackEdit paymentFeedbackEdit) {
        if (paymentFeedbackEdit == null) {
            return null;
        }
        TransactionFeedbackUpdateDTO transactionFeedbackUpdateDTO = new TransactionFeedbackUpdateDTO();
        transactionFeedbackUpdateDTO.setAdminComments(paymentFeedbackEdit.getManagerComments());
        transactionFeedbackUpdateDTO.setComments(paymentFeedbackEdit.getGiveComments());
        transactionFeedbackUpdateDTO.setLevel(this.referencesApiHelper.toReferenceLevel(paymentFeedbackEdit.getLevel()));
        transactionFeedbackUpdateDTO.setReplyComments(paymentFeedbackEdit.getReplyComments());
        transactionFeedbackUpdateDTO.setVersion(paymentFeedbackEdit.getVersion());
        return transactionFeedbackUpdateDTO;
    }

    public TransactionsAwaitingFeedbackQuery toTransactionAwaitingFeedbackQuery(PaymentFeedbacksApi.SearchPaymentAwaitingFeedbackParams searchPaymentAwaitingFeedbackParams) {
        PaymentAwaitingFeedbackQueryFilters paymentAwaitingFeedbackQueryFilters = (PaymentAwaitingFeedbackQueryFilters)ClassHelper.convert((Object)searchPaymentAwaitingFeedbackParams, PaymentAwaitingFeedbackQueryFilters.class);
        TransactionsAwaitingFeedbackQuery transactionsAwaitingFeedbackQuery = this.apiHelper.newQuery(TransactionsAwaitingFeedbackQuery.class, paymentAwaitingFeedbackQueryFilters);
        transactionsAwaitingFeedbackQuery.setFrom((UserVO)ModelHelper.voFromString(UserVO.class, (String)searchPaymentAwaitingFeedbackParams.user));
        transactionsAwaitingFeedbackQuery.setTo((UserVO)ModelHelper.voFromString(UserVO.class, (String)paymentAwaitingFeedbackQueryFilters.getRelatedUser()));
        return transactionsAwaitingFeedbackQuery;
    }

    public TransactionFeedbackQuery toTransactionFeedbackQuery(PaymentFeedbacksApi.SearchPaymentFeedbacksParams searchPaymentFeedbacksParams) {
        TransactionFeedbackQuery transactionFeedbackQuery = this.apiHelper.newQuery(TransactionFeedbackQuery.class, searchPaymentFeedbacksParams.page, searchPaymentFeedbacksParams.pageSize, searchPaymentFeedbacksParams.skipTotalCount);
        transactionFeedbackQuery.setOwner((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)searchPaymentFeedbacksParams.user));
        transactionFeedbackQuery.setUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)searchPaymentFeedbacksParams.relatedUser));
        transactionFeedbackQuery.setLevels(CollectionHelper.orEmpty(searchPaymentFeedbacksParams.levels).stream().map(this.referencesApiHelper::toReferenceLevel).collect(Collectors.toSet()));
        transactionFeedbackQuery.setReferenceType(this.referencesApiHelper.toReferenceType(searchPaymentFeedbacksParams.direction));
        transactionFeedbackQuery.setPeriod(this.apiHelper.toDatePeriodDTO(searchPaymentFeedbacksParams.period));
        transactionFeedbackQuery.setActive(true);
        transactionFeedbackQuery.setNoReplied(Boolean.TRUE.equals(searchPaymentFeedbacksParams.noReplied));
        return transactionFeedbackQuery;
    }

    private PaymentFeedbackEdit toPaymentFeedbackEdit(TransactionFeedbackDTO transactionFeedbackDTO) {
        if (transactionFeedbackDTO == null) {
            return null;
        }
        PaymentFeedbackEdit paymentFeedbackEdit = new PaymentFeedbackEdit();
        paymentFeedbackEdit.setManagerComments(transactionFeedbackDTO.getAdminComments());
        paymentFeedbackEdit.setGiveComments(transactionFeedbackDTO.getComments());
        paymentFeedbackEdit.setLevel(this.referencesApiHelper.toReferenceLevelEnum(transactionFeedbackDTO.getLevel()));
        paymentFeedbackEdit.setReplyComments(transactionFeedbackDTO.getReplyComments());
        paymentFeedbackEdit.setVersion(transactionFeedbackDTO.getVersion());
        return paymentFeedbackEdit;
    }

    private PaymentFeedbackGive toPaymentFeedbackGive(TransactionFeedbackDTO transactionFeedbackDTO) {
        if (transactionFeedbackDTO == null) {
            return null;
        }
        PaymentFeedbackGive paymentFeedbackGive = new PaymentFeedbackGive();
        paymentFeedbackGive.setComments(transactionFeedbackDTO.getComments());
        paymentFeedbackGive.setLevel(this.referencesApiHelper.toReferenceLevelEnum(transactionFeedbackDTO.getLevel()));
        return paymentFeedbackGive;
    }

    private PaymentFeedbackQueryFilters toPaymentFeedbackQueryFilters(TransactionFeedbackQuery transactionFeedbackQuery) {
        PaymentFeedbackQueryFilters paymentFeedbackQueryFilters = this.referencesApiHelper.newBaseReferenceQueryFilters(PaymentFeedbackQueryFilters.class, (ReferenceQuery)transactionFeedbackQuery);
        return paymentFeedbackQueryFilters;
    }
}

