/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclos.model.access.MobileOperation;
import org.cyclos.model.contentmanagement.GetMobileUserDataParams;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageVO;
import org.cyclos.model.contentmanagement.translations.TranslationsData;
import org.cyclos.model.system.configurations.MapPreference;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.system.languages.DateFormat;
import org.cyclos.model.system.languages.NumberFormat;
import org.cyclos.model.system.languages.TimeFormat;
import org.cyclos.model.utils.FileSizeDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.mobile.BaseMobileData;
import org.cyclos.server.model.mobile.MobileGuestData;
import org.cyclos.server.model.mobile.MobileUserData;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.server.utils.LocaleHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.MobileApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.helpers.DevicesApiHelper;
import org.cyclos.web.rest.helpers.LocalizationApiHelper;
import org.cyclos.web.rest.helpers.MessagesApiHelper;
import org.cyclos.web.rest.helpers.NotificationsApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.PushApiHelper;
import org.cyclos.web.rest.helpers.UiApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.DataForMobileGuest;
import org.cyclos.web.rest.model.DataForMobileUser;
import org.cyclos.web.rest.model.DateFormatEnum;
import org.cyclos.web.rest.model.MapPreferenceEnum;
import org.cyclos.web.rest.model.MobileBaseData;
import org.cyclos.web.rest.model.MobileOperationEnum;
import org.cyclos.web.rest.model.MobilePage;
import org.cyclos.web.rest.model.MobileTranslations;
import org.cyclos.web.rest.model.NumberFormatEnum;
import org.cyclos.web.rest.model.TimeFormatEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MobileApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private NotificationsApiHelper notificationsApiHelper;
    @Autowired
    private MessagesApiHelper messagesApiHelper;
    @Autowired
    private UiApiHelper uiApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private DevicesApiHelper devicesApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private LocalizationApiHelper localizationApiHelper;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;
    @Autowired
    private PushApiHelper pushApiHelper;

    public GetVersionedDataParams toGetDataGuestParams(MobileApi.DataForMobileGuestParams dataForMobileGuestParams) {
        if (dataForMobileGuestParams == null) {
            return null;
        }
        return this.uiApiHelper.newGetVersionedDataParams(dataForMobileGuestParams.cyclosVersion, dataForMobileGuestParams.headerIf, dataForMobileGuestParams.footerIf, dataForMobileGuestParams.welcomePageIf, dataForMobileGuestParams.themeIf, dataForMobileGuestParams.translationsIf);
    }

    public GetMobileUserDataParams toGetDataUserParams(MobileApi.DataForMobileUserParams dataForMobileUserParams) {
        if (dataForMobileUserParams == null) {
            return null;
        }
        GetMobileUserDataParams getMobileUserDataParams = this.uiApiHelper.newGetVersionedDataParams(GetMobileUserDataParams.class, dataForMobileUserParams.cyclosVersion, dataForMobileUserParams.themeIf, dataForMobileUserParams.translationsIf);
        getMobileUserDataParams.setMobileHelp(this.apiHelper.toTranslatableVersionedVO(dataForMobileUserParams.mobileHelpIf));
        getMobileUserDataParams.setPosHelp(this.apiHelper.toTranslatableVersionedVO(dataForMobileUserParams.posHelpIf));
        getMobileUserDataParams.setHomePage(this.apiHelper.toTranslatableVersionedVO(dataForMobileUserParams.homePageIf));
        return getMobileUserDataParams;
    }

    public MapPreferenceEnum toMapPreferenceEnum(MapPreference mapPreference) {
        if (mapPreference != null) {
            switch (mapPreference) {
                case LOCAL_MAP: {
                    return MapPreferenceEnum.LOCAL_MAP;
                }
                case DEFAULT_MAP: {
                    return MapPreferenceEnum.DEFAULT_MAP;
                }
                case FILTERS: {
                    return MapPreferenceEnum.FILTERS;
                }
            }
        }
        return null;
    }

    public DataForMobileGuest toMobileDataForGuest(MobileGuestData mobileGuestData) {
        DataForMobileGuest dataForMobileGuest = this.newMobileBaseData(DataForMobileGuest.class, (BaseMobileData)mobileGuestData);
        dataForMobileGuest.setDataForLogin(this.authApiHelper.toDataForLogin(mobileGuestData.getLoginData()));
        dataForMobileGuest.setDataForDeviceConfirmationApproval(this.deviceConfirmationsApiHelper.toDataForApproval(mobileGuestData.getApprovalData()));
        dataForMobileGuest.setHeader(this.uiApiHelper.toTranslatableUIElementWithContent(mobileGuestData.getLoginHeader()));
        dataForMobileGuest.setFooter(this.uiApiHelper.toTranslatableUIElementWithContent(mobileGuestData.getLoginFooter()));
        dataForMobileGuest.setWelcomePage(this.uiApiHelper.toTranslatableUIElementWithContent(mobileGuestData.getWelcomePage()));
        dataForMobileGuest.setGroupsForRegistration(mobileGuestData.getGroupsForRegistration().stream().map(this.usersApiHelper::toGroupForRegistration).collect(Collectors.toList()));
        dataForMobileGuest.setAllowQuickPayment(mobileGuestData.isAllowQuickPayment());
        dataForMobileGuest.setMediumScreenRegistrationWizard(this.wizardsApiHelper.toWizard(mobileGuestData.getMediumScreenRegistrationWizard()));
        dataForMobileGuest.setSmallScreenRegistrationWizard(this.wizardsApiHelper.toWizard(mobileGuestData.getSmallScreenRegistrationWizard()));
        dataForMobileGuest.setWelcomePageEnabled(mobileGuestData.isWelcomePageEnabled());
        return dataForMobileGuest;
    }

    public DataForMobileUser toMobileDataForUser(MobileUserData mobileUserData) {
        DataForMobileUser dataForMobileUser = this.newMobileBaseData(DataForMobileUser.class, (BaseMobileData)mobileUserData);
        dataForMobileUser.setAuth(this.authApiHelper.toAuth(mobileUserData.getAuth()));
        dataForMobileUser.setNameOfUser(mobileUserData.getNameOfUser());
        CollectionHelper.orEmpty((List)mobileUserData.getAllowedOperations()).stream().map(this::toMobileOperationEnum).forEach(dataForMobileUser.getAllowedOperations()::add);
        dataForMobileUser.setMobileHelp(this.uiApiHelper.toTranslatableUIElementWithContent(mobileUserData.getMobileHelp()));
        dataForMobileUser.setPosHelp(this.uiApiHelper.toTranslatableUIElementWithContent(mobileUserData.getPosHelp()));
        dataForMobileUser.setHideUsersSearchMenu(mobileUserData.isHideUsersSearchMenu());
        dataForMobileUser.setAutoCompleteResults(mobileUserData.getAutoCompleteResults());
        CollectionHelper.orEmpty((List)mobileUserData.getPages()).stream().map(this::toMobilePage).forEach(dataForMobileUser.getPages()::add);
        CollectionHelper.orEmpty((List)mobileUserData.getCustomOperations()).stream().map(this.operationsApiHelper::toOperation).forEach(dataForMobileUser.getOperations()::add);
        dataForMobileUser.setCanReceiveFromNfcTag(mobileUserData.isCanReceiveFromNfcTag());
        dataForMobileUser.setDeviceActivationMode(this.devicesApiHelper.toDeviceActivationModeEnum(mobileUserData.getDeviceActivationMode()));
        dataForMobileUser.setPersonalizeOtherUsers(mobileUserData.isPersonalizeOtherUsers());
        dataForMobileUser.setMobileCameraOnPayment(mobileUserData.isMobileCameraOnPayment());
        dataForMobileUser.setScanQr(mobileUserData.isScanQR());
        CollectionHelper.orEmpty((List)mobileUserData.getPrincipalsAllowingQRCode()).stream().map(this.authApiHelper::toPrincipal).forEach(dataForMobileUser.getPrincipalsAllowingQRCode()::add);
        dataForMobileUser.setShoppingCartWebShopCount(mobileUserData.getShoppingCartWebShopCount());
        dataForMobileUser.setMessagesStatus(this.messagesApiHelper.toMessagesStatus(mobileUserData.getMessagesStatus()));
        dataForMobileUser.setNotificationsStatus(this.notificationsApiHelper.toNotificationsStatus(mobileUserData.getNotificationsStatus()));
        dataForMobileUser.setEnableBluetoothPrinter(mobileUserData.isEnableBluetoothPrinter());
        dataForMobileUser.setApplyDefaultUserSearchFiltersOnPayment(mobileUserData.isApplyDefaultUserSearchFiltersOnPayment());
        dataForMobileUser.setTopUpEnabled(mobileUserData.isTopUpEnabled());
        CollectionHelper.orEmpty((List)mobileUserData.getWizards()).stream().map(this.wizardsApiHelper::toWizard).forEach(dataForMobileUser.getWizards()::add);
        dataForMobileUser.setMapPreference(this.toMapPreferenceEnum(mobileUserData.getMapPreference()));
        dataForMobileUser.setTrustedDevicePrompt(mobileUserData.getTrustedDevicePrompt());
        dataForMobileUser.setPinPrompt(mobileUserData.getPinPrompt());
        dataForMobileUser.setHomePage(this.uiApiHelper.toTranslatableUIElementWithContent(mobileUserData.getHomePage()));
        CollectionHelper.orEmpty((Set)mobileUserData.getUpdateHomeOnEvents()).stream().map(this.pushApiHelper::toPushNotificationEventKind).forEach(dataForMobileUser.getUpdateHomeOnEvents()::add);
        dataForMobileUser.setHomePageEnabled(mobileUserData.isHomePageEnabled());
        dataForMobileUser.setReloadHomePage(mobileUserData.isReloadHomePage());
        dataForMobileUser.setHideQuickActions(mobileUserData.isHideQuickActions());
        return dataForMobileUser;
    }

    public MobileOperationEnum toMobileOperationEnum(MobileOperation mobileOperation) {
        if (mobileOperation != null) {
            switch (mobileOperation) {
                case CARD_FORMAT: {
                    return MobileOperationEnum.FORMAT_NFC;
                }
                case CARD_INITIALIZE: {
                    return MobileOperationEnum.INITIALIZE_NFC;
                }
                case CARD_PERSONALIZE: {
                    return MobileOperationEnum.PERSONALIZE_NFC;
                }
                case CARD_PERSONALIZE_SELF: {
                    return MobileOperationEnum.PERSONALIZE_NFC_SELF;
                }
                case CARD_READ: {
                    return MobileOperationEnum.READ_NFC;
                }
                case MAKE_SYSTEM_PAYMENT: {
                    return MobileOperationEnum.MAKE_SYSTEM_PAYMENT;
                }
                case MAKE_USER_PAYMENT: {
                    return MobileOperationEnum.MAKE_USER_PAYMENT;
                }
                case MANAGE_CONTACTS: {
                    return MobileOperationEnum.MANAGE_CONTACTS;
                }
                case MAP_DIRECTORY: {
                    return MobileOperationEnum.MAP_DIRECTORY;
                }
                case NFC_ACTIVATE: {
                    return MobileOperationEnum.ACTIVATE_NFC_DEVICE;
                }
                case NFC_DEACTIVATE: {
                    return MobileOperationEnum.DEACTIVATE_NFC_DEVICE;
                }
                case POS_ASSIGN: {
                    return MobileOperationEnum.ASSIGN_POS;
                }
                case POS_UNASSIGN: {
                    return MobileOperationEnum.UNASSIGN_POS;
                }
                case RECEIVE_PAYMENT: {
                    return MobileOperationEnum.RECEIVE_PAYMENT;
                }
                case REDEEM_VOUCHER: {
                    return MobileOperationEnum.REDEEM_VOUCHER;
                }
                case VIEW_REDEEMED: {
                    return MobileOperationEnum.VIEW_REDEEMED;
                }
                case USERS_SEARCH: {
                    return MobileOperationEnum.USERS_SEARCH;
                }
                case VIEW_ACCOUNT_INFORMATION: {
                    return MobileOperationEnum.VIEW_ACCOUNT_INFORMATION;
                }
                case VIEW_USER_PROFILE: {
                    return MobileOperationEnum.VIEW_USER_PROFILE;
                }
                case VOUCHERS: {
                    return MobileOperationEnum.BOUGHT_VOUCHERS;
                }
                case BUY_VOUCHER: {
                    return MobileOperationEnum.BUY_VOUCHER;
                }
                case MANAGE_OPERATORS: {
                    return MobileOperationEnum.MANAGE_OPERATORS;
                }
                case REGISTER_USERS_AS_MANAGER: {
                    return MobileOperationEnum.REGISTER_USERS_AS_MANAGER;
                }
                case REGISTER_USERS_AS_MEMBER: {
                    return MobileOperationEnum.REGISTER_USERS_AS_MEMBER;
                }
                case CREATE_TICKET: {
                    return MobileOperationEnum.CREATE_TICKET;
                }
                case ACCEPT_TICKET: {
                    return MobileOperationEnum.ACCEPT_TICKET;
                }
                case MANAGE_PASSWORDS: {
                    return MobileOperationEnum.MANAGE_PASSWORDS;
                }
                case PAYMENT_REQUESTS: {
                    return MobileOperationEnum.PAYMENT_REQUESTS;
                }
                case SEND_PAYMENT_REQUEST_TO_SYSTEM: {
                    return MobileOperationEnum.SEND_PAYMENT_REQUEST_TO_SYSTEM;
                }
                case SEND_PAYMENT_REQUEST_TO_USER: {
                    return MobileOperationEnum.SEND_PAYMENT_REQUEST_TO_USER;
                }
                case PURCHASES: {
                    return MobileOperationEnum.PURCHASES;
                }
                case VIEW_ADVERTISEMENTS: {
                    return MobileOperationEnum.VIEW_ADVERTISEMENTS;
                }
            }
        }
        return null;
    }

    private <D extends MobileBaseData> D newMobileBaseData(Class<D> clazz, BaseMobileData baseMobileData) {
        MobileTranslations mobileTranslations;
        Locale locale;
        MobileBaseData mobileBaseData = (MobileBaseData)ClassHelper.instantiate(clazz);
        mobileBaseData.setCyclosVersion(baseMobileData.getCyclosVersion());
        mobileBaseData.setApplicationUsername(baseMobileData.getApplicationUsername());
        mobileBaseData.setCurrentClientTime(baseMobileData.getCurrentClientTime());
        mobileBaseData.setNumberFormat(this.toNumberFormatEnum(baseMobileData.getNumberFormat()));
        mobileBaseData.setDateFormat(this.toDateFormatEnum(baseMobileData.getDateFormat()));
        mobileBaseData.setTimeFormat(this.toTimeFormatEnum(baseMobileData.getTimeFormat()));
        mobileBaseData.setRootUrl(baseMobileData.getRootUrl());
        if (baseMobileData.getLanguageTemplate() != null) {
            mobileBaseData.setLocale(LocaleHelper.mapLocale((BuiltinLanguage)baseMobileData.getLanguageTemplate()).toString());
        }
        mobileBaseData.setTheme(this.uiApiHelper.toThemeUIElement(baseMobileData.getTheme()));
        mobileBaseData.setMapBrowserApiKey(baseMobileData.getMapBrowserApiKey());
        TranslationsData translationsData = baseMobileData.getInitialTranslations();
        if (translationsData != null) {
            locale = LocaleHelper.mapLocale((BuiltinLanguage)translationsData.getTemplate());
            mobileTranslations = new MobileTranslations();
            mobileTranslations.setId(ApiHelper.toId(translationsData.getLanguageId()));
            mobileTranslations.setVersion(translationsData.getLanguageVersion());
            mobileTranslations.setLocale(locale.toString());
            mobileTranslations.setTranslations(translationsData.getTranslations());
            mobileBaseData.setTranslations(mobileTranslations);
        }
        if (baseMobileData.getLocalesData() != null) {
            baseMobileData.getLocalesData().getAllowedLocales().stream().map(this.localizationApiHelper::toUserLocale).forEach(mobileBaseData.getAllowedLocales()::add);
        }
        if ((locale = baseMobileData.getMaxImageDimensions()) != null) {
            mobileBaseData.setMaxImageWidth(locale.getWidth());
            mobileBaseData.setMaxImageHeight(locale.getHeight());
        }
        mobileBaseData.setJpegQuality(baseMobileData.getJpegQuality());
        mobileTranslations = baseMobileData.getMaxUploadSize();
        if (ModelHelper.isValid((FileSizeDTO)mobileTranslations)) {
            mobileBaseData.setMaxUploadSize(mobileTranslations.getUnit().getBytes() * mobileTranslations.getSize());
        }
        return (D)mobileBaseData;
    }

    private DateFormatEnum toDateFormatEnum(DateFormat dateFormat) {
        if (dateFormat != null) {
            switch (dateFormat) {
                case DMY_DASH: {
                    return DateFormatEnum.DMY_DASH;
                }
                case DMY_PERIOD: {
                    return DateFormatEnum.DMY_PERIOD;
                }
                case DMY_SLASH: {
                    return DateFormatEnum.DMY_SLASH;
                }
                case MDY_DASH: {
                    return DateFormatEnum.MDY_DASH;
                }
                case MDY_PERIOD: {
                    return DateFormatEnum.MDY_PERIOD;
                }
                case MDY_SLASH: {
                    return DateFormatEnum.MDY_SLASH;
                }
                case YMD_DASH: {
                    return DateFormatEnum.YMD_DASH;
                }
                case YMD_PERIOD: {
                    return DateFormatEnum.YMD_PERIOD;
                }
                case YMD_SLASH: {
                    return DateFormatEnum.YMD_SLASH;
                }
            }
        }
        return null;
    }

    private MobilePage toMobilePage(MobilePageVO mobilePageVO) {
        if (mobilePageVO == null) {
            return null;
        }
        MobilePage mobilePage = this.apiHelper.newEntity(MobilePage.class, mobilePageVO);
        mobilePage.setVersion(mobilePageVO.getVersion());
        mobilePage.setUseFullSpace(mobilePageVO.isUseFullSpace());
        mobilePage.setExternalUrl(mobilePageVO.getExternalUrl());
        this.apiHelper.setIconOrCustomSVG(mobilePageVO.getIcon(), mobilePage);
        return mobilePage;
    }

    private NumberFormatEnum toNumberFormatEnum(NumberFormat numberFormat) {
        if (numberFormat != null) {
            switch (numberFormat) {
                case COMMA_AS_DECIMAL: {
                    return NumberFormatEnum.COMMA_AS_DECIMAL;
                }
                case PERIOD_AS_DECIMAL: {
                    return NumberFormatEnum.PERIOD_AS_DECIMAL;
                }
            }
        }
        return null;
    }

    private TimeFormatEnum toTimeFormatEnum(TimeFormat timeFormat) {
        if (timeFormat != null) {
            switch (timeFormat) {
                case H12: {
                    return TimeFormatEnum.H12;
                }
                case H24: {
                    return TimeFormatEnum.H24;
                }
            }
        }
        return null;
    }
}

