/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.access.identityproviders.IdentityProviderCallbackStatus;
import org.cyclos.model.access.identityproviders.IdentityProviderVO;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderListData;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderStatus;
import org.cyclos.model.access.useridentityproviders.UserIdentityProviderVO;
import org.cyclos.server.model.access.identityproviders.IdentityProviderRequestResult;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ImagesApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.IdentityProvider;
import org.cyclos.web.rest.model.IdentityProviderCallbackResult;
import org.cyclos.web.rest.model.IdentityProviderCallbackStatusEnum;
import org.cyclos.web.rest.model.UserIdentityProvider;
import org.cyclos.web.rest.model.UserIdentityProviderStatusEnum;
import org.cyclos.web.rest.model.UserIdentityProvidersListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdentityProvidersApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private ImagesApiHelper imagesApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;

    public IdentityProvider toIdentityProvider(IdentityProviderVO identityProviderVO) {
        if (identityProviderVO == null) {
            return null;
        }
        IdentityProvider identityProvider = this.apiHelper.newEntity(IdentityProvider.class, identityProviderVO);
        identityProvider.setBackgroundColor(identityProviderVO.getBackgroundColor());
        identityProvider.setBorderColor(identityProviderVO.getBorderColor());
        identityProvider.setTextColor(identityProviderVO.getTextColor());
        identityProvider.setImage(this.imagesApiHelper.toImage(identityProviderVO.getImage()));
        return identityProvider;
    }

    public IdentityProviderCallbackResult toIdentityProviderCallbackResult(org.cyclos.model.access.identityproviders.IdentityProviderCallbackResult identityProviderCallbackResult) {
        IdentityProviderCallbackResult identityProviderCallbackResult2 = new IdentityProviderCallbackResult();
        identityProviderCallbackResult2.setIdentityProvider(this.toIdentityProvider(identityProviderCallbackResult.getIdentityProvider()));
        identityProviderCallbackResult2.setStatus(this.toIdentityProviderCallbackStatusEnum(identityProviderCallbackResult.getStatus()));
        identityProviderCallbackResult2.setRequestId(identityProviderCallbackResult.getRequestId());
        identityProviderCallbackResult2.setSessionToken(identityProviderCallbackResult.getSessionToken());
        identityProviderCallbackResult2.setName(identityProviderCallbackResult.getName());
        identityProviderCallbackResult2.setEmail(identityProviderCallbackResult.getEmail());
        identityProviderCallbackResult2.setUsername(identityProviderCallbackResult.getUsername());
        identityProviderCallbackResult2.setMobilePhone(identityProviderCallbackResult.getMobilePhone());
        identityProviderCallbackResult2.setLandLinePhone(identityProviderCallbackResult.getLandLinePhone());
        identityProviderCallbackResult2.setLandLineExtension(identityProviderCallbackResult.getLandLineExtension());
        identityProviderCallbackResult2.setImage(this.imagesApiHelper.toImage(identityProviderCallbackResult.getImage()));
        identityProviderCallbackResult2.setCustomValues(identityProviderCallbackResult.getCustomValues());
        identityProviderCallbackResult2.setWizardExecutionData(this.wizardsApiHelper.toWizardExecutionData(identityProviderCallbackResult.getWizardExecutionData()));
        identityProviderCallbackResult2.setErrorMessage(identityProviderCallbackResult.getErrorMessage());
        identityProviderCallbackResult2.setPinCreationToken(identityProviderCallbackResult.getPinCreationToken());
        return identityProviderCallbackResult2;
    }

    public IdentityProviderCallbackStatusEnum toIdentityProviderCallbackStatusEnum(IdentityProviderCallbackStatus identityProviderCallbackStatus) {
        if (identityProviderCallbackStatus != null) {
            switch (identityProviderCallbackStatus) {
                case DENIED: {
                    return IdentityProviderCallbackStatusEnum.DENIED;
                }
                case ERROR: {
                    return IdentityProviderCallbackStatusEnum.ERROR;
                }
                case LINKED: {
                    return IdentityProviderCallbackStatusEnum.LINKED;
                }
                case LOGIN_EMAIL: {
                    return IdentityProviderCallbackStatusEnum.LOGIN_EMAIL;
                }
                case LOGIN_LINK: {
                    return IdentityProviderCallbackStatusEnum.LOGIN_LINK;
                }
                case LOGIN_NO_EMAIL: {
                    return IdentityProviderCallbackStatusEnum.LOGIN_NO_EMAIL;
                }
                case LOGIN_NO_MATCH: {
                    return IdentityProviderCallbackStatusEnum.LOGIN_NO_MATCH;
                }
                case REGISTRATION_DATA: {
                    return IdentityProviderCallbackStatusEnum.REGISTRATION_DATA;
                }
                case REGISTRATION_DONE: {
                    return IdentityProviderCallbackStatusEnum.REGISTRATION_DONE;
                }
                case WIZARD: {
                    return IdentityProviderCallbackStatusEnum.WIZARD;
                }
            }
        }
        return null;
    }

    public org.cyclos.web.rest.model.IdentityProviderRequestResult toIdentityProviderRequestResult(IdentityProviderRequestResult identityProviderRequestResult) {
        org.cyclos.web.rest.model.IdentityProviderRequestResult identityProviderRequestResult2 = new org.cyclos.web.rest.model.IdentityProviderRequestResult();
        identityProviderRequestResult2.setIdentityProvider(this.toIdentityProvider(identityProviderRequestResult.getIdentityProvider()));
        identityProviderRequestResult2.setRequestId(identityProviderRequestResult.getRequestId());
        identityProviderRequestResult2.setUrl(identityProviderRequestResult.getUrl());
        return identityProviderRequestResult2;
    }

    public UserIdentityProvider toUserIdentityProvider(UserIdentityProviderVO userIdentityProviderVO) {
        UserIdentityProvider userIdentityProvider = this.apiHelper.newEntity(UserIdentityProvider.class, userIdentityProviderVO);
        userIdentityProvider.setStatus(this.toUserIdentityProviderStatusEnum(userIdentityProviderVO.getStatus()));
        userIdentityProvider.setIdentityProvider(this.toIdentityProvider(userIdentityProviderVO.getIdentityProvider()));
        userIdentityProvider.setLinkDate(userIdentityProviderVO.getLinkDate());
        userIdentityProvider.setName(userIdentityProviderVO.getName());
        userIdentityProvider.setEmail(userIdentityProviderVO.getEmail());
        return userIdentityProvider;
    }

    public UserIdentityProvidersListData toUserIdentityProvidersListData(UserIdentityProviderListData userIdentityProviderListData) {
        UserIdentityProvidersListData userIdentityProvidersListData = new UserIdentityProvidersListData();
        userIdentityProvidersListData.setUser(this.usersApiHelper.toUser(userIdentityProviderListData.getUser()));
        userIdentityProvidersListData.setCanLink(userIdentityProviderListData.isCanLink());
        userIdentityProvidersListData.setCanEdit(userIdentityProviderListData.isCanManage());
        CollectionHelper.orEmpty((List)userIdentityProviderListData.getIdentityProviders()).stream().map(this::toUserIdentityProvider).forEach(userIdentityProvidersListData.getIdentityProviders()::add);
        return userIdentityProvidersListData;
    }

    public UserIdentityProviderStatusEnum toUserIdentityProviderStatusEnum(UserIdentityProviderStatus userIdentityProviderStatus) {
        if (userIdentityProviderStatus != null) {
            switch (userIdentityProviderStatus) {
                case DISABLED: {
                    return UserIdentityProviderStatusEnum.DISABLED;
                }
                case LINKED: {
                    return UserIdentityProviderStatusEnum.LINKED;
                }
                case NOT_LINKED: {
                    return UserIdentityProviderStatusEnum.NOT_LINKED;
                }
            }
        }
        return null;
    }
}

