/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.List;
import org.cyclos.model.EntityVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.banking.accounts.AccountOwner;
import org.cyclos.model.banking.transactions.AbstractPaymentTypeData;
import org.cyclos.model.banking.transactions.BasePaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentActionDTO;
import org.cyclos.model.banking.transactions.ExternalPaymentData;
import org.cyclos.model.banking.transactions.ExternalPaymentPreviewVO;
import org.cyclos.model.banking.transactions.ExternalPaymentResultVO;
import org.cyclos.model.banking.transactions.ExternalPaymentStatus;
import org.cyclos.model.banking.transactions.ExternalPaymentVO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentDTO;
import org.cyclos.model.banking.transactions.PerformExternalPaymentData;
import org.cyclos.model.banking.transactions.PerformExternalPaymentTypeData;
import org.cyclos.model.banking.transactions.PerformTransactionDTO;
import org.cyclos.model.banking.transactions.TransactionVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.PaymentsApiHelper;
import org.cyclos.web.rest.helpers.TransactionsApiHelper;
import org.cyclos.web.rest.model.BaseTransactionResult;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.ExternalPaymentPermissions;
import org.cyclos.web.rest.model.ExternalPaymentPreview;
import org.cyclos.web.rest.model.ExternalPaymentStatusEnum;
import org.cyclos.web.rest.model.IdentificationMethodEnum;
import org.cyclos.web.rest.model.PerformExternalPayment;
import org.cyclos.web.rest.model.TransactionView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ExternalPaymentsApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    @Lazy
    private PaymentsApiHelper paymentsApiHelper;
    @Autowired
    @Lazy
    private TransactionsApiHelper transactionsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;

    public void fillTransactionResult(ExternalPaymentResultVO externalPaymentResultVO, BaseTransactionResult baseTransactionResult) {
        baseTransactionResult.setToPrincipalType(this.authApiHelper.toPrincipalType(externalPaymentResultVO.getToPrincipalType()));
        baseTransactionResult.setToPrincipalValue(externalPaymentResultVO.getToPrincipalValue());
        baseTransactionResult.setExternalPaymentStatus(this.toExternalPaymentStatusEnum(externalPaymentResultVO.getStatus()));
        baseTransactionResult.setExpirationDate(externalPaymentResultVO.getExpirationDate());
    }

    public void fillTransactionView(ExternalPaymentData externalPaymentData, TransactionView transactionView) {
        ExternalPaymentPermissions externalPaymentPermissions = new ExternalPaymentPermissions();
        externalPaymentPermissions.setCancel(externalPaymentData.isCanCancel());
        transactionView.setExternalPaymentPermissions(externalPaymentPermissions);
    }

    public void fillTransactionView(ExternalPaymentVO externalPaymentVO, TransactionView transactionView) {
        transactionView.setExternalPaymentStatus(this.toExternalPaymentStatusEnum(externalPaymentVO.getStatus()));
        transactionView.setExpirationDate(externalPaymentVO.getExpirationDate());
        transactionView.setProcessDate(externalPaymentVO.getProcessDate());
        transactionView.setTransaction(this.transactionsApiHelper.toTransaction((TransactionVO)externalPaymentVO.getPayment()));
        transactionView.setToPrincipalType(this.authApiHelper.toPrincipalType(externalPaymentVO.getToPrincipalType()));
        transactionView.setToPrincipalValue(externalPaymentVO.getToPrincipalValue());
        transactionView.setComments(externalPaymentVO.getComments());
    }

    public DataForTransaction toDataForPerformExternalPayment(PerformExternalPaymentData performExternalPaymentData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        CollectionHelper.orEmpty((List)performExternalPaymentData.getAccounts()).stream().map(this.accountsApiHelper::toAccountWithStatus).forEach(dataForTransaction.getAccounts()::add);
        dataForTransaction.setFromKind(this.accountsApiHelper.toAccountKind((AccountOwner)performExternalPaymentData.getFrom()));
        dataForTransaction.setFromUser(this.accountsApiHelper.toUser((AccountOwner)performExternalPaymentData.getFrom()));
        CollectionHelper.orEmpty((List)performExternalPaymentData.getPaymentTypes()).stream().map(this.accountsApiHelper::toTransferTypeWithCurrency).forEach(dataForTransaction.getPaymentTypes()::add);
        dataForTransaction.setPaymentTypeData(this.transactionsApiHelper.toTransactionTypeData((AbstractPaymentTypeData)performExternalPaymentData.getExternalPaymentTypeData()));
        dataForTransaction.setAllowedUsers(null);
        CollectionHelper.orEmpty((List)performExternalPaymentData.getPrincipalTypes()).stream().map(this.authApiHelper::toPrincipalTypeInput).forEach(dataForTransaction.getPrincipalTypes()::add);
        dataForTransaction.setDefaultPrincipalType(ModelHelper.stringOrIdFromVO((EntityVO)performExternalPaymentData.getDefaultPrincipalType()));
        dataForTransaction.setDefaultIdMethod(performExternalPaymentData.getDefaultPrincipalType() == null ? null : IdentificationMethodEnum.PRINCIPAL_TYPE);
        return dataForTransaction;
    }

    public DataForTransaction toDataForPerformExternalPayment(PerformExternalPaymentTypeData performExternalPaymentTypeData) {
        DataForTransaction dataForTransaction = new DataForTransaction();
        dataForTransaction.setPaymentTypeData(this.transactionsApiHelper.toTransactionTypeData((AbstractPaymentTypeData)performExternalPaymentTypeData));
        dataForTransaction.setAccounts(null);
        dataForTransaction.setPrincipalTypes(null);
        dataForTransaction.setPaymentTypes(null);
        dataForTransaction.setAllowedUsers(null);
        return dataForTransaction;
    }

    public ExternalPaymentActionDTO toExternalPaymentActionDTO(String string, String string2, String string3) {
        ExternalPaymentActionDTO externalPaymentActionDTO = new ExternalPaymentActionDTO();
        externalPaymentActionDTO.setExternalPayment((ExternalPaymentVO)ModelHelper.voFromString(ExternalPaymentVO.class, (String)string));
        externalPaymentActionDTO.setConfirmationPassword(string2);
        externalPaymentActionDTO.setComments(string3);
        return externalPaymentActionDTO;
    }

    public ExternalPaymentPreview toExternalPaymentPreview(ExternalPaymentPreviewVO externalPaymentPreviewVO) {
        if (externalPaymentPreviewVO == null) {
            return null;
        }
        PerformExternalPaymentDTO performExternalPaymentDTO = externalPaymentPreviewVO.getPayment();
        ExternalPaymentPreview externalPaymentPreview = this.transactionsApiHelper.newPreview(ExternalPaymentPreview.class, (BasePaymentPreviewVO)externalPaymentPreviewVO);
        externalPaymentPreview.setToPrincipalType(this.authApiHelper.toPrincipalType(performExternalPaymentDTO.getToPrincipalType()));
        externalPaymentPreview.setMainAmount(this.apiHelper.getAmount(externalPaymentPreviewVO.getMainAmount()));
        CollectionHelper.orEmpty((List)externalPaymentPreviewVO.getFees()).stream().map(this.paymentsApiHelper::toFeePreview).forEach(externalPaymentPreview.getFees()::add);
        externalPaymentPreview.setPayment(this.toPerformExternalPayment(performExternalPaymentDTO));
        return externalPaymentPreview;
    }

    public ExternalPaymentStatus toExternalPaymentStatus(ExternalPaymentStatusEnum externalPaymentStatusEnum) {
        if (externalPaymentStatusEnum != null) {
            switch (externalPaymentStatusEnum) {
                case PENDING: {
                    return ExternalPaymentStatus.PENDING;
                }
                case PROCESSED: {
                    return ExternalPaymentStatus.PROCESSED;
                }
                case EXPIRED: {
                    return ExternalPaymentStatus.EXPIRED;
                }
                case CANCELED: {
                    return ExternalPaymentStatus.CANCELED;
                }
                case FAILED: {
                    return ExternalPaymentStatus.FAILED;
                }
            }
        }
        return null;
    }

    public ExternalPaymentStatusEnum toExternalPaymentStatusEnum(ExternalPaymentStatus externalPaymentStatus) {
        if (externalPaymentStatus != null) {
            switch (externalPaymentStatus) {
                case PENDING: {
                    return ExternalPaymentStatusEnum.PENDING;
                }
                case PROCESSED: {
                    return ExternalPaymentStatusEnum.PROCESSED;
                }
                case EXPIRED: {
                    return ExternalPaymentStatusEnum.EXPIRED;
                }
                case CANCELED: {
                    return ExternalPaymentStatusEnum.CANCELED;
                }
                case FAILED: {
                    return ExternalPaymentStatusEnum.FAILED;
                }
            }
        }
        return null;
    }

    public PerformExternalPayment toPerformExternalPayment(PerformExternalPaymentDTO performExternalPaymentDTO) {
        if (performExternalPaymentDTO == null) {
            return null;
        }
        PerformExternalPayment performExternalPayment = this.transactionsApiHelper.newPerformTransaction(PerformExternalPayment.class, (PerformTransactionDTO)performExternalPaymentDTO);
        performExternalPayment.setToPrincipalType(ModelHelper.stringOrIdFromVO((EntityVO)performExternalPaymentDTO.getToPrincipalType()));
        performExternalPayment.setToPrincipalValue(performExternalPaymentDTO.getToPrincipalValue());
        return performExternalPayment;
    }

    public PerformExternalPaymentDTO toPerformExternalPaymentDTO(String string, String string2, PerformExternalPayment performExternalPayment) {
        PerformExternalPaymentDTO performExternalPaymentDTO = this.transactionsApiHelper.newPerformTransactionDTO(PerformExternalPaymentDTO.class, string, string2, performExternalPayment);
        performExternalPaymentDTO.setToPrincipalType((PrincipalTypeVO)ModelHelper.voFromString(PrincipalTypeVO.class, (String)performExternalPayment.getToPrincipalType()));
        performExternalPaymentDTO.setToPrincipalValue(performExternalPayment.getToPrincipalValue());
        return performExternalPaymentDTO;
    }
}

