/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import org.cyclos.model.access.clients.AccessClientAction;
import org.cyclos.model.access.clients.AccessClientActionConfirmationField;
import org.cyclos.model.access.devices.ActivateTrustedDeviceConfirmationField;
import org.cyclos.model.access.devices.CreateDeviceConfirmationParams;
import org.cyclos.model.access.devices.DeviceConfirmationApprovalData;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationField;
import org.cyclos.model.access.devices.DeviceConfirmationType;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.devices.InvalidDeviceConfirmationResult;
import org.cyclos.model.access.devices.TrustedDeviceAction;
import org.cyclos.model.access.passwords.GenerateNewPasswordConfirmationField;
import org.cyclos.model.banking.accounts.ChangeAccountLimitsConfirmationField;
import org.cyclos.model.banking.authorizations.AuthorizationAction;
import org.cyclos.model.banking.transactions.ApproveTicketConfirmationField;
import org.cyclos.model.banking.transactions.ExternalPaymentAction;
import org.cyclos.model.banking.transactions.ManageExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManagePaymentRequestConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageRecurringPaymentFailedOccurrenceConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentConfirmationField;
import org.cyclos.model.banking.transactions.ManageScheduledPaymentInstallmentConfirmationField;
import org.cyclos.model.banking.transactions.ManageTransactionAuthorizationConfirmationField;
import org.cyclos.model.banking.transactions.PaymentRequestAction;
import org.cyclos.model.banking.transactions.PerformExternalPaymentConfirmationField;
import org.cyclos.model.banking.transactions.PerformPaymentConfirmationField;
import org.cyclos.model.banking.transactions.RecurringPaymentAction;
import org.cyclos.model.banking.transactions.RecurringPaymentFailedOccurrenceAction;
import org.cyclos.model.banking.transactions.ScheduledPaymentAction;
import org.cyclos.model.banking.transactions.ScheduledPaymentInstallmentAction;
import org.cyclos.model.banking.transfers.ChargebackConfirmationField;
import org.cyclos.model.banking.vouchers.GenerateVouchersConfirmationField;
import org.cyclos.model.banking.vouchers.ManageVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.SendVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.TopUpVoucherConfirmationField;
import org.cyclos.model.banking.vouchers.VoucherAction;
import org.cyclos.model.marketplace.webshoporders.AcceptOrderConfirmationField;
import org.cyclos.model.marketplace.webshoporders.ShoppingCartCheckoutConfirmationField;
import org.cyclos.model.system.imports.ImportUserPaymentsConfirmationField;
import org.cyclos.model.system.imports.ImportUserSendVouchersConfirmationField;
import org.cyclos.model.system.operations.RunCustomOperationConfirmationField;
import org.cyclos.model.system.wizards.RunCustomWizardConfirmationField;
import org.cyclos.model.users.addresses.ManageAddressConfirmationField;
import org.cyclos.model.users.contactinfos.ManageContactInfoConfirmationField;
import org.cyclos.model.users.phones.ManagePhoneConfirmationField;
import org.cyclos.model.users.records.ManageRecordConfirmationField;
import org.cyclos.model.utils.DeviceConfirmationParamsBuilder;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.model.AuthorizationActionEnum;
import org.cyclos.web.rest.model.ClientActionEnum;
import org.cyclos.web.rest.model.CreateDeviceConfirmation;
import org.cyclos.web.rest.model.DataForDeviceConfirmationApproval;
import org.cyclos.web.rest.model.DeviceActionEnum;
import org.cyclos.web.rest.model.DeviceConfirmationStatusEnum;
import org.cyclos.web.rest.model.DeviceConfirmationTypeEnum;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.ExternalPaymentActionEnum;
import org.cyclos.web.rest.model.FailedOccurrenceActionEnum;
import org.cyclos.web.rest.model.ImageSizeEnum;
import org.cyclos.web.rest.model.InstallmentActionEnum;
import org.cyclos.web.rest.model.InvalidDeviceConfirmationEnum;
import org.cyclos.web.rest.model.PaymentRequestActionEnum;
import org.cyclos.web.rest.model.RecurringPaymentActionEnum;
import org.cyclos.web.rest.model.ScheduledPaymentActionEnum;
import org.cyclos.web.rest.model.VoucherActionEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeviceConfirmationsApiHelper {
    @Autowired
    private ApiHelper apiHelper;

    public AccessClientAction toAccessClientAction(ClientActionEnum clientActionEnum) {
        if (clientActionEnum != null) {
            switch (clientActionEnum) {
                case BLOCK: {
                    return AccessClientAction.BLOCK;
                }
                case GET_ACTIVATION_CODE: {
                    return AccessClientAction.GET_ACTIVATION_CODE;
                }
                case UNASSIGN: {
                    return AccessClientAction.UNASSIGN;
                }
                case UNBLOCK: {
                    return AccessClientAction.UNBLOCK;
                }
            }
        }
        return null;
    }

    public CreateDeviceConfirmationParams toCreateDeviceConfirmationParams(CreateDeviceConfirmation createDeviceConfirmation) {
        if (createDeviceConfirmation == null || createDeviceConfirmation.getType() == null) {
            return null;
        }
        DeviceConfirmationType deviceConfirmationType = this.toDeviceConfirmationType(createDeviceConfirmation.getType());
        DeviceConfirmationParamsBuilder deviceConfirmationParamsBuilder = DeviceConfirmationParamsBuilder.builder((DeviceConfirmationType)deviceConfirmationType);
        switch (deviceConfirmationType) {
            case SECONDARY_LOGIN: 
            case EDIT_PROFILE: 
            case LOGIN: 
            case IMPORT_PAYMENTS: 
            case PERSONALIZE_NFC_TAG: {
                break;
            }
            case MANAGE_TRUSTED_DEVICE: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ActivateTrustedDeviceConfirmationField.DEVICE, createDeviceConfirmation.getDeviceId()).field((DeviceConfirmationField)ActivateTrustedDeviceConfirmationField.ACTION, (Enum)this.toTrustedDeviceAction(createDeviceConfirmation.getDeviceAction()));
                break;
            }
            case ACCESS_CLIENT_ACTION: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)AccessClientActionConfirmationField.CLIENT, createDeviceConfirmation.getClient()).field((DeviceConfirmationField)AccessClientActionConfirmationField.ACTION, (Enum)this.toAccessClientAction(createDeviceConfirmation.getClientAction()));
                break;
            }
            case MANAGE_ADDRESS: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageAddressConfirmationField.NAME, createDeviceConfirmation.getName());
                break;
            }
            case MANAGE_PHONE: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManagePhoneConfirmationField.NAME, createDeviceConfirmation.getName());
                break;
            }
            case MANAGE_CONTACT_INFO: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageContactInfoConfirmationField.NAME, createDeviceConfirmation.getName());
                break;
            }
            case MANAGE_RECORD: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageRecordConfirmationField.TYPE, createDeviceConfirmation.getRecordType());
                break;
            }
            case PERFORM_PAYMENT: 
            case PERFORM_EXTERNAL_PAYMENT: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)PerformPaymentConfirmationField.FROM, createDeviceConfirmation.getFrom());
                if (deviceConfirmationType == DeviceConfirmationType.PERFORM_PAYMENT) {
                    deviceConfirmationParamsBuilder.field((DeviceConfirmationField)PerformPaymentConfirmationField.TO, createDeviceConfirmation.getTo());
                } else {
                    deviceConfirmationParamsBuilder.field((DeviceConfirmationField)PerformExternalPaymentConfirmationField.TO, createDeviceConfirmation.getToPrincipal());
                }
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)PerformPaymentConfirmationField.AMOUNT, createDeviceConfirmation.getAmount()).field((DeviceConfirmationField)PerformPaymentConfirmationField.TYPE, createDeviceConfirmation.getPaymentType());
                break;
            }
            case MANAGE_EXTERNAL_PAYMENT: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageExternalPaymentConfirmationField.PAYMENT, createDeviceConfirmation.getTransaction()).field((DeviceConfirmationField)ManageExternalPaymentConfirmationField.ACTION, (Enum)this.toExternalPaymentAction(createDeviceConfirmation.getExternalPaymentAction()));
                break;
            }
            case MANAGE_AUTHORIZATION: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageTransactionAuthorizationConfirmationField.PAYMENT, createDeviceConfirmation.getTransaction()).field((DeviceConfirmationField)ManageTransactionAuthorizationConfirmationField.ACTION, (Enum)this.toAuthorizationAction(createDeviceConfirmation.getAuthorizationAction()));
                break;
            }
            case MANAGE_PAYMENT_REQUEST: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManagePaymentRequestConfirmationField.PAYMENT_REQUEST, createDeviceConfirmation.getTransaction()).field((DeviceConfirmationField)ManagePaymentRequestConfirmationField.ACTION, (Enum)this.toPaymentRequestAction(createDeviceConfirmation.getPaymentRequestAction()));
                break;
            }
            case MANAGE_SCHEDULED_PAYMENT: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageScheduledPaymentConfirmationField.PAYMENT, createDeviceConfirmation.getTransaction()).field((DeviceConfirmationField)ManageScheduledPaymentConfirmationField.ACTION, (Enum)this.toScheduledPaymentAction(createDeviceConfirmation.getScheduledPaymentAction()));
                break;
            }
            case MANAGE_RECURRING_PAYMENT: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageRecurringPaymentConfirmationField.PAYMENT, createDeviceConfirmation.getTransaction()).field((DeviceConfirmationField)ManageRecurringPaymentConfirmationField.ACTION, (Enum)this.toRecurringPaymentAction(createDeviceConfirmation.getRecurringPaymentAction()));
                break;
            }
            case MANAGE_SCHEDULED_PAYMENT_INSTALLMENT: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageScheduledPaymentInstallmentConfirmationField.INSTALLMENT, createDeviceConfirmation.getInstallment()).field((DeviceConfirmationField)ManageScheduledPaymentInstallmentConfirmationField.ACTION, (Enum)this.toScheduledPaymentInstallmentAction(createDeviceConfirmation.getInstallmentAction()));
                break;
            }
            case MANAGE_RECURRING_PAYMENT_FAILED_OCCURRENCE: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageRecurringPaymentFailedOccurrenceConfirmationField.OCCURRENCE, createDeviceConfirmation.getFailedOccurrence()).field((DeviceConfirmationField)ManageRecurringPaymentFailedOccurrenceConfirmationField.ACTION, (Enum)this.toRecurringPaymentFailedOccurrenceAction(createDeviceConfirmation.getFailedOccurrenceAction()));
                break;
            }
            case SHOPPING_CART_CHECKOUT: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ShoppingCartCheckoutConfirmationField.AMOUNT, createDeviceConfirmation.getAmount()).field((DeviceConfirmationField)ShoppingCartCheckoutConfirmationField.PAYMENT_TYPE, createDeviceConfirmation.getPaymentType()).field((DeviceConfirmationField)ShoppingCartCheckoutConfirmationField.SELLER, createDeviceConfirmation.getSeller());
                break;
            }
            case ACCEPT_ORDER: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)AcceptOrderConfirmationField.ORDER, createDeviceConfirmation.getOrder());
                break;
            }
            case RUN_CUSTOM_OPERATION: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)RunCustomOperationConfirmationField.OPERATION, createDeviceConfirmation.getOperation());
                break;
            }
            case RUN_CUSTOM_WIZARD: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)RunCustomWizardConfirmationField.WIZARD, createDeviceConfirmation.getWizard());
                break;
            }
            case MANAGE_VOUCHER: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ManageVoucherConfirmationField.VOUCHER, createDeviceConfirmation.getVoucher()).field((DeviceConfirmationField)ManageVoucherConfirmationField.ACTION, (Enum)this.toVoucherAction(createDeviceConfirmation.getVoucherAction()));
                break;
            }
            case GENERATE_VOUCHERS: 
            case BUY_VOUCHERS: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)GenerateVouchersConfirmationField.AMOUNT, createDeviceConfirmation.getAmount()).field((DeviceConfirmationField)GenerateVouchersConfirmationField.COUNT, createDeviceConfirmation.getNumberOfVouchers()).field((DeviceConfirmationField)GenerateVouchersConfirmationField.TYPE, createDeviceConfirmation.getVoucherType());
                break;
            }
            case SEND_VOUCHER: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)SendVoucherConfirmationField.AMOUNT, createDeviceConfirmation.getAmount()).field((DeviceConfirmationField)SendVoucherConfirmationField.EMAIL, createDeviceConfirmation.getEmail()).field((DeviceConfirmationField)SendVoucherConfirmationField.TYPE, createDeviceConfirmation.getVoucherType());
                break;
            }
            case TOP_UP_VOUCHER: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)TopUpVoucherConfirmationField.AMOUNT, createDeviceConfirmation.getAmount()).field((DeviceConfirmationField)TopUpVoucherConfirmationField.TYPE, createDeviceConfirmation.getVoucherType());
                break;
            }
            case CHARGEBACK: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ChargebackConfirmationField.TRANSFER, createDeviceConfirmation.getTransfer());
                break;
            }
            case CHANGE_ACCOUNT_LIMITS: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ChangeAccountLimitsConfirmationField.ACCOUNT, createDeviceConfirmation.getAccount());
                break;
            }
            case GENERATE_NEW_PASSWORD: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)GenerateNewPasswordConfirmationField.TYPE, createDeviceConfirmation.getPasswordType());
                break;
            }
            case IMPORT_USER_PAYMENTS: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ImportUserPaymentsConfirmationField.TYPE, createDeviceConfirmation.getPaymentType());
                break;
            }
            case IMPORT_USER_SEND_VOUCHERS: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ImportUserSendVouchersConfirmationField.TYPE, createDeviceConfirmation.getVoucherType());
                break;
            }
            case APPROVE_TICKET: {
                deviceConfirmationParamsBuilder.field((DeviceConfirmationField)ApproveTicketConfirmationField.TICKET, createDeviceConfirmation.getTransaction());
                break;
            }
        }
        return deviceConfirmationParamsBuilder.build();
    }

    public DataForDeviceConfirmationApproval toDataForApproval(DeviceConfirmationApprovalData deviceConfirmationApprovalData) {
        if (deviceConfirmationApprovalData == null) {
            return null;
        }
        DataForDeviceConfirmationApproval dataForDeviceConfirmationApproval = new DataForDeviceConfirmationApproval();
        dataForDeviceConfirmationApproval.setAllowGuest(deviceConfirmationApprovalData.isAllowGuest());
        return dataForDeviceConfirmationApproval;
    }

    public DeviceConfirmationBarcodeParams toDeviceConfirmationBarcodeParams(String string, ImageSizeEnum imageSizeEnum) {
        DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams = new DeviceConfirmationBarcodeParams();
        deviceConfirmationBarcodeParams.setConfirmationId(string);
        deviceConfirmationBarcodeParams.setSize(this.apiHelper.toImageSize(imageSizeEnum));
        return deviceConfirmationBarcodeParams;
    }

    public DeviceConfirmationStatusEnum toDeviceConfirmationStatusEnum(Boolean bl) {
        if (bl == null) {
            return DeviceConfirmationStatusEnum.PENDING;
        }
        return bl != false ? DeviceConfirmationStatusEnum.APPROVED : DeviceConfirmationStatusEnum.REJECTED;
    }

    public DeviceConfirmationType toDeviceConfirmationType(DeviceConfirmationTypeEnum deviceConfirmationTypeEnum) {
        if (deviceConfirmationTypeEnum == null) {
            return null;
        }
        switch (deviceConfirmationTypeEnum) {
            case EDIT_PROFILE: {
                return DeviceConfirmationType.EDIT_PROFILE;
            }
            case MANAGE_ADDRESS: {
                return DeviceConfirmationType.MANAGE_ADDRESS;
            }
            case CLIENT_ACTION: {
                return DeviceConfirmationType.ACCESS_CLIENT_ACTION;
            }
            case MANAGE_PHONE: {
                return DeviceConfirmationType.MANAGE_PHONE;
            }
            case MANAGE_CONTACT_INFO: {
                return DeviceConfirmationType.MANAGE_CONTACT_INFO;
            }
            case PERFORM_PAYMENT: {
                return DeviceConfirmationType.PERFORM_PAYMENT;
            }
            case PERFORM_EXTERNAL_PAYMENT: {
                return DeviceConfirmationType.PERFORM_EXTERNAL_PAYMENT;
            }
            case MANAGE_EXTERNAL_PAYMENT: {
                return DeviceConfirmationType.MANAGE_EXTERNAL_PAYMENT;
            }
            case MANAGE_PAYMENT_REQUEST: {
                return DeviceConfirmationType.MANAGE_PAYMENT_REQUEST;
            }
            case MANAGE_AUTHORIZATION: {
                return DeviceConfirmationType.MANAGE_AUTHORIZATION;
            }
            case MANAGE_SCHEDULED_PAYMENT: {
                return DeviceConfirmationType.MANAGE_SCHEDULED_PAYMENT;
            }
            case MANAGE_RECURRING_PAYMENT: {
                return DeviceConfirmationType.MANAGE_RECURRING_PAYMENT;
            }
            case MANAGE_INSTALLMENT: {
                return DeviceConfirmationType.MANAGE_SCHEDULED_PAYMENT_INSTALLMENT;
            }
            case MANAGE_FAILED_OCCURRENCE: {
                return DeviceConfirmationType.MANAGE_RECURRING_PAYMENT_FAILED_OCCURRENCE;
            }
            case MANAGE_RECORD: {
                return DeviceConfirmationType.MANAGE_RECORD;
            }
            case SECONDARY_LOGIN: {
                return DeviceConfirmationType.SECONDARY_LOGIN;
            }
            case SHOPPING_CART_CHECKOUT: {
                return DeviceConfirmationType.SHOPPING_CART_CHECKOUT;
            }
            case ACCEPT_ORDER: {
                return DeviceConfirmationType.ACCEPT_ORDER;
            }
            case RUN_OPERATION: {
                return DeviceConfirmationType.RUN_CUSTOM_OPERATION;
            }
            case RUN_WIZARD: {
                return DeviceConfirmationType.RUN_CUSTOM_WIZARD;
            }
            case MANAGE_VOUCHER: {
                return DeviceConfirmationType.MANAGE_VOUCHER;
            }
            case GENERATE_VOUCHERS: {
                return DeviceConfirmationType.GENERATE_VOUCHERS;
            }
            case BUY_VOUCHERS: {
                return DeviceConfirmationType.BUY_VOUCHERS;
            }
            case SEND_VOUCHER: {
                return DeviceConfirmationType.SEND_VOUCHER;
            }
            case TOP_UP_VOUCHER: {
                return DeviceConfirmationType.TOP_UP_VOUCHER;
            }
            case CHARGEBACK: {
                return DeviceConfirmationType.CHARGEBACK;
            }
            case CHANGE_ACCOUNT_LIMITS: {
                return DeviceConfirmationType.CHANGE_ACCOUNT_LIMITS;
            }
            case GENERATE_PASSWORD: {
                return DeviceConfirmationType.GENERATE_NEW_PASSWORD;
            }
            case IMPORT_PAYMENTS: {
                return DeviceConfirmationType.IMPORT_PAYMENTS;
            }
            case IMPORT_USER_PAYMENTS: {
                return DeviceConfirmationType.IMPORT_USER_PAYMENTS;
            }
            case IMPORT_USER_SEND_VOUCHERS: {
                return DeviceConfirmationType.IMPORT_USER_SEND_VOUCHERS;
            }
            case APPROVE_TICKET: {
                return DeviceConfirmationType.APPROVE_TICKET;
            }
            case PERSONALIZE_NFC: {
                return DeviceConfirmationType.PERSONALIZE_NFC_TAG;
            }
            case MANAGE_DEVICE: {
                return DeviceConfirmationType.MANAGE_TRUSTED_DEVICE;
            }
            case REMOVE_TOTP_SECRET: {
                return DeviceConfirmationType.REMOVE_TOTP_SECRET;
            }
        }
        return null;
    }

    public DeviceConfirmationTypeEnum toDeviceConfirmationTypeEnum(DeviceConfirmationType deviceConfirmationType) {
        if (deviceConfirmationType == null) {
            return null;
        }
        switch (deviceConfirmationType) {
            case EDIT_PROFILE: {
                return DeviceConfirmationTypeEnum.EDIT_PROFILE;
            }
            case MANAGE_ADDRESS: {
                return DeviceConfirmationTypeEnum.MANAGE_ADDRESS;
            }
            case ACCESS_CLIENT_ACTION: {
                return DeviceConfirmationTypeEnum.CLIENT_ACTION;
            }
            case MANAGE_PHONE: {
                return DeviceConfirmationTypeEnum.MANAGE_PHONE;
            }
            case MANAGE_CONTACT_INFO: {
                return DeviceConfirmationTypeEnum.MANAGE_CONTACT_INFO;
            }
            case PERFORM_PAYMENT: {
                return DeviceConfirmationTypeEnum.PERFORM_PAYMENT;
            }
            case PERFORM_EXTERNAL_PAYMENT: {
                return DeviceConfirmationTypeEnum.PERFORM_EXTERNAL_PAYMENT;
            }
            case MANAGE_EXTERNAL_PAYMENT: {
                return DeviceConfirmationTypeEnum.MANAGE_EXTERNAL_PAYMENT;
            }
            case MANAGE_PAYMENT_REQUEST: {
                return DeviceConfirmationTypeEnum.MANAGE_PAYMENT_REQUEST;
            }
            case MANAGE_AUTHORIZATION: {
                return DeviceConfirmationTypeEnum.MANAGE_AUTHORIZATION;
            }
            case MANAGE_SCHEDULED_PAYMENT: {
                return DeviceConfirmationTypeEnum.MANAGE_SCHEDULED_PAYMENT;
            }
            case MANAGE_RECURRING_PAYMENT: {
                return DeviceConfirmationTypeEnum.MANAGE_RECURRING_PAYMENT;
            }
            case MANAGE_SCHEDULED_PAYMENT_INSTALLMENT: {
                return DeviceConfirmationTypeEnum.MANAGE_INSTALLMENT;
            }
            case MANAGE_RECURRING_PAYMENT_FAILED_OCCURRENCE: {
                return DeviceConfirmationTypeEnum.MANAGE_FAILED_OCCURRENCE;
            }
            case MANAGE_RECORD: {
                return DeviceConfirmationTypeEnum.MANAGE_RECORD;
            }
            case SECONDARY_LOGIN: {
                return DeviceConfirmationTypeEnum.SECONDARY_LOGIN;
            }
            case LOGIN: {
                return null;
            }
            case SHOPPING_CART_CHECKOUT: {
                return DeviceConfirmationTypeEnum.SHOPPING_CART_CHECKOUT;
            }
            case ACCEPT_ORDER: {
                return DeviceConfirmationTypeEnum.ACCEPT_ORDER;
            }
            case RUN_CUSTOM_OPERATION: {
                return DeviceConfirmationTypeEnum.RUN_OPERATION;
            }
            case RUN_CUSTOM_WIZARD: {
                return DeviceConfirmationTypeEnum.RUN_WIZARD;
            }
            case MANAGE_VOUCHER: {
                return DeviceConfirmationTypeEnum.MANAGE_VOUCHER;
            }
            case GENERATE_VOUCHERS: {
                return DeviceConfirmationTypeEnum.GENERATE_VOUCHERS;
            }
            case BUY_VOUCHERS: {
                return DeviceConfirmationTypeEnum.BUY_VOUCHERS;
            }
            case SEND_VOUCHER: {
                return DeviceConfirmationTypeEnum.SEND_VOUCHER;
            }
            case TOP_UP_VOUCHER: {
                return DeviceConfirmationTypeEnum.TOP_UP_VOUCHER;
            }
            case CHARGEBACK: {
                return DeviceConfirmationTypeEnum.CHARGEBACK;
            }
            case CHANGE_ACCOUNT_LIMITS: {
                return DeviceConfirmationTypeEnum.CHANGE_ACCOUNT_LIMITS;
            }
            case GENERATE_NEW_PASSWORD: {
                return DeviceConfirmationTypeEnum.GENERATE_PASSWORD;
            }
            case IMPORT_PAYMENTS: {
                return DeviceConfirmationTypeEnum.IMPORT_PAYMENTS;
            }
            case IMPORT_USER_PAYMENTS: {
                return DeviceConfirmationTypeEnum.IMPORT_USER_PAYMENTS;
            }
            case IMPORT_USER_SEND_VOUCHERS: {
                return DeviceConfirmationTypeEnum.IMPORT_USER_SEND_VOUCHERS;
            }
            case APPROVE_TICKET: {
                return DeviceConfirmationTypeEnum.APPROVE_TICKET;
            }
            case PERSONALIZE_NFC_TAG: {
                return DeviceConfirmationTypeEnum.PERSONALIZE_NFC;
            }
            case MANAGE_TRUSTED_DEVICE: {
                return DeviceConfirmationTypeEnum.MANAGE_DEVICE;
            }
            case REMOVE_TOTP_SECRET: {
                return DeviceConfirmationTypeEnum.REMOVE_TOTP_SECRET;
            }
        }
        return null;
    }

    public DeviceConfirmationView toDeviceConfirmationView(DeviceConfirmationVO deviceConfirmationVO) {
        if (deviceConfirmationVO == null) {
            return null;
        }
        DeviceConfirmationView deviceConfirmationView = new DeviceConfirmationView();
        deviceConfirmationView.setId(deviceConfirmationVO.getId());
        deviceConfirmationView.setQrContent(deviceConfirmationVO.getQrContent());
        deviceConfirmationView.setStatus(this.toDeviceConfirmationStatusEnum(deviceConfirmationVO.getApproved()));
        deviceConfirmationView.setType(this.toDeviceConfirmationTypeEnum(deviceConfirmationVO.getType()));
        return deviceConfirmationView;
    }

    public ExternalPaymentAction toExternalPaymentAction(ExternalPaymentActionEnum externalPaymentActionEnum) {
        if (externalPaymentActionEnum != null) {
            switch (externalPaymentActionEnum) {
                case CANCEL: {
                    return ExternalPaymentAction.CANCEL;
                }
            }
        }
        return null;
    }

    public InvalidDeviceConfirmationEnum toInvalidDeviceConfirmationEnum(InvalidDeviceConfirmationResult invalidDeviceConfirmationResult) {
        if (invalidDeviceConfirmationResult != null) {
            switch (invalidDeviceConfirmationResult) {
                case INVALID_CONFIRMATION: {
                    return InvalidDeviceConfirmationEnum.INVALID_CONFIRMATION;
                }
                case INVALID_DEVICE: {
                    return InvalidDeviceConfirmationEnum.INVALID_DEVICE;
                }
                case MAX_CHECK_ATTEMPTS_REACHED: {
                    return InvalidDeviceConfirmationEnum.MAX_CHECK_ATEMPTS_REACHED;
                }
            }
        }
        return null;
    }

    public RecurringPaymentAction toRecurringPaymentAction(RecurringPaymentActionEnum recurringPaymentActionEnum) {
        if (recurringPaymentActionEnum != null) {
            switch (recurringPaymentActionEnum) {
                case CANCEL: {
                    return RecurringPaymentAction.CANCEL;
                }
                case BLOCK: {
                    return RecurringPaymentAction.BLOCK;
                }
                case UNBLOCK: {
                    return RecurringPaymentAction.UNBLOCK;
                }
                case MODIFY: {
                    return RecurringPaymentAction.MODIFY;
                }
            }
        }
        return null;
    }

    public RecurringPaymentFailedOccurrenceAction toRecurringPaymentFailedOccurrenceAction(FailedOccurrenceActionEnum failedOccurrenceActionEnum) {
        if (failedOccurrenceActionEnum != null) {
            switch (failedOccurrenceActionEnum) {
                case PROCESS: {
                    return RecurringPaymentFailedOccurrenceAction.PROCESS;
                }
            }
        }
        return null;
    }

    public ScheduledPaymentAction toScheduledPaymentAction(ScheduledPaymentActionEnum scheduledPaymentActionEnum) {
        if (scheduledPaymentActionEnum != null) {
            switch (scheduledPaymentActionEnum) {
                case CANCEL: {
                    return ScheduledPaymentAction.CANCEL;
                }
                case BLOCK: {
                    return ScheduledPaymentAction.BLOCK;
                }
                case SETTLE: {
                    return ScheduledPaymentAction.SETTLE;
                }
                case UNBLOCK: {
                    return ScheduledPaymentAction.UNBLOCK;
                }
            }
        }
        return null;
    }

    public ScheduledPaymentInstallmentAction toScheduledPaymentInstallmentAction(InstallmentActionEnum installmentActionEnum) {
        if (installmentActionEnum != null) {
            switch (installmentActionEnum) {
                case PROCESS: {
                    return ScheduledPaymentInstallmentAction.PROCESS;
                }
                case SETTLE: {
                    return ScheduledPaymentInstallmentAction.SETTLE;
                }
            }
        }
        return null;
    }

    private AuthorizationAction toAuthorizationAction(AuthorizationActionEnum authorizationActionEnum) {
        if (authorizationActionEnum != null) {
            switch (authorizationActionEnum) {
                case AUTHORIZE: {
                    return AuthorizationAction.AUTHORIZED;
                }
                case DENY: {
                    return AuthorizationAction.DENIED;
                }
                case CANCEL: {
                    return AuthorizationAction.CANCELED;
                }
            }
        }
        return null;
    }

    private PaymentRequestAction toPaymentRequestAction(PaymentRequestActionEnum paymentRequestActionEnum) {
        if (paymentRequestActionEnum != null) {
            switch (paymentRequestActionEnum) {
                case ACCEPT: {
                    return PaymentRequestAction.ACCEPT;
                }
                case DENY: {
                    return PaymentRequestAction.DENY;
                }
                case RESCHEDULE: {
                    return PaymentRequestAction.RESCHEDULE;
                }
                case CANCEL: {
                    return PaymentRequestAction.CANCEL;
                }
                case CHANGE_EXPIRATION: {
                    return PaymentRequestAction.CHANGE_EXPIRATION_DATE;
                }
            }
        }
        return null;
    }

    private TrustedDeviceAction toTrustedDeviceAction(DeviceActionEnum deviceActionEnum) {
        if (deviceActionEnum != null) {
            switch (deviceActionEnum) {
                case ACTIVATE: {
                    return TrustedDeviceAction.ACTIVATE;
                }
                case REMOVE: {
                    return TrustedDeviceAction.REMOVE;
                }
            }
        }
        return null;
    }

    private VoucherAction toVoucherAction(VoucherActionEnum voucherActionEnum) {
        if (voucherActionEnum != null) {
            switch (voucherActionEnum) {
                case CANCEL: {
                    return VoucherAction.CANCEL;
                }
                case CHANGE_EXPIRATION: {
                    return VoucherAction.CHANGE_EXPIRATION_DATE;
                }
                case CHANGE_NOTIFICATION_SETTINGS: {
                    return VoucherAction.CHANGE_NOTIFICATION_SETTINGS;
                }
                case CHANGE_PIN: {
                    return VoucherAction.CHANGE_PIN;
                }
            }
        }
        return null;
    }
}

