/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.helpers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.cyclos.model.EntityModel;
import org.cyclos.model.EntityVO;
import org.cyclos.model.IEntity;
import org.cyclos.model.access.CaptchaInputDTO;
import org.cyclos.model.access.CaptchaResponseDTO;
import org.cyclos.model.access.CredentialType;
import org.cyclos.model.access.LoginData;
import org.cyclos.model.access.Role;
import org.cyclos.model.access.identityproviders.IdentityProviderNotLinkReason;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordDTO;
import org.cyclos.model.access.passwords.ChangeForgottenPasswordData;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ForgotPasswordRequestDTO;
import org.cyclos.model.access.passwords.GetChangeForgottenPasswordDataParams;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.access.passwords.PasswordStatus;
import org.cyclos.model.access.passwords.SendOtpData;
import org.cyclos.model.access.passwords.SendOtpParams;
import org.cyclos.model.access.passwordtypes.PasswordTypeVO;
import org.cyclos.model.access.pins.PinInputDTO;
import org.cyclos.model.access.principaltypes.ExistingBuiltInPrincipalType;
import org.cyclos.model.access.principaltypes.PrincipalTypeInputVO;
import org.cyclos.model.access.principaltypes.PrincipalTypeNature;
import org.cyclos.model.access.principaltypes.PrincipalTypeVO;
import org.cyclos.model.access.principaltypes.PrincipalVO;
import org.cyclos.model.access.principaltypes.TokenType;
import org.cyclos.model.banking.accounttypes.AccountTypeVO;
import org.cyclos.model.banking.transfertypes.TransferTypeVO;
import org.cyclos.model.system.configurations.CaptchaProvider;
import org.cyclos.model.system.configurations.ForgotPasswordMode;
import org.cyclos.model.users.groups.BasicGroupNature;
import org.cyclos.model.users.phones.PhoneVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.model.utils.TimeIntervalDTO;
import org.cyclos.server.model.access.login.AccountPermissionsVO;
import org.cyclos.server.model.access.login.AgreementsPermissionsVO;
import org.cyclos.server.model.access.login.AuthVO;
import org.cyclos.server.model.access.login.BankingPermissionsVO;
import org.cyclos.server.model.access.login.ConnectedUsersPermissionsVO;
import org.cyclos.server.model.access.login.ContactsPermissionsVO;
import org.cyclos.server.model.access.login.DocumentsPermissionsVO;
import org.cyclos.server.model.access.login.ExternalPaymentsPermissionsVO;
import org.cyclos.server.model.access.login.IdentityProvidersPermissionsVO;
import org.cyclos.server.model.access.login.ImagesPermissionsVO;
import org.cyclos.server.model.access.login.ImportsPermissionsVO;
import org.cyclos.server.model.access.login.InvitePermissionsVO;
import org.cyclos.server.model.access.login.MarketplacePermissionsVO;
import org.cyclos.server.model.access.login.MessagesPermissionsVO;
import org.cyclos.server.model.access.login.MyMessagesPermissionsVO;
import org.cyclos.server.model.access.login.NotificationSettingsPermissionsVO;
import org.cyclos.server.model.access.login.NotificationsPermissionsVO;
import org.cyclos.server.model.access.login.OperationPermissionsVO;
import org.cyclos.server.model.access.login.OperationsPermissionsVO;
import org.cyclos.server.model.access.login.OperatorsPermissionsVO;
import org.cyclos.server.model.access.login.PasswordPermissionsVO;
import org.cyclos.server.model.access.login.PasswordsPermissionsVO;
import org.cyclos.server.model.access.login.PaymentRequestsPermissionsVO;
import org.cyclos.server.model.access.login.PaymentsPermissionsVO;
import org.cyclos.server.model.access.login.PermissionsVO;
import org.cyclos.server.model.access.login.PrivacySettingsPermissionsVO;
import org.cyclos.server.model.access.login.ProfilePermissionsVO;
import org.cyclos.server.model.access.login.RecordPermissionsVO;
import org.cyclos.server.model.access.login.RecordsPermissionsVO;
import org.cyclos.server.model.access.login.ReferencesPermissionsVO;
import org.cyclos.server.model.access.login.ScheduledPaymentsPermissionsVO;
import org.cyclos.server.model.access.login.SessionPropertiesVO;
import org.cyclos.server.model.access.login.SessionSource;
import org.cyclos.server.model.access.login.SetSessionPropertiesDTO;
import org.cyclos.server.model.access.login.SystemMessagesPermissionsVO;
import org.cyclos.server.model.access.login.TicketsPermissionsVO;
import org.cyclos.server.model.access.login.TokensPermissionsVO;
import org.cyclos.server.model.access.login.TransactionAuthorizationsPermissionsVO;
import org.cyclos.server.model.access.login.UserAlertsPermissionsVO;
import org.cyclos.server.model.access.login.UsersPermissionsVO;
import org.cyclos.server.model.access.login.VoucherPermissionsVO;
import org.cyclos.server.model.access.login.VouchersPermissionsVO;
import org.cyclos.server.model.access.login.WizardPermissionsVO;
import org.cyclos.server.model.access.login.WizardsPermissionsVO;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.access.LoginDTO;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.MaskHelper;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.helpers.DevicePinsApiHelper;
import org.cyclos.web.rest.helpers.IdentityProvidersApiHelper;
import org.cyclos.web.rest.helpers.ImportsApiHelper;
import org.cyclos.web.rest.helpers.OperationsApiHelper;
import org.cyclos.web.rest.helpers.PasswordsApiHelper;
import org.cyclos.web.rest.helpers.PhonesApiHelper;
import org.cyclos.web.rest.helpers.RecordsApiHelper;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.helpers.UsersApiHelper;
import org.cyclos.web.rest.helpers.VouchersApiHelper;
import org.cyclos.web.rest.helpers.WizardsApiHelper;
import org.cyclos.web.rest.model.AccountPermissions;
import org.cyclos.web.rest.model.AgreementsPermissions;
import org.cyclos.web.rest.model.AlertsPermissions;
import org.cyclos.web.rest.model.Auth;
import org.cyclos.web.rest.model.BankingPermissions;
import org.cyclos.web.rest.model.BaseAuth;
import org.cyclos.web.rest.model.CaptchaInput;
import org.cyclos.web.rest.model.CaptchaProviderEnum;
import org.cyclos.web.rest.model.CaptchaResponse;
import org.cyclos.web.rest.model.ChangeForgottenPassword;
import org.cyclos.web.rest.model.ContactsPermissions;
import org.cyclos.web.rest.model.CredentialTypeEnum;
import org.cyclos.web.rest.model.DataForChangeForgottenPassword;
import org.cyclos.web.rest.model.DataForLogin;
import org.cyclos.web.rest.model.DataForSendingOtp;
import org.cyclos.web.rest.model.DocumentsPermissions;
import org.cyclos.web.rest.model.ExternalPaymentsPermissions;
import org.cyclos.web.rest.model.ForgottenPasswordRequest;
import org.cyclos.web.rest.model.ForgottenPasswordResponse;
import org.cyclos.web.rest.model.IdentityProviderNotLinkReasonEnum;
import org.cyclos.web.rest.model.IdentityProvidersPermissions;
import org.cyclos.web.rest.model.ImagesPermissions;
import org.cyclos.web.rest.model.ImportsPermissions;
import org.cyclos.web.rest.model.InvitePermissions;
import org.cyclos.web.rest.model.LoginAuth;
import org.cyclos.web.rest.model.MarketplacePermissions;
import org.cyclos.web.rest.model.MessagesPermissions;
import org.cyclos.web.rest.model.MyMarketplacePermissions;
import org.cyclos.web.rest.model.MyMessagesPermissions;
import org.cyclos.web.rest.model.NotificationSettingsPermissions;
import org.cyclos.web.rest.model.NotificationsPermissions;
import org.cyclos.web.rest.model.OperationPermissions;
import org.cyclos.web.rest.model.OperationsPermissions;
import org.cyclos.web.rest.model.OperatorsPermissions;
import org.cyclos.web.rest.model.OtpResult;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.PasswordInputMethodEnum;
import org.cyclos.web.rest.model.PasswordModeEnum;
import org.cyclos.web.rest.model.PasswordPermissions;
import org.cyclos.web.rest.model.PasswordTypeDetailed;
import org.cyclos.web.rest.model.PasswordsPermissions;
import org.cyclos.web.rest.model.PaymentFeedbacksPermissions;
import org.cyclos.web.rest.model.PaymentRequestsPermissions;
import org.cyclos.web.rest.model.PaymentsPermissions;
import org.cyclos.web.rest.model.Permissions;
import org.cyclos.web.rest.model.PinInput;
import org.cyclos.web.rest.model.Principal;
import org.cyclos.web.rest.model.PrincipalType;
import org.cyclos.web.rest.model.PrincipalTypeInput;
import org.cyclos.web.rest.model.PrincipalTypeKind;
import org.cyclos.web.rest.model.PrivacySettingsPermissions;
import org.cyclos.web.rest.model.RecordPermissions;
import org.cyclos.web.rest.model.RecordsPermissions;
import org.cyclos.web.rest.model.ReferencesPermissions;
import org.cyclos.web.rest.model.RelatedTransferType;
import org.cyclos.web.rest.model.RoleEnum;
import org.cyclos.web.rest.model.ScheduledPaymentsPermissions;
import org.cyclos.web.rest.model.SendOtp;
import org.cyclos.web.rest.model.SessionPropertiesEdit;
import org.cyclos.web.rest.model.SessionPropertiesView;
import org.cyclos.web.rest.model.SessionSourceEnum;
import org.cyclos.web.rest.model.SessionsPermissions;
import org.cyclos.web.rest.model.SystemImageCategoryPermissions;
import org.cyclos.web.rest.model.SystemMessagesPermissions;
import org.cyclos.web.rest.model.TicketsPermissions;
import org.cyclos.web.rest.model.TokenTypeEnum;
import org.cyclos.web.rest.model.TokensPermissions;
import org.cyclos.web.rest.model.TransactionAuthorizationsPermissions;
import org.cyclos.web.rest.model.UserBaseAdPermissions;
import org.cyclos.web.rest.model.UserProfilePermissions;
import org.cyclos.web.rest.model.UsersPermissions;
import org.cyclos.web.rest.model.VoucherPermissions;
import org.cyclos.web.rest.model.VouchersPermissions;
import org.cyclos.web.rest.model.WizardPermissions;
import org.cyclos.web.rest.model.WizardsPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuthApiHelper {
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private PhonesApiHelper phonesApiHelper;
    @Autowired
    private UsersApiHelper usersApiHelper;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private RecordsApiHelper recordsApiHelper;
    @Autowired
    private VouchersApiHelper vouchersApiHelper;
    @Autowired
    private PasswordsApiHelper passwordsApiHelper;
    @Autowired
    private OperationsApiHelper operationsApiHelper;
    @Autowired
    private WizardsApiHelper wizardsApiHelper;
    @Autowired
    private TokensApiHelper tokensApiHelper;
    @Autowired
    private IdentityProvidersApiHelper identityProvidersApiHelper;
    @Autowired
    private DevicePinsApiHelper devicePinsApiHelper;
    @Autowired
    private ImportsApiHelper importsApiHelper;

    public void fillAuth(Auth auth, AuthVO authVO) {
        if (auth == null) {
            return;
        }
        auth.setPinInput(this.toPinInput(authVO.getPinInput()));
        auth.setConfiguration(this.apiHelper.toVersioned((EntityVO)authVO.getConfiguration(), authVO.getConfigurationVersion()));
    }

    public <A extends BaseAuth> A newAuth(Class<A> clazz, AuthVO authVO) {
        BaseAuth baseAuth = (BaseAuth)ClassHelper.instantiate(clazz);
        CredentialInputDTO credentialInputDTO = authVO.getLoginConfirmation();
        BasicUserVO basicUserVO = authVO.getUser();
        baseAuth.setUser(this.usersApiHelper.toUser(basicUserVO));
        Set set = CollectionHelper.orEmpty((Set)authVO.getRoles());
        RoleEnum roleEnum = this.toRole(set);
        baseAuth.setRole(roleEnum);
        if (roleEnum == RoleEnum.ADMINISTRATOR) {
            baseAuth.setSystemAdministrator(CollectionHelper.containsAny((Collection)set, (Object[])new Object[]{Role.GLOBAL_ADMIN, Role.NETWORK_ADMIN}));
        }
        if (roleEnum == RoleEnum.OPERATOR) {
            baseAuth.setAliasOperator(set.contains(Role.ALIAS_OPERATOR));
        }
        baseAuth.setPermissions(this.toPermissions(authVO.getPermissions()));
        baseAuth.setLanguage(this.apiHelper.toVersioned((EntityVO)authVO.getLanguage(), authVO.getLanguageVersion()));
        baseAuth.setGlobal(authVO.isGlobal());
        baseAuth.setAccessClient(this.apiHelper.toReference((EntityModel)authVO.getAccessClient()));
        baseAuth.setPrincipalType(this.apiHelper.toReference((EntityModel)authVO.getPrincipalType()));
        baseAuth.setPrincipal(authVO.getPrincipal());
        baseAuth.setPasswordType(this.passwordsApiHelper.toPasswordType(authVO.getPasswordType()));
        baseAuth.setLoginConfirmation(this.toPasswordInput((ICredentialInputDTO)credentialInputDTO));
        baseAuth.setTotpEnabled(authVO.isTotpEnabled());
        baseAuth.setTrustedSession(authVO.isTrustedSession());
        baseAuth.setPendingAgreements(authVO.isPendingAgreements());
        baseAuth.setEverAcceptedAgreements(authVO.isEverAcceptedAgreements());
        baseAuth.setExpiredPassword(authVO.isExpiredPassword());
        baseAuth.setUnauthorizedAddress(authVO.isUnauthorizedAddress());
        if (credentialInputDTO != null) {
            boolean bl = ObjectHelper.isOneOf((Object)credentialInputDTO.getPasswordStatus(), (Object[])new Object[]{PasswordStatus.EXPIRED, PasswordStatus.RESET});
            baseAuth.setExpiredSecondaryPassword(bl);
            baseAuth.setPendingSecondaryPassword(!bl);
            baseAuth.setSecondaryPasswordType(this.passwordsApiHelper.toPasswordType((PasswordTypeVO)credentialInputDTO.getPasswordType()));
        }
        return (A)baseAuth;
    }

    public <R extends OtpResult> R newOtpResult(Class<R> clazz, org.cyclos.model.access.passwords.OtpResult otpResult) {
        OtpResult otpResult2 = (OtpResult)this.apiHelper.newEntity(clazz, otpResult);
        otpResult2.setSentTo(otpResult.getSentTo());
        otpResult2.setSendMedium(this.apiHelper.toSendMediumEnum(otpResult.getSendMedium()));
        return (R)otpResult2;
    }

    public <R extends SendOtp> R newSendOtp(Class<R> clazz, SendOtpParams sendOtpParams) {
        SendOtp sendOtp = (SendOtp)ClassHelper.instantiate(clazz);
        sendOtp.setMedium(this.apiHelper.toSendMediumEnum(sendOtpParams.getMedium()));
        sendOtp.setMobilePhone(ModelHelper.stringOrIdFromVO((EntityVO)sendOtpParams.getMobilePhone()));
        return (R)sendOtp;
    }

    public Auth toAuth(AuthVO authVO) {
        if (authVO == null) {
            return null;
        }
        Auth auth = this.newAuth(Auth.class, authVO);
        this.fillAuth(auth, authVO);
        return auth;
    }

    public CaptchaInput toCaptchaInput(CaptchaInputDTO captchaInputDTO) {
        if (captchaInputDTO == null) {
            return null;
        }
        CaptchaInput captchaInput = new CaptchaInput();
        captchaInput.setProvider(this.toCaptchaProviderEnum(captchaInputDTO.getProvider()));
        captchaInput.setTextLength(captchaInputDTO.getTextLength());
        captchaInput.setRecaptchaKey(captchaInputDTO.getRecaptchaKey());
        return captchaInput;
    }

    public CaptchaProviderEnum toCaptchaProviderEnum(CaptchaProvider captchaProvider) {
        if (captchaProvider != null) {
            switch (captchaProvider) {
                case INTERNAL: {
                    return CaptchaProviderEnum.INTERNAL;
                }
                case RECAPTCHA_V2: {
                    return CaptchaProviderEnum.RECAPTCHA_V2;
                }
            }
        }
        return null;
    }

    public CaptchaResponseDTO toCaptchaResponseDTO(CaptchaResponse captchaResponse) {
        if (captchaResponse == null) {
            return null;
        }
        CaptchaResponseDTO captchaResponseDTO = new CaptchaResponseDTO();
        captchaResponseDTO.setChallenge(captchaResponse.getChallenge());
        captchaResponseDTO.setResponse(captchaResponse.getResponse());
        return captchaResponseDTO;
    }

    public ChangeForgottenPasswordDTO toChangeForgottenPasswordDTO(ChangeForgottenPassword changeForgottenPassword) {
        ChangeForgottenPasswordDTO changeForgottenPasswordDTO = new ChangeForgottenPasswordDTO();
        changeForgottenPasswordDTO.setUser(ModelHelper.userLocator((String)changeForgottenPassword.getUser(), (boolean)false));
        changeForgottenPasswordDTO.setCode(changeForgottenPassword.getCode());
        changeForgottenPasswordDTO.setNewPassword(changeForgottenPassword.getNewPassword());
        if (Boolean.TRUE.equals(changeForgottenPassword.getCheckConfirmation())) {
            changeForgottenPasswordDTO.setConfirmNewPassword(changeForgottenPassword.getNewPasswordConfirmation());
        } else {
            changeForgottenPasswordDTO.setConfirmNewPassword(changeForgottenPassword.getNewPassword());
        }
        changeForgottenPasswordDTO.setSecurityAnswer(changeForgottenPassword.getSecurityAnswer());
        changeForgottenPasswordDTO.setSendMedium(this.apiHelper.toSendMedium(changeForgottenPassword.getSendMedium()));
        return changeForgottenPasswordDTO;
    }

    public CredentialTypeEnum toCredentialTypeEnum(CredentialType credentialType) {
        if (credentialType != null) {
            switch (credentialType) {
                case DEVICE: {
                    return CredentialTypeEnum.DEVICE;
                }
                case PASSWORD: {
                    return CredentialTypeEnum.PASSWORD;
                }
                case PIN: {
                    return CredentialTypeEnum.PIN;
                }
                case TOTP: {
                    return CredentialTypeEnum.TOTP;
                }
            }
        }
        return null;
    }

    public DataForChangeForgottenPassword toDataForChangeForgottenPassword(ChangeForgottenPasswordData changeForgottenPasswordData) {
        DataForChangeForgottenPassword dataForChangeForgottenPassword = new DataForChangeForgottenPassword();
        dataForChangeForgottenPassword.setUser(this.usersApiHelper.toUser(changeForgottenPasswordData.getUser()));
        dataForChangeForgottenPassword.setPasswordType(this.passwordsApiHelper.toPasswordTypeDetailed(changeForgottenPasswordData.getPasswordType()));
        dataForChangeForgottenPassword.setSecurityQuestion(changeForgottenPasswordData.getSecurityQuestion());
        CollectionHelper.orEmpty((List)changeForgottenPasswordData.getPrincipalsData()).stream().map(this.usersApiHelper::toUserRegistrationPrincipal).forEach(dataForChangeForgottenPassword.getPrincipals()::add);
        return dataForChangeForgottenPassword;
    }

    public DataForLogin toDataForLogin(LoginData loginData) {
        if (loginData == null) {
            return null;
        }
        DataForLogin dataForLogin = new DataForLogin();
        CollectionHelper.orEmpty((List)loginData.getPrincipalTypes()).stream().map(this::toPrincipalTypeInput).filter(Objects::nonNull).forEach(dataForLogin.getPrincipalTypes()::add);
        dataForLogin.setDefaultPrincipalType(ModelHelper.internalNameOrId((IEntity)loginData.getDefaultPrincipalType()));
        dataForLogin.setLoginPasswordInput(this.toPasswordInput((ICredentialInputDTO)loginData.getLoginPasswordInput()));
        dataForLogin.setAccessPasswordType(this.apiHelper.toReference((EntityModel)loginData.getAccessPasswordType()));
        dataForLogin.setDeviceConfirmation(this.deviceConfirmationsApiHelper.toDeviceConfirmationView(loginData.getDeviceConfirmation()));
        CollectionHelper.orEmpty((List)loginData.getIdentityProviders()).stream().map(this.identityProvidersApiHelper::toIdentityProvider).filter(Objects::nonNull).forEach(dataForLogin.getIdentityProviders()::add);
        ForgotPasswordMode forgotPasswordMode = loginData.getForgotPasswordMode();
        if (forgotPasswordMode.showForgotPassword()) {
            CollectionHelper.orEmpty((List)loginData.getForgotPasswordPrincipalTypes()).stream().filter(principalTypeInputVO -> !loginData.getPrincipalTypes().contains(principalTypeInputVO)).map(this::toPrincipalTypeInput).filter(Objects::nonNull).forEach(dataForLogin.getExtraForgotPasswordPrincipalTypes()::add);
            CollectionHelper.orEmpty((List)loginData.getForgotPasswordSendMediums()).stream().map(this.apiHelper::toSendMediumEnum).forEach(dataForLogin.getForgotPasswordMediums()::add);
        }
        dataForLogin.setVerificationCodeSeconds(loginData.getVerificationCodeSeconds());
        dataForLogin.setForgotPasswordCaptchaInput(this.toCaptchaInput(loginData.getForgotPasswordCaptchaInput()));
        dataForLogin.setPinActive(loginData.getPinActive());
        if (dataForLogin.getForgotPasswordCaptchaInput() != null) {
            dataForLogin.setForgotPasswordCaptchaProvider(dataForLogin.getForgotPasswordCaptchaInput().getProvider());
        }
        return dataForLogin;
    }

    public DataForSendingOtp toDataForSendingOtp(SendOtpData sendOtpData) {
        if (sendOtpData == null) {
            return null;
        }
        DataForSendingOtp dataForSendingOtp = new DataForSendingOtp();
        dataForSendingOtp.setEmail(sendOtpData.getEmail());
        CollectionHelper.orEmpty((Set)sendOtpData.getSendMediums()).stream().map(this.apiHelper::toSendMediumEnum).forEach(dataForSendingOtp.getMediums()::add);
        CollectionHelper.orEmpty((List)sendOtpData.getMobilePhones()).stream().map(this.phonesApiHelper::toPhone).forEach(dataForSendingOtp.getPhones()::add);
        dataForSendingOtp.setVerificationCodeSeconds(sendOtpData.getVerificationCodeSeconds());
        return dataForSendingOtp;
    }

    public ForgotPasswordRequestDTO toForgotPasswordRequestDTO(ForgottenPasswordRequest forgottenPasswordRequest) {
        ForgotPasswordRequestDTO forgotPasswordRequestDTO = new ForgotPasswordRequestDTO();
        forgotPasswordRequestDTO.setUser(ModelHelper.userLocator((String)forgottenPasswordRequest.getUser(), (boolean)false));
        forgotPasswordRequestDTO.setSendMedium(this.apiHelper.toSendMedium(forgottenPasswordRequest.getSendMedium()));
        forgotPasswordRequestDTO.setCaptchaResponse(this.toCaptchaResponseDTO(forgottenPasswordRequest.getCaptcha()));
        return forgotPasswordRequestDTO;
    }

    public ForgottenPasswordResponse toForgottenPasswordResponse(org.cyclos.model.access.passwords.OtpResult otpResult) {
        ForgottenPasswordResponse forgottenPasswordResponse = new ForgottenPasswordResponse();
        forgottenPasswordResponse.setSendMedium(this.apiHelper.toSendMediumEnum(otpResult.getSendMedium()));
        forgottenPasswordResponse.setSentTo(StringHelper.splitTrimming((String)otpResult.getSentTo(), (String)","));
        return forgottenPasswordResponse;
    }

    public GetChangeForgottenPasswordDataParams toGetChangeForgottenPasswordDataParams(String string, String string2) {
        GetChangeForgottenPasswordDataParams getChangeForgottenPasswordDataParams = new GetChangeForgottenPasswordDataParams();
        getChangeForgottenPasswordDataParams.setUser(ModelHelper.userLocator((String)string, (boolean)false));
        getChangeForgottenPasswordDataParams.setCode(string2);
        return getChangeForgottenPasswordDataParams;
    }

    public LoginAuth toLoginAuth(AuthVO authVO) {
        if (authVO == null) {
            return null;
        }
        LoginAuth loginAuth = this.newAuth(LoginAuth.class, authVO);
        this.fillAuth(loginAuth, authVO);
        loginAuth.setSessionToken(authVO.getSessionToken());
        loginAuth.setIdentityProviderNotLinkReason(this.toIdentityProviderNotLinkReason(authVO.getIdentityProviderNotLinkReason()));
        loginAuth.setPinCreationToken(authVO.getPinCreationToken());
        return loginAuth;
    }

    public LoginDTO toLoginDTO(TimeIntervalDTO timeIntervalDTO, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        LoginDTO loginDTO = new LoginDTO();
        loginDTO.setCustomSessionTimeout(timeIntervalDTO);
        loginDTO.setDeviceConfirmationId(string);
        loginDTO.setDeviceId(this.apiHelper.fromId(string2));
        loginDTO.setHmac(string3);
        loginDTO.setIdentityProviderRequestId(string4);
        loginDTO.setFcmDeviceToken(string5);
        loginDTO.setUserAgentId(string6);
        loginDTO.setMobileAppVersion(string7);
        return loginDTO;
    }

    public OtpResult toOtpResult(org.cyclos.model.access.passwords.OtpResult otpResult) {
        if (otpResult == null) {
            return null;
        }
        return this.newOtpResult(OtpResult.class, otpResult);
    }

    public PasswordInput toPasswordInput(ICredentialInputDTO iCredentialInputDTO) {
        if (!(iCredentialInputDTO instanceof CredentialInputDTO)) {
            return null;
        }
        CredentialInputDTO credentialInputDTO = (CredentialInputDTO)iCredentialInputDTO;
        PasswordInput passwordInput = new PasswordInput();
        CollectionHelper.orEmpty((List)credentialInputDTO.getAllowedCredentials()).stream().map(this::toCredentialTypeEnum).forEach(passwordInput.getAllowedCredentials()::add);
        CollectionHelper.orEmpty((List)credentialInputDTO.getActiveCredentials()).stream().map(this::toCredentialTypeEnum).forEach(passwordInput.getActiveCredentials()::add);
        PasswordTypeDetailed passwordTypeDetailed = this.passwordsApiHelper.toPasswordTypeDetailed(credentialInputDTO.getPasswordType());
        passwordInput.setPasswordType(passwordTypeDetailed);
        passwordInput.setPasswordStatus(this.passwordsApiHelper.toPasswordStatusEnum(credentialInputDTO.getPasswordStatus()));
        passwordInput.setVirtualKeyboardId(credentialInputDTO.getInputId());
        passwordInput.setPinInput(this.toPinInput(credentialInputDTO.getPinInput()));
        passwordInput.setConfirmationPasswordOncePerSession(credentialInputDTO.isConfirmationPasswordOncePerSession());
        if (passwordTypeDetailed != null && passwordTypeDetailed.getMode() == PasswordModeEnum.OTP) {
            credentialInputDTO.getOtpSendMediums().stream().map(this.apiHelper::toSendMediumEnum).filter(Objects::nonNull).forEach(passwordInput.getOtpSendMediums()::add);
            passwordInput.setHasReusableOtp(credentialInputDTO.isHasReusableOtp());
            if (credentialInputDTO.getEmailToSendOtp() != null) {
                passwordInput.setEmailToSendOtp(credentialInputDTO.getEmailToSendOtp());
            }
            if (CollectionHelper.isNotEmpty((Iterable)credentialInputDTO.getMobilePhonesToSendOtp())) {
                credentialInputDTO.getMobilePhonesToSendOtp().stream().map(this.phonesApiHelper::toPhone).forEach(passwordInput.getMobilePhonesToSendOtp()::add);
            }
        } else {
            passwordInput.setOtpSendMediums(null);
            passwordInput.setMobilePhonesToSendOtp(null);
        }
        if (passwordTypeDetailed != null && passwordTypeDetailed.getInputMethod() == PasswordInputMethodEnum.VIRTUAL_KEYBOARD) {
            credentialInputDTO.getButtons().stream().map(string -> StringHelper.split((String)string, (String)credentialInputDTO.getSeparator())).filter(Objects::nonNull).forEach(passwordInput.getButtons()::add);
        } else {
            passwordInput.setButtons(null);
        }
        passwordInput.setHasActivePassword(passwordInput.getActiveCredentials().contains(CredentialTypeEnum.PASSWORD));
        passwordInput.setHasActiveDevice(passwordInput.getActiveCredentials().contains(CredentialTypeEnum.DEVICE));
        passwordInput.setDeviceAvailability(this.apiHelper.toAvailability(passwordInput.getAllowedCredentials().contains(CredentialTypeEnum.DEVICE), passwordInput.getAllowedCredentials().size() == 1));
        passwordInput.setPinAvailability(this.apiHelper.toAvailability(passwordInput.getAllowedCredentials().contains(CredentialTypeEnum.PIN), passwordInput.getAllowedCredentials().size() == 1));
        if (credentialInputDTO.getPasswordType() != null) {
            Map map = ClassHelper.describe((Object)passwordInput.getPasswordType());
            ClassHelper.fill((Object)passwordInput, (Map)map);
        }
        return passwordInput;
    }

    public PinInput toPinInput(PinInputDTO pinInputDTO) {
        if (pinInputDTO == null) {
            return null;
        }
        PinInput pinInput = new PinInput();
        pinInput.setMinLength(pinInputDTO.getMinLength());
        pinInput.setMaxLength(pinInputDTO.getMaxLength());
        return pinInput;
    }

    public Principal toPrincipal(PrincipalVO principalVO) {
        if (principalVO == null) {
            return null;
        }
        Principal principal = new Principal();
        principal.setType(this.apiHelper.toReference((EntityModel)principalVO.getType()));
        principal.setValue(principalVO.getValue());
        return principal;
    }

    public PrincipalType toPrincipalType(PrincipalTypeVO principalTypeVO) {
        if (principalTypeVO == null) {
            return null;
        }
        return this.newPrincipalType(PrincipalType.class, principalTypeVO);
    }

    public PrincipalTypeInput toPrincipalTypeInput(PrincipalTypeInputVO principalTypeInputVO) {
        if (principalTypeInputVO == null) {
            return null;
        }
        PrincipalTypeInput principalTypeInput = this.newPrincipalType(PrincipalTypeInput.class, (PrincipalTypeVO)principalTypeInputVO);
        principalTypeInput.setCustomField(this.apiHelper.toCustomFieldDetailed(principalTypeInputVO.getCustomField()));
        principalTypeInput.setTokenType(this.toTokenTypeEnum(principalTypeInputVO.getTokenType()));
        principalTypeInput.setMask((String)ObjectHelper.defaultValue((Object)principalTypeInputVO.getTokenMask(), (Object)principalTypeInputVO.getAccountNumberMask()));
        principalTypeInput.setExample(principalTypeInputVO.getMobilePhoneExample());
        if (principalTypeInput.getMask() != null && principalTypeInput.getExample() == null) {
            principalTypeInput.setExample(MaskHelper.getExample((String)principalTypeInput.getMask()));
        }
        if (principalTypeInputVO.getTokenType() != null) {
            principalTypeInput.setAllowManualInput(principalTypeInputVO.isAllowManualInputOfValue());
        }
        principalTypeInput.setKind(this.toPrincipalTypeKind(principalTypeInputVO.getInternalName(), principalTypeInputVO.getNature()));
        if (principalTypeInput.getKind() != PrincipalTypeKind.TOKEN) {
            principalTypeInput.setAllowManualInput(null);
        }
        return principalTypeInput;
    }

    public Role toRole(RoleEnum roleEnum) {
        if (roleEnum != null) {
            switch (roleEnum) {
                case ADMINISTRATOR: {
                    return Role.ADMIN;
                }
                case BROKER: {
                    return Role.BROKER;
                }
                case MEMBER: {
                    return Role.MEMBER;
                }
                case OPERATOR: {
                    return Role.OPERATOR;
                }
            }
        }
        return null;
    }

    public RoleEnum toRoleEnum(BasicGroupNature basicGroupNature) {
        if (basicGroupNature != null) {
            switch (basicGroupNature) {
                case ADMIN_GROUP: {
                    return RoleEnum.ADMINISTRATOR;
                }
                case BROKER_GROUP: {
                    return RoleEnum.BROKER;
                }
                case MEMBER_GROUP: {
                    return RoleEnum.MEMBER;
                }
                case GROUP_SET: {
                    return null;
                }
            }
        }
        return null;
    }

    public RoleEnum toRoleEnum(Role role) {
        if (role != null) {
            switch (role) {
                case ADMIN: 
                case GLOBAL_ADMIN: 
                case NETWORK_ADMIN: {
                    return RoleEnum.ADMINISTRATOR;
                }
                case BROKER: {
                    return RoleEnum.BROKER;
                }
                case MEMBER: {
                    return RoleEnum.MEMBER;
                }
                case OPERATOR: 
                case ALIAS_OPERATOR: 
                case RESTRICTED_OPERATOR: {
                    return RoleEnum.OPERATOR;
                }
            }
        }
        return null;
    }

    public SendOtp toSendOtp(SendOtpParams sendOtpParams) {
        if (sendOtpParams == null) {
            return null;
        }
        return this.newSendOtp(SendOtp.class, sendOtpParams);
    }

    public SendOtpParams toSendOtpParams(SendOtp sendOtp) {
        SendOtpParams sendOtpParams = new SendOtpParams();
        sendOtpParams.setMedium(this.apiHelper.toSendMedium(sendOtp.getMedium()));
        sendOtpParams.setMobilePhone((PhoneVO)ModelHelper.voFromString(PhoneVO.class, (String)sendOtp.getMobilePhone()));
        return sendOtpParams;
    }

    public SessionPropertiesView toSessionPropertiesView(SessionPropertiesVO sessionPropertiesVO) {
        if (sessionPropertiesVO == null) {
            return null;
        }
        SessionPropertiesView sessionPropertiesView = new SessionPropertiesView();
        sessionPropertiesView.setCreatedAt(sessionPropertiesVO.getCreatedAt());
        sessionPropertiesView.setExpiresAt(sessionPropertiesVO.getExpiresAt());
        sessionPropertiesView.setExpirationInterval(this.apiHelper.toTimeInterval(sessionPropertiesVO.getExpirationInterval()));
        sessionPropertiesView.setSource(this.toSessionSourceEnum(sessionPropertiesVO.getSource()));
        sessionPropertiesView.setDevice(this.apiHelper.toReference((EntityModel)sessionPropertiesVO.getTrustedDevice()));
        sessionPropertiesView.setDevicePin(this.devicePinsApiHelper.toDevicePin(sessionPropertiesVO.getPin()));
        return sessionPropertiesView;
    }

    public SessionSource toSessionSource(SessionSourceEnum sessionSourceEnum) {
        if (sessionSourceEnum != null) {
            switch (sessionSourceEnum) {
                case LOGIN: {
                    return SessionSource.LOGIN;
                }
                case DEVICE: {
                    return SessionSource.TRUSTED_DEVICE;
                }
            }
        }
        return null;
    }

    public SessionSourceEnum toSessionSourceEnum(SessionSource sessionSource) {
        if (sessionSource != null) {
            switch (sessionSource) {
                case LOGIN: {
                    return SessionSourceEnum.LOGIN;
                }
                case TRUSTED_DEVICE: {
                    return SessionSourceEnum.DEVICE;
                }
            }
        }
        return null;
    }

    public SetSessionPropertiesDTO toSetSessionPropertiesDTO(SessionPropertiesEdit sessionPropertiesEdit) {
        SetSessionPropertiesDTO setSessionPropertiesDTO = new SetSessionPropertiesDTO();
        if (sessionPropertiesEdit != null) {
            setSessionPropertiesDTO.setSource(this.toSessionSource(sessionPropertiesEdit.getSource()));
        }
        return setSessionPropertiesDTO;
    }

    public TokenTypeEnum toTokenTypeEnum(TokenType tokenType) {
        if (tokenType != null) {
            switch (tokenType) {
                case NFC_DEVICE: {
                    return TokenTypeEnum.NFC_DEVICE;
                }
                case NFC_TAG: {
                    return TokenTypeEnum.NFC_TAG;
                }
                case BARCODE: {
                    return TokenTypeEnum.BARCODE;
                }
                case QRCODE: {
                    return TokenTypeEnum.QRCODE;
                }
                case SWIPE: {
                    return TokenTypeEnum.SWIPE;
                }
                case OTHER: {
                    return TokenTypeEnum.OTHER;
                }
            }
        }
        return null;
    }

    private <T extends PrincipalType> T newPrincipalType(Class<T> clazz, PrincipalTypeVO principalTypeVO) {
        PrincipalType principalType = (PrincipalType)this.apiHelper.newEntity(clazz, principalTypeVO);
        principalType.setKind(this.toPrincipalTypeKind(principalTypeVO.getInternalName(), principalTypeVO.getNature()));
        return (T)principalType;
    }

    private AccountPermissions toAccountPermissions(AccountPermissionsVO accountPermissionsVO) {
        AccountPermissions accountPermissions = new AccountPermissions();
        accountPermissions.setAccount(this.accountsApiHelper.toAccountWithCurrency(accountPermissionsVO.getAccount()));
        accountPermissions.setVisible(accountPermissionsVO.isVisible());
        accountPermissions.setViewStatus(accountPermissionsVO.isViewStatus());
        AccountTypeVO accountTypeVO = accountPermissionsVO.getAccount().getType();
        Function<TransferTypeVO, RelatedTransferType> function = transferTypeVO -> this.accountsApiHelper.toRelatedTransferType((TransferTypeVO)transferTypeVO, accountTypeVO);
        CollectionHelper.orEmpty((List)accountPermissionsVO.getUserPayments()).stream().map(function).filter(Objects::nonNull).forEach(accountPermissions.getUserPayments()::add);
        CollectionHelper.orEmpty((List)accountPermissionsVO.getSystemPayments()).stream().map(function).filter(Objects::nonNull).forEach(accountPermissions.getSystemPayments()::add);
        if (accountPermissionsVO.getSelfPayments() != null) {
            accountPermissionsVO.getSelfPayments().stream().map(function).filter(Objects::nonNull).forEach(accountPermissions.getSelfPayments()::add);
        } else {
            accountPermissions.setSelfPayments(null);
        }
        if (accountPermissionsVO.getPosPayments() != null) {
            accountPermissionsVO.getPosPayments().stream().map(function).filter(Objects::nonNull).forEach(accountPermissions.getPosPayments()::add);
        } else {
            accountPermissions.setPosPayments(null);
        }
        return accountPermissions;
    }

    private AgreementsPermissions toAgreementsPermissions(AgreementsPermissionsVO agreementsPermissionsVO) {
        if (agreementsPermissionsVO == null) {
            return null;
        }
        AgreementsPermissions agreementsPermissions = new AgreementsPermissions();
        agreementsPermissions.setView(agreementsPermissionsVO.isView());
        return agreementsPermissions;
    }

    private AlertsPermissions toAlertsPermissions(UserAlertsPermissionsVO userAlertsPermissionsVO) {
        if (userAlertsPermissionsVO == null) {
            return null;
        }
        AlertsPermissions alertsPermissions = new AlertsPermissions();
        alertsPermissions.setView(userAlertsPermissionsVO.isView());
        return alertsPermissions;
    }

    private TransactionAuthorizationsPermissions toAuthorizationsPermissions(TransactionAuthorizationsPermissionsVO transactionAuthorizationsPermissionsVO) {
        if (transactionAuthorizationsPermissionsVO == null) {
            return null;
        }
        TransactionAuthorizationsPermissions transactionAuthorizationsPermissions = new TransactionAuthorizationsPermissions();
        transactionAuthorizationsPermissions.setView(transactionAuthorizationsPermissionsVO.isView());
        transactionAuthorizationsPermissions.setAuthorize(transactionAuthorizationsPermissionsVO.isAuthorize());
        transactionAuthorizationsPermissions.setDeny(transactionAuthorizationsPermissionsVO.isDeny());
        transactionAuthorizationsPermissions.setCancel(transactionAuthorizationsPermissionsVO.isCancel());
        return transactionAuthorizationsPermissions;
    }

    private BankingPermissions toBankingPermissions(BankingPermissionsVO bankingPermissionsVO) {
        if (bankingPermissionsVO == null) {
            return null;
        }
        BankingPermissions bankingPermissions = new BankingPermissions();
        bankingPermissions.setSearchUsersWithBalances(bankingPermissionsVO.isSearchUsersWithBalances());
        bankingPermissions.setSearchGeneralTransfers(bankingPermissionsVO.isSearchGeneralTransfers());
        bankingPermissions.setSearchGeneralAuthorizedPayments(bankingPermissionsVO.isSearchGeneralAuthorizedPayments());
        bankingPermissions.setSearchGeneralScheduledPayments(bankingPermissionsVO.isSearchGeneralScheduledPayments());
        bankingPermissions.setSearchGeneralExternalPayments(bankingPermissionsVO.isSearchGeneralExternalPayments());
        bankingPermissions.setSearchGeneralPaymentRequests(bankingPermissionsVO.isSearchGeneralPaymentRequests());
        bankingPermissions.setSearchGeneralBalanceLimits(bankingPermissionsVO.isSearchGeneralBalanceLimits());
        bankingPermissions.setSearchGeneralPaymentLimits(bankingPermissionsVO.isSearchGeneralPaymentLimits());
        bankingPermissions.setAccountVisibilitySettings(bankingPermissionsVO.isAccountVisibilitySettings());
        CollectionHelper.orEmpty((List)bankingPermissionsVO.getAccounts()).stream().map(this::toAccountPermissions).filter(Objects::nonNull).forEach(bankingPermissions.getAccounts()::add);
        bankingPermissions.setPayments(this.toPaymentsPermissions(bankingPermissionsVO.getPayments()));
        bankingPermissions.setAuthorizations(this.toAuthorizationsPermissions(bankingPermissionsVO.getAuthorizations()));
        bankingPermissions.setScheduledPayments(this.toScheduledPaymentsPermissions(bankingPermissionsVO.getScheduledPayments()));
        bankingPermissions.setExternalPayments(this.toExternalPaymentsPermissions(bankingPermissionsVO.getExternalPayments()));
        bankingPermissions.setPaymentRequests(this.toPaymentRequestsPermissions(bankingPermissionsVO.getPaymentRequests()));
        bankingPermissions.setTickets(this.toTicketsPermissions(bankingPermissionsVO.getTickets()));
        return bankingPermissions;
    }

    private ContactsPermissions toContactsPermissions(ContactsPermissionsVO contactsPermissionsVO) {
        if (contactsPermissionsVO == null) {
            return null;
        }
        ContactsPermissions contactsPermissions = new ContactsPermissions();
        contactsPermissions.setEnable(contactsPermissionsVO.isEnable());
        contactsPermissions.setHasEditableFields(contactsPermissionsVO.isHasEditableFields());
        contactsPermissions.setHasVisibleFields(contactsPermissionsVO.isHasVisibleFields());
        return contactsPermissions;
    }

    private DocumentsPermissions toDocumentsPermissions(DocumentsPermissionsVO documentsPermissionsVO) {
        if (documentsPermissionsVO == null) {
            return null;
        }
        DocumentsPermissions documentsPermissions = new DocumentsPermissions();
        documentsPermissions.setViewIndividual(documentsPermissionsVO.isViewIndividual());
        CollectionHelper.orEmpty((List)documentsPermissionsVO.getViewShared()).stream().map(this.apiHelper::toReference).forEach(documentsPermissions.getViewShared()::add);
        return documentsPermissions;
    }

    private ExternalPaymentsPermissions toExternalPaymentsPermissions(ExternalPaymentsPermissionsVO externalPaymentsPermissionsVO) {
        if (externalPaymentsPermissionsVO == null) {
            return null;
        }
        ExternalPaymentsPermissions externalPaymentsPermissions = new ExternalPaymentsPermissions();
        externalPaymentsPermissions.setView(externalPaymentsPermissionsVO.isView());
        externalPaymentsPermissions.setPerform(externalPaymentsPermissionsVO.isPerform());
        externalPaymentsPermissions.setCancel(externalPaymentsPermissionsVO.isCancel());
        return externalPaymentsPermissions;
    }

    private IdentityProviderNotLinkReasonEnum toIdentityProviderNotLinkReason(IdentityProviderNotLinkReason identityProviderNotLinkReason) {
        if (identityProviderNotLinkReason != null) {
            switch (identityProviderNotLinkReason) {
                case GLOBAL_USER_NETWORK_IDP_IGNORED: {
                    return IdentityProviderNotLinkReasonEnum.GLOBAL_USER_NETWORK_IDP_IGNORED;
                }
                case UNSUPPORTED_PRINCIPAL_TYPE: {
                    return IdentityProviderNotLinkReasonEnum.UNSUPPORTED_PRINCIPAL_TYPE;
                }
                case USER_DISABLED: {
                    return IdentityProviderNotLinkReasonEnum.USER_DISABLED;
                }
            }
        }
        return null;
    }

    private IdentityProvidersPermissions toIdentityProvidersPermissions(IdentityProvidersPermissionsVO identityProvidersPermissionsVO) {
        if (identityProvidersPermissionsVO == null) {
            return null;
        }
        IdentityProvidersPermissions identityProvidersPermissions = new IdentityProvidersPermissions();
        identityProvidersPermissions.setEnabled(identityProvidersPermissionsVO.isEnabled());
        return identityProvidersPermissions;
    }

    private ImagesPermissions toImagesPermissions(ImagesPermissionsVO imagesPermissionsVO) {
        if (imagesPermissionsVO == null) {
            return null;
        }
        ImagesPermissions imagesPermissions = new ImagesPermissions();
        imagesPermissions.setMyCustom(imagesPermissionsVO.isMyCustom());
        CollectionHelper.orEmpty((List)imagesPermissionsVO.getViewCategories()).stream().map(systemImageCategoryVO -> {
            SystemImageCategoryPermissions systemImageCategoryPermissions = new SystemImageCategoryPermissions();
            systemImageCategoryPermissions.setCategory(this.apiHelper.toReference((EntityModel)systemImageCategoryVO));
            systemImageCategoryPermissions.setCanEdit(imagesPermissionsVO.getManageCategories().contains(systemImageCategoryVO));
            return systemImageCategoryPermissions;
        }).forEach(imagesPermissions.getSystemCategories()::add);
        return imagesPermissions;
    }

    private ImportsPermissions toImportsPermissions(ImportsPermissionsVO importsPermissionsVO) {
        if (importsPermissionsVO == null) {
            return null;
        }
        ImportsPermissions importsPermissions = new ImportsPermissions();
        CollectionHelper.orEmpty((List)importsPermissionsVO.getVisibleTypes()).stream().map(this.importsApiHelper::toImportedFileKind).forEach(importsPermissions.getVisibleKinds()::add);
        return importsPermissions;
    }

    private InvitePermissions toInvitePermissions(InvitePermissionsVO invitePermissionsVO) {
        if (invitePermissionsVO == null) {
            return null;
        }
        InvitePermissions invitePermissions = new InvitePermissions();
        invitePermissions.setSend(invitePermissionsVO.isSend());
        return invitePermissions;
    }

    private MarketplacePermissions toMarketplacePermissions(MarketplacePermissionsVO marketplacePermissionsVO) {
        if (marketplacePermissionsVO == null) {
            return null;
        }
        MarketplacePermissions marketplacePermissions = new MarketplacePermissions();
        UserBaseAdPermissions userBaseAdPermissions = new UserBaseAdPermissions();
        UserBaseAdPermissions userBaseAdPermissions2 = new UserBaseAdPermissions();
        marketplacePermissions.setUserSimple(userBaseAdPermissions);
        marketplacePermissions.setUserWebshop(userBaseAdPermissions2);
        userBaseAdPermissions.setView(marketplacePermissionsVO.isViewAdvertisement());
        userBaseAdPermissions2.setView(marketplacePermissionsVO.isViewWebshop());
        MyMarketplacePermissions myMarketplacePermissions = new MyMarketplacePermissions();
        marketplacePermissions.setMySimple(myMarketplacePermissions);
        MyMarketplacePermissions myMarketplacePermissions2 = new MyMarketplacePermissions();
        marketplacePermissions.setMyWebshop(myMarketplacePermissions2);
        myMarketplacePermissions.setEnable(marketplacePermissionsVO.isAdvertisementEnabled());
        myMarketplacePermissions.setManage(marketplacePermissionsVO.isManageAdvertisement());
        myMarketplacePermissions.setQuestions(marketplacePermissionsVO.isAdvertisementQuestions());
        myMarketplacePermissions2.setEnable(marketplacePermissionsVO.isWebshopEnabled());
        myMarketplacePermissions2.setManage(marketplacePermissionsVO.isManageWebshop());
        myMarketplacePermissions2.setQuestions(marketplacePermissionsVO.isWebshopQuestions());
        userBaseAdPermissions.setManage(marketplacePermissionsVO.isManageUserAdvertisement());
        userBaseAdPermissions.setManagePending(marketplacePermissionsVO.isManageUserPendingAdvertisement());
        userBaseAdPermissions.setViewPending(marketplacePermissionsVO.isViewUserPendingAdvertisement());
        userBaseAdPermissions.setPurchase(false);
        userBaseAdPermissions2.setManage(marketplacePermissionsVO.isManageUserWebshop());
        userBaseAdPermissions2.setManagePending(marketplacePermissionsVO.isManageUserPendingWebshop());
        userBaseAdPermissions2.setViewPending(marketplacePermissionsVO.isViewUserPendingWebshop());
        userBaseAdPermissions2.setPurchase(marketplacePermissionsVO.isPurchase());
        marketplacePermissions.setInterests(marketplacePermissionsVO.isInterests());
        marketplacePermissions.setFavorites(marketplacePermissionsVO.isFavorites());
        return marketplacePermissions;
    }

    private MessagesPermissions toMessagesPermissions(MessagesPermissionsVO messagesPermissionsVO) {
        if (messagesPermissionsVO == null) {
            return null;
        }
        MessagesPermissions messagesPermissions = new MessagesPermissions();
        messagesPermissions.setMy(this.toMyMessagesPermissions(messagesPermissionsVO.getMy()));
        messagesPermissions.setSystem(this.toSystemMessagesPermissions(messagesPermissionsVO.getSystem()));
        return messagesPermissions;
    }

    private MyMessagesPermissions toMyMessagesPermissions(MyMessagesPermissionsVO myMessagesPermissionsVO) {
        if (myMessagesPermissionsVO == null) {
            return null;
        }
        MyMessagesPermissions myMessagesPermissions = new MyMessagesPermissions();
        myMessagesPermissions.setSendToBrokered(myMessagesPermissionsVO.isSendToBrokered());
        myMessagesPermissions.setSendToSystem(myMessagesPermissionsVO.isSendToSystem());
        myMessagesPermissions.setSendToUser(myMessagesPermissionsVO.isSendToUser());
        myMessagesPermissions.setView(myMessagesPermissionsVO.isView());
        return myMessagesPermissions;
    }

    private NotificationSettingsPermissions toNotificationSettingsPermissions(NotificationSettingsPermissionsVO notificationSettingsPermissionsVO) {
        if (notificationSettingsPermissionsVO == null) {
            return null;
        }
        NotificationSettingsPermissions notificationSettingsPermissions = new NotificationSettingsPermissions();
        notificationSettingsPermissions.setEnable(notificationSettingsPermissionsVO.isEnable());
        return notificationSettingsPermissions;
    }

    private NotificationsPermissions toNotificationsPermissions(NotificationsPermissionsVO notificationsPermissionsVO) {
        if (notificationsPermissionsVO == null) {
            return null;
        }
        NotificationsPermissions notificationsPermissions = new NotificationsPermissions();
        notificationsPermissions.setEnable(notificationsPermissionsVO.isEnable());
        return notificationsPermissions;
    }

    private OperationPermissions toOperationPermissions(OperationPermissionsVO operationPermissionsVO) {
        if (operationPermissionsVO == null) {
            return null;
        }
        OperationPermissions operationPermissions = new OperationPermissions();
        operationPermissions.setOperation(this.operationsApiHelper.toOperation(operationPermissionsVO.getOperation()));
        operationPermissions.setRun(operationPermissionsVO.isRun());
        return operationPermissions;
    }

    private OperationsPermissions toOperationsPermissions(OperationsPermissionsVO operationsPermissionsVO) {
        if (operationsPermissionsVO == null) {
            return null;
        }
        OperationsPermissions operationsPermissions = new OperationsPermissions();
        CollectionHelper.orEmpty((List)operationsPermissionsVO.getUser()).stream().map(this::toOperationPermissions).filter(Objects::nonNull).forEach(operationsPermissions.getUser()::add);
        if (operationsPermissionsVO.getSystem() != null) {
            operationsPermissionsVO.getSystem().stream().map(this::toOperationPermissions).filter(Objects::nonNull).forEach(operationsPermissions.getSystem()::add);
        } else {
            operationsPermissions.setSystem(null);
        }
        return operationsPermissions;
    }

    private OperatorsPermissions toOperatorsPermissions(OperatorsPermissionsVO operatorsPermissionsVO) {
        if (operatorsPermissionsVO == null) {
            return null;
        }
        OperatorsPermissions operatorsPermissions = new OperatorsPermissions();
        operatorsPermissions.setEnable(operatorsPermissionsVO.isEnable());
        operatorsPermissions.setManageOperators(operatorsPermissionsVO.isManageOperators());
        operatorsPermissions.setManageGroups(operatorsPermissionsVO.isManageGroups());
        return operatorsPermissions;
    }

    private PasswordPermissions toPasswordPermissions(PasswordPermissionsVO passwordPermissionsVO) {
        if (passwordPermissionsVO == null) {
            return null;
        }
        PasswordPermissions passwordPermissions = new PasswordPermissions();
        passwordPermissions.setType(this.passwordsApiHelper.toPasswordType(passwordPermissionsVO.getType()));
        passwordPermissions.setChange(passwordPermissionsVO.isChange());
        passwordPermissions.setEnable(passwordPermissionsVO.isEnable());
        passwordPermissions.setReset(passwordPermissionsVO.isReset());
        passwordPermissions.setUnblock(passwordPermissionsVO.isUnblock());
        return passwordPermissions;
    }

    private PasswordsPermissions toPasswordsPermissions(PasswordsPermissionsVO passwordsPermissionsVO) {
        if (passwordsPermissionsVO == null) {
            return null;
        }
        PasswordsPermissions passwordsPermissions = new PasswordsPermissions();
        passwordsPermissions.setManage(passwordsPermissionsVO.isManage());
        CollectionHelper.orEmpty((List)passwordsPermissionsVO.getPasswords()).stream().map(this::toPasswordPermissions).filter(Objects::nonNull).forEach(passwordsPermissions.getPasswords()::add);
        return passwordsPermissions;
    }

    private PaymentFeedbacksPermissions toPaymentFeedbacksPermissions(ReferencesPermissionsVO referencesPermissionsVO) {
        if (referencesPermissionsVO == null) {
            return null;
        }
        PaymentFeedbacksPermissions paymentFeedbacksPermissions = new PaymentFeedbacksPermissions();
        paymentFeedbacksPermissions.setGive(referencesPermissionsVO.isGive());
        paymentFeedbacksPermissions.setReceive(referencesPermissionsVO.isReceive());
        paymentFeedbacksPermissions.setView(referencesPermissionsVO.isView());
        return paymentFeedbacksPermissions;
    }

    private PaymentRequestsPermissions toPaymentRequestsPermissions(PaymentRequestsPermissionsVO paymentRequestsPermissionsVO) {
        if (paymentRequestsPermissionsVO == null) {
            return null;
        }
        PaymentRequestsPermissions paymentRequestsPermissions = new PaymentRequestsPermissions();
        paymentRequestsPermissions.setView(paymentRequestsPermissionsVO.isView());
        paymentRequestsPermissions.setSendToSystem(paymentRequestsPermissionsVO.isSendToSystem());
        paymentRequestsPermissions.setSendToUser(paymentRequestsPermissionsVO.isSendToUser());
        paymentRequestsPermissions.setAccept(paymentRequestsPermissionsVO.isAccept());
        paymentRequestsPermissions.setReject(paymentRequestsPermissionsVO.isReject());
        paymentRequestsPermissions.setCancel(paymentRequestsPermissionsVO.isCancel());
        paymentRequestsPermissions.setReschedule(paymentRequestsPermissionsVO.isReschedule());
        paymentRequestsPermissions.setChangeExpiration(paymentRequestsPermissionsVO.isChangeExpiration());
        return paymentRequestsPermissions;
    }

    private PaymentsPermissions toPaymentsPermissions(PaymentsPermissionsVO paymentsPermissionsVO) {
        if (paymentsPermissionsVO == null) {
            return null;
        }
        PaymentsPermissions paymentsPermissions = new PaymentsPermissions();
        paymentsPermissions.setUser(paymentsPermissionsVO.isUser());
        paymentsPermissions.setSystem(paymentsPermissionsVO.isSystem());
        paymentsPermissions.setSelf(paymentsPermissionsVO.isSelf());
        paymentsPermissions.setPos(paymentsPermissionsVO.isPos());
        return paymentsPermissions;
    }

    private Permissions toPermissions(PermissionsVO permissionsVO) {
        if (permissionsVO == null) {
            return null;
        }
        Permissions permissions = new Permissions();
        permissions.setUsers(this.toUsersPermissions(permissionsVO.getUsers()));
        permissions.setMyProfile(this.toUserProfilePermissions(permissionsVO.getMyProfile()));
        permissions.setOperators(this.toOperatorsPermissions(permissionsVO.getOperators()));
        permissions.setMarketplace(this.toMarketplacePermissions(permissionsVO.getMarketplace()));
        permissions.setBanking(this.toBankingPermissions(permissionsVO.getBanking()));
        permissions.setPasswords(this.toPasswordsPermissions(permissionsVO.getPasswords()));
        permissions.setRecords(this.toRecordsPermissions(permissionsVO.getRecords()));
        permissions.setOperations(this.toOperationsPermissions(permissionsVO.getOperations()));
        permissions.setWizards(this.toWizardsPermissions(permissionsVO.getWizards()));
        permissions.setContacts(this.toContactsPermissions(permissionsVO.getContacts()));
        permissions.setNotifications(this.toNotificationsPermissions(permissionsVO.getNotifications()));
        permissions.setNotificationSettings(this.toNotificationSettingsPermissions(permissionsVO.getNotificationSettings()));
        permissions.setTokens(this.toTokensPermissions(permissionsVO.getTokens()));
        permissions.setSessions(this.toSessionsPermissions(permissionsVO.getConnectedUsers()));
        permissions.setIdentityProviders(this.toIdentityProvidersPermissions(permissionsVO.getIdentityProviders()));
        permissions.setAlerts(this.toAlertsPermissions(permissionsVO.getUserAlerts()));
        permissions.setVouchers(this.toVouchersPermissions(permissionsVO.getVouchers()));
        permissions.setPrivacySettings(this.toPrivacySettingsPermissions(permissionsVO.getPrivacySettings()));
        permissions.setAgreements(this.toAgreementsPermissions(permissionsVO.getAgreements()));
        permissions.setImages(this.toImagesPermissions(permissionsVO.getImages()));
        permissions.setDocuments(this.toDocumentsPermissions(permissionsVO.getDocuments()));
        permissions.setReferences(this.toReferencesPermissions(permissionsVO.getReferences()));
        permissions.setPaymentFeedbacks(this.toPaymentFeedbacksPermissions(permissionsVO.getTransactionFeedbacks()));
        permissions.setInvite(this.toInvitePermissions(permissionsVO.getInvite()));
        permissions.setMessages(this.toMessagesPermissions(permissionsVO.getMessages()));
        permissions.setImports(this.toImportsPermissions(permissionsVO.getImports()));
        return permissions;
    }

    private PrincipalTypeKind toPrincipalTypeKind(String string, PrincipalTypeNature principalTypeNature) {
        if (principalTypeNature != null) {
            switch (principalTypeNature) {
                case BUILT_IN: {
                    ExistingBuiltInPrincipalType existingBuiltInPrincipalType = ExistingBuiltInPrincipalType.getByInternalName((String)string);
                    if (existingBuiltInPrincipalType == null) break;
                    switch (existingBuiltInPrincipalType) {
                        case ACCOUNT_NUMBER: {
                            return PrincipalTypeKind.ACCOUNT_NUMBER;
                        }
                        case EMAIL: {
                            return PrincipalTypeKind.EMAIL;
                        }
                        case MOBILE_PHONE: {
                            return PrincipalTypeKind.MOBILE_PHONE;
                        }
                        case USERNAME: {
                            return PrincipalTypeKind.USERNAME;
                        }
                        case TRUSTED_DEVICE: {
                            return PrincipalTypeKind.TRUSTED_DEVICE;
                        }
                    }
                    break;
                }
                case ACCESS_CLIENT: {
                    return PrincipalTypeKind.ACCESS_CLIENT;
                }
                case CUSTOM_FIELD: {
                    return PrincipalTypeKind.CUSTOM_FIELD;
                }
                case TOKEN: 
                case NFC_TOKEN: {
                    return PrincipalTypeKind.TOKEN;
                }
            }
        }
        return null;
    }

    private PrivacySettingsPermissions toPrivacySettingsPermissions(PrivacySettingsPermissionsVO privacySettingsPermissionsVO) {
        if (privacySettingsPermissionsVO == null) {
            return null;
        }
        PrivacySettingsPermissions privacySettingsPermissions = new PrivacySettingsPermissions();
        privacySettingsPermissions.setView(privacySettingsPermissionsVO.isView());
        privacySettingsPermissions.setManage(privacySettingsPermissionsVO.isManage());
        return privacySettingsPermissions;
    }

    private RecordPermissions toRecordPermissions(RecordPermissionsVO recordPermissionsVO) {
        if (recordPermissionsVO == null) {
            return null;
        }
        RecordPermissions recordPermissions = new RecordPermissions();
        recordPermissions.setType(this.recordsApiHelper.toRecordType(recordPermissionsVO.getType()));
        recordPermissions.setCreate(recordPermissionsVO.isCreate());
        recordPermissions.setEdit(recordPermissionsVO.isUpdate());
        recordPermissions.setRemove(recordPermissionsVO.isRemove());
        recordPermissions.setSingleRecordId(ApiHelper.toId(recordPermissionsVO.getSingleId()));
        return recordPermissions;
    }

    private RecordsPermissions toRecordsPermissions(RecordsPermissionsVO recordsPermissionsVO) {
        if (recordsPermissionsVO == null) {
            return null;
        }
        RecordsPermissions recordsPermissions = new RecordsPermissions();
        CollectionHelper.orEmpty((List)recordsPermissionsVO.getUser()).stream().map(this::toRecordPermissions).filter(Objects::nonNull).forEach(recordsPermissions.getUser()::add);
        if (recordsPermissionsVO.getUserManagement() != null) {
            recordsPermissionsVO.getUserManagement().stream().map(this::toRecordPermissions).filter(Objects::nonNull).forEach(recordsPermissions.getUserManagement()::add);
        } else {
            recordsPermissions.setUserManagement(null);
        }
        if (recordsPermissionsVO.getSystem() != null) {
            recordsPermissionsVO.getSystem().stream().map(this::toRecordPermissions).filter(Objects::nonNull).forEach(recordsPermissions.getSystem()::add);
        } else {
            recordsPermissions.setSystem(null);
        }
        return recordsPermissions;
    }

    private ReferencesPermissions toReferencesPermissions(ReferencesPermissionsVO referencesPermissionsVO) {
        if (referencesPermissionsVO == null) {
            return null;
        }
        ReferencesPermissions referencesPermissions = new ReferencesPermissions();
        referencesPermissions.setGive(referencesPermissionsVO.isGive());
        referencesPermissions.setReceive(referencesPermissionsVO.isReceive());
        referencesPermissions.setView(referencesPermissionsVO.isView());
        return referencesPermissions;
    }

    private RoleEnum toRole(Collection<Role> collection) {
        if (collection.contains(Role.ADMIN)) {
            return RoleEnum.ADMINISTRATOR;
        }
        if (collection.contains(Role.BROKER)) {
            return RoleEnum.BROKER;
        }
        if (collection.contains(Role.OPERATOR)) {
            return RoleEnum.OPERATOR;
        }
        if (collection.contains(Role.MEMBER)) {
            return RoleEnum.MEMBER;
        }
        return null;
    }

    private ScheduledPaymentsPermissions toScheduledPaymentsPermissions(ScheduledPaymentsPermissionsVO scheduledPaymentsPermissionsVO) {
        if (scheduledPaymentsPermissionsVO == null) {
            return null;
        }
        ScheduledPaymentsPermissions scheduledPaymentsPermissions = new ScheduledPaymentsPermissions();
        scheduledPaymentsPermissions.setView(scheduledPaymentsPermissionsVO.isView());
        scheduledPaymentsPermissions.setBlock(scheduledPaymentsPermissionsVO.isBlock());
        scheduledPaymentsPermissions.setUnblock(scheduledPaymentsPermissionsVO.isUnblock());
        scheduledPaymentsPermissions.setCancel(scheduledPaymentsPermissionsVO.isCancel());
        scheduledPaymentsPermissions.setSettle(scheduledPaymentsPermissionsVO.isSettle());
        scheduledPaymentsPermissions.setProcess(scheduledPaymentsPermissionsVO.isProcess());
        return scheduledPaymentsPermissions;
    }

    private SessionsPermissions toSessionsPermissions(ConnectedUsersPermissionsVO connectedUsersPermissionsVO) {
        if (connectedUsersPermissionsVO == null) {
            return null;
        }
        SessionsPermissions sessionsPermissions = new SessionsPermissions();
        sessionsPermissions.setDisconnect(connectedUsersPermissionsVO.isManage());
        sessionsPermissions.setLogin(connectedUsersPermissionsVO.isLogin());
        sessionsPermissions.setView(connectedUsersPermissionsVO.isView());
        return sessionsPermissions;
    }

    private SystemMessagesPermissions toSystemMessagesPermissions(SystemMessagesPermissionsVO systemMessagesPermissionsVO) {
        if (systemMessagesPermissionsVO == null) {
            return null;
        }
        SystemMessagesPermissions systemMessagesPermissions = new SystemMessagesPermissions();
        systemMessagesPermissions.setManage(systemMessagesPermissionsVO.isManage());
        systemMessagesPermissions.setSendToGroups(systemMessagesPermissionsVO.isSendToGroups());
        systemMessagesPermissions.setSendToUser(systemMessagesPermissionsVO.isSendToUser());
        systemMessagesPermissions.setView(systemMessagesPermissionsVO.isView());
        return systemMessagesPermissions;
    }

    private TicketsPermissions toTicketsPermissions(TicketsPermissionsVO ticketsPermissionsVO) {
        if (ticketsPermissionsVO == null) {
            return null;
        }
        TicketsPermissions ticketsPermissions = new TicketsPermissions();
        ticketsPermissions.setView(ticketsPermissionsVO.isView());
        ticketsPermissions.setCreate(ticketsPermissionsVO.isCreate());
        ticketsPermissions.setCancel(ticketsPermissionsVO.isCancel());
        ticketsPermissions.setApprove(ticketsPermissionsVO.isApprove());
        return ticketsPermissions;
    }

    private TokensPermissions toTokensPermissions(TokensPermissionsVO tokensPermissionsVO) {
        if (tokensPermissionsVO == null) {
            return null;
        }
        TokensPermissions tokensPermissions = new TokensPermissions();
        CollectionHelper.orEmpty((List)tokensPermissionsVO.getMy()).stream().map(this.tokensApiHelper::toTokenPermissions).forEach(tokensPermissions.getMy()::add);
        CollectionHelper.orEmpty((List)tokensPermissionsVO.getUser()).stream().map(this.tokensApiHelper::toTokenPermissions).forEach(tokensPermissions.getUser()::add);
        CollectionHelper.orEmpty((List)tokensPermissionsVO.getPersonalizeNfcTokensAsMember()).stream().map(this.tokensApiHelper::toTokenType).forEach(tokensPermissions.getPersonalizeNfcTokensAsMember()::add);
        return tokensPermissions;
    }

    private UserProfilePermissions toUserProfilePermissions(ProfilePermissionsVO profilePermissionsVO) {
        if (profilePermissionsVO == null) {
            return null;
        }
        UserProfilePermissions userProfilePermissions = new UserProfilePermissions();
        userProfilePermissions.setEditProfile(profilePermissionsVO.isEditProfile());
        userProfilePermissions.setManagePhones(profilePermissionsVO.isManagePhones());
        userProfilePermissions.setManageAddresses(profilePermissionsVO.isManageAddresses());
        userProfilePermissions.setManageContactInfos(profilePermissionsVO.isManageContactInfos());
        userProfilePermissions.setManageImages(profilePermissionsVO.isManageImages());
        if (profilePermissionsVO.isManageAddresses()) {
            userProfilePermissions.setMaxAddresses(profilePermissionsVO.getMaxAddresses());
            userProfilePermissions.setAddressAvailability(this.apiHelper.toAvailability(profilePermissionsVO.getMaxAddresses() > 0, profilePermissionsVO.isAddressRequired()));
        }
        if (profilePermissionsVO.isManagePhones()) {
            userProfilePermissions.setMaxLandLines(profilePermissionsVO.getMaxLandlines());
            userProfilePermissions.setLandLineAvailability(this.apiHelper.toAvailability(profilePermissionsVO.getMaxLandlines() > 0, profilePermissionsVO.isLandLineRequired()));
            userProfilePermissions.setMaxMobiles(profilePermissionsVO.getMaxMobiles());
            userProfilePermissions.setMobileAvailability(this.apiHelper.toAvailability(profilePermissionsVO.getMaxMobiles() > 0, profilePermissionsVO.isMobileRequired()));
        }
        if (profilePermissionsVO.isManageImages()) {
            userProfilePermissions.setMaxImages(profilePermissionsVO.getMaxProfileImages());
            userProfilePermissions.setProfileImageAvailability(this.apiHelper.toAvailability(profilePermissionsVO.getMaxProfileImages() > 0, profilePermissionsVO.isProfileImageRequired()));
        }
        if (profilePermissionsVO.isManageContactInfos()) {
            userProfilePermissions.setMaxContactInfos(profilePermissionsVO.getMaxContactInfos());
            userProfilePermissions.setContactInfoAvailability(this.apiHelper.toAvailability(profilePermissionsVO.getMaxContactInfos() > 0, false));
        }
        return userProfilePermissions;
    }

    private UsersPermissions toUsersPermissions(UsersPermissionsVO usersPermissionsVO) {
        if (usersPermissionsVO == null) {
            return null;
        }
        UsersPermissions usersPermissions = new UsersPermissions();
        usersPermissions.setSearch(usersPermissionsVO.isSearch());
        usersPermissions.setViewProfile(usersPermissionsVO.isViewProfile());
        usersPermissions.setMap(usersPermissionsVO.isMap());
        usersPermissions.setRegisterAsAdmin(usersPermissionsVO.isRegisterAsAdmin());
        usersPermissions.setRegisterAsBroker(usersPermissionsVO.isRegisterAsBroker());
        usersPermissions.setRegisterAsMember(usersPermissionsVO.isRegisterAsMember());
        usersPermissions.setViewPending(usersPermissionsVO.isViewPending());
        usersPermissions.setManagePending(usersPermissionsVO.isManagePending());
        return usersPermissions;
    }

    private VoucherPermissions toVoucherPermissions(VoucherPermissionsVO voucherPermissionsVO) {
        VoucherPermissions voucherPermissions = new VoucherPermissions();
        voucherPermissions.setConfiguration(this.vouchersApiHelper.toVoucherConfiguration(voucherPermissionsVO.getConfiguration()));
        voucherPermissions.setCancel(voucherPermissionsVO.isCancel());
        voucherPermissions.setChangeExpirationDate(voucherPermissionsVO.isChangeExpirationDate());
        voucherPermissions.setRefund(voucherPermissionsVO.isRefund());
        voucherPermissions.setGenerate(voucherPermissionsVO.isGenerate());
        voucherPermissions.setView(voucherPermissionsVO.isView());
        voucherPermissions.setViewVouchers(voucherPermissionsVO.isViewVouchers());
        voucherPermissions.setBuy(voucherPermissionsVO.isBuy());
        voucherPermissions.setSend(voucherPermissionsVO.isSend());
        voucherPermissions.setViewTransactions(voucherPermissionsVO.isViewTransactions());
        voucherPermissions.setRedeem(voucherPermissionsVO.isRedeem());
        voucherPermissions.setTopUp(voucherPermissionsVO.isTopUp());
        voucherPermissions.setEnabled(voucherPermissionsVO.isEnabled());
        voucherPermissions.setViewBought(voucherPermissionsVO.isViewVouchers());
        voucherPermissions.setViewRedeemed(voucherPermissionsVO.isViewTransactions());
        return voucherPermissions;
    }

    private VouchersPermissions toVouchersPermissions(VouchersPermissionsVO vouchersPermissionsVO) {
        if (vouchersPermissionsVO == null) {
            return null;
        }
        VouchersPermissions vouchersPermissions = new VouchersPermissions();
        CollectionHelper.orEmpty((List)vouchersPermissionsVO.getVouchers()).stream().map(this::toVoucherPermissions).filter(voucherPermissions -> voucherPermissions.getEnabled() != false || voucherPermissions.getView() != false).forEach(vouchersPermissions.getVouchers()::add);
        return vouchersPermissions;
    }

    private WizardPermissions toWizardPermissions(WizardPermissionsVO wizardPermissionsVO) {
        if (wizardPermissionsVO == null) {
            return null;
        }
        WizardPermissions wizardPermissions = new WizardPermissions();
        wizardPermissions.setWizard(this.wizardsApiHelper.toWizard(wizardPermissionsVO.getWizard()));
        wizardPermissions.setRun(wizardPermissionsVO.isRun());
        return wizardPermissions;
    }

    private WizardsPermissions toWizardsPermissions(WizardsPermissionsVO wizardsPermissionsVO) {
        if (wizardsPermissionsVO == null) {
            return null;
        }
        WizardsPermissions wizardsPermissions = new WizardsPermissions();
        CollectionHelper.orEmpty((List)wizardsPermissionsVO.getMy()).stream().map(this::toWizardPermissions).filter(Objects::nonNull).forEach(wizardsPermissions.getMy()::add);
        CollectionHelper.orEmpty((List)wizardsPermissionsVO.getSystem()).stream().map(this::toWizardPermissions).filter(Objects::nonNull).forEach(wizardsPermissions.getSystem()::add);
        return wizardsPermissions;
    }
}

