/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import org.cyclos.model.EntityDTO;
import org.cyclos.model.users.references.GeneralReferenceDTO;
import org.cyclos.model.users.references.GeneralReferenceData;
import org.cyclos.model.users.references.GeneralReferenceDataParams;
import org.cyclos.model.users.references.GeneralReferenceQuery;
import org.cyclos.model.users.references.GeneralReferenceSearchData;
import org.cyclos.model.users.references.ReferenceStatisticsParams;
import org.cyclos.model.users.references.ReferenceStatisticsVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.users.users.UserVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.users.GeneralReferenceService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.ReferencesApi;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.ReferencesApiHelper;
import org.cyclos.web.rest.model.ReferenceDataForSet;
import org.cyclos.web.rest.model.ReferenceSet;
import org.cyclos.web.rest.model.ReferenceStatistics;
import org.cyclos.web.rest.model.ReferenceView;
import org.cyclos.web.rest.model.UserReferenceDataForSearch;
import org.cyclos.web.rest.model.UserReferenceResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ReferencesApiImpl
extends BaseApiImpl {
    @Autowired
    private ReferencesApiHelper referencesApiHelper;
    @Autowired
    private GeneralReferenceService generalReferenceService;

    public ResponseEntity<Void> deleteReference(String string) {
        this.generalReferenceService.remove(this.apiHelper.fromId(string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ReferenceDataForSet> getReferenceDataForEdit(String string, List<String> list) {
        GeneralReferenceData generalReferenceData = (GeneralReferenceData)this.generalReferenceService.getData(this.apiHelper.fromId(string));
        ReferenceDataForSet referenceDataForSet = this.referencesApiHelper.toReferenceDataForSet(generalReferenceData);
        return this.ok(referenceDataForSet);
    }

    public ResponseEntity<ReferenceDataForSet> getReferenceDataForSet(String string, String string2, List<String> list) {
        GeneralReferenceDataParams generalReferenceDataParams = new GeneralReferenceDataParams();
        generalReferenceDataParams.setFromUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        generalReferenceDataParams.setToUser((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        GeneralReferenceData generalReferenceData = (GeneralReferenceData)this.generalReferenceService.getDataForNew((Object)generalReferenceDataParams);
        ReferenceDataForSet referenceDataForSet = this.referencesApiHelper.toReferenceDataForSet(generalReferenceData);
        return this.ok(referenceDataForSet);
    }

    public ResponseEntity<UserReferenceDataForSearch> getUserReferencesDataForSearch(String string, List<String> list) {
        GeneralReferenceSearchData generalReferenceSearchData = this.generalReferenceService.getSearchData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserReferenceDataForSearch userReferenceDataForSearch = this.referencesApiHelper.toUserReferenceDataForSearch(generalReferenceSearchData);
        return this.ok(userReferenceDataForSearch);
    }

    public ResponseEntity<ReferenceStatistics> getUserReferenceStatistics(ReferencesApi.GetUserReferenceStatisticsParams getUserReferenceStatisticsParams) {
        ReferenceStatisticsParams referenceStatisticsParams = this.referencesApiHelper.toReferenceStatisticsParams(getUserReferenceStatisticsParams);
        ReferenceStatisticsVO referenceStatisticsVO = this.generalReferenceService.getStatistics(referenceStatisticsParams);
        ReferenceStatistics referenceStatistics = this.referencesApiHelper.toReferenceStatistics(referenceStatisticsVO);
        return this.ok(referenceStatistics);
    }

    public ResponseEntity<List<UserReferenceResult>> searchUserReferences(ReferencesApi.SearchUserReferencesParams searchUserReferencesParams) {
        GeneralReferenceQuery generalReferenceQuery = this.referencesApiHelper.toGeneralReferenceQuery(searchUserReferencesParams);
        Page page = this.generalReferenceService.search(generalReferenceQuery);
        return this.pageResponse(page, this.referencesApiHelper::toUserReferenceResult);
    }

    public ResponseEntity<String> setReference(String string, String string2, ReferenceSet referenceSet) {
        GeneralReferenceDTO generalReferenceDTO = this.referencesApiHelper.toGeneralReferenceDTO(referenceSet);
        generalReferenceDTO.setFrom((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        generalReferenceDTO.setTo((UserVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        String string3 = ApiHelper.toId(this.generalReferenceService.save((EntityDTO)generalReferenceDTO));
        return this.created(this.apiHelper.uriFromApi("references", string3), string3);
    }

    public ResponseEntity<Void> updateReference(String string, ReferenceSet referenceSet) {
        GeneralReferenceDTO generalReferenceDTO = this.referencesApiHelper.toGeneralReferenceDTO(referenceSet);
        generalReferenceDTO.setId(this.apiHelper.fromId(string));
        this.generalReferenceService.save((EntityDTO)generalReferenceDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ReferenceView> viewReference(String string, List<String> list) {
        GeneralReferenceData generalReferenceData = (GeneralReferenceData)this.generalReferenceService.getData(this.apiHelper.fromId(string));
        ReferenceView referenceView = this.referencesApiHelper.toReferenceView(generalReferenceData);
        return this.ok(referenceView);
    }
}

