/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.math.BigDecimal;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.utils.DateTime;
import org.cyclos.web.rest.api.PaymentsApiImpl;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PaymentPreview;
import org.cyclos.web.rest.model.PerformInstallment;
import org.cyclos.web.rest.model.PerformPayment;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class PaymentsApi {
    @Autowired
    private PaymentsApiImpl impl;
    public static final String CALCULATE_PERFORM_PAYMENT_INSTALLMENTS = "/{owner}/payments/installments";
    public static final String DATA_FOR_PERFORM_PAYMENT = "/{owner}/payments/data-for-perform";
    public static final String PERFORM_PAYMENT = "/{owner}/payments";
    public static final String PREVIEW_PAYMENT = "/{owner}/payments/preview";

    @RequestMapping(value={"/api/{owner:.*}/payments/installments"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<List<PerformInstallment>> calculatePerformPaymentInstallments(@PathVariable(value="owner") String string, @RequestParam(value="to", required=true) String string2, @RequestParam(value="count", required=true) Integer n, @RequestParam(value="amount", required=true) BigDecimal bigDecimal, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="currency", required=false) String string3, @RequestParam(value="type", required=false) String string4, @RequestParam(value="firstDate", required=false) DateTime dateTime, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/payments/installments");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        CalculatePerformPaymentInstallmentsParams calculatePerformPaymentInstallmentsParams = new CalculatePerformPaymentInstallmentsParams();
        calculatePerformPaymentInstallmentsParams.owner = string;
        calculatePerformPaymentInstallmentsParams.to = string2;
        calculatePerformPaymentInstallmentsParams.count = n;
        calculatePerformPaymentInstallmentsParams.amount = bigDecimal;
        calculatePerformPaymentInstallmentsParams.fields = list;
        calculatePerformPaymentInstallmentsParams.currency = string3;
        calculatePerformPaymentInstallmentsParams.type = string4;
        calculatePerformPaymentInstallmentsParams.firstDate = dateTime;
        return this.impl.calculatePerformPaymentInstallments(calculatePerformPaymentInstallmentsParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/payments/data-for-perform"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForTransaction> dataForPerformPayment(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="to", required=false) String string2, @RequestParam(value="type", required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/payments/data-for-perform");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        DataForPerformPaymentParams dataForPerformPaymentParams = new DataForPerformPaymentParams();
        dataForPerformPaymentParams.owner = string;
        dataForPerformPaymentParams.fields = list;
        dataForPerformPaymentParams.to = string2;
        dataForPerformPaymentParams.type = string3;
        return this.impl.dataForPerformPayment(dataForPerformPaymentParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/payments"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> performPayment(@PathVariable(value="owner") String string, @RequestBody(required=true) PerformPayment performPayment, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/payments");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        PerformPaymentParams performPaymentParams = new PerformPaymentParams();
        performPaymentParams.owner = string;
        performPaymentParams.performPayment = performPayment;
        performPaymentParams.fields = list;
        performPaymentParams.confirmationPassword = string2;
        return this.impl.performPayment(performPaymentParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/payments/preview"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<PaymentPreview> previewPayment(@PathVariable(value="owner") String string, @RequestBody(required=true) PerformPayment performPayment, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/payments/preview");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewPayment(string, performPayment, list);
    }

    public static class CalculatePerformPaymentInstallmentsParams {
        public String owner;
        public static final String OWNER = "owner";
        public String to;
        public static final String TO = "to";
        public Integer count;
        public static final String COUNT = "count";
        public BigDecimal amount;
        public static final String AMOUNT = "amount";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String currency;
        public static final String CURRENCY = "currency";
        public String type;
        public static final String TYPE = "type";
        public DateTime firstDate;
        public static final String FIRST_DATE = "firstDate";
    }

    public static class DataForPerformPaymentParams {
        public String owner;
        public static final String OWNER = "owner";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String to;
        public static final String TO = "to";
        public String type;
        public static final String TYPE = "type";
    }

    public static class PerformPaymentParams {
        public String owner;
        public static final String OWNER = "owner";
        public PerformPayment performPayment;
        public static final String PERFORM_PAYMENT = "performPayment";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }
}

