/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.access.devices.DeviceConfirmationBarcodeParams;
import org.cyclos.model.access.devices.DeviceConfirmationVO;
import org.cyclos.model.access.principaltypes.TokenPrincipalTypeVO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateDTO;
import org.cyclos.model.access.tokens.ExternalNFCTagAuthenticateData;
import org.cyclos.model.access.tokens.InitializeNFCTagData;
import org.cyclos.model.access.tokens.InitializeNFCTagResult;
import org.cyclos.model.access.tokens.NFCTagInitializeDTO;
import org.cyclos.model.access.tokens.NFCTagPersonalizeDTO;
import org.cyclos.model.access.tokens.PersonalizeNFCTagData;
import org.cyclos.model.access.tokens.TokenActionDTO;
import org.cyclos.model.access.tokens.TokenQuery;
import org.cyclos.model.access.tokens.TokenVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.services.access.TokenService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.utils.ContentType;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.NfcApi;
import org.cyclos.web.rest.helpers.DeviceConfirmationsApiHelper;
import org.cyclos.web.rest.helpers.NfcApiHelper;
import org.cyclos.web.rest.helpers.TokensApiHelper;
import org.cyclos.web.rest.model.DeviceConfirmationView;
import org.cyclos.web.rest.model.NfcDataForInitialize;
import org.cyclos.web.rest.model.NfcDataForPersonalize;
import org.cyclos.web.rest.model.NfcExternalAuthenticateParameter;
import org.cyclos.web.rest.model.NfcExternalAuthenticateResult;
import org.cyclos.web.rest.model.NfcInitializeParameter;
import org.cyclos.web.rest.model.NfcInitializeResult;
import org.cyclos.web.rest.model.NfcPersonalizeDataParameter;
import org.cyclos.web.rest.model.NfcPersonalizeParameter;
import org.cyclos.web.rest.model.NfcTokenParameter;
import org.cyclos.web.rest.model.SendMediumEnum;
import org.cyclos.web.rest.model.TokenDetailed;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NfcApiImpl
extends BaseApiImpl {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private NfcApiHelper nfcApiHelper;
    @Autowired
    private DeviceConfirmationsApiHelper deviceConfirmationsApiHelper;
    @Autowired
    private TokensApiHelper tokensApiHelper;

    public ResponseEntity<Void> cancelNfc(NfcTokenParameter nfcTokenParameter) {
        TokenActionDTO tokenActionDTO = this.nfcApiHelper.toTokenActionDTO(nfcTokenParameter);
        this.tokenService.cancelNFCToken(tokenActionDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<String> createDeviceConfirmationForPersonalizeNfc(NfcPersonalizeDataParameter nfcPersonalizeDataParameter) {
        DeviceConfirmationVO deviceConfirmationVO = this.tokenService.createDeviceConfirmationForPersonalizeNFCTag((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)nfcPersonalizeDataParameter.getUser()), (TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)nfcPersonalizeDataParameter.getType()));
        return this.ok(deviceConfirmationVO.getId());
    }

    public ResponseEntity<Void> deleteDeviceConfirmationForPersonalizeNfc(String string, String string2, String string3) {
        this.tokenService.removeDeviceConfirmationForPersonalizeNFCTag((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2), (TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string3), string);
        return this.ok();
    }

    public ResponseEntity<InputStream> getDeviceConfirmationQrCodeForPersonalizeNfc(NfcApi.GetDeviceConfirmationQrCodeForPersonalizeNfcParams getDeviceConfirmationQrCodeForPersonalizeNfcParams) throws IOException {
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        DeviceConfirmationBarcodeParams deviceConfirmationBarcodeParams = this.deviceConfirmationsApiHelper.toDeviceConfirmationBarcodeParams(getDeviceConfirmationQrCodeForPersonalizeNfcParams.id, getDeviceConfirmationQrCodeForPersonalizeNfcParams.size);
        SerializableInputStream serializableInputStream = this.tokenService.deviceConfirmationBarcodeForPersonalizeNFCTag((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)getDeviceConfirmationQrCodeForPersonalizeNfcParams.user), (TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)getDeviceConfirmationQrCodeForPersonalizeNfcParams.type), deviceConfirmationBarcodeParams);
        ServletHelper.setContentType(httpServletResponse, ContentType.PNG);
        ServletHelper.writeContents(httpServletResponse, (InputStream)serializableInputStream);
        httpServletResponse.flushBuffer();
        return null;
    }

    public ResponseEntity<NfcDataForInitialize> getNfcDataForInitialize(List<String> list) {
        InitializeNFCTagData initializeNFCTagData = this.tokenService.getInitializeNFCTagData();
        NfcDataForInitialize nfcDataForInitialize = this.nfcApiHelper.toNfcDataForInitialize(initializeNFCTagData);
        return this.ok(nfcDataForInitialize);
    }

    public ResponseEntity<NfcDataForPersonalize> getNfcDataForPersonalize(String string, String string2, List<String> list) {
        PersonalizeNFCTagData personalizeNFCTagData = this.tokenService.getPersonalizeNFCTagData((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string), (UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2));
        NfcDataForPersonalize nfcDataForPersonalize = this.nfcApiHelper.toNfcDataForPersonalize(personalizeNFCTagData);
        return this.ok(nfcDataForPersonalize);
    }

    public ResponseEntity<TokenDetailed> getNfcToken(String string, String string2) {
        TokenQuery tokenQuery = new TokenQuery();
        tokenQuery.setValue(string2);
        tokenQuery.setType((TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string));
        TokenDetailed tokenDetailed = null;
        TokenVO tokenVO = (TokenVO)CollectionHelper.first((Iterable)this.tokenService.search(tokenQuery));
        if (tokenVO != null) {
            tokenDetailed = this.tokensApiHelper.toTokenDetailed(tokenVO);
        }
        return this.okOrNoContent(Optional.ofNullable(tokenDetailed));
    }

    public ResponseEntity<Void> getOtpForPersonalizeNfc(SendMediumEnum sendMediumEnum, NfcPersonalizeDataParameter nfcPersonalizeDataParameter) {
        this.tokenService.requestNewOTPForPersonalizeNFCTag((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)nfcPersonalizeDataParameter.getUser()), (TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)nfcPersonalizeDataParameter.getType()), this.apiHelper.toSendMedium(sendMediumEnum));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<NfcInitializeResult> initializeNfc(NfcInitializeParameter nfcInitializeParameter) {
        NFCTagInitializeDTO nFCTagInitializeDTO = this.nfcApiHelper.toNFCTagInitializeDTO(nfcInitializeParameter);
        InitializeNFCTagResult initializeNFCTagResult = this.tokenService.initializeNFCTag(nFCTagInitializeDTO);
        return this.ok(this.nfcApiHelper.toNfcInitializeResult(initializeNFCTagResult));
    }

    public ResponseEntity<NfcExternalAuthenticateResult> nfcExternalAuth(NfcExternalAuthenticateParameter nfcExternalAuthenticateParameter) {
        ExternalNFCTagAuthenticateDTO externalNFCTagAuthenticateDTO = this.nfcApiHelper.toExternalNFCTagAuthenticateDTO(nfcExternalAuthenticateParameter);
        ExternalNFCTagAuthenticateData externalNFCTagAuthenticateData = this.tokenService.requestForExternalAuthenticate(externalNFCTagAuthenticateDTO);
        return this.ok(this.nfcApiHelper.toNfcExternalAuthenticateResult(externalNFCTagAuthenticateData));
    }

    public ResponseEntity<Void> personalizeNfc(NfcPersonalizeParameter nfcPersonalizeParameter, String string) {
        NFCTagPersonalizeDTO nFCTagPersonalizeDTO = this.nfcApiHelper.toNFCTagPersonalizeDTO(nfcPersonalizeParameter, string);
        this.tokenService.personalizeNFCTag(nFCTagPersonalizeDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DeviceConfirmationView> viewDeviceConfirmationForPersonalizeNfc(String string, String string2, String string3) {
        DeviceConfirmationVO deviceConfirmationVO = this.tokenService.viewDeviceConfirmationForPersonalizeNFCTag((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string2), (TokenPrincipalTypeVO)ModelHelper.voFromString(TokenPrincipalTypeVO.class, (String)string3), string);
        return this.ok(this.deviceConfirmationsApiHelper.toDeviceConfirmationView(deviceConfirmationVO));
    }
}

