/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import org.cyclos.model.Property;
import org.cyclos.model.access.pins.PinLocatorVO;
import org.cyclos.model.contentmanagement.GetMobileUserDataParams;
import org.cyclos.model.contentmanagement.GetVersionedDataParams;
import org.cyclos.model.contentmanagement.mobilepages.MobilePageVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.mobile.MobileGuestData;
import org.cyclos.server.model.mobile.MobileUserData;
import org.cyclos.services.contentmanagement.MobilePageService;
import org.cyclos.services.mobile.InternalMobileService;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.MobileApi;
import org.cyclos.web.rest.helpers.MobileApiHelper;
import org.cyclos.web.rest.model.DataForMobileGuest;
import org.cyclos.web.rest.model.DataForMobileUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class MobileApiImpl
extends BaseApiImpl {
    @Autowired
    private InternalMobileService internalMobileService;
    @Autowired
    private MobileApiHelper mobileApiHelper;
    @Autowired
    private MobilePageService mobilePageService;

    public ResponseEntity<DataForMobileGuest> dataForMobileGuest(MobileApi.DataForMobileGuestParams dataForMobileGuestParams) {
        GetVersionedDataParams getVersionedDataParams = this.mobileApiHelper.toGetDataGuestParams(dataForMobileGuestParams);
        PinLocatorVO pinLocatorVO = null;
        if (StringHelper.isNotBlank((Object)dataForMobileGuestParams.pinPrincipal)) {
            pinLocatorVO = new PinLocatorVO((Property)PinLocatorVO.PRINCIPAL, (Object)dataForMobileGuestParams.pinPrincipal);
        }
        MobileGuestData mobileGuestData = this.internalMobileService.getGuestData(this.apiHelper.fromId(dataForMobileGuestParams.deviceId), pinLocatorVO, getVersionedDataParams);
        DataForMobileGuest dataForMobileGuest = this.mobileApiHelper.toMobileDataForGuest(mobileGuestData);
        return this.ok(dataForMobileGuest);
    }

    public ResponseEntity<DataForMobileUser> dataForMobileUser(MobileApi.DataForMobileUserParams dataForMobileUserParams) {
        GetMobileUserDataParams getMobileUserDataParams = this.mobileApiHelper.toGetDataUserParams(dataForMobileUserParams);
        MobileUserData mobileUserData = this.internalMobileService.getUserData(getMobileUserDataParams);
        DataForMobileUser dataForMobileUser = this.mobileApiHelper.toMobileDataForUser(mobileUserData);
        return this.ok(dataForMobileUser);
    }

    public ResponseEntity<String> mobilePageContent(String string) {
        String string2 = this.mobilePageService.getContent((MobilePageVO)ModelHelper.voFromString(MobilePageVO.class, (String)string));
        return this.html(string2);
    }
}

