/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.contentmanagement.contentitems.FrontendScreenSize;
import org.cyclos.model.contentmanagement.contentitems.MenuItemDetailedVO;
import org.cyclos.model.contentmanagement.contentitems.MenuItemVO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendContentVO;
import org.cyclos.model.contentmanagement.staticcontents.FrontendDashboardContentVO;
import org.cyclos.model.users.dashboardsettings.UserQuickAccessData;
import org.cyclos.model.users.users.FrontendSettingsDTO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.model.app.FrontendData;
import org.cyclos.server.model.app.FrontendHomeData;
import org.cyclos.server.utils.JsonConverter;
import org.cyclos.services.app.InternalFrontendService;
import org.cyclos.services.contentmanagement.MenuEntryService;
import org.cyclos.services.users.UserFrontendSettingsService;
import org.cyclos.services.users.UserQuickAccessService;
import org.cyclos.utils.CollectionHelper;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.api.IconsContentResolver;
import org.cyclos.web.rest.helpers.FrontendApiHelper;
import org.cyclos.web.rest.model.DataForFrontend;
import org.cyclos.web.rest.model.DataForFrontendHome;
import org.cyclos.web.rest.model.DataForUserQuickAccess;
import org.cyclos.web.rest.model.FrontendHomeContent;
import org.cyclos.web.rest.model.FrontendPageWithContent;
import org.cyclos.web.rest.model.FrontendScreenSizeEnum;
import org.cyclos.web.rest.model.FrontendSettings;
import org.cyclos.web.rest.model.UserQuickAccessSettingsEdit;
import org.cyclos.web.utils.IconHandler;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class FrontendApiImpl
extends BaseApiImpl {
    @Autowired
    private InternalFrontendService internalFrontendService;
    @Autowired
    private UserQuickAccessService userQuickAccessService;
    @Autowired
    private MenuEntryService menuEntryService;
    @Autowired
    private UserFrontendSettingsService userFrontendSettingsService;
    @Autowired
    private FrontendApiHelper frontendApiHelper;
    @Autowired
    private JsonConverter jsonConverter;
    @Autowired
    private IconHandler iconHandler;

    public ResponseEntity<DataForFrontend> dataForFrontend(List<String> list, FrontendScreenSizeEnum frontendScreenSizeEnum) {
        FrontendScreenSize frontendScreenSize = this.frontendApiHelper.toFrontendScreenSize(frontendScreenSizeEnum);
        FrontendData frontendData = this.internalFrontendService.getFrontendData(frontendScreenSize);
        DataForFrontend dataForFrontend = this.frontendApiHelper.toDataForFrontend(frontendData);
        return this.ok(dataForFrontend);
    }

    public ResponseEntity<DataForFrontendHome> dataForFrontendHome(List<String> list, FrontendScreenSizeEnum frontendScreenSizeEnum) {
        FrontendScreenSize frontendScreenSize = this.frontendApiHelper.toFrontendScreenSize(frontendScreenSizeEnum);
        FrontendHomeData frontendHomeData = this.internalFrontendService.getHomeData(frontendScreenSize);
        DataForFrontendHome dataForFrontendHome = this.frontendApiHelper.toDataForFrontendHome(frontendHomeData);
        return this.ok(dataForFrontendHome);
    }

    public ResponseEntity<DataForUserQuickAccess> getDataForUserQuickAccess(String string) {
        UserQuickAccessData userQuickAccessData = this.userQuickAccessService.getData(ModelHelper.userLocator((String)string));
        DataForUserQuickAccess dataForUserQuickAccess = this.frontendApiHelper.toDataForUserQuickAccess(userQuickAccessData);
        return this.ok(dataForUserQuickAccess);
    }

    public ResponseEntity<FrontendHomeContent> getFrontendHelp(List<String> list) {
        FrontendDashboardContentVO frontendDashboardContentVO = this.internalFrontendService.getHelp();
        FrontendHomeContent frontendHomeContent = this.frontendApiHelper.toFrontendHomeContent((FrontendContentVO)frontendDashboardContentVO);
        return this.ok(frontendHomeContent);
    }

    public ResponseEntity<Map<String, String>> getFrontendIcons(List<String> list) throws IOException {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        new IconsContentResolver(this.cyclosProperties, this.jsonConverter, this.iconHandler, list).write(httpServletRequest, httpServletResponse);
        return null;
    }

    public ResponseEntity<Void> restoreUserQuickAccessDefaults(String string) {
        this.userQuickAccessService.restoreDefaults(ModelHelper.userLocator((String)string));
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> saveFrontendSettings(FrontendSettings frontendSettings) {
        FrontendSettingsDTO frontendSettingsDTO = this.frontendApiHelper.toFrontendSettingsDTO(frontendSettings);
        this.userFrontendSettingsService.save(frontendSettingsDTO);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<Void> saveUserQuickAccess(String string, UserQuickAccessSettingsEdit userQuickAccessSettingsEdit) {
        List list = CollectionHelper.orEmpty(userQuickAccessSettingsEdit.getQuickAccess()).stream().map(this.frontendApiHelper::toUserQuickAccessDTO).collect(Collectors.toList());
        this.userQuickAccessService.save(ModelHelper.userLocator((String)string), list);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<FrontendPageWithContent> viewFrontendPage(String string, List<String> list) {
        MenuItemVO menuItemVO = (MenuItemVO)ModelHelper.voFromString(MenuItemVO.class, (String)string);
        MenuItemDetailedVO menuItemDetailedVO = this.menuEntryService.getMenuItemDetails(menuItemVO);
        FrontendPageWithContent frontendPageWithContent = this.frontendApiHelper.toFrontendPageWithContent(menuItemDetailedVO);
        return this.ok(frontendPageWithContent);
    }
}

