/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.ExternalPaymentsApiImpl;
import org.cyclos.web.rest.model.DataForTransaction;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.ExternalPaymentPreview;
import org.cyclos.web.rest.model.PaymentError;
import org.cyclos.web.rest.model.PerformExternalPayment;
import org.cyclos.web.rest.model.Transaction;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class ExternalPaymentsApi {
    @Autowired
    private ExternalPaymentsApiImpl impl;
    public static final String CANCEL_EXTERNAL_PAYMENT = "/external-payments/{key}/cancel";
    public static final String DATA_FOR_PERFORM_EXTERNAL_PAYMENT = "/{owner}/external-payments/data-for-perform";
    public static final String PERFORM_EXTERNAL_PAYMENT = "/{owner}/external-payments";
    public static final String PREVIEW_EXTERNAL_PAYMENT = "/{owner}/external-payments/preview";

    @RequestMapping(value={"/api/external-payments/{key}/cancel"}, produces={"application/json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    public ResponseEntity<Void> cancelExternalPayment(@PathVariable(value="key") String string, @RequestHeader(value="confirmationPassword", required=false) String string2, @RequestBody(required=false) String string3, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /external-payments/{key}/cancel");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.cancelExternalPayment(string, string2, string3);
    }

    @RequestMapping(value={"/api/{owner:.*}/external-payments/data-for-perform"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForTransaction> dataForPerformExternalPayment(@PathVariable(value="owner") String string, @RequestParam(value="fields", required=false) List<String> list, @RequestParam(value="type", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{owner}/external-payments/data-for-perform");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.dataForPerformExternalPayment(string, list, string2);
    }

    @RequestMapping(value={"/api/{owner:.*}/external-payments"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Transaction> performExternalPayment(@PathVariable(value="owner") String string, @RequestBody(required=true) PerformExternalPayment performExternalPayment, @RequestParam(value="fields", required=false) List<String> list, @RequestHeader(value="confirmationPassword", required=false) String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/external-payments");
        httpServletRequest.setAttribute("errorType", PaymentError.class);
        ServletHelper.denyGuest(httpServletRequest);
        PerformExternalPaymentParams performExternalPaymentParams = new PerformExternalPaymentParams();
        performExternalPaymentParams.owner = string;
        performExternalPaymentParams.performExternalPayment = performExternalPayment;
        performExternalPaymentParams.fields = list;
        performExternalPaymentParams.confirmationPassword = string2;
        return this.impl.performExternalPayment(performExternalPaymentParams);
    }

    @RequestMapping(value={"/api/{owner:.*}/external-payments/preview"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<ExternalPaymentPreview> previewExternalPayment(@PathVariable(value="owner") String string, @RequestBody(required=true) PerformExternalPayment performExternalPayment, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{owner}/external-payments/preview");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.previewExternalPayment(string, performExternalPayment, list);
    }

    public static class PerformExternalPaymentParams {
        public String owner;
        public static final String OWNER = "owner";
        public PerformExternalPayment performExternalPayment;
        public static final String PERFORM_EXTERNAL_PAYMENT = "performExternalPayment";
        public List<String> fields;
        public static final String FIELDS = "fields";
        public String confirmationPassword;
        public static final String CONFIRMATION_PASSWORD = "confirmationPassword";
    }
}

