/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.ValidationException;
import org.cyclos.model.access.devices.ActivateTrustedDeviceData;
import org.cyclos.model.access.devices.RequestActivationResult;
import org.cyclos.model.access.devices.RequestDeviceActivationParams;
import org.cyclos.model.access.devices.TrustedDeviceDTO;
import org.cyclos.model.access.passwords.CredentialInputDTO;
import org.cyclos.model.access.passwords.ICredentialInputDTO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.TrustedDeviceService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.DevicesApiHelper;
import org.cyclos.web.rest.model.ActivationRequest;
import org.cyclos.web.rest.model.DataForSendingOtp;
import org.cyclos.web.rest.model.Device;
import org.cyclos.web.rest.model.DeviceActivation;
import org.cyclos.web.rest.model.DeviceActivationInfo;
import org.cyclos.web.rest.model.DeviceActivationResult;
import org.cyclos.web.rest.model.DeviceDataForEdit;
import org.cyclos.web.rest.model.DeviceEdit;
import org.cyclos.web.rest.model.PasswordInput;
import org.cyclos.web.rest.model.SendActivationCodeRequest;
import org.cyclos.web.rest.model.SendActivationCodeResult;
import org.cyclos.web.rest.model.SendOtpWithId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class DevicesApiImpl
extends BaseApiImpl {
    @Autowired
    private TrustedDeviceService trustedDeviceService;
    @Autowired
    private DevicesApiHelper devicesApiHelper;
    @Autowired
    private ApiHelper apiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ResponseEntity<Void> deleteDevice(String string, String string2) {
        this.ensureDeviceId(this.apiHelper.fromId(string));
        this.trustedDeviceService.remove(this.apiHelper.fromId(string), string2);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<DeviceActivationResult> deviceActivation(DeviceActivation deviceActivation) {
        return this.ok(this.devicesApiHelper.toDeviceActivationResult(this.trustedDeviceService.activate(this.devicesApiHelper.toTrustedDeviceActivationParams(deviceActivation))));
    }

    public ResponseEntity<DeviceActivationInfo> deviceActivationIfPossible(ActivationRequest activationRequest, List<String> list) {
        ActivateTrustedDeviceData activateTrustedDeviceData = this.trustedDeviceService.activateIfPossible(this.devicesApiHelper.toTrustedDeviceActivationWithoutCodeParams(activationRequest));
        return this.ok(this.devicesApiHelper.toDeviceActivationInfo(activateTrustedDeviceData));
    }

    public ResponseEntity<DeviceDataForEdit> getDeviceDataForEdit(String string, List<String> list) {
        this.ensureDeviceId(this.apiHelper.fromId(string));
        return this.ok(this.devicesApiHelper.toDeviceDataForEdit(this.trustedDeviceService.getData(this.apiHelper.fromId(string).longValue())));
    }

    public ResponseEntity<DataForSendingOtp> getDeviceDataForSend(List<String> list) {
        return this.ok(this.authApiHelper.toDataForSendingOtp(this.trustedDeviceService.getActivationData()));
    }

    public ResponseEntity<PasswordInput> getPasswordInputForRemoveDevice(String string, List<String> list) {
        CredentialInputDTO credentialInputDTO = this.trustedDeviceService.getConfirmationPasswordInputForRemove(this.apiHelper.fromId(string));
        PasswordInput passwordInput = this.authApiHelper.toPasswordInput((ICredentialInputDTO)credentialInputDTO);
        return this.ok(passwordInput);
    }

    public ResponseEntity<List<Device>> listDevices(String string, List<String> list) {
        List list2 = this.trustedDeviceService.list((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        List list3 = list2.stream().map(this.devicesApiHelper::toDevice).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<SendActivationCodeResult> resendDeviceActivationCode(String string, SendOtpWithId sendOtpWithId) {
        RequestDeviceActivationParams requestDeviceActivationParams = this.devicesApiHelper.toRequestDeviceActivationParams(string, sendOtpWithId);
        this.ensureDeviceId(requestDeviceActivationParams.getDeviceId());
        RequestActivationResult requestActivationResult = this.trustedDeviceService.requestActivationCode(requestDeviceActivationParams);
        return this.ok(this.devicesApiHelper.toSendActivationCodeResult(requestActivationResult));
    }

    public ResponseEntity<SendActivationCodeResult> sendDeviceActivationCode(SendActivationCodeRequest sendActivationCodeRequest) {
        RequestDeviceActivationParams requestDeviceActivationParams = this.devicesApiHelper.toRequestDeviceActivationParams(sendActivationCodeRequest);
        RequestActivationResult requestActivationResult = this.trustedDeviceService.requestActivationCode(requestDeviceActivationParams);
        return this.ok(this.devicesApiHelper.toSendActivationCodeResult(requestActivationResult));
    }

    public ResponseEntity<Void> updateDevice(String string, DeviceEdit deviceEdit) {
        this.ensureDeviceId(this.apiHelper.fromId(string));
        TrustedDeviceDTO trustedDeviceDTO = this.devicesApiHelper.toDeviceDTO(string, deviceEdit);
        this.trustedDeviceService.save(trustedDeviceDTO);
        return ResponseEntity.noContent().build();
    }

    private void ensureDeviceId(Long l) {
        if (l == null) {
            throw new ValidationException("Missing id");
        }
    }
}

