/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import java.util.stream.Collectors;
import org.cyclos.model.access.channels.ChannelVO;
import org.cyclos.model.access.clients.AccessClientActionParams;
import org.cyclos.model.access.clients.AccessClientData;
import org.cyclos.model.access.clients.AccessClientsActivationData;
import org.cyclos.model.access.clients.ActivateAccessClientDTO;
import org.cyclos.model.access.passwords.OtpResult;
import org.cyclos.model.access.passwords.SendOtpParams;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.services.access.AccessClientService;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AuthApiHelper;
import org.cyclos.web.rest.helpers.ClientsApiHelper;
import org.cyclos.web.rest.model.ActivateClientResult;
import org.cyclos.web.rest.model.ClientView;
import org.cyclos.web.rest.model.CreateClientParams;
import org.cyclos.web.rest.model.DataForClientActivation;
import org.cyclos.web.rest.model.SendOtp;
import org.cyclos.web.rest.model.UserClientTypePermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class ClientsApiImpl
extends BaseApiImpl {
    @Autowired
    private AccessClientService accessClientService;
    @Autowired
    private ClientsApiHelper clientsApiHelper;
    @Autowired
    private AuthApiHelper authApiHelper;

    public ResponseEntity<ActivateClientResult> activateClient(String string, String string2) {
        ActivateAccessClientDTO activateAccessClientDTO = this.accessClientService.activate(string, string2);
        ActivateClientResult activateClientResult = this.clientsApiHelper.toActivateClientResult(activateAccessClientDTO);
        return this.ok(activateClientResult);
    }

    public ResponseEntity<ActivateClientResult> createAndActivateClient(String string, CreateClientParams createClientParams) {
        ActivateAccessClientDTO activateAccessClientDTO = this.accessClientService.createAndActivate(this.clientsApiHelper.toCreateAccessClientParameter(string, createClientParams));
        ActivateClientResult activateClientResult = this.clientsApiHelper.toActivateClientResult(activateAccessClientDTO);
        return this.ok(activateClientResult);
    }

    public ResponseEntity<DataForClientActivation> getDataForClientActivation(List<String> list, String string) {
        AccessClientsActivationData accessClientsActivationData = this.accessClientService.getActivationData((ChannelVO)ModelHelper.voFromString(ChannelVO.class, (String)string));
        DataForClientActivation dataForClientActivation = this.clientsApiHelper.toDataForClientActivation(accessClientsActivationData);
        return this.ok(dataForClientActivation);
    }

    public ResponseEntity<List<UserClientTypePermissions>> listClientTypesForUser(String string, List<String> list, String string2) {
        List list2 = this.accessClientService.getTypeData((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string), (ChannelVO)ModelHelper.voFromString(ChannelVO.class, (String)string2));
        List list3 = list2.stream().map(this.clientsApiHelper::toUserClientTypePermissions).collect(Collectors.toList());
        return this.ok(list3);
    }

    public ResponseEntity<org.cyclos.web.rest.model.OtpResult> sendClientActivationCode(SendOtp sendOtp, List<String> list) {
        SendOtpParams sendOtpParams = this.authApiHelper.toSendOtpParams(sendOtp);
        OtpResult otpResult = this.accessClientService.requestActivationCode(sendOtpParams);
        org.cyclos.web.rest.model.OtpResult otpResult2 = this.authApiHelper.toOtpResult(otpResult);
        return this.ok(otpResult2);
    }

    public ResponseEntity<Void> unassignClient(String string, String string2) {
        AccessClientActionParams accessClientActionParams = this.clientsApiHelper.toActionParams(string, string2);
        this.accessClientService.unassign(accessClientActionParams);
        return ResponseEntity.noContent().build();
    }

    public ResponseEntity<ClientView> viewClient(String string, List<String> list) {
        Long l = this.clientsApiHelper.ensureId(string);
        AccessClientData accessClientData = (AccessClientData)this.accessClientService.getData(l);
        ClientView clientView = this.clientsApiHelper.toClientView(accessClientData);
        return this.ok(clientView);
    }
}

