/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.FrameworkException;
import org.cyclos.model.utils.FieldSelector;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.server.utils.CyclosProperties;
import org.cyclos.services.contentmanagement.InternalTranslationMessageService;
import org.cyclos.utils.HasPartialData;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.helpers.ApiHelper;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

public class BaseApiImpl {
    public static final MediaType HTML = new MediaType("text", "html", StandardCharsets.UTF_8);
    public static final MediaType TEXT = new MediaType("text", "plain", StandardCharsets.UTF_8);
    @Autowired
    protected ApiHelper apiHelper;
    @Autowired
    protected CyclosProperties cyclosProperties;
    @Autowired
    private InternalTranslationMessageService internalTranslationMessageService;

    protected ResponseEntity.BodyBuilder appendPageHeaders(ResponseEntity.BodyBuilder bodyBuilder, Integer n, Integer n2, Integer n3, Integer n4, Boolean bl, Boolean bl2) {
        if (n != null) {
            bodyBuilder.header("X-Total-Count", new String[]{n.toString()});
        }
        if (n2 != null) {
            bodyBuilder.header("X-Page-Size", new String[]{n2.toString()});
        }
        if (n3 != null) {
            bodyBuilder.header("X-Current-Page", new String[]{n3.toString()});
        }
        if (n4 != null) {
            bodyBuilder.header("X-Page-Count", new String[]{n4.toString()});
        }
        if (bl != null) {
            bodyBuilder.header("X-Has-Next-Page", new String[]{bl.toString()});
        }
        if (Boolean.TRUE.equals(bl2)) {
            bodyBuilder.header("X-Partial-Data", new String[]{"true"});
        }
        return bodyBuilder;
    }

    protected ResponseEntity<String> created(URI uRI, Long l) {
        return this.created(uRI, ApiHelper.toId(l));
    }

    protected ResponseEntity<String> created(URI uRI, String string) {
        if (string == null) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return ResponseEntity.created((URI)uRI).contentType(TEXT).body((Object)string);
    }

    protected FieldSelector fields() {
        return ServletHelper.getRequestData().getFields();
    }

    protected ResponseEntity<String> html(String string) {
        if (string == null) {
            return this.okOrNoContent(Optional.empty());
        }
        return ResponseEntity.ok().contentType(HTML).body((Object)string);
    }

    protected String message(MessageFormat messageFormat, MessageKey messageKey, Object ... objectArray) throws FrameworkException {
        return this.internalTranslationMessageService.message(messageFormat, messageKey, objectArray);
    }

    protected String message(MessageKey messageKey, Object ... objectArray) throws FrameworkException {
        return this.internalTranslationMessageService.message(messageKey, objectArray);
    }

    protected ResponseEntity<Void> ok() {
        return ResponseEntity.ok().build();
    }

    protected <T> ResponseEntity<T> ok(T t) {
        this.fields().apply(t);
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
        if (t instanceof HasPartialData) {
            boolean bl = ((HasPartialData)t).isPartialData();
            if (bl) {
                bodyBuilder.header("X-Partial-Data", new String[]{"true"});
            }
        } else if (t instanceof String) {
            bodyBuilder.contentType(TEXT);
        }
        return bodyBuilder.body(t);
    }

    protected <T> ResponseEntity<T> okOrNoContent(Optional<T> optional) {
        if (optional != null && optional.isPresent()) {
            return this.ok(optional.get());
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    protected <T, VO> ResponseEntity<List<T>> pageResponse(Page<VO> page, Function<VO, T> function) {
        List list = page == null ? null : page.getPageItems();
        Integer n = page == null ? null : page.getTotalCount();
        Integer n2 = page == null ? null : Integer.valueOf(page.getPageSize());
        Integer n3 = page == null ? null : Integer.valueOf(page.getCurrentPage());
        Integer n4 = page == null ? null : page.getPageCount();
        Boolean bl = page == null ? null : Boolean.valueOf(page.isHasNextPage());
        Boolean bl2 = page == null ? null : Boolean.valueOf(page.isPartialData());
        List list2 = list == null ? Collections.emptyList() : list.stream().map(function).collect(Collectors.toList());
        this.fields().apply(list2);
        ResponseEntity.BodyBuilder bodyBuilder = ResponseEntity.ok();
        return this.appendPageHeaders(bodyBuilder, n, n2, n3, n4, bl, bl2).body(list2);
    }

    protected ResponseEntity<InputStream> writeFile(FileInfo fileInfo) {
        HttpServletRequest httpServletRequest = ServletHelper.getRequest();
        HttpServletResponse httpServletResponse = ServletHelper.getResponse();
        try {
            ServletHelper.writeFileContent(httpServletRequest, httpServletResponse, fileInfo);
            return null;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }
}

