/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.io.InputStream;
import java.util.List;
import org.cyclos.model.banking.accounts.AccountBalanceLimitDTO;
import org.cyclos.model.banking.accounts.AccountBalanceLimitsOverviewQuery;
import org.cyclos.model.banking.accounts.AccountLimitsOverviewData;
import org.cyclos.model.banking.accounts.AccountVO;
import org.cyclos.model.banking.accounts.UserAccountBalanceLimitData;
import org.cyclos.model.system.exportformats.ExportFormatVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.model.utils.FileInfo;
import org.cyclos.model.utils.ModelHelper;
import org.cyclos.server.utils.ClassHelper;
import org.cyclos.services.banking.AccountService;
import org.cyclos.utils.Page;
import org.cyclos.web.rest.api.BalanceLimitsApi;
import org.cyclos.web.rest.api.BaseApiImpl;
import org.cyclos.web.rest.helpers.AccountsApiHelper;
import org.cyclos.web.rest.helpers.BalanceLimitsApiHelper;
import org.cyclos.web.rest.model.AccountBalanceLimitsData;
import org.cyclos.web.rest.model.DataForBalanceLimitsSearch;
import org.cyclos.web.rest.model.GeneralAccountBalanceLimitsResult;
import org.cyclos.web.rest.model.UserAccountBalanceLimitsListData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class BalanceLimitsApiImpl
extends BaseApiImpl {
    @Autowired
    private BalanceLimitsApiHelper balanceLimitsApiHelper;
    @Autowired
    private AccountsApiHelper accountsApiHelper;
    @Autowired
    private AccountService accountService;

    public ResponseEntity<InputStream> exportAccountBalanceLimits(BalanceLimitsApi.ExportAccountBalanceLimitsParams exportAccountBalanceLimitsParams) {
        BalanceLimitsApi.SearchAccountBalanceLimitsParams searchAccountBalanceLimitsParams = (BalanceLimitsApi.SearchAccountBalanceLimitsParams)ClassHelper.convert((Object)exportAccountBalanceLimitsParams, BalanceLimitsApi.SearchAccountBalanceLimitsParams.class);
        AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery = this.balanceLimitsApiHelper.toAccountBalanceLimitsOverviewQuery(searchAccountBalanceLimitsParams);
        ExportFormatVO exportFormatVO = (ExportFormatVO)ModelHelper.voFromString(ExportFormatVO.class, (String)exportAccountBalanceLimitsParams.format);
        FileInfo fileInfo = this.accountService.exportAccountBalanceLimitsOverview(exportFormatVO, accountBalanceLimitsOverviewQuery);
        return this.writeFile(fileInfo);
    }

    public ResponseEntity<AccountBalanceLimitsData> getAccountBalanceLimits(String string, String string2, List<String> list) {
        AccountVO accountVO = this.accountsApiHelper.toAccountVO(string, string2);
        UserAccountBalanceLimitData userAccountBalanceLimitData = this.accountService.getUserAccountBalanceLimitData(accountVO);
        AccountBalanceLimitsData accountBalanceLimitsData = this.balanceLimitsApiHelper.toAccountBalanceLimitsData(userAccountBalanceLimitData);
        return this.ok(accountBalanceLimitsData);
    }

    public ResponseEntity<DataForBalanceLimitsSearch> getAccountBalanceLimitsData(List<String> list) {
        AccountLimitsOverviewData accountLimitsOverviewData = this.accountService.getAccountBalanceLimitsOverviewData();
        DataForBalanceLimitsSearch dataForBalanceLimitsSearch = this.balanceLimitsApiHelper.toDataForBalanceLimitsSearch(accountLimitsOverviewData);
        return this.ok(dataForBalanceLimitsSearch);
    }

    public ResponseEntity<UserAccountBalanceLimitsListData> getDataForUserBalanceLimits(String string, List<String> list) {
        List list2 = this.accountService.getUserAccountsBalanceLimits((UserLocatorVO)ModelHelper.voFromString(UserLocatorVO.class, (String)string));
        UserAccountBalanceLimitsListData userAccountBalanceLimitsListData = this.balanceLimitsApiHelper.toUserAccountBalanceLimitsListData(string, list2);
        return this.ok(userAccountBalanceLimitsListData);
    }

    public ResponseEntity<List<GeneralAccountBalanceLimitsResult>> searchAccountBalanceLimits(BalanceLimitsApi.SearchAccountBalanceLimitsParams searchAccountBalanceLimitsParams) {
        AccountBalanceLimitsOverviewQuery accountBalanceLimitsOverviewQuery = this.balanceLimitsApiHelper.toAccountBalanceLimitsOverviewQuery(searchAccountBalanceLimitsParams);
        Page page = this.accountService.searchAccountBalanceLimitsOverview(accountBalanceLimitsOverviewQuery);
        return this.pageResponse(page, this.balanceLimitsApiHelper::toGeneralAccountBalanceLimitsResult);
    }

    public ResponseEntity<Void> setAccountBalanceLimits(BalanceLimitsApi.SetAccountBalanceLimitsParams setAccountBalanceLimitsParams) {
        AccountBalanceLimitDTO accountBalanceLimitDTO = this.balanceLimitsApiHelper.toAccountBalanceLimitDTO(setAccountBalanceLimitsParams);
        this.accountService.setBalanceLimit(accountBalanceLimitDTO);
        return ResponseEntity.noContent().build();
    }
}

