/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.rest.api;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.cyclos.web.rest.api.AccountVisibilityApiImpl;
import org.cyclos.web.rest.model.DataForUserAccountVisibility;
import org.cyclos.web.rest.model.Error;
import org.cyclos.web.rest.model.SaveUserAccountVisibilityAsVisibleParams;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(produces={"application/json"})
public class AccountVisibilityApi {
    @Autowired
    private AccountVisibilityApiImpl impl;
    public static final String GET_USER_ACCOUNT_VISIBILITY_DATA = "/{user}/account-visibility";
    public static final String SAVE_USER_ACCOUNT_VISIBILITY = "/{user}/account-visibility";
    public static final String SET_USER_ACCOUNT_VISIBILITY_AS_HIDDEN = "/{user}/account-visibility/{accountType}/hide";
    public static final String SET_USER_ACCOUNT_VISIBILITY_AS_VISIBLE = "/{user}/account-visibility/{accountType}/show";

    @RequestMapping(value={"/api/{user:.*}/account-visibility"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<DataForUserAccountVisibility> getUserAccountVisibilityData(@PathVariable(value="user") String string, @RequestParam(value="fields", required=false) List<String> list, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"GET /{user}/account-visibility");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.getUserAccountVisibilityData(string, list);
    }

    @RequestMapping(value={"/api/{user:.*}/account-visibility"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    public ResponseEntity<Void> saveUserAccountVisibility(@PathVariable(value="user") String string, @RequestBody(required=true) SaveUserAccountVisibilityAsVisibleParams saveUserAccountVisibilityAsVisibleParams, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"PUT /{user}/account-visibility");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.saveUserAccountVisibility(string, saveUserAccountVisibilityAsVisibleParams);
    }

    @RequestMapping(value={"/api/{user:.*}/account-visibility/{accountType}/hide"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setUserAccountVisibilityAsHidden(@PathVariable(value="user") String string, @PathVariable(value="accountType") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/account-visibility/{accountType}/hide");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setUserAccountVisibilityAsHidden(string, string2);
    }

    @RequestMapping(value={"/api/{user:.*}/account-visibility/{accountType}/show"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> setUserAccountVisibilityAsVisible(@PathVariable(value="user") String string, @PathVariable(value="accountType") String string2, HttpServletRequest httpServletRequest) throws Exception {
        httpServletRequest.setAttribute("request", (Object)httpServletRequest);
        httpServletRequest.setAttribute("restOperation", (Object)"POST /{user}/account-visibility/{accountType}/show");
        httpServletRequest.setAttribute("errorType", Error.class);
        ServletHelper.denyGuest(httpServletRequest);
        return this.impl.setUserAccountVisibilityAsVisible(string, string2);
    }
}

