/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.system;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cyclos.model.banking.vouchertypes.VoucherTypeVO;
import org.cyclos.model.contentmanagement.imagecategories.SystemImageCategoryVO;
import org.cyclos.model.marketplace.advertisements.BasicAdVO;
import org.cyclos.model.marketplace.categories.AdCategoryVO;
import org.cyclos.model.system.configurations.ConfigurationImageType;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.configurations.ConfigurationVO;
import org.cyclos.model.system.fields.CustomFieldNature;
import org.cyclos.model.system.fields.CustomFieldVO;
import org.cyclos.model.system.images.ImageVO;
import org.cyclos.model.system.images.NewConfigurationImageParams;
import org.cyclos.model.system.images.NewTempImageParams;
import org.cyclos.model.system.images.TempImageTarget;
import org.cyclos.model.users.contactinfos.ContactInfoVO;
import org.cyclos.model.users.users.BasicUserVO;
import org.cyclos.model.users.users.UserLocatorVO;
import org.cyclos.server.utils.SerializableInputStream;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.banking.VoucherTypeImageService;
import org.cyclos.services.contentmanagement.SystemCustomImageService;
import org.cyclos.services.contentmanagement.UserCustomImageService;
import org.cyclos.services.marketplace.AdCategoryImageService;
import org.cyclos.services.marketplace.AdImageService;
import org.cyclos.services.system.ConfigurationImageService;
import org.cyclos.services.system.InternalImageService;
import org.cyclos.services.system.TempImageService;
import org.cyclos.services.users.ContactInfoImageService;
import org.cyclos.services.users.UserImageService;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.controllers.system.ConfigurationImageContentResolver;
import org.cyclos.web.controllers.system.ImageContentResolver;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class ImagesController
extends BaseController {
    @Autowired
    private InternalImageService internalImageService;
    @Autowired
    private TempImageService tempImageService;
    @Autowired
    private AdCategoryImageService adCategoryImageService;
    @Autowired
    private UserImageService userImageService;
    @Autowired
    private AdImageService adImageService;
    @Autowired
    private UserCustomImageService userCustomImageService;
    @Autowired
    private SystemCustomImageService systemCustomImageService;
    @Autowired
    private ConfigurationImageService configurationImageService;
    @Autowired
    private VoucherTypeImageService voucherTypeImageService;
    @Autowired
    private ContactInfoImageService contactInfoImageService;

    @GetMapping(value={"/content/images/configuration/{configurationId}/{type:.*}"})
    public void getConfiguration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="configurationId") Long l, @PathVariable(value="type") ConfigurationImageType configurationImageType, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws Exception {
        ConfigurationImageVO configurationImageVO = this.resolveConfigurationImage(httpServletRequest, httpServletResponse, l, configurationImageType, null);
        this.writeConfigurationImage(httpServletRequest, httpServletResponse, configurationImageVO, n, n2);
    }

    @GetMapping(value={"/content/images/configuration/{id:.*}"})
    public void getConfiguration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="id") Long l, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws Exception {
        ConfigurationImageVO configurationImageVO = this.resolveConfigurationImage(httpServletRequest, httpServletResponse, null, null, l);
        this.writeConfigurationImage(httpServletRequest, httpServletResponse, configurationImageVO, n, n2);
    }

    @GetMapping(value={"/content/images/configurationDefault/{type:.*}"})
    public void getConfigurationDefault(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="type") ConfigurationImageType configurationImageType, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws Exception {
        ConfigurationImageVO configurationImageVO = this.resolveConfigurationImage(httpServletRequest, httpServletResponse, null, configurationImageType, null);
        this.writeConfigurationImage(httpServletRequest, httpServletResponse, configurationImageVO, n, n2);
    }

    @GetMapping(value={"/content/images/{file:.*}"})
    public void getContent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="file") String string, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws Exception {
        ServletHelper.forceGuest(httpServletRequest);
        ImageContentResolver imageContentResolver = new ImageContentResolver(this.cyclosProperties, this.internalImageService, string, n, n2);
        imageContentResolver.write(httpServletRequest, httpServletResponse);
    }

    @GetMapping(value={"/content/images/currentConfiguration/{type:.*}"})
    public void getCurrentConfiguration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="type") ConfigurationImageType configurationImageType, @RequestParam(value="configurationId", required=false) Long l, @RequestParam(name="width", required=false) Integer n, @RequestParam(name="height", required=false) Integer n2) throws Exception {
        ConfigurationImageVO configurationImageVO = this.resolveConfigurationImage(httpServletRequest, httpServletResponse, l, configurationImageType, null);
        this.writeConfigurationImage(httpServletRequest, httpServletResponse, configurationImageVO, n, n2);
    }

    @GetMapping(value={"/favicon.ico"})
    public void getFavicon(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.getConfigurationDefault(httpServletRequest, httpServletResponse, ConfigurationImageType.SHORTCUT_ICON, null, null);
    }

    @PostMapping(value={"/content/images/productsAndServices/{adId:.*}"})
    public void postAd(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="adId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.adImageService.save((Object)new BasicAdVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/adCategory/{adCategoryId:.*}"})
    public void postAdCategory(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="adCategoryId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.adCategoryImageService.save((Object)new AdCategoryVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/configuration/{configurationId}/{type:.*}"})
    public void postConfiguration(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="configurationId") Long l, @PathVariable(value="type") ConfigurationImageType configurationImageType) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            NewConfigurationImageParams newConfigurationImageParams = new NewConfigurationImageParams();
            newConfigurationImageParams.setConfigurationId(l);
            newConfigurationImageParams.setType(configurationImageType);
            this.configurationImageService.save((Object)newConfigurationImageParams, multipartFile.getOriginalFilename(), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/contactInfo/{contactInfoId:.*}"})
    public void postContactInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="contactInfoId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.contactInfoImageService.save((Object)new ContactInfoVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/userCustom/{ownerId:.*}"})
    public void postCustomUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="ownerId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.userCustomImageService.save((Object)new UserLocatorVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/systemCustom"})
    public void postSystemCustom(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam(value="categoryId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.systemCustomImageService.save((Object)new SystemImageCategoryVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/temp"})
    public void postTemp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @RequestParam(name="name", required=false) String string, @RequestParam(name="guestKey", required=false) String string2, @RequestParam(name="target", required=true) TempImageTarget tempImageTarget, @RequestParam(name="userId", required=false) Long l, @RequestParam(name="customFieldId", required=false) Long l2, @RequestParam(name="customFieldNature", required=false) CustomFieldNature customFieldNature) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            CustomFieldVO customFieldVO;
            NewTempImageParams newTempImageParams = new NewTempImageParams();
            newTempImageParams.setTarget(tempImageTarget);
            newTempImageParams.setGuestKey(string2);
            if (l2 != null) {
                customFieldVO = new CustomFieldVO(l2);
                customFieldVO.setNature(customFieldNature);
                newTempImageParams.setCustomField(customFieldVO);
            }
            if (l != null) {
                newTempImageParams.setUser(new BasicUserVO(l));
            }
            customFieldVO = this.tempImageService.save((Object)newTempImageParams, this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, (ImageVO)customFieldVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/user/{ownerId:.*}"})
    public void postUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="ownerId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.userImageService.save((Object)new UserLocatorVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    @PostMapping(value={"/content/images/voucherType/{voucherTypeId:.*}"})
    public void postVoucherType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="file") MultipartFile multipartFile, @PathVariable(value="voucherTypeId") Long l, @RequestParam(name="name", required=false) String string) throws Exception {
        if (!this.checkContentType(multipartFile.getContentType(), httpServletRequest, httpServletResponse)) {
            return;
        }
        try {
            ImageVO imageVO = this.voucherTypeImageService.save((Object)new VoucherTypeVO(l), this.getImageName(string, multipartFile), new SerializableInputStream(multipartFile.getInputStream()), multipartFile.getContentType());
            this.writeUploadSuccess(httpServletRequest, httpServletResponse, imageVO);
        }
        catch (Exception exception) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, exception);
        }
    }

    private boolean checkContentType(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            ServerImageHelper.ImageType.getByContentType((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ServletHelper.writeJsonErrorToResponse(httpServletRequest, httpServletResponse, illegalArgumentException);
            return false;
        }
        return true;
    }

    private String getImageName(String string, MultipartFile multipartFile) {
        if (StringHelper.isBlank((Object)string)) {
            string = this.trimImageExtension(multipartFile.getOriginalFilename());
        }
        return string;
    }

    private ConfigurationImageVO resolveConfigurationImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Long l, ConfigurationImageType configurationImageType, Long l2) {
        ServletHelper.forceGuest(httpServletRequest);
        if (l2 != null) {
            return this.configurationImageService.load(l2);
        }
        ConfigurationVO configurationVO = l == null ? null : new ConfigurationVO(l);
        return this.configurationImageService.getImageVO(configurationVO, configurationImageType);
    }

    private String trimImageExtension(String string) {
        String string2 = "";
        if (StringHelper.isNotBlank((Object)string)) {
            int n = string.lastIndexOf(46);
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void writeConfigurationImage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ConfigurationImageVO configurationImageVO, Integer n, Integer n2) throws IOException {
        ConfigurationImageContentResolver configurationImageContentResolver = new ConfigurationImageContentResolver(this.cyclosProperties, this.internalImageService, configurationImageVO, n, n2);
        configurationImageContentResolver.write(httpServletRequest, httpServletResponse);
    }

    private void writeUploadSuccess(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ImageVO imageVO) throws IOException {
        ServletHelper.writeUploadSuccess(httpServletRequest, httpServletResponse, "result", imageVO);
    }
}

