/*
 * Decompiled with CFR 0.152.
 */
package org.cyclos.web.controllers.index;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cyclos.CyclosVersion;
import org.cyclos.model.CyclosException;
import org.cyclos.model.access.BasicInitializationData;
import org.cyclos.model.access.RemoteAddressBlockedException;
import org.cyclos.model.access.RequestData;
import org.cyclos.model.general.GeneralKeys;
import org.cyclos.model.system.configurations.ConfigurationImageVO;
import org.cyclos.model.system.configurations.Frontend;
import org.cyclos.model.system.languages.BuiltinLanguage;
import org.cyclos.model.utils.Cookie;
import org.cyclos.model.utils.CountryVO;
import org.cyclos.model.utils.NotificationLevel;
import org.cyclos.server.model.app.WebManifestData;
import org.cyclos.server.utils.ReservedUris;
import org.cyclos.server.utils.ServerImageHelper;
import org.cyclos.services.access.InitializationService;
import org.cyclos.services.access.LoginService;
import org.cyclos.services.access.ServiceFacade;
import org.cyclos.services.app.InternalFrontendService;
import org.cyclos.services.system.LocalizationService;
import org.cyclos.utils.ContentType;
import org.cyclos.utils.MessageFormat;
import org.cyclos.utils.MessageKey;
import org.cyclos.utils.ObjectHelper;
import org.cyclos.utils.StringHelper;
import org.cyclos.web.controllers.BaseController;
import org.cyclos.web.utils.ServletHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IndexController
extends BaseController {
    @Autowired
    private LoginService loginService;
    @Autowired
    private InitializationService initializationService;
    @Autowired
    private LocalizationService localizationService;
    @Autowired
    private InternalFrontendService internalFrontendService;
    private Map<BuiltinLanguage, String> encodedCountriesPerLanguage = new HashMap<BuiltinLanguage, String>();
    @Autowired
    private ServiceFacade serviceFacade;

    @RequestMapping(value={"/classic"})
    public ModelAndView classic(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.doIndex(httpServletRequest, httpServletResponse, true, false, null, null, false);
    }

    @RequestMapping(value={"/error"})
    public ModelAndView error(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string;
        String string2;
        if (Boolean.TRUE.equals(httpServletRequest.getAttribute("ignoreError"))) {
            return null;
        }
        if (httpServletResponse.isCommitted()) {
            Throwable throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception");
            String string3 = (String)httpServletRequest.getAttribute("javax.servlet.error.message");
            String string4 = (String)httpServletRequest.getAttribute("javax.servlet.error.request_uri");
            String string5 = (String)httpServletRequest.getAttribute("javax.servlet.error.servlet_name");
            Integer n = (Integer)httpServletRequest.getAttribute("javax.servlet.error.status_code");
            this.getLogger().error(String.format("Response already committed on error handler - URI: %s Servlet: %s, Status code: %d, Message: %s", string4, string5, n, string3), throwable);
            return null;
        }
        Throwable throwable = (Throwable)httpServletRequest.getAttribute("originalError");
        if (throwable == null) {
            throwable = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception");
            httpServletRequest.setAttribute("originalError", (Object)throwable);
            if (!(throwable instanceof CyclosException)) {
                string2 = (String)httpServletRequest.getAttribute("javax.servlet.error.message");
                string = (String)httpServletRequest.getAttribute("javax.servlet.error.request_uri");
                String string6 = (String)httpServletRequest.getAttribute("javax.servlet.error.servlet_name");
                Integer n = (Integer)httpServletRequest.getAttribute("javax.servlet.error.status_code");
                this.getLogger().error(String.format("Servlet error - URI: %s Servlet: %s, Status code: %d, Message: %s", string, string6, n, string2), throwable);
            }
        } else {
            Throwable throwable2 = (Throwable)httpServletRequest.getAttribute("javax.servlet.error.exception");
            ServletHelper.setContentType(httpServletResponse, ContentType.HTML);
            httpServletResponse.setCharacterEncoding("UTF-8");
            try (InputStream inputStream = httpServletRequest.getServletContext().getResourceAsStream("/WEB-INF/pages/basicStyle.html");
                 PrintWriter printWriter = httpServletResponse.getWriter();){
                printWriter.println("<!DOCTYPE html>\n");
                printWriter.println("<html>\n");
                printWriter.println("<head>\n");
                printWriter.println("<title>Error</title>\n");
                if (inputStream != null) {
                    List list = IOUtils.readLines((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    list.forEach(printWriter::println);
                }
                printWriter.println("</head>\n");
                printWriter.println("<body>\n");
                printWriter.println("<h1>Error</h1>\n");
                printWriter.println("<p class='emphasis'><br>An error has ocurred:</p>\n");
                printWriter.println("<pre>\n");
                throwable.printStackTrace(printWriter);
                printWriter.println("</pre>\n");
                if (throwable2 != null) {
                    printWriter.println("<p class='emphasis'><br>");
                    printWriter.println("However, when it was being handled, another error occurred:</p>\n");
                    printWriter.println("<pre>\n");
                    throwable2.printStackTrace(printWriter);
                    printWriter.println("</pre>\n");
                }
                printWriter.println("</body>\n");
                printWriter.println("</html>\n");
            }
            return null;
        }
        ServletHelper.forceGuest(httpServletRequest);
        string2 = this.errorKey(httpServletRequest.getParameter("key"));
        try {
            string = ServletHelper.runAsLocal(() -> this.lambda$error$0((MessageKey)string2));
        }
        catch (Exception exception) {
            string = string2.key();
        }
        if (Arrays.asList(GeneralKeys.Errors.NOT_FOUND, GeneralKeys.Errors.REMOTE_ADDRESS_BLOCKED).contains(string2)) {
            return ServletHelper.showError(string);
        }
        return this.doIndex(httpServletRequest, httpServletResponse, false, false, NotificationLevel.ERROR, string, true);
    }

    @RequestMapping(value={"/", "/index"})
    public ModelAndView index(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getHeader("User-Agent");
        if (string != null && (string.contains("MSIE") || string.contains("rv:11.0)"))) {
            return this.sendNotification(NotificationLevel.ERROR, this.message(MessageFormat.HTML, GeneralKeys.Ui.BROWSER_NOT_SUPPORTED, new Object[0]), true);
        }
        return this.doIndex(httpServletRequest, httpServletResponse, true, true, null, null, false);
    }

    public Map<String, Object> indexModel(RequestData requestData, BasicInitializationData basicInitializationData) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cyclosVersion", CyclosVersion.get());
        hashMap.put("cyclosCommitId", CyclosVersion.getCommitId());
        hashMap.put("resourceCacheKey", this.serviceFacade.getResourceCacheKey());
        hashMap.put("reservedUris", ReservedUris.internal());
        hashMap.put("browserNotSupported", this.message(MessageFormat.HTML, GeneralKeys.Ui.BROWSER_NOT_SUPPORTED, new Object[0]));
        hashMap.put("problemsLoading", this.message(MessageFormat.HTML, GeneralKeys.Ui.PROBLEMS_LOADING, "javascript:location.reload()"));
        hashMap.put("initializationData", basicInitializationData);
        hashMap.put("shortcutIconUrl", ServerImageHelper.getConfigurationImageUrl((RequestData)requestData, (ConfigurationImageVO)basicInitializationData.getShortcutIcon(), (String)basicInitializationData.getResourceCacheKey()));
        hashMap.put("license", basicInitializationData.getLicense());
        hashMap.put("countries", this.encodeCountries(basicInitializationData.getBuiltinLanguage()));
        return hashMap;
    }

    @RequestMapping(value={"/manifest.webmanifest"})
    @ResponseBody
    public WebManifestData webManifest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.internalFrontendService.getWebManifestData(false);
    }

    private ModelAndView doIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, boolean bl2, NotificationLevel notificationLevel, String string, boolean bl3) throws IOException, ServletException {
        BasicInitializationData basicInitializationData;
        RequestData requestData = ServletHelper.getRequestData();
        ServletHelper.forceGuest(httpServletRequest);
        ServletHelper.setNoCache(httpServletResponse);
        if (requestData.isDefaultGlobal()) {
            String string2 = httpServletRequest.getContextPath() + "/global/" + StringUtils.removeStart((String)requestData.getUri(), (String)"/");
            if (StringHelper.isNotBlank((Object)httpServletRequest.getQueryString())) {
                string2 = string2 + "?" + httpServletRequest.getQueryString();
            }
            httpServletResponse.sendRedirect(string2);
            return null;
        }
        Object object = ObjectHelper.coalesce((Object[])new String[]{StringHelper.trimToNull((Object)httpServletRequest.getParameter("sessionToken")), StringHelper.trimToNull((Object)httpServletRequest.getParameter("Session-Token"))});
        if (object != null) {
            Object object2;
            String string3 = this.message(MessageFormat.HTML, GeneralKeys.Ui.BROWSER_NOT_SUPPORTED, new Object[0]);
            String string4 = this.initializationService.getResourceCacheKey();
            ServletHelper.setSessionToken(httpServletRequest, (String)object);
            if (bl && (object2 = this.loginService.replaceSession()) != null) {
                object = object2;
            }
            object2 = ServletHelper.splitSessionToken((String)object);
            ServletHelper.setSessionToken(httpServletRequest, httpServletResponse, (String)object2.getSecond());
            return new ModelAndView("store-session").addObject("reservedUris", (Object)ReservedUris.all()).addObject("resourceCacheKey", (Object)string4).addObject("sessionPrefix", object2.getFirst()).addObject("browserNotSupported", (Object)string3).addObject("returnTo", (Object)StringHelper.trimToNull((Object)httpServletRequest.getParameter("returnTo")));
        }
        try {
            basicInitializationData = this.initializationService.getBasicInitializationData();
        }
        catch (RemoteAddressBlockedException remoteAddressBlockedException) {
            ServletHelper.runAsLocal(() -> {
                httpServletRequest.getRequestDispatcher("/error?key=remoteAddressBlocked").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return null;
            });
            return null;
        }
        String string5 = StringHelper.trimToNull((Object)httpServletRequest.getParameter("inviteToken"));
        if (string5 != null) {
            ServletHelper.sendCookie(httpServletRequest, httpServletResponse, null, false, true, Cookie.INVITE_TOKEN, string5);
        }
        if (bl2 && basicInitializationData.getFrontend() == Frontend.NEW) {
            httpServletResponse.sendRedirect(requestData.getBaseUrl() + "/ui/");
            return null;
        }
        if (string5 != null) {
            httpServletResponse.sendRedirect(requestData.getBaseUrl());
            return null;
        }
        return new ModelAndView("index").addObject("notificationLevel", (Object)notificationLevel).addObject("notificationMessage", (Object)string).addObject("notificationOnly", (Object)bl3).addAllObjects(this.indexModel(requestData, basicInitializationData));
    }

    private String encodeCountries(BuiltinLanguage builtinLanguage) {
        String string = this.encodedCountriesPerLanguage.get(builtinLanguage);
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (CountryVO countryVO : this.localizationService.listCountries()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(countryVO.getCode()).append('~').append(countryVO.getName());
            }
            string = stringBuilder.toString();
            this.encodedCountriesPerLanguage.put(builtinLanguage, string);
        }
        return string;
    }

    private MessageKey errorKey(String string) {
        switch ((String)ObjectHelper.defaultValue((Object)string, (Object)"general")) {
            case "permissionDenied": {
                return GeneralKeys.Errors.PERMISSION_DENIED;
            }
            case "notFound": {
                return GeneralKeys.Errors.NOT_FOUND;
            }
            case "illegalAction": {
                return GeneralKeys.Errors.ILLEGAL_ACTION;
            }
            case "validation": {
                return GeneralKeys.Errors.VALIDATION;
            }
            case "sessionExpired": {
                return GeneralKeys.Errors.SESSION_EXPIRED;
            }
            case "badRequest": {
                return GeneralKeys.Errors.BAD_REQUEST;
            }
            case "remoteAddressBlocked": {
                return GeneralKeys.Errors.REMOTE_ADDRESS_BLOCKED;
            }
        }
        return GeneralKeys.Errors.GENERAL;
    }

    private /* synthetic */ String lambda$error$0(MessageKey messageKey) throws Exception {
        return this.message(messageKey, new Object[0]);
    }
}

