/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.sql;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.AbstractSQLQuery;
import com.querydsl.jpa.NativeSQLSerializer;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.impl.JPAProvider;
import com.querydsl.jpa.impl.JPAUtil;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.SQLSerializer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractJPASQLQuery<T, Q extends AbstractJPASQLQuery<T, Q>>
extends AbstractSQLQuery<T, Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJPASQLQuery.class);
    private final EntityManager entityManager;
    protected final Multimap<String, Object> hints = HashMultimap.create();
    protected final QueryHandler queryHandler;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;
    @Nullable
    protected FactoryExpression<?> projection;

    public AbstractJPASQLQuery(EntityManager em, Configuration configuration) {
        this(em, configuration, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPASQLQuery(EntityManager em, Configuration configuration, QueryHandler queryHandler) {
        this(em, configuration, queryHandler, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPASQLQuery(EntityManager em, Configuration configuration, QueryMetadata metadata) {
        this(em, configuration, JPAProvider.getTemplates(em).getQueryHandler(), metadata);
    }

    public AbstractJPASQLQuery(EntityManager em, Configuration configuration, QueryHandler queryHandler, QueryMetadata metadata) {
        super(metadata, configuration);
        this.entityManager = em;
        this.queryHandler = queryHandler;
    }

    public Query createQuery() {
        return this.createQuery(false);
    }

    private Query createQuery(boolean forCount) {
        NativeSQLSerializer serializer = (NativeSQLSerializer)this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString, serializer.getConstantToAllLabels());
        Expression projection = this.queryMixin.getMetadata().getProjection();
        Query query = !FactoryExpression.class.isAssignableFrom(projection.getClass()) && this.isEntityExpression(projection) ? (this.queryHandler.createNativeQueryTyped() ? this.entityManager.createNativeQuery(queryString, projection.getType()) : this.entityManager.createNativeQuery(queryString)) : this.entityManager.createNativeQuery(queryString);
        if (!forCount) {
            ListMultimap<Expression<?>, String> aliases = serializer.getAliases();
            HashSet used = Sets.newHashSet();
            if (projection instanceof FactoryExpression) {
                block0: for (Expression expr : ((FactoryExpression)projection).getArgs()) {
                    if (this.isEntityExpression(expr)) {
                        this.queryHandler.addEntity(query, this.extractEntityExpression(expr).toString(), expr.getType());
                        continue;
                    }
                    if (!aliases.containsKey((Object)expr)) continue;
                    for (String scalar : aliases.get((Object)expr)) {
                        if (used.contains(scalar)) continue;
                        this.queryHandler.addScalar(query, scalar, expr.getType());
                        used.add(scalar);
                        continue block0;
                    }
                }
            } else if (this.isEntityExpression(projection)) {
                this.queryHandler.addEntity(query, this.extractEntityExpression(projection).toString(), projection.getType());
            } else if (aliases.containsKey((Object)projection)) {
                for (String scalar : aliases.get((Object)projection)) {
                    if (used.contains(scalar)) continue;
                    this.queryHandler.addScalar(query, scalar, projection.getType());
                    used.add(scalar);
                    break;
                }
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry entry : this.hints.entries()) {
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        JPAUtil.setConstants(query, serializer.getConstantToAllLabels(), this.queryMixin.getMetadata().getParams());
        this.projection = null;
        if (projection instanceof FactoryExpression && !this.queryHandler.transform(query, (FactoryExpression)projection)) {
            this.projection = (FactoryExpression)projection;
        }
        return query;
    }

    protected SQLSerializer createSerializer() {
        return new NativeSQLSerializer(this.configuration, this.queryHandler.wrapEntityProjections());
    }

    private List<?> getResultList(Query query) {
        if (this.projection != null) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            for (Object o : results) {
                if (o != null) {
                    Object[] arr = !o.getClass().isArray() ? new Object[]{o} : (Object[])o;
                    if (this.projection.getArgs().size() < arr.length) {
                        Object[] shortened = new Object[this.projection.getArgs().size()];
                        System.arraycopy(arr, 0, shortened, 0, shortened.length);
                        arr = shortened;
                    }
                    rv.add(this.projection.newInstance(arr));
                    continue;
                }
                rv.add(null);
            }
            return rv;
        }
        return query.getResultList();
    }

    @Nullable
    private Object getSingleResult(Query query) {
        if (this.projection != null) {
            Object[] result = query.getSingleResult();
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return this.projection.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public List<T> fetch() {
        try {
            Query query = this.createQuery();
            List<?> list = this.getResultList(query);
            return list;
        }
        finally {
            this.reset();
        }
    }

    public CloseableIterator<T> iterate() {
        try {
            Query query = this.createQuery();
            CloseableIterator closeableIterator = this.queryHandler.iterate(query, null);
            return closeableIterator;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults<T> fetchResults() {
        try {
            Query query = this.createQuery(true);
            long total = ((Number)query.getSingleResult()).longValue();
            if (total > 0L) {
                QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
                query = this.createQuery(false);
                List<?> list = this.getResultList(query);
                QueryResults queryResults = new QueryResults(list, modifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString, Map<Object, String> parameters) {
        if (logger.isDebugEnabled()) {
            String normalizedQuery = queryString.replace('\n', ' ');
            MDC.put((String)"querydsl.query", (String)normalizedQuery);
            MDC.put((String)"querydsl.parameters", (String)String.valueOf(parameters));
            logger.debug(normalizedQuery);
        }
    }

    protected void cleanupMDC() {
        MDC.remove((String)"querydsl.query");
        MDC.remove((String)"querydsl.parameters");
    }

    protected void reset() {
        this.cleanupMDC();
    }

    public T fetchOne() throws NonUniqueResultException {
        Query query = this.createQuery();
        return (T)this.uniqueResult(query);
    }

    @Nullable
    private Object uniqueResult(Query query) {
        try {
            Object object = this.getSingleResult(query);
            return object;
        }
        catch (NoResultException e) {
            logger.trace(e.getMessage(), (Throwable)e);
            Object var3_5 = null;
            return var3_5;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException((Exception)((Object)e));
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)((Object)this);
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)((Object)this);
    }

    public Q setHint(String name, Object value) {
        this.hints.put((Object)name, value);
        return (Q)((Object)this);
    }

    protected void clone(Q query) {
        super.clone(query);
        this.flushMode = ((AbstractJPASQLQuery)((Object)query)).flushMode;
        this.hints.putAll(((AbstractJPASQLQuery)((Object)query)).hints);
        this.lockMode = ((AbstractJPASQLQuery)((Object)query)).lockMode;
        this.projection = ((AbstractJPASQLQuery)((Object)query)).projection;
    }

    public abstract Q clone(EntityManager var1);

    public Q clone() {
        return this.clone(this.entityManager);
    }
}

