/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.querydsl.core.JoinType;
import com.querydsl.core.dml.DeleteClause;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.JPAQueryMixin;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.impl.JPAProvider;
import com.querydsl.jpa.impl.JPAUtil;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;

public class JPADeleteClause
implements DeleteClause<JPADeleteClause> {
    private final QueryMixin<?> queryMixin = new JPAQueryMixin();
    private final EntityManager entityManager;
    private final JPQLTemplates templates;
    @Nullable
    private LockModeType lockMode;

    public JPADeleteClause(EntityManager em, EntityPath<?> entity) {
        this(em, entity, JPAProvider.getTemplates(em));
    }

    public JPADeleteClause(EntityManager entityManager, EntityPath<?> entity, JPQLTemplates templates) {
        this.entityManager = entityManager;
        this.templates = templates;
        this.queryMixin.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForDelete(this.queryMixin.getMetadata());
        Map constants = serializer.getConstantToAllLabels();
        Query query = this.entityManager.createQuery(serializer.toString());
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        JPAUtil.setConstants(query, constants, this.queryMixin.getMetadata().getParams());
        return query.executeUpdate();
    }

    public JPADeleteClause where(Predicate ... o) {
        for (Predicate p : o) {
            this.queryMixin.where(p);
        }
        return this;
    }

    public JPADeleteClause setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForDelete(this.queryMixin.getMetadata());
        return serializer.toString();
    }
}

