/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.JoinFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.Context;
import com.querydsl.core.support.PathsExtractor;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.support.ReplaceVisitor;
import com.querydsl.core.types.CollectionExpression;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.CollectionPathBase;
import com.querydsl.jpa.Conversions;
import com.querydsl.jpa.JPACollectionAnyVisitor;
import com.querydsl.jpa.JPAListAccessVisitor;
import com.querydsl.jpa.JPAMapAccessVisitor;
import com.querydsl.jpa.JPQLOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Entity;

public class JPAQueryMixin<T>
extends QueryMixin<T> {
    private final Set<Path<?>> paths = Sets.newHashSet();
    private final Map<Expression<?>, Path<?>> aliases = Maps.newHashMap();
    private final JPAMapAccessVisitor mapAccessVisitor;
    private final JPAListAccessVisitor listAccessVisitor;
    private final JPACollectionAnyVisitor collectionAnyVisitor;
    private final ReplaceVisitor<Void> replaceVisitor = new ReplaceVisitor<Void>(){

        public Expression<?> visit(Path<?> expr, Void context) {
            return JPAQueryMixin.this.convertPathForOrder(expr);
        }

        public Expression<?> visit(SubQueryExpression<?> expr, @Nullable Void context) {
            return expr;
        }
    };
    public static final JoinFlag FETCH = new JoinFlag("fetch ");
    public static final JoinFlag FETCH_ALL_PROPERTIES = new JoinFlag(" fetch all properties");

    public JPAQueryMixin() {
        this(null, (QueryMetadata)new DefaultQueryMetadata());
    }

    public JPAQueryMixin(QueryMetadata metadata) {
        this(null, metadata);
    }

    public JPAQueryMixin(T self, QueryMetadata metadata) {
        super(self, metadata);
        this.mapAccessVisitor = new JPAMapAccessVisitor(metadata, this.aliases);
        this.listAccessVisitor = new JPAListAccessVisitor(metadata, this.aliases);
        this.collectionAnyVisitor = new JPACollectionAnyVisitor();
    }

    public T fetchJoin() {
        this.addJoinFlag(FETCH);
        return (T)this.getSelf();
    }

    public T fetchAll() {
        this.addJoinFlag(FETCH_ALL_PROPERTIES);
        return (T)this.getSelf();
    }

    protected <D> Expression<D> createAlias(Expression<?> expr, Path<D> alias) {
        this.aliases.put(expr, alias);
        return super.createAlias(expr, alias);
    }

    static boolean isEntityPath(Path<?> path) {
        if (path instanceof CollectionPathBase) {
            return JPAQueryMixin.isEntityPath((Path)((CollectionPathBase)path).any());
        }
        return path instanceof EntityPath || path.getType().isAnnotationPresent(Entity.class);
    }

    static <T> Class<T> getElementTypeOrType(Path<T> path) {
        if (path instanceof CollectionExpression) {
            return ((CollectionExpression)path).getParameter(0);
        }
        return path.getType();
    }

    private <T> Path<T> shorten(Path<T> path, List<Path<?>> paths) {
        PathMetadata metadata = path.getMetadata();
        if (metadata.isRoot() || paths.contains(path)) {
            return path;
        }
        if (this.aliases.containsKey(path)) {
            return this.aliases.get(path);
        }
        if (metadata.getPathType() == PathType.COLLECTION_ANY) {
            return this.shorten(metadata.getParent(), paths);
        }
        if (!JPAQueryMixin.isEntityPath(path)) {
            Path<T> parent = this.shorten(metadata.getParent(), paths);
            if (parent.equals((Object)metadata.getParent())) {
                return path;
            }
            return ExpressionUtils.path((Class)path.getType(), (PathMetadata)new PathMetadata(parent, metadata.getElement(), metadata.getPathType()));
        }
        if (metadata.getParent().getMetadata().isRoot()) {
            Class<T> type = JPAQueryMixin.getElementTypeOrType(path);
            Path newPath = ExpressionUtils.path(type, (String)ExpressionUtils.createRootVariable(path));
            this.leftJoin((Expression)path, newPath);
            return newPath;
        }
        Class<T> type = JPAQueryMixin.getElementTypeOrType(path);
        Path<T> parent = this.shorten(metadata.getParent(), paths);
        Path oldPath = ExpressionUtils.path((Class)path.getType(), (PathMetadata)new PathMetadata(parent, metadata.getElement(), metadata.getPathType()));
        Path newPath = ExpressionUtils.path(type, (String)ExpressionUtils.createRootVariable((Path)oldPath));
        this.aliases.put((Expression<?>)path, (Path<?>)newPath);
        this.leftJoin((Expression)oldPath, newPath);
        return newPath;
    }

    private <T> Path<T> convertPathForOrder(Path<T> path) {
        PathMetadata metadata = path.getMetadata();
        if (metadata.getParent() != null && !metadata.getParent().getMetadata().isRoot()) {
            HashSet exprs = Sets.newHashSet();
            QueryMetadata md = this.getMetadata();
            exprs.addAll(md.getGroupBy());
            if (md.getProjection() != null) {
                exprs.add(md.getProjection());
            }
            if (md.getWhere() != null) {
                exprs.add(md.getWhere());
            }
            if (md.getHaving() != null) {
                exprs.add(md.getHaving());
            }
            ArrayList paths = Lists.newArrayList();
            PathsExtractor.DEFAULT.visit((Collection)exprs, (List)paths);
            if (!paths.contains(path) && !paths.contains(metadata.getParent())) {
                Path<T> shortened = this.shorten(metadata.getParent(), paths);
                return ExpressionUtils.path((Class)path.getType(), (PathMetadata)new PathMetadata(shortened, metadata.getElement(), metadata.getPathType()));
            }
            return path;
        }
        return path;
    }

    public <RT> Expression<RT> convert(Expression<RT> expr, QueryMixin.Role role) {
        expr = (Expression)expr.accept((Visitor)this.mapAccessVisitor, null);
        expr = (Expression)expr.accept((Visitor)this.listAccessVisitor, null);
        if (role == QueryMixin.Role.ORDER_BY) {
            expr = expr instanceof Path ? this.convertPathForOrder((Path)expr) : (Expression)expr.accept(this.replaceVisitor, null);
        }
        return Conversions.convert(super.convert(expr, role));
    }

    protected Predicate convert(Predicate predicate, QueryMixin.Role role) {
        if (predicate != null) {
            predicate = (Predicate)ExpressionUtils.extract((Expression)predicate);
        }
        if (predicate != null) {
            predicate = (Predicate)predicate.accept((Visitor)this.mapAccessVisitor, null);
            predicate = (Predicate)predicate.accept((Visitor)this.listAccessVisitor, null);
        }
        if (predicate != null) {
            predicate = (Predicate)predicate.accept((Visitor)this.collectionAnyVisitor, (Object)new Context());
            return predicate;
        }
        return null;
    }

    private void addCondition(Context context, int i, Path<?> path, boolean where) {
        this.paths.add(path);
        EntityPath alias = (EntityPath)context.replacements.get(i);
        this.leftJoin((Expression)path.getMetadata().getParent(), (Path)context.replacements.get(i));
        Operation index = ExpressionUtils.operation(Integer.class, (Operator)JPQLOps.INDEX, (Expression[])new Expression[]{alias});
        Object element = path.getMetadata().getElement();
        if (!(element instanceof Expression)) {
            element = ConstantImpl.create((Object)element);
        }
        Predicate condition = ExpressionUtils.eq((Expression)index, (Expression)((Expression)element));
        if (where) {
            super.where(condition);
        } else {
            super.having(condition);
        }
    }
}

