/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import org.opensearch.LegacyESVersion;
import org.opensearch.common.ParseField;
import org.opensearch.common.Strings;
import org.opensearch.common.TriFunction;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ObjectParser;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.script.Script;
import org.opensearch.search.aggregations.support.BaseMultiValuesSourceFieldConfig;

public class MultiValuesSourceFieldConfig
extends BaseMultiValuesSourceFieldConfig {
    private final QueryBuilder filter;
    private static final String NAME = "field_config";
    public static final ParseField FILTER = new ParseField("filter", new String[0]);
    public static final TriFunction<Boolean, Boolean, Boolean, ObjectParser<Builder, Void>> PARSER = (scriptable, timezoneAware, filtered) -> {
        ObjectParser parser = new ObjectParser(NAME, Builder::new);
        BaseMultiValuesSourceFieldConfig.PARSER.apply((ObjectParser<BaseMultiValuesSourceFieldConfig.Builder<BaseMultiValuesSourceFieldConfig, BaseMultiValuesSourceFieldConfig.Builder<?, ?>>, Void>)parser, (Boolean)scriptable, (Boolean)timezoneAware);
        if (filtered.booleanValue()) {
            parser.declareField(Builder::setFilter, (p, context) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), FILTER, ObjectParser.ValueType.OBJECT);
        }
        return parser;
    };

    protected MultiValuesSourceFieldConfig(String fieldName, Object missing, Script script, ZoneId timeZone, QueryBuilder filter) {
        super(fieldName, missing, script, timeZone);
        this.filter = filter;
    }

    public MultiValuesSourceFieldConfig(StreamInput in) throws IOException {
        super(in);
        this.filter = in.getVersion().onOrAfter(LegacyESVersion.V_7_8_0) ? in.readOptionalNamedWriteable(QueryBuilder.class) : null;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_8_0)) {
            out.writeOptionalNamedWriteable(this.filter);
        }
    }

    @Override
    public void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.filter != null) {
            builder.field(FILTER.getPreferredName());
            this.filter.toXContent(builder, params);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiValuesSourceFieldConfig that = (MultiValuesSourceFieldConfig)o;
        return Objects.equals(this.filter, that.filter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filter);
    }

    public static class Builder
    extends BaseMultiValuesSourceFieldConfig.Builder<BaseMultiValuesSourceFieldConfig, Builder> {
        private QueryBuilder filter = null;

        public Builder setFilter(QueryBuilder filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public MultiValuesSourceFieldConfig build() {
            if (Strings.isNullOrEmpty(this.fieldName) && this.script == null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be null.  Please specify one or the other.");
            }
            if (!Strings.isNullOrEmpty(this.fieldName) && this.script != null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be configured.  Please specify one or the other.");
            }
            return new MultiValuesSourceFieldConfig(this.fieldName, this.missing, this.script, this.timeZone, this.filter);
        }
    }
}

