/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.List;
import java.util.Map;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.opensearch.common.Explicit;
import org.opensearch.common.geo.GeometryParser;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.geo.builders.ShapeBuilder;
import org.opensearch.geometry.Geometry;
import org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoShapeIndexer;
import org.opensearch.index.mapper.GeoShapeParser;
import org.opensearch.index.mapper.GeoShapeQueryable;
import org.opensearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.VectorGeoShapeQueryProcessor;

public class GeoShapeFieldMapper
extends AbstractShapeGeometryFieldMapper<Geometry, Geometry> {
    public static final String CONTENT_TYPE = "geo_shape";
    public static final FieldType FIELD_TYPE = new FieldType();

    public GeoShapeFieldMapper(String simpleName, FieldType fieldType, MappedFieldType mappedFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Explicit<ShapeBuilder.Orientation> orientation, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, ignoreMalformed, coerce, ignoreZValue, orientation, multiFields, copyTo);
    }

    @Override
    protected void addStoredFields(ParseContext context, Geometry geometry) {
    }

    @Override
    protected void addDocValuesFields(String name, Geometry geometry, List fields, ParseContext context) {
    }

    @Override
    protected void addMultiFields(ParseContext context, Geometry geometry) {
    }

    @Override
    protected void mergeGeoOptions(AbstractShapeGeometryFieldMapper<?, ?> mergeWith, List<String> conflicts) {
        if (mergeWith instanceof LegacyGeoShapeFieldMapper) {
            LegacyGeoShapeFieldMapper legacy = (LegacyGeoShapeFieldMapper)mergeWith;
            throw new IllegalArgumentException("[" + this.fieldType().name() + "] with field mapper [" + this.fieldType().typeName() + "] using [BKD] strategy cannot be merged with [" + legacy.fieldType().typeName() + "] with [" + legacy.fieldType().strategy() + "] strategy");
        }
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected boolean docValuesByDefault() {
        return false;
    }

    static {
        FIELD_TYPE.setDimensions(7, 4, 4);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.freeze();
    }

    public static class GeoShapeFieldType
    extends AbstractShapeGeometryFieldMapper.AbstractShapeGeometryFieldType<Geometry, Geometry>
    implements GeoShapeQueryable {
        private final VectorGeoShapeQueryProcessor queryProcessor = new VectorGeoShapeQueryProcessor();

        public GeoShapeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, false, meta);
        }

        @Override
        public String typeName() {
            return GeoShapeFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
            return this.queryProcessor.geoShapeQuery(shape, fieldName, relation, context);
        }
    }

    public static final class TypeParser
    extends AbstractShapeGeometryFieldMapper.TypeParser {
        @Override
        protected AbstractShapeGeometryFieldMapper.Builder newBuilder(String name, Map<String, Object> params) {
            if (params.containsKey("deprecated_parameters")) {
                return new LegacyGeoShapeFieldMapper.Builder(name, (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get("deprecated_parameters"));
            }
            return new Builder(name);
        }
    }

    public static class Builder
    extends AbstractShapeGeometryFieldMapper.Builder<Builder, GeoShapeFieldType> {
        public Builder(String name) {
            super(name, FIELD_TYPE);
            this.hasDocValues = false;
        }

        private GeoShapeFieldType buildFieldType(Mapper.BuilderContext context) {
            GeoShapeFieldType ft = new GeoShapeFieldType(this.buildFullName(context), this.indexed, this.fieldType.stored(), this.hasDocValues, this.meta);
            GeometryParser geometryParser = new GeometryParser(ft.orientation.getAsBoolean(), this.coerce().value(), this.ignoreZValue().value());
            ft.setGeometryParser(new GeoShapeParser(geometryParser));
            ft.setGeometryIndexer(new GeoShapeIndexer(this.orientation().value().getAsBoolean(), this.buildFullName(context)));
            ft.setOrientation(this.orientation == null ? AbstractShapeGeometryFieldMapper.Defaults.ORIENTATION.value() : this.orientation);
            return ft;
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            return new GeoShapeFieldMapper(this.name, this.fieldType, this.buildFieldType(context), this.ignoreMalformed(context), this.coerce(context), this.ignoreZValue(), this.orientation(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

