/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.store.Directory;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.index.engine.OpenSearchReaderManager;

public class NRTReplicationReaderManager
extends OpenSearchReaderManager {
    private static final Logger logger = LogManager.getLogger(NRTReplicationReaderManager.class);
    private volatile SegmentInfos currentInfos;

    NRTReplicationReaderManager(OpenSearchDirectoryReader reader) {
        super(reader);
        this.currentInfos = this.unwrapStandardReader(reader).getSegmentInfos();
    }

    @Override
    protected OpenSearchDirectoryReader refreshIfNeeded(OpenSearchDirectoryReader referenceToRefresh) throws IOException {
        Objects.requireNonNull(referenceToRefresh);
        ArrayList<LeafReader> subs = new ArrayList<LeafReader>();
        StandardDirectoryReader standardDirectoryReader = this.unwrapStandardReader(referenceToRefresh);
        for (LeafReaderContext ctx : standardDirectoryReader.leaves()) {
            subs.add(ctx.reader());
        }
        DirectoryReader innerReader = StandardDirectoryReader.open((Directory)referenceToRefresh.directory(), (SegmentInfos)this.currentInfos, subs, null);
        SoftDeletesDirectoryReaderWrapper softDeletesDirectoryReaderWrapper = new SoftDeletesDirectoryReaderWrapper(innerReader, "__soft_deletes");
        logger.trace(() -> new ParameterizedMessage("updated to SegmentInfosVersion=" + this.currentInfos.getVersion() + " reader=" + innerReader, new Object[0]));
        return OpenSearchDirectoryReader.wrap((DirectoryReader)softDeletesDirectoryReaderWrapper, referenceToRefresh.shardId());
    }

    public synchronized void updateSegments(SegmentInfos infos) throws IOException {
        infos.updateGeneration(this.currentInfos);
        this.currentInfos = infos;
        this.maybeRefresh();
    }

    public SegmentInfos getSegmentInfos() {
        return this.currentInfos;
    }

    private StandardDirectoryReader unwrapStandardReader(OpenSearchDirectoryReader reader) {
        DirectoryReader delegate = reader.getDelegate();
        if (delegate instanceof SoftDeletesDirectoryReaderWrapper) {
            return (StandardDirectoryReader)((SoftDeletesDirectoryReaderWrapper)delegate).getDelegate();
        }
        return (StandardDirectoryReader)delegate;
    }
}

