/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.cluster.service.ClusterManagerTaskThrottlerListener;
import org.opensearch.common.metrics.CounterMetric;

public class ClusterManagerThrottlingStats
implements ClusterManagerTaskThrottlerListener {
    private Map<String, CounterMetric> throttledTasksCount = new ConcurrentHashMap<String, CounterMetric>();

    private void incrementThrottlingCount(String type, int counts) {
        this.throttledTasksCount.computeIfAbsent(type, k -> new CounterMetric()).inc(counts);
    }

    public long getThrottlingCount(String type) {
        return this.throttledTasksCount.get(type) == null ? 0L : this.throttledTasksCount.get(type).count();
    }

    public long getTotalThrottledTaskCount() {
        CounterMetric totalCount = new CounterMetric();
        this.throttledTasksCount.forEach((aClass, counterMetric) -> totalCount.inc(counterMetric.count()));
        return totalCount.count();
    }

    @Override
    public void onThrottle(String type, int counts) {
        this.incrementThrottlingCount(type, counts);
    }
}

