/*
 * Decompiled with CFR 0.152.
 */
package org.stro.jdartsass;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.stro.jdartsass.CompilationOptions;
import org.stro.jdartsass.Installation;

public class JDartSass {
    private File executable;
    private List<File> loadPaths;

    public JDartSass(Installation installation) {
        this(installation, Collections.emptyList());
    }

    public JDartSass(Installation installation, List<File> loadPaths) {
        this.executable = installation.getExecutable();
        this.loadPaths = loadPaths;
    }

    public String compile(CompilationOptions options) {
        boolean deleteFile;
        File inputFile = options.getInputFile();
        if (inputFile != null && !inputFile.exists()) {
            throw new IllegalArgumentException("The given SASS file doesn't exist: " + inputFile.getAbsolutePath());
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.executable.getAbsolutePath());
        if (this.loadPaths != null) {
            this.loadPaths.forEach(lp -> args.add("--load-path=" + lp.getAbsolutePath()));
        }
        args.add("--style=" + options.getStyle().name().toLowerCase());
        if (options.isDebug()) {
            args.add("--trace");
            args.add("--error-css");
        }
        args.add("--no-source-map");
        boolean bl = deleteFile = inputFile == null;
        if (inputFile == null) {
            deleteFile = true;
            try {
                inputFile = File.createTempFile("jdartsass", ".scss");
                FileUtils.writeStringToFile((File)inputFile, (String)options.getInputText().toString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        args.add(inputFile.getAbsolutePath());
        try {
            Process process = new ProcessBuilder(new String[0]).command(args).directory(this.executable.getParentFile()).redirectErrorStream(true).start();
            StringBuilder sb = new StringBuilder(5120);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            }
            try {
                if (!process.waitFor(1L, TimeUnit.MINUTES)) {
                    process.destroyForcibly();
                    throw new IllegalStateException("SASS process didn't finish");
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            if (process.exitValue() != 0) {
                throw new IllegalStateException(String.format("Return value %d when executing %s:%nn%s", process.exitValue(), args, sb));
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (deleteFile) {
                inputFile.delete();
            }
        }
    }
}

