/*
 * Decompiled with CFR 0.152.
 */
package org.stro.jdartsass;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class Distribution {
    public static final String LAST_KNOWN_VERSION = "1.53.0";
    public static final String DEFAULT_BASE_URL = "https://github.com/sass/dart-sass/releases/download";
    static final String ARM_ARCH_JAVA = "aarch64";
    static final String ARM_ARCH_DART = "arm64";
    public static final List<String> VALID_ARCHITECTURES = Collections.unmodifiableList(Arrays.asList("x64", "arm64", "aarch64", "ia32"));
    public static final List<String> VALID_OPERATING_SYSTEMS = Collections.unmodifiableList(Arrays.asList("linux", "windows", "macos"));
    private String version = "1.53.0";
    private String baseUrl = "https://github.com/sass/dart-sass/releases/download";
    private String operatingSystem = Distribution.getCurrentOperatingSystem();
    private String architecture = Distribution.getCurrentArchitecture();

    public static String getCurrentArchitecture() {
        String arch = SystemUtils.OS_ARCH.toLowerCase();
        return arch.contains(ARM_ARCH_DART) || arch.contains(ARM_ARCH_JAVA) ? ARM_ARCH_DART : (arch.contains("64") ? "x64" : "ia32");
    }

    public static String getCurrentOperatingSystem() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "windows";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "macos";
        }
        return "linux";
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getArchiveFileName() {
        return String.format("dart-sass-%s-%s-%s.%s", this.getVersion(), this.operatingSystem, this.architecture, this.getArchiveExtension());
    }

    public URL getArchiveUrl() {
        String url = String.format("%s/%s/%s", this.getBaseUrl(), this.getVersion(), this.getArchiveFileName());
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + url, e);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getVersion() {
        return this.version;
    }

    public void setArchitecture(String architecture) {
        if (!VALID_ARCHITECTURES.contains(architecture)) {
            throw new IllegalArgumentException("Invalid architecture: " + architecture + ". Expected one of " + VALID_ARCHITECTURES);
        }
        this.architecture = architecture;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setOperatingSystem(String operatingSystem) {
        if (!VALID_OPERATING_SYSTEMS.contains(operatingSystem)) {
            throw new IllegalArgumentException("Invalid operating system: " + operatingSystem + ". Expected one of " + VALID_OPERATING_SYSTEMS);
        }
        this.operatingSystem = operatingSystem;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private String getArchiveExtension() {
        return "windows".equals(this.operatingSystem) ? "zip" : "tar.gz";
    }
}

