/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.PutAllBackupOperation;
import com.hazelcast.map.impl.operation.steps.PutAllOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class PutAllOperation
extends MapOperation
implements PartitionAwareOperation,
BackupAwareOperation,
MutatingOperation,
Versioned {
    private transient int currentIndex;
    private MapEntries mapEntries;
    private volatile boolean triggerMapLoader;
    private transient boolean hasMapListener;
    private transient boolean hasWanReplication;
    private transient boolean hasBackups;
    private transient boolean hasInvalidation;
    private transient List backupPairs;
    private transient List<Data> invalidationKeys;

    public PutAllOperation() {
    }

    public PutAllOperation(String name, MapEntries mapEntries, boolean triggerMapLoader) {
        super(name);
        this.mapEntries = mapEntries;
        this.triggerMapLoader = triggerMapLoader;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        if (this.recordStore != null) {
            this.recordStore.checkIfLoaded();
        }
        this.hasMapListener = this.mapEventPublisher.hasEventListener(this.name);
        this.hasWanReplication = this.mapContainer.isWanReplicationEnabled();
        this.hasBackups = this.hasBackups();
        this.hasInvalidation = this.mapContainer.hasInvalidationListener();
        if (this.hasBackups) {
            this.backupPairs = new ArrayList(2 * this.mapEntries.size());
        }
        if (this.hasInvalidation) {
            this.invalidationKeys = new ArrayList<Data>(this.mapEntries.size());
        }
    }

    @Override
    public State createState() {
        return super.createState().setMapEntries(this.mapEntries).setTriggerMapLoader(this.triggerMapLoader);
    }

    @Override
    public Step getStartingStep() {
        return PutAllOpSteps.READ;
    }

    @Override
    protected void runInternal() {
        int size = this.mapEntries.size();
        while (this.currentIndex < size) {
            this.put(this.mapEntries.getKey(this.currentIndex), this.mapEntries.getValue(this.currentIndex));
            ++this.currentIndex;
        }
    }

    protected void put(Data dataKey, Data dataValue) {
        Object oldValue = this.putToRecordStore(dataKey, dataValue);
        dataValue = this.getValueOrPostProcessedValue(dataKey, dataValue);
        this.mapServiceContext.interceptAfterPut(this.mapContainer.getInterceptorRegistry(), dataValue);
        if (this.hasMapListener) {
            EntryEventType eventType = oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, eventType, dataKey, oldValue, dataValue);
        }
        if (this.hasWanReplication) {
            this.publishWanUpdate(dataKey, dataValue);
        }
        if (this.hasInvalidation) {
            this.invalidationKeys.add(dataKey);
        }
        if (this.hasBackups) {
            this.backupPairs.add(dataKey);
            this.backupPairs.add(dataValue);
        }
        this.evict(dataKey);
    }

    public boolean isHasMapListener() {
        return this.hasMapListener;
    }

    public boolean isHasWanReplication() {
        return this.hasWanReplication;
    }

    public boolean isHasBackups() {
        return this.hasBackups;
    }

    public boolean isHasInvalidation() {
        return this.hasInvalidation;
    }

    public List getBackupPairs() {
        return this.backupPairs;
    }

    public List<Data> getInvalidationKeys() {
        return this.invalidationKeys;
    }

    private boolean hasBackups() {
        return this.mapContainer.getTotalBackupCount() > 0;
    }

    private Object putToRecordStore(Data dataKey, Data dataValue) {
        if (this.triggerMapLoader && this.hasMapListener) {
            return this.recordStore.put(dataKey, dataValue, -1L, -1L);
        }
        this.recordStore.set(dataKey, dataValue, -1L, -1L);
        return null;
    }

    @Override
    public void afterRunInternal() {
        this.invalidateNearCache(this.invalidationKeys);
        super.afterRunInternal();
    }

    public Data getValueOrPostProcessedValue(Data dataKey, Data dataValue) {
        if (!this.isPostProcessingOrHasInterceptor(this.recordStore)) {
            return dataValue;
        }
        Object record = this.recordStore.getRecord(dataKey);
        return this.mapServiceContext.toData(record.getValue());
    }

    @Override
    public Object getResponse() {
        return true;
    }

    @Override
    public boolean shouldBackup() {
        return this.hasBackups && !this.mapEntries.isEmpty();
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public Operation getBackupOperation() {
        return new PutAllBackupOperation(this.name, this.toBackupListByRemovingEvictedRecords(), false);
    }

    @Nonnull
    private List toBackupListByRemovingEvictedRecords() {
        ArrayList<Object> toBackupList = new ArrayList<Object>(this.backupPairs.size());
        for (int i = 0; i < this.backupPairs.size(); i += 2) {
            Data dataKey = (Data)this.backupPairs.get(i);
            Object record = this.recordStore.getRecord(dataKey);
            if (record == null) continue;
            toBackupList.add(dataKey);
            toBackupList.add(this.backupPairs.get(i + 1));
            toBackupList.add(record);
            toBackupList.add(this.recordStore.getExpirySystem().getExpiryMetadata(dataKey));
        }
        return toBackupList;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.mapEntries);
        if (out.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            out.writeBoolean(this.triggerMapLoader);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.mapEntries = (MapEntries)in.readObject();
        this.triggerMapLoader = in.getVersion().isGreaterOrEqual(Versions.V4_1) ? in.readBoolean() : true;
    }

    @Override
    public int getClassId() {
        return 21;
    }
}

