/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.internal.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.internal.monitor.impl.LocalRecordStoreStatsImpl;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.NotifiableIterator;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.MapIndexInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class MapChunkContext {
    private final int partitionId;
    private final String mapName;
    private final SerializationService ss;
    private final ExpirySystem expirySystem;
    private final MapServiceContext mapServiceContext;
    private final RecordStore recordStore;
    private final LocalMapStatsImpl mapStats;
    private ServiceNamespace serviceNamespace;
    private volatile Iterator<Map.Entry<Data, Record>> iterator;

    public MapChunkContext(MapServiceContext mapServiceContext, int partitionId, ServiceNamespace namespaces) {
        this.mapServiceContext = mapServiceContext;
        this.partitionId = partitionId;
        this.serviceNamespace = namespaces;
        this.mapName = ((ObjectNamespace)this.serviceNamespace).getObjectName();
        this.recordStore = this.getRecordStore(this.mapName);
        this.expirySystem = this.recordStore.getExpirySystem();
        this.ss = mapServiceContext.getNodeEngine().getSerializationService();
        this.mapStats = mapServiceContext.getLocalMapStatsProvider().getLocalMapStatsImpl(this.mapName);
    }

    protected Iterator<Map.Entry<Data, Record>> createIterator() {
        return this.recordStore.iterator();
    }

    public final ILogger getLogger(String className) {
        return this.mapServiceContext.getNodeEngine().getLogger(className);
    }

    private RecordStore getRecordStore(String mapName) {
        return this.mapServiceContext.getRecordStore(this.partitionId, mapName, true);
    }

    public final boolean hasMoreChunks() {
        this.beforeOperation();
        try {
            boolean bl = this.getIterator().hasNext();
            return bl;
        }
        finally {
            this.afterOperation();
        }
    }

    public final ServiceNamespace getServiceNamespace() {
        return this.serviceNamespace;
    }

    public final Iterator<Map.Entry<Data, Record>> getIterator() {
        if (this.iterator == null) {
            this.iterator = this.createIterator();
        }
        return this.iterator;
    }

    public final void setIterator(Iterator<Map.Entry<Data, Record>> iterator) {
        this.iterator = iterator;
    }

    public final RecordStore getRecordStore() {
        return this.recordStore;
    }

    public final int getPartitionId() {
        return this.partitionId;
    }

    public final String getMapName() {
        return this.mapName;
    }

    public final SerializationService getSerializationService() {
        return this.ss;
    }

    public final ExpiryMetadata getExpiryMetadata(Data dataKey) {
        return this.expirySystem.getExpiryMetadata(dataKey);
    }

    public final LocalMapStatsImpl getMapStats() {
        return this.mapStats;
    }

    public final MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public final boolean isRecordStoreLoaded() {
        return this.recordStore.isLoaded();
    }

    public final LocalRecordStoreStatsImpl getLocalRecordStoreStats() {
        return this.recordStore.getLocalRecordStoreStats();
    }

    public final MapIndexInfo createMapIndexInfo() {
        MapContainer mapContainer = this.recordStore.getMapContainer();
        HashSet<IndexConfig> indexConfigs = new HashSet<IndexConfig>();
        if (mapContainer.isGlobalIndexEnabled()) {
            Indexes indexes = mapContainer.getIndexes();
            for (InternalIndex index : indexes.getIndexes()) {
                indexConfigs.add(index.getConfig());
            }
            indexConfigs.addAll(indexes.getIndexDefinitions());
        } else {
            Indexes indexes = mapContainer.getIndexes(this.partitionId);
            if (indexes != null && indexes.haveAtLeastOneIndexOrDefinition()) {
                for (InternalIndex index : indexes.getIndexes()) {
                    indexConfigs.add(index.getConfig());
                }
                indexConfigs.addAll(indexes.getIndexDefinitions());
            }
        }
        return new MapIndexInfo(this.mapName).addIndexCofigs(indexConfigs);
    }

    public final void beforeOperation() {
        this.recordStore.beforeOperation();
        if (this.getIterator() instanceof NotifiableIterator) {
            ((NotifiableIterator)((Object)this.getIterator())).onBeforeIteration();
        }
    }

    public final void afterOperation() {
        this.recordStore.afterOperation();
    }
}

