/*
 * Decompiled with CFR 0.152.
 */
package cn.danielw.fop;

public class PoolConfig {
    private int maxWaitMilliseconds = 5000;
    private int maxIdleMilliseconds = 300000;
    private int minSize = 5;
    private int maxSize = 20;
    private int partitionSize = 4;
    private int scavengeIntervalMilliseconds = 120000;
    private double scavengeRatio = 0.5;
    private int shutdownWaitMilliseconds = 30000;

    public int getMaxWaitMilliseconds() {
        return this.maxWaitMilliseconds;
    }

    public PoolConfig setMaxWaitMilliseconds(int maxWaitMilliseconds) {
        if (maxWaitMilliseconds <= 0) {
            throw new IllegalArgumentException("Cannot set max wait time to a negative number " + maxWaitMilliseconds);
        }
        this.maxWaitMilliseconds = maxWaitMilliseconds;
        return this;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public PoolConfig setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public PoolConfig setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public int getMaxIdleMilliseconds() {
        return this.maxIdleMilliseconds;
    }

    public PoolConfig setMaxIdleMilliseconds(int maxIdleMilliseconds) {
        this.maxIdleMilliseconds = maxIdleMilliseconds;
        return this;
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public PoolConfig setPartitionSize(int partitionSize) {
        this.partitionSize = partitionSize;
        return this;
    }

    public int getScavengeIntervalMilliseconds() {
        return this.scavengeIntervalMilliseconds;
    }

    public PoolConfig setScavengeIntervalMilliseconds(int scavengeIntervalMilliseconds) {
        if (scavengeIntervalMilliseconds != 0 && scavengeIntervalMilliseconds < 5000) {
            throw new IllegalArgumentException("Cannot set interval too short (" + scavengeIntervalMilliseconds + "), must be at least 5 seconds, or zero to disable scavenger");
        }
        this.scavengeIntervalMilliseconds = scavengeIntervalMilliseconds;
        return this;
    }

    public double getScavengeRatio() {
        return this.scavengeRatio;
    }

    public PoolConfig setScavengeRatio(double scavengeRatio) {
        if (scavengeRatio <= 0.0 || scavengeRatio > 1.0) {
            throw new IllegalArgumentException("Invalid scavenge ratio: " + scavengeRatio);
        }
        this.scavengeRatio = scavengeRatio;
        return this;
    }

    public int getShutdownWaitMilliseconds() {
        return this.shutdownWaitMilliseconds;
    }

    public void setShutdownWaitMilliseconds(int shutdownWaitMilliseconds) {
        if (shutdownWaitMilliseconds < 0) {
            throw new IllegalArgumentException("cannot set negative timeout:" + shutdownWaitMilliseconds);
        }
        this.shutdownWaitMilliseconds = shutdownWaitMilliseconds;
    }
}

