/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.stro.dbdiff.model.BaseDatabaseMetadata;
import org.stro.dbdiff.model.TableMetadata;

public class DatabaseMetadata
extends BaseDatabaseMetadata {
    private Map<String, TableMetadata> tables = new HashMap<String, TableMetadata>();

    @Override
    public void clear() {
        super.clear();
        this.tables.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseMetadata other = (DatabaseMetadata)obj;
        return this.bothEqualsOrEmpty(this.tables, other.tables);
    }

    public Map<String, TableMetadata> getTables() {
        return this.tables;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.tables);
        return result;
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty() && MapUtils.isEmpty(this.tables);
    }

    public void setTables(Map<String, TableMetadata> tables) {
        this.tables = tables;
    }

    public String toString() {
        return "DatabaseMetadata [tables=" + this.tables + ", productName=" + this.productName + ", productVersion=" + this.productVersion + ", productVersionCode=" + this.productVersionCode + ", functions=" + this.functions + ", views=" + this.views + ", sequences=" + this.sequences + "]";
    }
}

