/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.stro.dbdiff.DDLGenerator;
import org.stro.dbdiff.DbDiffException;
import org.stro.dbdiff.LoadFromDatabaseOptions;
import org.stro.dbdiff.model.DatabaseDiffResult;
import org.stro.dbdiff.model.DatabaseMetadata;
import org.stro.dbdiff.model.MultiChanges;

public interface MetadataHandler {
    public static void fillNames(DatabaseDiffResult diff) {
        Consumer<Map> mapSetter = map -> {
            if (map != null) {
                map.forEach((k, v) -> v.setName((String)k));
            }
        };
        Consumer<MultiChanges> multiMapSetter = multiMap -> {
            if (multiMap == null) {
                return;
            }
            mapSetter.accept(multiMap.getAdded());
            mapSetter.accept(multiMap.getRemoved());
            mapSetter.accept(multiMap.getChanged());
        };
        MetadataHandler.fillNames(diff.getActual());
        MetadataHandler.fillNames(diff.getAdded());
        MetadataHandler.fillNames(diff.getRemoved());
        mapSetter.accept(diff.getChanged().getFunctions());
        mapSetter.accept(diff.getChanged().getSequences());
        mapSetter.accept(diff.getChanged().getTables());
        mapSetter.accept(diff.getChanged().getViews());
        diff.getChanged().getTables().forEach((k, ch) -> {
            multiMapSetter.accept(ch.getColumns());
            multiMapSetter.accept(ch.getfKConstraints());
            multiMapSetter.accept(ch.getIndexes());
            multiMapSetter.accept(ch.getTriggers());
            multiMapSetter.accept(ch.getUniqueConstraints());
        });
    }

    public static void fillNames(DatabaseMetadata metadata) {
        if (metadata == null) {
            return;
        }
        Consumer<Map> setter = map -> map.forEach((k, v) -> v.setName((String)k));
        setter.accept(metadata.getFunctions());
        setter.accept(metadata.getSequences());
        setter.accept(metadata.getTables());
        setter.accept(metadata.getViews());
        metadata.getTables().forEach((k, t) -> {
            setter.accept(t.getColumns());
            setter.accept(t.getfKConstraints());
            setter.accept(t.getIndexes());
            setter.accept(t.getTriggers());
            setter.accept(t.getUniqueConstraints());
        });
    }

    public DDLGenerator ddlGenerator(DatabaseDiffResult var1);

    public DatabaseMetadata loadFromDatabase(JdbcTemplate var1, LoadFromDatabaseOptions var2) throws DbDiffException;

    public DatabaseMetadata loadFromJson(InputStream var1) throws DbDiffException;

    public DatabaseMetadata loadFromJson(String var1) throws DbDiffException;

    public void storeJson(DatabaseMetadata var1, OutputStream var2) throws DbDiffException;

    public void storeJson(DatabaseMetadata var1, String var2) throws DbDiffException;

    public String toJson(DatabaseMetadata var1) throws DbDiffException;
}

