/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.stro.dbdiff.MetadataHandler;
import org.stro.dbdiff.model.ColumnMetadata;
import org.stro.dbdiff.model.DatabaseChanges;
import org.stro.dbdiff.model.DatabaseDiffResult;
import org.stro.dbdiff.model.DatabaseMetadata;
import org.stro.dbdiff.model.DefinableMetadata;
import org.stro.dbdiff.model.MultiChanges;
import org.stro.dbdiff.model.NamedMetadata;
import org.stro.dbdiff.model.PKConstraintMetadata;
import org.stro.dbdiff.model.TableChanges;
import org.stro.dbdiff.model.TableMetadata;

public class DatabaseDiff {
    private static final Pattern PK_PATTERN = Pattern.compile("(?i).*PRIMARY KEY\\s+\\((?<cols>.*)\\).*");
    private static final Pattern FK_PATTERN = Pattern.compile("(?i).*FOREIGN KEY\\s+\\((?<referencingCols>.*)\\)\\s+REFERENCES\\s+(?<referencedTable>.*)\\((?<referencedCols>.*)\\)");
    private static final Pattern INDEX_PATTERN = Pattern.compile("(?i)^.*INDEX[^\\(]+\\((?<cols>[^\\)]*).*");
    private static final Pattern UNIQUE_CONSTRAINT_PATTERN = Pattern.compile("(?i)^.*UNIQUE[^\\(]+\\((?<cols>[^\\)]*).*");
    private DatabaseMetadata expected;
    private DatabaseMetadata actual;
    private DatabaseMetadata addedDiff;
    private DatabaseMetadata removedDiff;
    private DatabaseChanges changedDiff;

    public static void main(String[] args) {
        Pattern pattern = INDEX_PATTERN;
        Matcher matcher = pattern.matcher("CREATE UNIQUE INDEX ix_products_authorization_roles ON public.products_authorization_roles USING btree (product_id, authorization_role_id)");
        System.out.printf("Matches: %s, cols=%s", matcher.matches(), matcher.group("cols"));
    }

    public DatabaseDiff(DatabaseMetadata expected, DatabaseMetadata actual) {
        this.expected = expected;
        this.actual = actual;
        this.addedDiff = new DatabaseMetadata();
        this.removedDiff = new DatabaseMetadata();
        this.changedDiff = new DatabaseChanges();
    }

    public DatabaseDiffResult diff() {
        if (this.expected.equals(this.actual)) {
            return DatabaseDiffResult.empty();
        }
        this.diff(this.functionDiffParams(), this::computeChanges);
        this.diff(this.sequencesDiffParams(), this::computeChanges);
        this.diff(this.viewsDiffParams(), this::computeChanges);
        this.diffTables();
        DatabaseMetadata actualChanges = this.getActualChanges();
        return new DatabaseDiffResult(actualChanges, this.addedDiff, this.removedDiff, this.changedDiff);
    }

    private ColumnMetadata computeChanges(ColumnMetadata expected, ColumnMetadata actual) {
        ColumnMetadata changes = new ColumnMetadata();
        changes.setName(expected.getName());
        changes.setActualDefaultValueTemporal(actual.getDefaultValue());
        if (!Objects.equals(expected.getDefaultValue(), actual.getDefaultValue())) {
            changes.setDefaultValue(expected.getDefaultValue());
            changes.setDefaultValueDropped(expected.getDefaultValue() == null);
        }
        if (!Objects.equals(expected.getNullable(), actual.getNullable())) {
            changes.setNullable(expected.getNullable());
        }
        if (!Objects.equals(expected.getType(), actual.getType())) {
            changes.setType(expected.getType());
        }
        return changes;
    }

    private DefinableMetadata computeChanges(DefinableMetadata expected, DefinableMetadata actual) {
        DefinableMetadata changes = new DefinableMetadata();
        changes.setName(expected.getName());
        changes.setDefinition(expected.getDefinition());
        return changes;
    }

    private <K, V> void copy(Set<K> keys, Map<K, V> source, Map<K, V> target) {
        keys.forEach(k -> target.put(k, source.get(k)));
    }

    private <M extends NamedMetadata> DiffParams<M> diff(DiffParams<M> params, BiFunction<M, M, Boolean> comparator, BiFunction<M, M, M> changeFunc) {
        Set<String> expectedNames = params.expected.keySet();
        Set<String> actualNames = params.actual.keySet();
        CollectionUtils.subtract(expectedNames, actualNames).stream().filter(n -> !params.actual.values().stream().anyMatch(e -> (Boolean)comparator.apply(e, (NamedMetadata)params.expected.get(n)))).forEach(n -> params.removedMap.put((String)n, (NamedMetadata)params.expected.get(n)));
        CollectionUtils.subtract(actualNames, expectedNames).stream().filter(n -> !params.expected.values().stream().anyMatch(e -> (Boolean)comparator.apply(e, (NamedMetadata)params.actual.get(n)))).forEach(n -> params.addedMap.put((String)n, (NamedMetadata)params.actual.get(n)));
        expectedNames.stream().filter(n -> actualNames.contains(n) && (Boolean)comparator.apply((NamedMetadata)params.expected.get(n), (NamedMetadata)params.actual.get(n)) == false).forEach(n -> params.changedMap.put((String)n, (NamedMetadata)changeFunc.apply((NamedMetadata)params.expected.get(n), (NamedMetadata)params.actual.get(n))));
        return params;
    }

    private <M extends NamedMetadata> DiffParams<M> diff(DiffParams<M> params, BiFunction<M, M, M> changeFunc) {
        return this.diff(params, NamedMetadata::equals, changeFunc);
    }

    private void diffTables() {
        DiffParams<TableMetadata> tableDiff = this.diff(this.tablesDiffParams(), (expected, actual) -> actual);
        tableDiff.changedMap.keySet().stream().forEach(tableName -> {
            TableMetadata expectedTable = this.expected.getTables().get(tableName);
            TableMetadata actualTable = this.actual.getTables().get(tableName);
            TableChanges tableChanges = new TableChanges();
            tableChanges.setName((String)tableName);
            this.diff(this.tableColumnDiffParams(expectedTable, actualTable, tableChanges), this::computeChanges);
            this.diff(this.tableFKDiffParams(expectedTable, actualTable, tableChanges), this::isSameFk, this::computeChanges);
            this.diff(this.tableIndexDiffParams(expectedTable, actualTable, tableChanges), this::isSameIndex, this::computeChanges);
            this.diff(this.tableTriggerDiffParams(expectedTable, actualTable, tableChanges), this::computeChanges);
            this.diff(this.tableUniqueDiffParams(expectedTable, actualTable, tableChanges), this::isSameUniqueConstraint, this::computeChanges);
            PKConstraintMetadata expectedPK = expectedTable.getpKConstraint();
            PKConstraintMetadata actualPK = actualTable.getpKConstraint();
            if (!this.isSamePk(expectedPK, actualPK)) {
                if (expectedPK == null && actualPK != null) {
                    tableChanges.getPkConstraint().setAdded(actualPK);
                } else if (expectedPK != null && actualPK == null) {
                    tableChanges.getPkConstraint().setRemoved(expectedPK);
                } else {
                    PKConstraintMetadata changed = new PKConstraintMetadata();
                    changed.setName(expectedPK.getName());
                    changed.setDefinition(expectedPK.getDefinition());
                    tableChanges.getPkConstraint().setChanged(changed);
                }
            }
            if (!tableChanges.isEmpty()) {
                this.changedDiff.getTables().put((String)tableName, tableChanges);
            }
        });
    }

    private DiffParams<DefinableMetadata> functionDiffParams() {
        return new DiffParams<DefinableMetadata>(this.expected.getFunctions(), this.actual.getFunctions(), this.addedDiff.getFunctions(), this.removedDiff.getFunctions(), this.changedDiff.getFunctions());
    }

    private DatabaseMetadata getActualChanges() {
        DatabaseMetadata actualChanges = new DatabaseMetadata();
        actualChanges.setProductName(this.actual.getProductName());
        actualChanges.setProductVersion(this.actual.getProductVersion());
        actualChanges.setProductVersionCode(this.actual.getProductVersionCode());
        this.copy(this.changedDiff.getFunctions().keySet(), this.actual.getFunctions(), actualChanges.getFunctions());
        this.copy(this.changedDiff.getSequences().keySet(), this.actual.getSequences(), actualChanges.getSequences());
        this.copy(this.changedDiff.getViews().keySet(), this.actual.getViews(), actualChanges.getViews());
        this.changedDiff.getTables().forEach((k, v) -> {
            TableMetadata actualTableChanges = new TableMetadata();
            actualChanges.getTables().put((String)k, actualTableChanges);
            TableMetadata actualTable = this.actual.getTables().get(k);
            this.copy(v.getColumns().getChanged().keySet(), actualTable.getColumns(), actualTableChanges.getColumns());
            this.copy(v.getfKConstraints().getChanged().keySet(), actualTable.getfKConstraints(), actualTableChanges.getfKConstraints());
            this.copy(v.getIndexes().getChanged().keySet(), actualTable.getIndexes(), actualTableChanges.getIndexes());
            actualTableChanges.setpKConstraint(v.getPkConstraint().getChanged());
            this.copy(v.getTriggers().getChanged().keySet(), actualTable.getTriggers(), actualTableChanges.getTriggers());
            this.copy(v.getUniqueConstraints().getChanged().keySet(), actualTable.getUniqueConstraints(), actualTableChanges.getUniqueConstraints());
        });
        MetadataHandler.fillNames(actualChanges);
        return actualChanges;
    }

    private DefinitionMatching getDefinitionMatch(DefinableMetadata expected, DefinableMetadata actual) {
        if (Objects.equals(expected, actual)) {
            return DefinitionMatching.EXACT_MATCH;
        }
        if (expected == null && actual != null || expected != null && actual == null) {
            return DefinitionMatching.NO_MATCH;
        }
        if (expected.getDefinition().equals(actual.getDefinition())) {
            return DefinitionMatching.EXACT_MATCH;
        }
        return DefinitionMatching.UNKNOWN;
    }

    private Pair<Matcher, Matcher> getMatchers(DefinableMetadata expected, DefinableMetadata actual, Pattern pattern) {
        Matcher matcherExp = pattern.matcher(expected.getDefinition());
        Matcher matcherAct = pattern.matcher(actual.getDefinition());
        if (!matcherExp.matches() || !matcherAct.matches()) {
            throw new IllegalArgumentException(String.format("Unexpected pattern for metadata (%s): %s", expected.getName(), pattern.toString()));
        }
        return Pair.of((Object)matcherExp, (Object)matcherAct);
    }

    private boolean isSameFk(DefinableMetadata expected, DefinableMetadata actual) {
        Pair<Matcher, Matcher> pair = this.getMatchers(expected, actual, FK_PATTERN);
        Matcher matcherExp = (Matcher)pair.getLeft();
        Matcher matcherAct = (Matcher)pair.getRight();
        if (!matcherExp.group("referencedTable").equals(matcherAct.group("referencedTable"))) {
            return false;
        }
        if (!this.split(matcherExp.group("referencingCols")).equals(this.split(matcherAct.group("referencingCols")))) {
            return false;
        }
        return this.split(matcherExp.group("referencedCols")).equals(this.split(matcherAct.group("referencedCols")));
    }

    private boolean isSameIndex(DefinableMetadata expected, DefinableMetadata actual) {
        Pair<Matcher, Matcher> pair = this.getMatchers(expected, actual, INDEX_PATTERN);
        Matcher matcherExp = (Matcher)pair.getLeft();
        Matcher matcherAct = (Matcher)pair.getRight();
        return this.split(matcherExp.group("cols")).equals(this.split(matcherAct.group("cols")));
    }

    private boolean isSamePk(PKConstraintMetadata expected, PKConstraintMetadata actual) {
        DefinitionMatching match = this.getDefinitionMatch(expected, actual);
        if (match != DefinitionMatching.UNKNOWN) {
            return match.isSame();
        }
        Pair<Matcher, Matcher> pair = this.getMatchers(expected, actual, PK_PATTERN);
        Matcher matcherExp = (Matcher)pair.getLeft();
        Matcher matcherAct = (Matcher)pair.getRight();
        return this.split(matcherExp.group("cols")).equals(this.split(matcherAct.group("cols")));
    }

    private boolean isSameUniqueConstraint(DefinableMetadata expected, DefinableMetadata actual) {
        Pair<Matcher, Matcher> pair = this.getMatchers(expected, actual, UNIQUE_CONSTRAINT_PATTERN);
        Matcher matcherExp = (Matcher)pair.getLeft();
        Matcher matcherAct = (Matcher)pair.getRight();
        return this.split(matcherExp.group("cols")).equals(this.split(matcherAct.group("cols")));
    }

    private DiffParams<DefinableMetadata> sequencesDiffParams() {
        return new DiffParams<DefinableMetadata>(this.expected.getSequences(), this.actual.getSequences(), this.addedDiff.getSequences(), this.removedDiff.getSequences(), this.changedDiff.getSequences());
    }

    private Set<String> split(String def) {
        return Arrays.stream(StringUtils.split((String)def, (char)',')).map(String::trim).collect(Collectors.toSet());
    }

    private DiffParams<ColumnMetadata> tableColumnDiffParams(TableMetadata expectedTable, TableMetadata actualTable, TableChanges tableChanges) {
        MultiChanges<ColumnMetadata> columns = tableChanges.getColumns();
        return new DiffParams<ColumnMetadata>(expectedTable.getColumns(), actualTable.getColumns(), columns.getAdded(), columns.getRemoved(), columns.getChanged());
    }

    private DiffParams<DefinableMetadata> tableFKDiffParams(TableMetadata expectedTable, TableMetadata actualTable, TableChanges tableChanges) {
        MultiChanges<DefinableMetadata> fk = tableChanges.getfKConstraints();
        return new DiffParams<DefinableMetadata>(expectedTable.getfKConstraints(), actualTable.getfKConstraints(), fk.getAdded(), fk.getRemoved(), fk.getChanged());
    }

    private DiffParams<DefinableMetadata> tableIndexDiffParams(TableMetadata expectedTable, TableMetadata actualTable, TableChanges tableChanges) {
        MultiChanges<DefinableMetadata> index = tableChanges.getIndexes();
        return new DiffParams<DefinableMetadata>(expectedTable.getIndexes(), actualTable.getIndexes(), index.getAdded(), index.getRemoved(), index.getChanged());
    }

    private DiffParams<TableMetadata> tablesDiffParams() {
        return new DiffParams<TableMetadata>(this.expected.getTables(), this.actual.getTables(), this.addedDiff.getTables(), this.removedDiff.getTables(), new HashMap());
    }

    private DiffParams<DefinableMetadata> tableTriggerDiffParams(TableMetadata expectedTable, TableMetadata actualTable, TableChanges tableChanges) {
        MultiChanges<DefinableMetadata> trigger = tableChanges.getTriggers();
        return new DiffParams<DefinableMetadata>(expectedTable.getTriggers(), actualTable.getTriggers(), trigger.getAdded(), trigger.getRemoved(), trigger.getChanged());
    }

    private DiffParams<DefinableMetadata> tableUniqueDiffParams(TableMetadata expectedTable, TableMetadata actualTable, TableChanges tableChanges) {
        MultiChanges<DefinableMetadata> unique = tableChanges.getUniqueConstraints();
        return new DiffParams<DefinableMetadata>(expectedTable.getUniqueConstraints(), actualTable.getUniqueConstraints(), unique.getAdded(), unique.getRemoved(), unique.getChanged());
    }

    private DiffParams<DefinableMetadata> viewsDiffParams() {
        return new DiffParams<DefinableMetadata>(this.expected.getViews(), this.actual.getViews(), this.addedDiff.getViews(), this.removedDiff.getViews(), this.changedDiff.getViews());
    }

    private class DiffParams<M extends NamedMetadata> {
        private Map<String, M> expected;
        private Map<String, M> actual;
        private Map<String, M> addedMap;
        private Map<String, M> removedMap;
        private Map<String, M> changedMap;

        public DiffParams(Map<String, M> expected, Map<String, M> actual, Map<String, M> addedMap, Map<String, M> removedMap, Map<String, M> changedMap) {
            this.expected = expected;
            this.actual = actual;
            this.addedMap = addedMap;
            this.removedMap = removedMap;
            this.changedMap = changedMap;
        }
    }

    private static enum DefinitionMatching {
        NO_MATCH,
        EXACT_MATCH,
        UNKNOWN;


        boolean isSame() {
            return this == EXACT_MATCH;
        }
    }
}

