/*
 * Decompiled with CFR 0.152.
 */
package org.stro.dbdiff;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.logging.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.stro.dbdiff.DbDiffException;
import org.stro.dbdiff.LoadFromDatabaseOptions;
import org.stro.dbdiff.MetadataHandler;
import org.stro.dbdiff.model.DatabaseMetadata;
import org.stro.dbdiff.model.DefinableMetadata;
import org.stro.dbdiff.model.TableMetadata;

public abstract class AbstractDatabaseMetadataHandler
implements MetadataHandler {
    protected Logger logger;
    protected ObjectMapper objectMapper;
    protected DatabaseMetaData md;
    protected LoadFromDatabaseOptions options;
    protected JdbcTemplate jdbcTemplate;
    protected int dbServerVersion;

    public AbstractDatabaseMetadataHandler() {
        this.init();
    }

    @Override
    public DatabaseMetadata loadFromDatabase(JdbcTemplate jdbcTemplate, LoadFromDatabaseOptions options) throws DbDiffException {
        try {
            this.options = this.preprocessOptions(options);
            this.jdbcTemplate = jdbcTemplate;
            return (DatabaseMetadata)jdbcTemplate.execute(this::extract);
        }
        catch (DataAccessException e) {
            throw new DbDiffException("Error loading metadata from database: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseMetadata loadFromJson(InputStream in) throws DbDiffException {
        try {
            DatabaseMetadata metadata = (DatabaseMetadata)this.objectMapper.readValue(in, DatabaseMetadata.class);
            MetadataHandler.fillNames(metadata);
            return metadata;
        }
        catch (IOException e) {
            throw new DbDiffException("Error loading metadata from input stream: " + e.getMessage(), e);
        }
    }

    @Override
    public DatabaseMetadata loadFromJson(String path) throws DbDiffException {
        DatabaseMetadata databaseMetadata;
        FileInputStream fos = new FileInputStream(new File(path));
        try {
            databaseMetadata = this.loadFromJson(fos);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DbDiffException("Error opening file to read from: " + e.getMessage(), e);
            }
        }
        fos.close();
        return databaseMetadata;
    }

    @Override
    public void storeJson(DatabaseMetadata metadata, OutputStream out) throws DbDiffException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, Charset.forName("utf-8")));
        try {
            writer.write(this.toJson(metadata));
            writer.flush();
        }
        catch (IOException e) {
            throw new DbDiffException("Error storing metadata: " + e.getMessage(), e);
        }
    }

    @Override
    public void storeJson(DatabaseMetadata metadata, String path) throws DbDiffException {
        try (FileOutputStream fos = new FileOutputStream(new File(path));){
            this.storeJson(metadata, fos);
        }
        catch (IOException e) {
            throw new DbDiffException("Error creating file to store metadata: " + e.getMessage(), e);
        }
    }

    @Override
    public String toJson(DatabaseMetadata metadata) throws DbDiffException {
        try {
            return this.objectMapper.writeValueAsString((Object)metadata);
        }
        catch (JsonProcessingException e) {
            throw new DbDiffException("Error generating JSON: " + e.getMessage(), e);
        }
    }

    protected abstract Map<String, DefinableMetadata> extractFunctions() throws SQLException;

    protected String extractProductName() throws SQLException {
        return this.md.getDatabaseProductName();
    }

    protected String extractProductVersion() throws SQLException {
        return String.format("%s, v%s. %s, v%s", this.md.getDatabaseProductName(), this.md.getDatabaseProductVersion(), this.md.getDriverName(), this.md.getDriverVersion());
    }

    protected abstract int extractProductVersionCode() throws SQLException;

    protected abstract Map<String, DefinableMetadata> extractSequences() throws SQLException;

    protected abstract Map<String, TableMetadata> extractTables() throws SQLException;

    protected abstract Map<String, DefinableMetadata> extractViews() throws SQLException;

    protected abstract Logger getLogger();

    protected LoadFromDatabaseOptions preprocessOptions(LoadFromDatabaseOptions options) {
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseMetadata extract(Connection con) throws SQLException {
        this.md = con.getMetaData();
        StopWatch watch = new StopWatch();
        watch.start();
        DatabaseMetadata metadata = new DatabaseMetadata();
        try {
            this.logger.trace("Extracting product name...");
            metadata.setProductName(this.extractProductName());
            this.logger.trace("Extracting product version...");
            metadata.setProductVersion(this.extractProductVersion());
            this.logger.trace("Extracting product version code ...");
            this.dbServerVersion = this.extractProductVersionCode();
            metadata.setProductVersionCode(this.dbServerVersion);
            this.logger.trace("Extracting tables...");
            metadata.setTables(this.extractTables());
            this.logger.trace("Extracting funtions...");
            metadata.setFunctions(this.extractFunctions());
            this.logger.trace("Extracting views...");
            metadata.setViews(this.extractViews());
            this.logger.trace("Extracting sequences...");
            metadata.setSequences(this.extractSequences());
            DatabaseMetadata databaseMetadata = metadata;
            return databaseMetadata;
        }
        finally {
            watch.stop();
            this.logger.debug("Metadata load took: " + watch.toString());
        }
    }

    private void init() {
        this.logger = this.getLogger();
        this.objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

